/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for ConnectionProperty.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConnectionProperty extends com.google.api.client.json.GenericJson {

  /**
   * [Required] Name of the connection property to set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * [Required] Value of the connection property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * [Required] Name of the connection property to set.
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * [Required] Name of the connection property to set.
   * @param key key or {@code null} for none
   */
  public ConnectionProperty setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  /**
   * [Required] Value of the connection property.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * [Required] Value of the connection property.
   * @param value value or {@code null} for none
   */
  public ConnectionProperty setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public ConnectionProperty set(String fieldName, Object value) {
    return (ConnectionProperty) super.set(fieldName, value);
  }

  @Override
  public ConnectionProperty clone() {
    return (ConnectionProperty) super.clone();
  }

}
