/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-18 at 00:39:43 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * This represents a user session performed on a specific device at a certain time over a period of
 * time.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserActivitySession extends com.google.api.client.json.GenericJson {

  /**
   * Represents a detailed view into each of the activity in this session.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Activity> activities;

  static {
    // hack to force ProGuard to consider Activity used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Activity.class);
  }

  /**
   * The data source of a hit. By default, hits sent from analytics.js are reported as "web" and
   * hits sent from the mobile SDKs are reported as "app". These values can be overridden in the
   * Measurement Protocol.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataSource;

  /**
   * The type of device used: "mobile", "tablet" etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deviceCategory;

  /**
   * Platform on which the activity happened: "android", "ios" etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String platform;

  /**
   * Date of this session in ISO-8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sessionDate;

  /**
   * Unique ID of the session.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sessionId;

  /**
   * Represents a detailed view into each of the activity in this session.
   * @return value or {@code null} for none
   */
  public java.util.List<Activity> getActivities() {
    return activities;
  }

  /**
   * Represents a detailed view into each of the activity in this session.
   * @param activities activities or {@code null} for none
   */
  public UserActivitySession setActivities(java.util.List<Activity> activities) {
    this.activities = activities;
    return this;
  }

  /**
   * The data source of a hit. By default, hits sent from analytics.js are reported as "web" and
   * hits sent from the mobile SDKs are reported as "app". These values can be overridden in the
   * Measurement Protocol.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataSource() {
    return dataSource;
  }

  /**
   * The data source of a hit. By default, hits sent from analytics.js are reported as "web" and
   * hits sent from the mobile SDKs are reported as "app". These values can be overridden in the
   * Measurement Protocol.
   * @param dataSource dataSource or {@code null} for none
   */
  public UserActivitySession setDataSource(java.lang.String dataSource) {
    this.dataSource = dataSource;
    return this;
  }

  /**
   * The type of device used: "mobile", "tablet" etc.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeviceCategory() {
    return deviceCategory;
  }

  /**
   * The type of device used: "mobile", "tablet" etc.
   * @param deviceCategory deviceCategory or {@code null} for none
   */
  public UserActivitySession setDeviceCategory(java.lang.String deviceCategory) {
    this.deviceCategory = deviceCategory;
    return this;
  }

  /**
   * Platform on which the activity happened: "android", "ios" etc.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlatform() {
    return platform;
  }

  /**
   * Platform on which the activity happened: "android", "ios" etc.
   * @param platform platform or {@code null} for none
   */
  public UserActivitySession setPlatform(java.lang.String platform) {
    this.platform = platform;
    return this;
  }

  /**
   * Date of this session in ISO-8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getSessionDate() {
    return sessionDate;
  }

  /**
   * Date of this session in ISO-8601 format.
   * @param sessionDate sessionDate or {@code null} for none
   */
  public UserActivitySession setSessionDate(java.lang.String sessionDate) {
    this.sessionDate = sessionDate;
    return this;
  }

  /**
   * Unique ID of the session.
   * @return value or {@code null} for none
   */
  public java.lang.String getSessionId() {
    return sessionId;
  }

  /**
   * Unique ID of the session.
   * @param sessionId sessionId or {@code null} for none
   */
  public UserActivitySession setSessionId(java.lang.String sessionId) {
    this.sessionId = sessionId;
    return this;
  }

  @Override
  public UserActivitySession set(String fieldName, Object value) {
    return (UserActivitySession) super.set(fieldName, value);
  }

  @Override
  public UserActivitySession clone() {
    return (UserActivitySession) super.clone();
  }

}
