/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-18 at 00:39:43 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * E-commerce details associated with the user activity.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EcommerceData extends com.google.api.client.json.GenericJson {

  /**
   * Action associated with this e-commerce action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String actionType;

  /**
   * The type of this e-commerce activity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ecommerceType;

  /**
   * Details of the products in this transaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ProductData> products;

  /**
   * Transaction details of this e-commerce action.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TransactionData transaction;

  /**
   * Action associated with this e-commerce action.
   * @return value or {@code null} for none
   */
  public java.lang.String getActionType() {
    return actionType;
  }

  /**
   * Action associated with this e-commerce action.
   * @param actionType actionType or {@code null} for none
   */
  public EcommerceData setActionType(java.lang.String actionType) {
    this.actionType = actionType;
    return this;
  }

  /**
   * The type of this e-commerce activity.
   * @return value or {@code null} for none
   */
  public java.lang.String getEcommerceType() {
    return ecommerceType;
  }

  /**
   * The type of this e-commerce activity.
   * @param ecommerceType ecommerceType or {@code null} for none
   */
  public EcommerceData setEcommerceType(java.lang.String ecommerceType) {
    this.ecommerceType = ecommerceType;
    return this;
  }

  /**
   * Details of the products in this transaction.
   * @return value or {@code null} for none
   */
  public java.util.List<ProductData> getProducts() {
    return products;
  }

  /**
   * Details of the products in this transaction.
   * @param products products or {@code null} for none
   */
  public EcommerceData setProducts(java.util.List<ProductData> products) {
    this.products = products;
    return this;
  }

  /**
   * Transaction details of this e-commerce action.
   * @return value or {@code null} for none
   */
  public TransactionData getTransaction() {
    return transaction;
  }

  /**
   * Transaction details of this e-commerce action.
   * @param transaction transaction or {@code null} for none
   */
  public EcommerceData setTransaction(TransactionData transaction) {
    this.transaction = transaction;
    return this;
  }

  @Override
  public EcommerceData set(String fieldName, Object value) {
    return (EcommerceData) super.set(fieldName, value);
  }

  @Override
  public EcommerceData clone() {
    return (EcommerceData) super.clone();
  }

}
