/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-06-09 16:41:44 UTC)
 * on 2014-06-18 at 00:10:36 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for an Analytics account ticket. The account ticket consists of the ticket ID and
 * the basic information for the account, property and profile.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountTicket extends com.google.api.client.json.GenericJson {

  /**
   * Account for this ticket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Account account;

  /**
   * Account ticket ID used to access the account ticket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Resource type for account ticket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * View (Profile) for the account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Profile profile;

  /**
   * Redirect URI where the user will be sent after accepting Terms of Service. Must be configured
   * in APIs console as a callback URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String redirectUri;

  /**
   * Web property for the account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Webproperty webproperty;

  /**
   * Account for this ticket.
   * @return value or {@code null} for none
   */
  public Account getAccount() {
    return account;
  }

  /**
   * Account for this ticket.
   * @param account account or {@code null} for none
   */
  public AccountTicket setAccount(Account account) {
    this.account = account;
    return this;
  }

  /**
   * Account ticket ID used to access the account ticket.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Account ticket ID used to access the account ticket.
   * @param id id or {@code null} for none
   */
  public AccountTicket setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Resource type for account ticket.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for account ticket.
   * @param kind kind or {@code null} for none
   */
  public AccountTicket setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * View (Profile) for the account.
   * @return value or {@code null} for none
   */
  public Profile getProfile() {
    return profile;
  }

  /**
   * View (Profile) for the account.
   * @param profile profile or {@code null} for none
   */
  public AccountTicket setProfile(Profile profile) {
    this.profile = profile;
    return this;
  }

  /**
   * Redirect URI where the user will be sent after accepting Terms of Service. Must be configured
   * in APIs console as a callback URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getRedirectUri() {
    return redirectUri;
  }

  /**
   * Redirect URI where the user will be sent after accepting Terms of Service. Must be configured
   * in APIs console as a callback URL.
   * @param redirectUri redirectUri or {@code null} for none
   */
  public AccountTicket setRedirectUri(java.lang.String redirectUri) {
    this.redirectUri = redirectUri;
    return this;
  }

  /**
   * Web property for the account.
   * @return value or {@code null} for none
   */
  public Webproperty getWebproperty() {
    return webproperty;
  }

  /**
   * Web property for the account.
   * @param webproperty webproperty or {@code null} for none
   */
  public AccountTicket setWebproperty(Webproperty webproperty) {
    this.webproperty = webproperty;
    return this;
  }

  @Override
  public AccountTicket set(String fieldName, Object value) {
    return (AccountTicket) super.set(fieldName, value);
  }

  @Override
  public AccountTicket clone() {
    return (AccountTicket) super.clone();
  }

}
