/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-08-26 17:13:51 UTC)
 * on 2013-09-09 at 19:13:30 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * An advanced segment collection lists Analytics advanced segments that the user has access to.
 * Each resource in the collection corresponds to a single Analytics advanced segment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Segments extends com.google.api.client.json.GenericJson {

  /**
   * A list of advanced segments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Segment> items;

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer itemsPerPage;

  /**
   * Collection type for advanced segments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Link to next page for this advanced segment collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextLink;

  /**
   * Link to previous page for this advanced segment collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String previousLink;

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startIndex;

  /**
   * The total number of results for the query, regardless of the number of results in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalResults;

  /**
   * Email ID of the authenticated user
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String username;

  /**
   * A list of advanced segments.
   * @return value or {@code null} for none
   */
  public java.util.List<Segment> getItems() {
    return items;
  }

  /**
   * A list of advanced segments.
   * @param items items or {@code null} for none
   */
  public Segments setItems(java.util.List<Segment> items) {
    this.items = items;
    return this;
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getItemsPerPage() {
    return itemsPerPage;
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * @param itemsPerPage itemsPerPage or {@code null} for none
   */
  public Segments setItemsPerPage(java.lang.Integer itemsPerPage) {
    this.itemsPerPage = itemsPerPage;
    return this;
  }

  /**
   * Collection type for advanced segments.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Collection type for advanced segments.
   * @param kind kind or {@code null} for none
   */
  public Segments setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Link to next page for this advanced segment collection.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextLink() {
    return nextLink;
  }

  /**
   * Link to next page for this advanced segment collection.
   * @param nextLink nextLink or {@code null} for none
   */
  public Segments setNextLink(java.lang.String nextLink) {
    this.nextLink = nextLink;
    return this;
  }

  /**
   * Link to previous page for this advanced segment collection.
   * @return value or {@code null} for none
   */
  public java.lang.String getPreviousLink() {
    return previousLink;
  }

  /**
   * Link to previous page for this advanced segment collection.
   * @param previousLink previousLink or {@code null} for none
   */
  public Segments setPreviousLink(java.lang.String previousLink) {
    this.previousLink = previousLink;
    return this;
  }

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartIndex() {
    return startIndex;
  }

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * @param startIndex startIndex or {@code null} for none
   */
  public Segments setStartIndex(java.lang.Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  /**
   * The total number of results for the query, regardless of the number of results in the response.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalResults() {
    return totalResults;
  }

  /**
   * The total number of results for the query, regardless of the number of results in the response.
   * @param totalResults totalResults or {@code null} for none
   */
  public Segments setTotalResults(java.lang.Integer totalResults) {
    this.totalResults = totalResults;
    return this;
  }

  /**
   * Email ID of the authenticated user
   * @return value or {@code null} for none
   */
  public java.lang.String getUsername() {
    return username;
  }

  /**
   * Email ID of the authenticated user
   * @param username username or {@code null} for none
   */
  public Segments setUsername(java.lang.String username) {
    this.username = username;
    return this;
  }

  @Override
  public Segments set(String fieldName, Object value) {
    return (Segments) super.set(fieldName, value);
  }

  @Override
  public Segments clone() {
    return (Segments) super.clone();
  }

}
