/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.analytics.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.api.client.util.DateTime;

/**
 * JSON template for Analytics goal resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Goal extends GenericJson {

  /**
   * Account ID to which this goal belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String accountId;

  /**
   * Determines whether this goal is active.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean active;

  /**
   * Time this goal was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime created;

  /**
   * Details for the goal of the type EVENT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EventDetails eventDetails;

  /**
   * Goal ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * Internal ID for the web property to which this goal belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String internalWebPropertyId;

  /**
   * Resource type for an Analytics goal.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Goal name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Parent link for a goal. Points to the profile to which this goal belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParentLink parentLink;

  /**
   * Profile ID to which this goal belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String profileId;

  /**
   * Link for this goal.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Goal type. Possible values are URL_DESTINATION, VISIT_TIME_ON_SITE, VISIT_NUM_PAGES, AND EVENT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String type;

  /**
   * Time this goal was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime updated;

  /**
   * Details for the goal of the type URL_DESTINATION.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UrlDestinationDetails urlDestinationDetails;

  /**
   * Goal value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Float value;

  /**
   * Details for the goal of the type VISIT_NUM_PAGES.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VisitNumPagesDetails visitNumPagesDetails;

  /**
   * Details for the goal of the type VISIT_TIME_ON_SITE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VisitTimeOnSiteDetails visitTimeOnSiteDetails;

  /**
   * Web property ID to which this goal belongs. The web property ID is of the form UA-XXXXX-YY.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String webPropertyId;

  /**
   * Account ID to which this goal belongs.
   * The value returned may be {@code null}.
   */
  public String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this goal belongs.
   * The value set may be {@code null}.
   */
  public Goal setAccountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Determines whether this goal is active.
   * The value returned may be {@code null}.
   */
  public Boolean getActive() {
    return active;
  }

  /**
   * Determines whether this goal is active.
   * The value set may be {@code null}.
   */
  public Goal setActive(Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Time this goal was created.
   * The value returned may be {@code null}.
   */
  public DateTime getCreated() {
    return created;
  }

  /**
   * Time this goal was created.
   * The value set may be {@code null}.
   */
  public Goal setCreated(DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * Details for the goal of the type EVENT.
   * The value returned may be {@code null}.
   */
  public EventDetails getEventDetails() {
    return eventDetails;
  }

  /**
   * Details for the goal of the type EVENT.
   * The value set may be {@code null}.
   */
  public Goal setEventDetails(EventDetails eventDetails) {
    this.eventDetails = eventDetails;
    return this;
  }

  /**
   * Goal ID.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * Goal ID.
   * The value set may be {@code null}.
   */
  public Goal setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Internal ID for the web property to which this goal belongs.
   * The value returned may be {@code null}.
   */
  public String getInternalWebPropertyId() {
    return internalWebPropertyId;
  }

  /**
   * Internal ID for the web property to which this goal belongs.
   * The value set may be {@code null}.
   */
  public Goal setInternalWebPropertyId(String internalWebPropertyId) {
    this.internalWebPropertyId = internalWebPropertyId;
    return this;
  }

  /**
   * Resource type for an Analytics goal.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Resource type for an Analytics goal.
   * The value set may be {@code null}.
   */
  public Goal setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Goal name.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Goal name.
   * The value set may be {@code null}.
   */
  public Goal setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Parent link for a goal. Points to the profile to which this goal belongs.
   * The value returned may be {@code null}.
   */
  public ParentLink getParentLink() {
    return parentLink;
  }

  /**
   * Parent link for a goal. Points to the profile to which this goal belongs.
   * The value set may be {@code null}.
   */
  public Goal setParentLink(ParentLink parentLink) {
    this.parentLink = parentLink;
    return this;
  }

  /**
   * Profile ID to which this goal belongs.
   * The value returned may be {@code null}.
   */
  public String getProfileId() {
    return profileId;
  }

  /**
   * Profile ID to which this goal belongs.
   * The value set may be {@code null}.
   */
  public Goal setProfileId(String profileId) {
    this.profileId = profileId;
    return this;
  }

  /**
   * Link for this goal.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this goal.
   * The value set may be {@code null}.
   */
  public Goal setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Goal type. Possible values are URL_DESTINATION, VISIT_TIME_ON_SITE, VISIT_NUM_PAGES, AND EVENT.
   * The value returned may be {@code null}.
   */
  public String getType() {
    return type;
  }

  /**
   * Goal type. Possible values are URL_DESTINATION, VISIT_TIME_ON_SITE, VISIT_NUM_PAGES, AND EVENT.
   * The value set may be {@code null}.
   */
  public Goal setType(String type) {
    this.type = type;
    return this;
  }

  /**
   * Time this goal was last modified.
   * The value returned may be {@code null}.
   */
  public DateTime getUpdated() {
    return updated;
  }

  /**
   * Time this goal was last modified.
   * The value set may be {@code null}.
   */
  public Goal setUpdated(DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Details for the goal of the type URL_DESTINATION.
   * The value returned may be {@code null}.
   */
  public UrlDestinationDetails getUrlDestinationDetails() {
    return urlDestinationDetails;
  }

  /**
   * Details for the goal of the type URL_DESTINATION.
   * The value set may be {@code null}.
   */
  public Goal setUrlDestinationDetails(UrlDestinationDetails urlDestinationDetails) {
    this.urlDestinationDetails = urlDestinationDetails;
    return this;
  }

  /**
   * Goal value.
   * The value returned may be {@code null}.
   */
  public Float getValue() {
    return value;
  }

  /**
   * Goal value.
   * The value set may be {@code null}.
   */
  public Goal setValue(Float value) {
    this.value = value;
    return this;
  }

  /**
   * Details for the goal of the type VISIT_NUM_PAGES.
   * The value returned may be {@code null}.
   */
  public VisitNumPagesDetails getVisitNumPagesDetails() {
    return visitNumPagesDetails;
  }

  /**
   * Details for the goal of the type VISIT_NUM_PAGES.
   * The value set may be {@code null}.
   */
  public Goal setVisitNumPagesDetails(VisitNumPagesDetails visitNumPagesDetails) {
    this.visitNumPagesDetails = visitNumPagesDetails;
    return this;
  }

  /**
   * Details for the goal of the type VISIT_TIME_ON_SITE.
   * The value returned may be {@code null}.
   */
  public VisitTimeOnSiteDetails getVisitTimeOnSiteDetails() {
    return visitTimeOnSiteDetails;
  }

  /**
   * Details for the goal of the type VISIT_TIME_ON_SITE.
   * The value set may be {@code null}.
   */
  public Goal setVisitTimeOnSiteDetails(VisitTimeOnSiteDetails visitTimeOnSiteDetails) {
    this.visitTimeOnSiteDetails = visitTimeOnSiteDetails;
    return this;
  }

  /**
   * Web property ID to which this goal belongs. The web property ID is of the form UA-XXXXX-YY.
   * The value returned may be {@code null}.
   */
  public String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID to which this goal belongs. The web property ID is of the form UA-XXXXX-YY.
   * The value set may be {@code null}.
   */
  public Goal setWebPropertyId(String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  /**
   * Details for the goal of the type EVENT.
   */
  public static final class EventDetails extends GenericJson {

    /**
     * List of event conditions.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<EventConditions> eventConditions;

    static {
      // hack to force ProGuard to consider EventConditions used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(EventConditions.class);
    }

    /**
     * Determines if the event value should be used as the value for this goal.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean useEventValue;

    /**
     * List of event conditions.
     * The value returned may be {@code null}.
     */
    public java.util.List<EventConditions> getEventConditions() {
      return eventConditions;
    }

    /**
     * List of event conditions.
     * The value set may be {@code null}.
     */
    public EventDetails setEventConditions(java.util.List<EventConditions> eventConditions) {
      this.eventConditions = eventConditions;
      return this;
    }

    /**
     * Determines if the event value should be used as the value for this goal.
     * The value returned may be {@code null}.
     */
    public Boolean getUseEventValue() {
      return useEventValue;
    }

    /**
     * Determines if the event value should be used as the value for this goal.
     * The value set may be {@code null}.
     */
    public EventDetails setUseEventValue(Boolean useEventValue) {
      this.useEventValue = useEventValue;
      return this;
    }

    /**
     * Model definition for GoalEventDetailsEventConditions.
     */
    public static final class EventConditions extends GenericJson {

      /**
       * Type of comparison. Possible values are LESS_THAN, GREATER_THAN or EQUAL.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String comparisonType;

      /**
       * Value used for this comparison.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key @JsonString
      private Long comparisonValue;

      /**
       * Expression used for this match.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String expression;

      /**
       * Type of the match to be performed. Possible values are REGEXP, BEGINS_WITH, or EXACT.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String matchType;

      /**
       * Type of this event condition. Possible values are CATEGORY, ACTION, LABEL, or VALUE.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String type;

      /**
       * Type of comparison. Possible values are LESS_THAN, GREATER_THAN or EQUAL.
       * The value returned may be {@code null}.
       */
      public String getComparisonType() {
        return comparisonType;
      }

      /**
       * Type of comparison. Possible values are LESS_THAN, GREATER_THAN or EQUAL.
       * The value set may be {@code null}.
       */
      public EventConditions setComparisonType(String comparisonType) {
        this.comparisonType = comparisonType;
        return this;
      }

      /**
       * Value used for this comparison.
       * The value returned may be {@code null}.
       */
      public Long getComparisonValue() {
        return comparisonValue;
      }

      /**
       * Value used for this comparison.
       * The value set may be {@code null}.
       */
      public EventConditions setComparisonValue(Long comparisonValue) {
        this.comparisonValue = comparisonValue;
        return this;
      }

      /**
       * Expression used for this match.
       * The value returned may be {@code null}.
       */
      public String getExpression() {
        return expression;
      }

      /**
       * Expression used for this match.
       * The value set may be {@code null}.
       */
      public EventConditions setExpression(String expression) {
        this.expression = expression;
        return this;
      }

      /**
       * Type of the match to be performed. Possible values are REGEXP, BEGINS_WITH, or EXACT.
       * The value returned may be {@code null}.
       */
      public String getMatchType() {
        return matchType;
      }

      /**
       * Type of the match to be performed. Possible values are REGEXP, BEGINS_WITH, or EXACT.
       * The value set may be {@code null}.
       */
      public EventConditions setMatchType(String matchType) {
        this.matchType = matchType;
        return this;
      }

      /**
       * Type of this event condition. Possible values are CATEGORY, ACTION, LABEL, or VALUE.
       * The value returned may be {@code null}.
       */
      public String getType() {
        return type;
      }

      /**
       * Type of this event condition. Possible values are CATEGORY, ACTION, LABEL, or VALUE.
       * The value set may be {@code null}.
       */
      public EventConditions setType(String type) {
        this.type = type;
        return this;
      }

    }
  }

  /**
   * Parent link for a goal. Points to the profile to which this goal belongs.
   */
  public static final class ParentLink extends GenericJson {

    /**
     * Link to the profile to which this goal belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String href;

    /**
     * Value is "analytics#profile".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String type;

    /**
     * Link to the profile to which this goal belongs.
     * The value returned may be {@code null}.
     */
    public String getHref() {
      return href;
    }

    /**
     * Link to the profile to which this goal belongs.
     * The value set may be {@code null}.
     */
    public ParentLink setHref(String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#profile".
     * The value returned may be {@code null}.
     */
    public String getType() {
      return type;
    }

    /**
     * Value is "analytics#profile".
     * The value set may be {@code null}.
     */
    public ParentLink setType(String type) {
      this.type = type;
      return this;
    }

  }

  /**
   * Details for the goal of the type URL_DESTINATION.
   */
  public static final class UrlDestinationDetails extends GenericJson {

    /**
     * Determines if the goal URL must exactly match the capitalization of visited URLs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean caseSensitive;

    /**
     * Determines if the first step in this goal is required.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean firstStepRequired;

    /**
     * Match type for the goal URL. Possible values are HEAD, EXACT, or REGEX.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String matchType;

    /**
     * List of steps configured for this goal funnel.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Steps> steps;

    static {
      // hack to force ProGuard to consider Steps used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Steps.class);
    }

    /**
     * URL for this goal.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String url;

    /**
     * Determines if the goal URL must exactly match the capitalization of visited URLs.
     * The value returned may be {@code null}.
     */
    public Boolean getCaseSensitive() {
      return caseSensitive;
    }

    /**
     * Determines if the goal URL must exactly match the capitalization of visited URLs.
     * The value set may be {@code null}.
     */
    public UrlDestinationDetails setCaseSensitive(Boolean caseSensitive) {
      this.caseSensitive = caseSensitive;
      return this;
    }

    /**
     * Determines if the first step in this goal is required.
     * The value returned may be {@code null}.
     */
    public Boolean getFirstStepRequired() {
      return firstStepRequired;
    }

    /**
     * Determines if the first step in this goal is required.
     * The value set may be {@code null}.
     */
    public UrlDestinationDetails setFirstStepRequired(Boolean firstStepRequired) {
      this.firstStepRequired = firstStepRequired;
      return this;
    }

    /**
     * Match type for the goal URL. Possible values are HEAD, EXACT, or REGEX.
     * The value returned may be {@code null}.
     */
    public String getMatchType() {
      return matchType;
    }

    /**
     * Match type for the goal URL. Possible values are HEAD, EXACT, or REGEX.
     * The value set may be {@code null}.
     */
    public UrlDestinationDetails setMatchType(String matchType) {
      this.matchType = matchType;
      return this;
    }

    /**
     * List of steps configured for this goal funnel.
     * The value returned may be {@code null}.
     */
    public java.util.List<Steps> getSteps() {
      return steps;
    }

    /**
     * List of steps configured for this goal funnel.
     * The value set may be {@code null}.
     */
    public UrlDestinationDetails setSteps(java.util.List<Steps> steps) {
      this.steps = steps;
      return this;
    }

    /**
     * URL for this goal.
     * The value returned may be {@code null}.
     */
    public String getUrl() {
      return url;
    }

    /**
     * URL for this goal.
     * The value set may be {@code null}.
     */
    public UrlDestinationDetails setUrl(String url) {
      this.url = url;
      return this;
    }

    /**
     * Model definition for GoalUrlDestinationDetailsSteps.
     */
    public static final class Steps extends GenericJson {

      /**
       * Step name.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String name;

      /**
       * Step number.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private Integer number;

      /**
       * URL for this step.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String url;

      /**
       * Step name.
       * The value returned may be {@code null}.
       */
      public String getName() {
        return name;
      }

      /**
       * Step name.
       * The value set may be {@code null}.
       */
      public Steps setName(String name) {
        this.name = name;
        return this;
      }

      /**
       * Step number.
       * The value returned may be {@code null}.
       */
      public Integer getNumber() {
        return number;
      }

      /**
       * Step number.
       * The value set may be {@code null}.
       */
      public Steps setNumber(Integer number) {
        this.number = number;
        return this;
      }

      /**
       * URL for this step.
       * The value returned may be {@code null}.
       */
      public String getUrl() {
        return url;
      }

      /**
       * URL for this step.
       * The value set may be {@code null}.
       */
      public Steps setUrl(String url) {
        this.url = url;
        return this;
      }

    }
  }

  /**
   * Details for the goal of the type VISIT_NUM_PAGES.
   */
  public static final class VisitNumPagesDetails extends GenericJson {

    /**
     * Type of comparison. Possible values are LESS_THAN, GREATER_THAN, or EQUAL.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String comparisonType;

    /**
     * Value used for this comparison.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @JsonString
    private Long comparisonValue;

    /**
     * Type of comparison. Possible values are LESS_THAN, GREATER_THAN, or EQUAL.
     * The value returned may be {@code null}.
     */
    public String getComparisonType() {
      return comparisonType;
    }

    /**
     * Type of comparison. Possible values are LESS_THAN, GREATER_THAN, or EQUAL.
     * The value set may be {@code null}.
     */
    public VisitNumPagesDetails setComparisonType(String comparisonType) {
      this.comparisonType = comparisonType;
      return this;
    }

    /**
     * Value used for this comparison.
     * The value returned may be {@code null}.
     */
    public Long getComparisonValue() {
      return comparisonValue;
    }

    /**
     * Value used for this comparison.
     * The value set may be {@code null}.
     */
    public VisitNumPagesDetails setComparisonValue(Long comparisonValue) {
      this.comparisonValue = comparisonValue;
      return this;
    }

  }

  /**
   * Details for the goal of the type VISIT_TIME_ON_SITE.
   */
  public static final class VisitTimeOnSiteDetails extends GenericJson {

    /**
     * Type of comparison. Possible values are LESS_THAN or GREATER_THAN.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String comparisonType;

    /**
     * Value used for this comparison.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @JsonString
    private Long comparisonValue;

    /**
     * Type of comparison. Possible values are LESS_THAN or GREATER_THAN.
     * The value returned may be {@code null}.
     */
    public String getComparisonType() {
      return comparisonType;
    }

    /**
     * Type of comparison. Possible values are LESS_THAN or GREATER_THAN.
     * The value set may be {@code null}.
     */
    public VisitTimeOnSiteDetails setComparisonType(String comparisonType) {
      this.comparisonType = comparisonType;
      return this;
    }

    /**
     * Value used for this comparison.
     * The value returned may be {@code null}.
     */
    public Long getComparisonValue() {
      return comparisonValue;
    }

    /**
     * Value used for this comparison.
     * The value set may be {@code null}.
     */
    public VisitTimeOnSiteDetails setComparisonValue(Long comparisonValue) {
      this.comparisonValue = comparisonValue;
      return this;
    }

  }

}
