/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.analytics.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;

/**
 * Metadata for daily upload entity.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DailyUpload extends GenericJson {

  /**
   * Account ID to which this daily upload belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String accountId;

  /**
   * Number of appends for this date.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer appendCount;

  /**
   * Time this daily upload was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime createdTime;

  /**
   * Custom data source ID to which this daily upload belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String customDataSourceId;

  /**
   * Date associated with daily upload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String date;

  /**
   * Resource type for Analytics daily upload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Time this daily upload was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime modifiedTime;

  /**
   * Parent link for a daily upload. Points to the custom data source to which this daily upload
   * belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParentLink parentLink;

  /**
   * Change log for last 10 changes in chronological order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RecentChanges> recentChanges;

  static {
    // hack to force ProGuard to consider RecentChanges used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(RecentChanges.class);
  }

  /**
   * Link for this daily upload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Web property ID of the form UA-XXXXX-YY to which this daily upload belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String webPropertyId;

  /**
   * Account ID to which this daily upload belongs.
   * The value returned may be {@code null}.
   */
  public String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this daily upload belongs.
   * The value set may be {@code null}.
   */
  public DailyUpload setAccountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Number of appends for this date.
   * The value returned may be {@code null}.
   */
  public Integer getAppendCount() {
    return appendCount;
  }

  /**
   * Number of appends for this date.
   * The value set may be {@code null}.
   */
  public DailyUpload setAppendCount(Integer appendCount) {
    this.appendCount = appendCount;
    return this;
  }

  /**
   * Time this daily upload was created.
   * The value returned may be {@code null}.
   */
  public DateTime getCreatedTime() {
    return createdTime;
  }

  /**
   * Time this daily upload was created.
   * The value set may be {@code null}.
   */
  public DailyUpload setCreatedTime(DateTime createdTime) {
    this.createdTime = createdTime;
    return this;
  }

  /**
   * Custom data source ID to which this daily upload belongs.
   * The value returned may be {@code null}.
   */
  public String getCustomDataSourceId() {
    return customDataSourceId;
  }

  /**
   * Custom data source ID to which this daily upload belongs.
   * The value set may be {@code null}.
   */
  public DailyUpload setCustomDataSourceId(String customDataSourceId) {
    this.customDataSourceId = customDataSourceId;
    return this;
  }

  /**
   * Date associated with daily upload.
   * The value returned may be {@code null}.
   */
  public String getDate() {
    return date;
  }

  /**
   * Date associated with daily upload.
   * The value set may be {@code null}.
   */
  public DailyUpload setDate(String date) {
    this.date = date;
    return this;
  }

  /**
   * Resource type for Analytics daily upload.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics daily upload.
   * The value set may be {@code null}.
   */
  public DailyUpload setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Time this daily upload was last modified.
   * The value returned may be {@code null}.
   */
  public DateTime getModifiedTime() {
    return modifiedTime;
  }

  /**
   * Time this daily upload was last modified.
   * The value set may be {@code null}.
   */
  public DailyUpload setModifiedTime(DateTime modifiedTime) {
    this.modifiedTime = modifiedTime;
    return this;
  }

  /**
   * Parent link for a daily upload. Points to the custom data source to which this daily upload
   * belongs.
   * The value returned may be {@code null}.
   */
  public ParentLink getParentLink() {
    return parentLink;
  }

  /**
   * Parent link for a daily upload. Points to the custom data source to which this daily upload
   * belongs.
   * The value set may be {@code null}.
   */
  public DailyUpload setParentLink(ParentLink parentLink) {
    this.parentLink = parentLink;
    return this;
  }

  /**
   * Change log for last 10 changes in chronological order.
   * The value returned may be {@code null}.
   */
  public java.util.List<RecentChanges> getRecentChanges() {
    return recentChanges;
  }

  /**
   * Change log for last 10 changes in chronological order.
   * The value set may be {@code null}.
   */
  public DailyUpload setRecentChanges(java.util.List<RecentChanges> recentChanges) {
    this.recentChanges = recentChanges;
    return this;
  }

  /**
   * Link for this daily upload.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this daily upload.
   * The value set may be {@code null}.
   */
  public DailyUpload setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this daily upload belongs.
   * The value returned may be {@code null}.
   */
  public String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this daily upload belongs.
   * The value set may be {@code null}.
   */
  public DailyUpload setWebPropertyId(String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  /**
   * Parent link for a daily upload. Points to the custom data source to which this daily upload
   * belongs.
   */
  public static final class ParentLink extends GenericJson {

    /**
     * Link to the custom data source to which this daily upload belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String href;

    /**
     * Value is "analytics#customDataSource".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String type;

    /**
     * Link to the custom data source to which this daily upload belongs.
     * The value returned may be {@code null}.
     */
    public String getHref() {
      return href;
    }

    /**
     * Link to the custom data source to which this daily upload belongs.
     * The value set may be {@code null}.
     */
    public ParentLink setHref(String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#customDataSource".
     * The value returned may be {@code null}.
     */
    public String getType() {
      return type;
    }

    /**
     * Value is "analytics#customDataSource".
     * The value set may be {@code null}.
     */
    public ParentLink setType(String type) {
      this.type = type;
      return this;
    }

  }

  /**
   * Model definition for DailyUploadRecentChanges.
   */
  public static final class RecentChanges extends GenericJson {

    /**
     * The type of change: APPEND, RESET, or DELETE.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String change;

    /**
     * The time when the change occurred.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DateTime time;

    /**
     * The type of change: APPEND, RESET, or DELETE.
     * The value returned may be {@code null}.
     */
    public String getChange() {
      return change;
    }

    /**
     * The type of change: APPEND, RESET, or DELETE.
     * The value set may be {@code null}.
     */
    public RecentChanges setChange(String change) {
      this.change = change;
      return this;
    }

    /**
     * The time when the change occurred.
     * The value returned may be {@code null}.
     */
    public DateTime getTime() {
      return time;
    }

    /**
     * The time when the change occurred.
     * The value set may be {@code null}.
     */
    public RecentChanges setTime(DateTime time) {
      this.time = time;
      return this;
    }

  }

}
