/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.analytics.model;

import com.google.api.client.json.GenericJson;

/**
 * An account collection provides a list of Analytics accounts to which a user has access. The
 * account collection is the entry point to all management information. Each resource in the
 * collection corresponds to a single Analytics account.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Accounts extends GenericJson {

  /**
   * A list of accounts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Account> items;

  static {
    // hack to force ProGuard to consider Account used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Account.class);
  }

  /**
   * The maximum number of entries the response can contain, regardless of the actual number of
   * entries returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or otherwise
   * specified by the max-results query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer itemsPerPage;

  /**
   * Collection type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Next link for this account collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextLink;

  /**
   * Previous link for this account collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String previousLink;

  /**
   * The starting index of the entries, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer startIndex;

  /**
   * The total number of results for the query, regardless of the number of results in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer totalResults;

  /**
   * Email ID of the authenticated user
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String username;

  /**
   * A list of accounts.
   * The value returned may be {@code null}.
   */
  public java.util.List<Account> getItems() {
    return items;
  }

  /**
   * A list of accounts.
   * The value set may be {@code null}.
   */
  public Accounts setItems(java.util.List<Account> items) {
    this.items = items;
    return this;
  }

  /**
   * The maximum number of entries the response can contain, regardless of the actual number of
   * entries returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or otherwise
   * specified by the max-results query parameter.
   * The value returned may be {@code null}.
   */
  public Integer getItemsPerPage() {
    return itemsPerPage;
  }

  /**
   * The maximum number of entries the response can contain, regardless of the actual number of
   * entries returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or otherwise
   * specified by the max-results query parameter.
   * The value set may be {@code null}.
   */
  public Accounts setItemsPerPage(Integer itemsPerPage) {
    this.itemsPerPage = itemsPerPage;
    return this;
  }

  /**
   * Collection type.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Collection type.
   * The value set may be {@code null}.
   */
  public Accounts setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Next link for this account collection.
   * The value returned may be {@code null}.
   */
  public String getNextLink() {
    return nextLink;
  }

  /**
   * Next link for this account collection.
   * The value set may be {@code null}.
   */
  public Accounts setNextLink(String nextLink) {
    this.nextLink = nextLink;
    return this;
  }

  /**
   * Previous link for this account collection.
   * The value returned may be {@code null}.
   */
  public String getPreviousLink() {
    return previousLink;
  }

  /**
   * Previous link for this account collection.
   * The value set may be {@code null}.
   */
  public Accounts setPreviousLink(String previousLink) {
    this.previousLink = previousLink;
    return this;
  }

  /**
   * The starting index of the entries, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * The value returned may be {@code null}.
   */
  public Integer getStartIndex() {
    return startIndex;
  }

  /**
   * The starting index of the entries, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * The value set may be {@code null}.
   */
  public Accounts setStartIndex(Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  /**
   * The total number of results for the query, regardless of the number of results in the response.
   * The value returned may be {@code null}.
   */
  public Integer getTotalResults() {
    return totalResults;
  }

  /**
   * The total number of results for the query, regardless of the number of results in the response.
   * The value set may be {@code null}.
   */
  public Accounts setTotalResults(Integer totalResults) {
    this.totalResults = totalResults;
    return this;
  }

  /**
   * Email ID of the authenticated user
   * The value returned may be {@code null}.
   */
  public String getUsername() {
    return username;
  }

  /**
   * Email ID of the authenticated user
   * The value set may be {@code null}.
   */
  public Accounts setUsername(String username) {
    this.username = username;
    return this;
  }

}
