/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-20 at 11:23:34 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for an Analytics custom data source.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomDataSource extends com.google.api.client.json.GenericJson {

  /**
   * Account ID to which this custom data source belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChildLink childLink;

  /**
   * Time this custom data source was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime created;

  /**
   * Description of custom data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Custom data source ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String importBehavior;

  /**
   * Resource type for Analytics custom data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of this custom data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Parent link for this custom data source. Points to the web property to which this custom data
   * source belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParentLink parentLink;

  /**
   * IDs of views (profiles) linked to the custom data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> profilesLinked;

  /**
   * Collection of schema headers of the custom data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> schema;

  /**
   * Link for this Analytics custom data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Type of the custom data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Time this custom data source was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * Upload type of the custom data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uploadType;

  /**
   * Web property ID of the form UA-XXXXX-YY to which this custom data source belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webPropertyId;

  /**
   * Account ID to which this custom data source belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this custom data source belongs.
   * @param accountId accountId or {@code null} for none
   */
  public CustomDataSource setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public ChildLink getChildLink() {
    return childLink;
  }

  /**
   * @param childLink childLink or {@code null} for none
   */
  public CustomDataSource setChildLink(ChildLink childLink) {
    this.childLink = childLink;
    return this;
  }

  /**
   * Time this custom data source was created.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreated() {
    return created;
  }

  /**
   * Time this custom data source was created.
   * @param created created or {@code null} for none
   */
  public CustomDataSource setCreated(com.google.api.client.util.DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * Description of custom data source.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Description of custom data source.
   * @param description description or {@code null} for none
   */
  public CustomDataSource setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Custom data source ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Custom data source ID.
   * @param id id or {@code null} for none
   */
  public CustomDataSource setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getImportBehavior() {
    return importBehavior;
  }

  /**
   * @param importBehavior importBehavior or {@code null} for none
   */
  public CustomDataSource setImportBehavior(java.lang.String importBehavior) {
    this.importBehavior = importBehavior;
    return this;
  }

  /**
   * Resource type for Analytics custom data source.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics custom data source.
   * @param kind kind or {@code null} for none
   */
  public CustomDataSource setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this custom data source.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this custom data source.
   * @param name name or {@code null} for none
   */
  public CustomDataSource setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Parent link for this custom data source. Points to the web property to which this custom data
   * source belongs.
   * @return value or {@code null} for none
   */
  public ParentLink getParentLink() {
    return parentLink;
  }

  /**
   * Parent link for this custom data source. Points to the web property to which this custom data
   * source belongs.
   * @param parentLink parentLink or {@code null} for none
   */
  public CustomDataSource setParentLink(ParentLink parentLink) {
    this.parentLink = parentLink;
    return this;
  }

  /**
   * IDs of views (profiles) linked to the custom data source.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getProfilesLinked() {
    return profilesLinked;
  }

  /**
   * IDs of views (profiles) linked to the custom data source.
   * @param profilesLinked profilesLinked or {@code null} for none
   */
  public CustomDataSource setProfilesLinked(java.util.List<java.lang.String> profilesLinked) {
    this.profilesLinked = profilesLinked;
    return this;
  }

  /**
   * Collection of schema headers of the custom data source.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSchema() {
    return schema;
  }

  /**
   * Collection of schema headers of the custom data source.
   * @param schema schema or {@code null} for none
   */
  public CustomDataSource setSchema(java.util.List<java.lang.String> schema) {
    this.schema = schema;
    return this;
  }

  /**
   * Link for this Analytics custom data source.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this Analytics custom data source.
   * @param selfLink selfLink or {@code null} for none
   */
  public CustomDataSource setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Type of the custom data source.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of the custom data source.
   * @param type type or {@code null} for none
   */
  public CustomDataSource setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Time this custom data source was last modified.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * Time this custom data source was last modified.
   * @param updated updated or {@code null} for none
   */
  public CustomDataSource setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Upload type of the custom data source.
   * @return value or {@code null} for none
   */
  public java.lang.String getUploadType() {
    return uploadType;
  }

  /**
   * Upload type of the custom data source.
   * @param uploadType uploadType or {@code null} for none
   */
  public CustomDataSource setUploadType(java.lang.String uploadType) {
    this.uploadType = uploadType;
    return this;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this custom data source belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this custom data source belongs.
   * @param webPropertyId webPropertyId or {@code null} for none
   */
  public CustomDataSource setWebPropertyId(java.lang.String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  @Override
  public CustomDataSource set(String fieldName, Object value) {
    return (CustomDataSource) super.set(fieldName, value);
  }

  @Override
  public CustomDataSource clone() {
    return (CustomDataSource) super.clone();
  }

  /**
   * Model definition for CustomDataSourceChildLink.
   */
  public static final class ChildLink extends com.google.api.client.json.GenericJson {

    /**
     * Link to the list of daily uploads for this custom data source. Link to the list of uploads for
     * this custom data source.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String href;

    /**
     * Value is "analytics#dailyUploads". Value is "analytics#uploads".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Link to the list of daily uploads for this custom data source. Link to the list of uploads for
     * this custom data source.
     * @return value or {@code null} for none
     */
    public java.lang.String getHref() {
      return href;
    }

    /**
     * Link to the list of daily uploads for this custom data source. Link to the list of uploads for
     * this custom data source.
     * @param href href or {@code null} for none
     */
    public ChildLink setHref(java.lang.String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#dailyUploads". Value is "analytics#uploads".
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Value is "analytics#dailyUploads". Value is "analytics#uploads".
     * @param type type or {@code null} for none
     */
    public ChildLink setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public ChildLink set(String fieldName, Object value) {
      return (ChildLink) super.set(fieldName, value);
    }

    @Override
    public ChildLink clone() {
      return (ChildLink) super.clone();
    }

  }

  /**
   * Parent link for this custom data source. Points to the web property to which this custom data
   * source belongs.
   */
  public static final class ParentLink extends com.google.api.client.json.GenericJson {

    /**
     * Link to the web property to which this custom data source belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String href;

    /**
     * Value is "analytics#webproperty".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Link to the web property to which this custom data source belongs.
     * @return value or {@code null} for none
     */
    public java.lang.String getHref() {
      return href;
    }

    /**
     * Link to the web property to which this custom data source belongs.
     * @param href href or {@code null} for none
     */
    public ParentLink setHref(java.lang.String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#webproperty".
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Value is "analytics#webproperty".
     * @param type type or {@code null} for none
     */
    public ParentLink setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public ParentLink set(String fieldName, Object value) {
      return (ParentLink) super.set(fieldName, value);
    }

    @Override
    public ParentLink clone() {
      return (ParentLink) super.clone();
    }

  }

}
