/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-05-05 at 19:05:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * Real time data for a given view (profile).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RealtimeData extends com.google.api.client.json.GenericJson {

  /**
   * Column headers that list dimension names followed by the metric names. The order of dimensions
   * and metrics is same as specified in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ColumnHeaders> columnHeaders;

  static {
    // hack to force ProGuard to consider ColumnHeaders used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ColumnHeaders.class);
  }

  /**
   * Unique ID for this data response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Resource type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Information for the view (profile), for which the real time data was requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProfileInfo profileInfo;

  /**
   * Real time data request query parameters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Query query;

  /**
   * Real time data rows, where each row contains a list of dimension values followed by the metric
   * values. The order of dimensions and metrics is same as specified in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.util.List<java.lang.String>> rows;

  /**
   * Link to this page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The total number of rows for the query, regardless of the number of rows in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalResults;

  /**
   * Total values for the requested metrics over all the results, not just the results returned in
   * this response. The order of the metric totals is same as the metric order specified in the
   * request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> totalsForAllResults;

  /**
   * Column headers that list dimension names followed by the metric names. The order of dimensions
   * and metrics is same as specified in the request.
   * @return value or {@code null} for none
   */
  public java.util.List<ColumnHeaders> getColumnHeaders() {
    return columnHeaders;
  }

  /**
   * Column headers that list dimension names followed by the metric names. The order of dimensions
   * and metrics is same as specified in the request.
   * @param columnHeaders columnHeaders or {@code null} for none
   */
  public RealtimeData setColumnHeaders(java.util.List<ColumnHeaders> columnHeaders) {
    this.columnHeaders = columnHeaders;
    return this;
  }

  /**
   * Unique ID for this data response.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Unique ID for this data response.
   * @param id id or {@code null} for none
   */
  public RealtimeData setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Resource type.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type.
   * @param kind kind or {@code null} for none
   */
  public RealtimeData setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Information for the view (profile), for which the real time data was requested.
   * @return value or {@code null} for none
   */
  public ProfileInfo getProfileInfo() {
    return profileInfo;
  }

  /**
   * Information for the view (profile), for which the real time data was requested.
   * @param profileInfo profileInfo or {@code null} for none
   */
  public RealtimeData setProfileInfo(ProfileInfo profileInfo) {
    this.profileInfo = profileInfo;
    return this;
  }

  /**
   * Real time data request query parameters.
   * @return value or {@code null} for none
   */
  public Query getQuery() {
    return query;
  }

  /**
   * Real time data request query parameters.
   * @param query query or {@code null} for none
   */
  public RealtimeData setQuery(Query query) {
    this.query = query;
    return this;
  }

  /**
   * Real time data rows, where each row contains a list of dimension values followed by the metric
   * values. The order of dimensions and metrics is same as specified in the request.
   * @return value or {@code null} for none
   */
  public java.util.List<java.util.List<java.lang.String>> getRows() {
    return rows;
  }

  /**
   * Real time data rows, where each row contains a list of dimension values followed by the metric
   * values. The order of dimensions and metrics is same as specified in the request.
   * @param rows rows or {@code null} for none
   */
  public RealtimeData setRows(java.util.List<java.util.List<java.lang.String>> rows) {
    this.rows = rows;
    return this;
  }

  /**
   * Link to this page.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Link to this page.
   * @param selfLink selfLink or {@code null} for none
   */
  public RealtimeData setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The total number of rows for the query, regardless of the number of rows in the response.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalResults() {
    return totalResults;
  }

  /**
   * The total number of rows for the query, regardless of the number of rows in the response.
   * @param totalResults totalResults or {@code null} for none
   */
  public RealtimeData setTotalResults(java.lang.Integer totalResults) {
    this.totalResults = totalResults;
    return this;
  }

  /**
   * Total values for the requested metrics over all the results, not just the results returned in
   * this response. The order of the metric totals is same as the metric order specified in the
   * request.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getTotalsForAllResults() {
    return totalsForAllResults;
  }

  /**
   * Total values for the requested metrics over all the results, not just the results returned in
   * this response. The order of the metric totals is same as the metric order specified in the
   * request.
   * @param totalsForAllResults totalsForAllResults or {@code null} for none
   */
  public RealtimeData setTotalsForAllResults(java.util.Map<String, java.lang.String> totalsForAllResults) {
    this.totalsForAllResults = totalsForAllResults;
    return this;
  }

  @Override
  public RealtimeData set(String fieldName, Object value) {
    return (RealtimeData) super.set(fieldName, value);
  }

  @Override
  public RealtimeData clone() {
    return (RealtimeData) super.clone();
  }

  /**
   * Model definition for RealtimeDataColumnHeaders.
   */
  public static final class ColumnHeaders extends com.google.api.client.json.GenericJson {

    /**
     * Column Type. Either DIMENSION or METRIC.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String columnType;

    /**
     * Data type. Dimension column headers have only STRING as the data type. Metric column headers
     * have data types for metric values such as INTEGER, DOUBLE, CURRENCY etc.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String dataType;

    /**
     * Column name.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String name;

    /**
     * Column Type. Either DIMENSION or METRIC.
     * @return value or {@code null} for none
     */
    public java.lang.String getColumnType() {
      return columnType;
    }

    /**
     * Column Type. Either DIMENSION or METRIC.
     * @param columnType columnType or {@code null} for none
     */
    public ColumnHeaders setColumnType(java.lang.String columnType) {
      this.columnType = columnType;
      return this;
    }

    /**
     * Data type. Dimension column headers have only STRING as the data type. Metric column headers
     * have data types for metric values such as INTEGER, DOUBLE, CURRENCY etc.
     * @return value or {@code null} for none
     */
    public java.lang.String getDataType() {
      return dataType;
    }

    /**
     * Data type. Dimension column headers have only STRING as the data type. Metric column headers
     * have data types for metric values such as INTEGER, DOUBLE, CURRENCY etc.
     * @param dataType dataType or {@code null} for none
     */
    public ColumnHeaders setDataType(java.lang.String dataType) {
      this.dataType = dataType;
      return this;
    }

    /**
     * Column name.
     * @return value or {@code null} for none
     */
    public java.lang.String getName() {
      return name;
    }

    /**
     * Column name.
     * @param name name or {@code null} for none
     */
    public ColumnHeaders setName(java.lang.String name) {
      this.name = name;
      return this;
    }

    @Override
    public ColumnHeaders set(String fieldName, Object value) {
      return (ColumnHeaders) super.set(fieldName, value);
    }

    @Override
    public ColumnHeaders clone() {
      return (ColumnHeaders) super.clone();
    }

  }

  /**
   * Information for the view (profile), for which the real time data was requested.
   */
  public static final class ProfileInfo extends com.google.api.client.json.GenericJson {

    /**
     * Account ID to which this view (profile) belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String accountId;

    /**
     * Internal ID for the web property to which this view (profile) belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String internalWebPropertyId;

    /**
     * View (Profile) ID.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String profileId;

    /**
     * View (Profile) name.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String profileName;

    /**
     * Table ID for view (profile).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String tableId;

    /**
     * Web Property ID to which this view (profile) belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String webPropertyId;

    /**
     * Account ID to which this view (profile) belongs.
     * @return value or {@code null} for none
     */
    public java.lang.String getAccountId() {
      return accountId;
    }

    /**
     * Account ID to which this view (profile) belongs.
     * @param accountId accountId or {@code null} for none
     */
    public ProfileInfo setAccountId(java.lang.String accountId) {
      this.accountId = accountId;
      return this;
    }

    /**
     * Internal ID for the web property to which this view (profile) belongs.
     * @return value or {@code null} for none
     */
    public java.lang.String getInternalWebPropertyId() {
      return internalWebPropertyId;
    }

    /**
     * Internal ID for the web property to which this view (profile) belongs.
     * @param internalWebPropertyId internalWebPropertyId or {@code null} for none
     */
    public ProfileInfo setInternalWebPropertyId(java.lang.String internalWebPropertyId) {
      this.internalWebPropertyId = internalWebPropertyId;
      return this;
    }

    /**
     * View (Profile) ID.
     * @return value or {@code null} for none
     */
    public java.lang.String getProfileId() {
      return profileId;
    }

    /**
     * View (Profile) ID.
     * @param profileId profileId or {@code null} for none
     */
    public ProfileInfo setProfileId(java.lang.String profileId) {
      this.profileId = profileId;
      return this;
    }

    /**
     * View (Profile) name.
     * @return value or {@code null} for none
     */
    public java.lang.String getProfileName() {
      return profileName;
    }

    /**
     * View (Profile) name.
     * @param profileName profileName or {@code null} for none
     */
    public ProfileInfo setProfileName(java.lang.String profileName) {
      this.profileName = profileName;
      return this;
    }

    /**
     * Table ID for view (profile).
     * @return value or {@code null} for none
     */
    public java.lang.String getTableId() {
      return tableId;
    }

    /**
     * Table ID for view (profile).
     * @param tableId tableId or {@code null} for none
     */
    public ProfileInfo setTableId(java.lang.String tableId) {
      this.tableId = tableId;
      return this;
    }

    /**
     * Web Property ID to which this view (profile) belongs.
     * @return value or {@code null} for none
     */
    public java.lang.String getWebPropertyId() {
      return webPropertyId;
    }

    /**
     * Web Property ID to which this view (profile) belongs.
     * @param webPropertyId webPropertyId or {@code null} for none
     */
    public ProfileInfo setWebPropertyId(java.lang.String webPropertyId) {
      this.webPropertyId = webPropertyId;
      return this;
    }

    @Override
    public ProfileInfo set(String fieldName, Object value) {
      return (ProfileInfo) super.set(fieldName, value);
    }

    @Override
    public ProfileInfo clone() {
      return (ProfileInfo) super.clone();
    }

  }

  /**
   * Real time data request query parameters.
   */
  public static final class Query extends com.google.api.client.json.GenericJson {

    /**
     * List of real time dimensions.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String dimensions;

    /**
     * Comma-separated list of dimension or metric filters.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String filters;

    /**
     * Unique table ID.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String ids;

    /**
     * Maximum results per page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("max-results")
    private java.lang.Integer maxResults;

    /**
     * List of real time metrics.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> metrics;

    /**
     * List of dimensions or metrics based on which real time data is sorted.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> sort;

    /**
     * List of real time dimensions.
     * @return value or {@code null} for none
     */
    public java.lang.String getDimensions() {
      return dimensions;
    }

    /**
     * List of real time dimensions.
     * @param dimensions dimensions or {@code null} for none
     */
    public Query setDimensions(java.lang.String dimensions) {
      this.dimensions = dimensions;
      return this;
    }

    /**
     * Comma-separated list of dimension or metric filters.
     * @return value or {@code null} for none
     */
    public java.lang.String getFilters() {
      return filters;
    }

    /**
     * Comma-separated list of dimension or metric filters.
     * @param filters filters or {@code null} for none
     */
    public Query setFilters(java.lang.String filters) {
      this.filters = filters;
      return this;
    }

    /**
     * Unique table ID.
     * @return value or {@code null} for none
     */
    public java.lang.String getIds() {
      return ids;
    }

    /**
     * Unique table ID.
     * @param ids ids or {@code null} for none
     */
    public Query setIds(java.lang.String ids) {
      this.ids = ids;
      return this;
    }

    /**
     * Maximum results per page.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getMaxResults() {
      return maxResults;
    }

    /**
     * Maximum results per page.
     * @param maxResults maxResults or {@code null} for none
     */
    public Query setMaxResults(java.lang.Integer maxResults) {
      this.maxResults = maxResults;
      return this;
    }

    /**
     * List of real time metrics.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getMetrics() {
      return metrics;
    }

    /**
     * List of real time metrics.
     * @param metrics metrics or {@code null} for none
     */
    public Query setMetrics(java.util.List<java.lang.String> metrics) {
      this.metrics = metrics;
      return this;
    }

    /**
     * List of dimensions or metrics based on which real time data is sorted.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getSort() {
      return sort;
    }

    /**
     * List of dimensions or metrics based on which real time data is sorted.
     * @param sort sort or {@code null} for none
     */
    public Query setSort(java.util.List<java.lang.String> sort) {
      this.sort = sort;
      return this;
    }

    @Override
    public Query set(String fieldName, Object value) {
      return (Query) super.set(fieldName, value);
    }

    @Override
    public Query clone() {
      return (Query) super.clone();
    }

  }

}
