/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-05-05 at 19:05:46 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for an Analytics web property.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Webproperty extends com.google.api.client.json.GenericJson {

  /**
   * Account ID to which this web property belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * Child link for this web property. Points to the list of views (profiles) for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChildLink childLink;

  /**
   * Time this web property was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime created;

  /**
   * Default view (profile) ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long defaultProfileId;

  /**
   * Web property ID of the form UA-XXXXX-YY.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The industry vertical/category selected for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String industryVertical;

  /**
   * Internal ID for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String internalWebPropertyId;

  /**
   * Resource type for Analytics WebProperty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Level for this web property. Possible values are STANDARD or PREMIUM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String level;

  /**
   * Name of this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Parent link for this web property. Points to the account to which this web property belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParentLink parentLink;

  /**
   * Permissions the user has for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Permissions permissions;

  /**
   * View (Profile) count for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer profileCount;

  /**
   * Link for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Time this web property was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * Website url for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String websiteUrl;

  /**
   * Account ID to which this web property belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this web property belongs.
   * @param accountId accountId or {@code null} for none
   */
  public Webproperty setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Child link for this web property. Points to the list of views (profiles) for this web property.
   * @return value or {@code null} for none
   */
  public ChildLink getChildLink() {
    return childLink;
  }

  /**
   * Child link for this web property. Points to the list of views (profiles) for this web property.
   * @param childLink childLink or {@code null} for none
   */
  public Webproperty setChildLink(ChildLink childLink) {
    this.childLink = childLink;
    return this;
  }

  /**
   * Time this web property was created.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreated() {
    return created;
  }

  /**
   * Time this web property was created.
   * @param created created or {@code null} for none
   */
  public Webproperty setCreated(com.google.api.client.util.DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * Default view (profile) ID.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDefaultProfileId() {
    return defaultProfileId;
  }

  /**
   * Default view (profile) ID.
   * @param defaultProfileId defaultProfileId or {@code null} for none
   */
  public Webproperty setDefaultProfileId(java.lang.Long defaultProfileId) {
    this.defaultProfileId = defaultProfileId;
    return this;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY.
   * @param id id or {@code null} for none
   */
  public Webproperty setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The industry vertical/category selected for this web property.
   * @return value or {@code null} for none
   */
  public java.lang.String getIndustryVertical() {
    return industryVertical;
  }

  /**
   * The industry vertical/category selected for this web property.
   * @param industryVertical industryVertical or {@code null} for none
   */
  public Webproperty setIndustryVertical(java.lang.String industryVertical) {
    this.industryVertical = industryVertical;
    return this;
  }

  /**
   * Internal ID for this web property.
   * @return value or {@code null} for none
   */
  public java.lang.String getInternalWebPropertyId() {
    return internalWebPropertyId;
  }

  /**
   * Internal ID for this web property.
   * @param internalWebPropertyId internalWebPropertyId or {@code null} for none
   */
  public Webproperty setInternalWebPropertyId(java.lang.String internalWebPropertyId) {
    this.internalWebPropertyId = internalWebPropertyId;
    return this;
  }

  /**
   * Resource type for Analytics WebProperty.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics WebProperty.
   * @param kind kind or {@code null} for none
   */
  public Webproperty setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Level for this web property. Possible values are STANDARD or PREMIUM.
   * @return value or {@code null} for none
   */
  public java.lang.String getLevel() {
    return level;
  }

  /**
   * Level for this web property. Possible values are STANDARD or PREMIUM.
   * @param level level or {@code null} for none
   */
  public Webproperty setLevel(java.lang.String level) {
    this.level = level;
    return this;
  }

  /**
   * Name of this web property.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this web property.
   * @param name name or {@code null} for none
   */
  public Webproperty setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Parent link for this web property. Points to the account to which this web property belongs.
   * @return value or {@code null} for none
   */
  public ParentLink getParentLink() {
    return parentLink;
  }

  /**
   * Parent link for this web property. Points to the account to which this web property belongs.
   * @param parentLink parentLink or {@code null} for none
   */
  public Webproperty setParentLink(ParentLink parentLink) {
    this.parentLink = parentLink;
    return this;
  }

  /**
   * Permissions the user has for this web property.
   * @return value or {@code null} for none
   */
  public Permissions getPermissions() {
    return permissions;
  }

  /**
   * Permissions the user has for this web property.
   * @param permissions permissions or {@code null} for none
   */
  public Webproperty setPermissions(Permissions permissions) {
    this.permissions = permissions;
    return this;
  }

  /**
   * View (Profile) count for this web property.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getProfileCount() {
    return profileCount;
  }

  /**
   * View (Profile) count for this web property.
   * @param profileCount profileCount or {@code null} for none
   */
  public Webproperty setProfileCount(java.lang.Integer profileCount) {
    this.profileCount = profileCount;
    return this;
  }

  /**
   * Link for this web property.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this web property.
   * @param selfLink selfLink or {@code null} for none
   */
  public Webproperty setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Time this web property was last modified.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * Time this web property was last modified.
   * @param updated updated or {@code null} for none
   */
  public Webproperty setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Website url for this web property.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebsiteUrl() {
    return websiteUrl;
  }

  /**
   * Website url for this web property.
   * @param websiteUrl websiteUrl or {@code null} for none
   */
  public Webproperty setWebsiteUrl(java.lang.String websiteUrl) {
    this.websiteUrl = websiteUrl;
    return this;
  }

  @Override
  public Webproperty set(String fieldName, Object value) {
    return (Webproperty) super.set(fieldName, value);
  }

  @Override
  public Webproperty clone() {
    return (Webproperty) super.clone();
  }

  /**
   * Child link for this web property. Points to the list of views (profiles) for this web property.
   */
  public static final class ChildLink extends com.google.api.client.json.GenericJson {

    /**
     * Link to the list of views (profiles) for this web property.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String href;

    /**
     * Type of the parent link. Its value is "analytics#profiles".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Link to the list of views (profiles) for this web property.
     * @return value or {@code null} for none
     */
    public java.lang.String getHref() {
      return href;
    }

    /**
     * Link to the list of views (profiles) for this web property.
     * @param href href or {@code null} for none
     */
    public ChildLink setHref(java.lang.String href) {
      this.href = href;
      return this;
    }

    /**
     * Type of the parent link. Its value is "analytics#profiles".
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Type of the parent link. Its value is "analytics#profiles".
     * @param type type or {@code null} for none
     */
    public ChildLink setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public ChildLink set(String fieldName, Object value) {
      return (ChildLink) super.set(fieldName, value);
    }

    @Override
    public ChildLink clone() {
      return (ChildLink) super.clone();
    }

  }

  /**
   * Parent link for this web property. Points to the account to which this web property belongs.
   */
  public static final class ParentLink extends com.google.api.client.json.GenericJson {

    /**
     * Link to the account for this web property.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String href;

    /**
     * Type of the parent link. Its value is "analytics#account".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Link to the account for this web property.
     * @return value or {@code null} for none
     */
    public java.lang.String getHref() {
      return href;
    }

    /**
     * Link to the account for this web property.
     * @param href href or {@code null} for none
     */
    public ParentLink setHref(java.lang.String href) {
      this.href = href;
      return this;
    }

    /**
     * Type of the parent link. Its value is "analytics#account".
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Type of the parent link. Its value is "analytics#account".
     * @param type type or {@code null} for none
     */
    public ParentLink setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public ParentLink set(String fieldName, Object value) {
      return (ParentLink) super.set(fieldName, value);
    }

    @Override
    public ParentLink clone() {
      return (ParentLink) super.clone();
    }

  }

  /**
   * Permissions the user has for this web property.
   */
  public static final class Permissions extends com.google.api.client.json.GenericJson {

    /**
     * All the permissions that the user has for this web property. These include any implied
     * permissions (e.g., EDIT implies VIEW) or inherited permissions from the parent account.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> effective;

    /**
     * All the permissions that the user has for this web property. These include any implied
     * permissions (e.g., EDIT implies VIEW) or inherited permissions from the parent account.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getEffective() {
      return effective;
    }

    /**
     * All the permissions that the user has for this web property. These include any implied
     * permissions (e.g., EDIT implies VIEW) or inherited permissions from the parent account.
     * @param effective effective or {@code null} for none
     */
    public Permissions setEffective(java.util.List<java.lang.String> effective) {
      this.effective = effective;
      return this;
    }

    @Override
    public Permissions set(String fieldName, Object value) {
      return (Permissions) super.set(fieldName, value);
    }

    @Override
    public Permissions clone() {
      return (Permissions) super.clone();
    }

  }

}
