/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-05-05 at 19:05:46 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for an Analytics WebPropertySummary. WebPropertySummary returns basic information
 * (i.e., summary) for a web property.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WebPropertySummary extends com.google.api.client.json.GenericJson {

  /**
   * Web property ID of the form UA-XXXXX-YY.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Internal ID for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String internalWebPropertyId;

  /**
   * Resource type for Analytics WebPropertySummary.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Level for this web property. Possible values are STANDARD or PREMIUM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String level;

  /**
   * Web property name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * List of profiles under this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ProfileSummary> profiles;

  static {
    // hack to force ProGuard to consider ProfileSummary used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ProfileSummary.class);
  }

  /**
   * Website url for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String websiteUrl;

  /**
   * Web property ID of the form UA-XXXXX-YY.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY.
   * @param id id or {@code null} for none
   */
  public WebPropertySummary setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Internal ID for this web property.
   * @return value or {@code null} for none
   */
  public java.lang.String getInternalWebPropertyId() {
    return internalWebPropertyId;
  }

  /**
   * Internal ID for this web property.
   * @param internalWebPropertyId internalWebPropertyId or {@code null} for none
   */
  public WebPropertySummary setInternalWebPropertyId(java.lang.String internalWebPropertyId) {
    this.internalWebPropertyId = internalWebPropertyId;
    return this;
  }

  /**
   * Resource type for Analytics WebPropertySummary.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics WebPropertySummary.
   * @param kind kind or {@code null} for none
   */
  public WebPropertySummary setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Level for this web property. Possible values are STANDARD or PREMIUM.
   * @return value or {@code null} for none
   */
  public java.lang.String getLevel() {
    return level;
  }

  /**
   * Level for this web property. Possible values are STANDARD or PREMIUM.
   * @param level level or {@code null} for none
   */
  public WebPropertySummary setLevel(java.lang.String level) {
    this.level = level;
    return this;
  }

  /**
   * Web property name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Web property name.
   * @param name name or {@code null} for none
   */
  public WebPropertySummary setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * List of profiles under this web property.
   * @return value or {@code null} for none
   */
  public java.util.List<ProfileSummary> getProfiles() {
    return profiles;
  }

  /**
   * List of profiles under this web property.
   * @param profiles profiles or {@code null} for none
   */
  public WebPropertySummary setProfiles(java.util.List<ProfileSummary> profiles) {
    this.profiles = profiles;
    return this;
  }

  /**
   * Website url for this web property.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebsiteUrl() {
    return websiteUrl;
  }

  /**
   * Website url for this web property.
   * @param websiteUrl websiteUrl or {@code null} for none
   */
  public WebPropertySummary setWebsiteUrl(java.lang.String websiteUrl) {
    this.websiteUrl = websiteUrl;
    return this;
  }

  @Override
  public WebPropertySummary set(String fieldName, Object value) {
    return (WebPropertySummary) super.set(fieldName, value);
  }

  @Override
  public WebPropertySummary clone() {
    return (WebPropertySummary) super.clone();
  }

}
