/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-05-05 at 19:05:46 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for a linked view (profile).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProfileRef extends com.google.api.client.json.GenericJson {

  /**
   * Account ID to which this view (profile) belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * Link for this view (profile).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String href;

  /**
   * View (Profile) ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Internal ID for the web property to which this view (profile) belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String internalWebPropertyId;

  /**
   * Analytics view (profile) reference.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of this view (profile).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Web property ID of the form UA-XXXXX-YY to which this view (profile) belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webPropertyId;

  /**
   * Account ID to which this view (profile) belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this view (profile) belongs.
   * @param accountId accountId or {@code null} for none
   */
  public ProfileRef setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Link for this view (profile).
   * @return value or {@code null} for none
   */
  public java.lang.String getHref() {
    return href;
  }

  /**
   * Link for this view (profile).
   * @param href href or {@code null} for none
   */
  public ProfileRef setHref(java.lang.String href) {
    this.href = href;
    return this;
  }

  /**
   * View (Profile) ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * View (Profile) ID.
   * @param id id or {@code null} for none
   */
  public ProfileRef setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Internal ID for the web property to which this view (profile) belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getInternalWebPropertyId() {
    return internalWebPropertyId;
  }

  /**
   * Internal ID for the web property to which this view (profile) belongs.
   * @param internalWebPropertyId internalWebPropertyId or {@code null} for none
   */
  public ProfileRef setInternalWebPropertyId(java.lang.String internalWebPropertyId) {
    this.internalWebPropertyId = internalWebPropertyId;
    return this;
  }

  /**
   * Analytics view (profile) reference.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Analytics view (profile) reference.
   * @param kind kind or {@code null} for none
   */
  public ProfileRef setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this view (profile).
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this view (profile).
   * @param name name or {@code null} for none
   */
  public ProfileRef setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this view (profile) belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this view (profile) belongs.
   * @param webPropertyId webPropertyId or {@code null} for none
   */
  public ProfileRef setWebPropertyId(java.lang.String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  @Override
  public ProfileRef set(String fieldName, Object value) {
    return (ProfileRef) super.set(fieldName, value);
  }

  @Override
  public ProfileRef clone() {
    return (ProfileRef) super.clone();
  }

}
