/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 00:00:06 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for Analytics goal resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Goal extends com.google.api.client.json.GenericJson {

  /**
   * Account ID to which this goal belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * Determines whether this goal is active.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean active;

  /**
   * Time this goal was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime created;

  /**
   * Details for the goal of the type EVENT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EventDetails eventDetails;

  /**
   * Goal ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Internal ID for the web property to which this goal belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String internalWebPropertyId;

  /**
   * Resource type for an Analytics goal.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Goal name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Parent link for a goal. Points to the view (profile) to which this goal belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParentLink parentLink;

  /**
   * View (Profile) ID to which this goal belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String profileId;

  /**
   * Link for this goal.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Goal type. Possible values are URL_DESTINATION, VISIT_TIME_ON_SITE, VISIT_NUM_PAGES, AND EVENT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Time this goal was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * Details for the goal of the type URL_DESTINATION.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UrlDestinationDetails urlDestinationDetails;

  /**
   * Goal value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float value;

  /**
   * Details for the goal of the type VISIT_NUM_PAGES.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VisitNumPagesDetails visitNumPagesDetails;

  /**
   * Details for the goal of the type VISIT_TIME_ON_SITE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VisitTimeOnSiteDetails visitTimeOnSiteDetails;

  /**
   * Web property ID to which this goal belongs. The web property ID is of the form UA-XXXXX-YY.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webPropertyId;

  /**
   * Account ID to which this goal belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this goal belongs.
   * @param accountId accountId or {@code null} for none
   */
  public Goal setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Determines whether this goal is active.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getActive() {
    return active;
  }

  /**
   * Determines whether this goal is active.
   * @param active active or {@code null} for none
   */
  public Goal setActive(java.lang.Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Time this goal was created.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreated() {
    return created;
  }

  /**
   * Time this goal was created.
   * @param created created or {@code null} for none
   */
  public Goal setCreated(com.google.api.client.util.DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * Details for the goal of the type EVENT.
   * @return value or {@code null} for none
   */
  public EventDetails getEventDetails() {
    return eventDetails;
  }

  /**
   * Details for the goal of the type EVENT.
   * @param eventDetails eventDetails or {@code null} for none
   */
  public Goal setEventDetails(EventDetails eventDetails) {
    this.eventDetails = eventDetails;
    return this;
  }

  /**
   * Goal ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Goal ID.
   * @param id id or {@code null} for none
   */
  public Goal setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Internal ID for the web property to which this goal belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getInternalWebPropertyId() {
    return internalWebPropertyId;
  }

  /**
   * Internal ID for the web property to which this goal belongs.
   * @param internalWebPropertyId internalWebPropertyId or {@code null} for none
   */
  public Goal setInternalWebPropertyId(java.lang.String internalWebPropertyId) {
    this.internalWebPropertyId = internalWebPropertyId;
    return this;
  }

  /**
   * Resource type for an Analytics goal.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for an Analytics goal.
   * @param kind kind or {@code null} for none
   */
  public Goal setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Goal name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Goal name.
   * @param name name or {@code null} for none
   */
  public Goal setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Parent link for a goal. Points to the view (profile) to which this goal belongs.
   * @return value or {@code null} for none
   */
  public ParentLink getParentLink() {
    return parentLink;
  }

  /**
   * Parent link for a goal. Points to the view (profile) to which this goal belongs.
   * @param parentLink parentLink or {@code null} for none
   */
  public Goal setParentLink(ParentLink parentLink) {
    this.parentLink = parentLink;
    return this;
  }

  /**
   * View (Profile) ID to which this goal belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getProfileId() {
    return profileId;
  }

  /**
   * View (Profile) ID to which this goal belongs.
   * @param profileId profileId or {@code null} for none
   */
  public Goal setProfileId(java.lang.String profileId) {
    this.profileId = profileId;
    return this;
  }

  /**
   * Link for this goal.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this goal.
   * @param selfLink selfLink or {@code null} for none
   */
  public Goal setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Goal type. Possible values are URL_DESTINATION, VISIT_TIME_ON_SITE, VISIT_NUM_PAGES, AND EVENT.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Goal type. Possible values are URL_DESTINATION, VISIT_TIME_ON_SITE, VISIT_NUM_PAGES, AND EVENT.
   * @param type type or {@code null} for none
   */
  public Goal setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Time this goal was last modified.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * Time this goal was last modified.
   * @param updated updated or {@code null} for none
   */
  public Goal setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Details for the goal of the type URL_DESTINATION.
   * @return value or {@code null} for none
   */
  public UrlDestinationDetails getUrlDestinationDetails() {
    return urlDestinationDetails;
  }

  /**
   * Details for the goal of the type URL_DESTINATION.
   * @param urlDestinationDetails urlDestinationDetails or {@code null} for none
   */
  public Goal setUrlDestinationDetails(UrlDestinationDetails urlDestinationDetails) {
    this.urlDestinationDetails = urlDestinationDetails;
    return this;
  }

  /**
   * Goal value.
   * @return value or {@code null} for none
   */
  public java.lang.Float getValue() {
    return value;
  }

  /**
   * Goal value.
   * @param value value or {@code null} for none
   */
  public Goal setValue(java.lang.Float value) {
    this.value = value;
    return this;
  }

  /**
   * Details for the goal of the type VISIT_NUM_PAGES.
   * @return value or {@code null} for none
   */
  public VisitNumPagesDetails getVisitNumPagesDetails() {
    return visitNumPagesDetails;
  }

  /**
   * Details for the goal of the type VISIT_NUM_PAGES.
   * @param visitNumPagesDetails visitNumPagesDetails or {@code null} for none
   */
  public Goal setVisitNumPagesDetails(VisitNumPagesDetails visitNumPagesDetails) {
    this.visitNumPagesDetails = visitNumPagesDetails;
    return this;
  }

  /**
   * Details for the goal of the type VISIT_TIME_ON_SITE.
   * @return value or {@code null} for none
   */
  public VisitTimeOnSiteDetails getVisitTimeOnSiteDetails() {
    return visitTimeOnSiteDetails;
  }

  /**
   * Details for the goal of the type VISIT_TIME_ON_SITE.
   * @param visitTimeOnSiteDetails visitTimeOnSiteDetails or {@code null} for none
   */
  public Goal setVisitTimeOnSiteDetails(VisitTimeOnSiteDetails visitTimeOnSiteDetails) {
    this.visitTimeOnSiteDetails = visitTimeOnSiteDetails;
    return this;
  }

  /**
   * Web property ID to which this goal belongs. The web property ID is of the form UA-XXXXX-YY.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID to which this goal belongs. The web property ID is of the form UA-XXXXX-YY.
   * @param webPropertyId webPropertyId or {@code null} for none
   */
  public Goal setWebPropertyId(java.lang.String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  @Override
  public Goal set(String fieldName, Object value) {
    return (Goal) super.set(fieldName, value);
  }

  @Override
  public Goal clone() {
    return (Goal) super.clone();
  }

  /**
   * Details for the goal of the type EVENT.
   */
  public static final class EventDetails extends com.google.api.client.json.GenericJson {

    /**
     * List of event conditions.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<EventConditions> eventConditions;

    static {
      // hack to force ProGuard to consider EventConditions used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(EventConditions.class);
    }

    /**
     * Determines if the event value should be used as the value for this goal.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean useEventValue;

    /**
     * List of event conditions.
     * @return value or {@code null} for none
     */
    public java.util.List<EventConditions> getEventConditions() {
      return eventConditions;
    }

    /**
     * List of event conditions.
     * @param eventConditions eventConditions or {@code null} for none
     */
    public EventDetails setEventConditions(java.util.List<EventConditions> eventConditions) {
      this.eventConditions = eventConditions;
      return this;
    }

    /**
     * Determines if the event value should be used as the value for this goal.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getUseEventValue() {
      return useEventValue;
    }

    /**
     * Determines if the event value should be used as the value for this goal.
     * @param useEventValue useEventValue or {@code null} for none
     */
    public EventDetails setUseEventValue(java.lang.Boolean useEventValue) {
      this.useEventValue = useEventValue;
      return this;
    }

    @Override
    public EventDetails set(String fieldName, Object value) {
      return (EventDetails) super.set(fieldName, value);
    }

    @Override
    public EventDetails clone() {
      return (EventDetails) super.clone();
    }

    /**
     * Model definition for GoalEventDetailsEventConditions.
     */
    public static final class EventConditions extends com.google.api.client.json.GenericJson {

      /**
       * Type of comparison. Possible values are LESS_THAN, GREATER_THAN or EQUAL.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String comparisonType;

      /**
       * Value used for this comparison.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key @com.google.api.client.json.JsonString
      private java.lang.Long comparisonValue;

      /**
       * Expression used for this match.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String expression;

      /**
       * Type of the match to be performed. Possible values are REGEXP, BEGINS_WITH, or EXACT.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String matchType;

      /**
       * Type of this event condition. Possible values are CATEGORY, ACTION, LABEL, or VALUE.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String type;

      /**
       * Type of comparison. Possible values are LESS_THAN, GREATER_THAN or EQUAL.
       * @return value or {@code null} for none
       */
      public java.lang.String getComparisonType() {
        return comparisonType;
      }

      /**
       * Type of comparison. Possible values are LESS_THAN, GREATER_THAN or EQUAL.
       * @param comparisonType comparisonType or {@code null} for none
       */
      public EventConditions setComparisonType(java.lang.String comparisonType) {
        this.comparisonType = comparisonType;
        return this;
      }

      /**
       * Value used for this comparison.
       * @return value or {@code null} for none
       */
      public java.lang.Long getComparisonValue() {
        return comparisonValue;
      }

      /**
       * Value used for this comparison.
       * @param comparisonValue comparisonValue or {@code null} for none
       */
      public EventConditions setComparisonValue(java.lang.Long comparisonValue) {
        this.comparisonValue = comparisonValue;
        return this;
      }

      /**
       * Expression used for this match.
       * @return value or {@code null} for none
       */
      public java.lang.String getExpression() {
        return expression;
      }

      /**
       * Expression used for this match.
       * @param expression expression or {@code null} for none
       */
      public EventConditions setExpression(java.lang.String expression) {
        this.expression = expression;
        return this;
      }

      /**
       * Type of the match to be performed. Possible values are REGEXP, BEGINS_WITH, or EXACT.
       * @return value or {@code null} for none
       */
      public java.lang.String getMatchType() {
        return matchType;
      }

      /**
       * Type of the match to be performed. Possible values are REGEXP, BEGINS_WITH, or EXACT.
       * @param matchType matchType or {@code null} for none
       */
      public EventConditions setMatchType(java.lang.String matchType) {
        this.matchType = matchType;
        return this;
      }

      /**
       * Type of this event condition. Possible values are CATEGORY, ACTION, LABEL, or VALUE.
       * @return value or {@code null} for none
       */
      public java.lang.String getType() {
        return type;
      }

      /**
       * Type of this event condition. Possible values are CATEGORY, ACTION, LABEL, or VALUE.
       * @param type type or {@code null} for none
       */
      public EventConditions setType(java.lang.String type) {
        this.type = type;
        return this;
      }

      @Override
      public EventConditions set(String fieldName, Object value) {
        return (EventConditions) super.set(fieldName, value);
      }

      @Override
      public EventConditions clone() {
        return (EventConditions) super.clone();
      }

    }
  }

  /**
   * Parent link for a goal. Points to the view (profile) to which this goal belongs.
   */
  public static final class ParentLink extends com.google.api.client.json.GenericJson {

    /**
     * Link to the view (profile) to which this goal belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String href;

    /**
     * Value is "analytics#profile".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Link to the view (profile) to which this goal belongs.
     * @return value or {@code null} for none
     */
    public java.lang.String getHref() {
      return href;
    }

    /**
     * Link to the view (profile) to which this goal belongs.
     * @param href href or {@code null} for none
     */
    public ParentLink setHref(java.lang.String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#profile".
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Value is "analytics#profile".
     * @param type type or {@code null} for none
     */
    public ParentLink setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public ParentLink set(String fieldName, Object value) {
      return (ParentLink) super.set(fieldName, value);
    }

    @Override
    public ParentLink clone() {
      return (ParentLink) super.clone();
    }

  }

  /**
   * Details for the goal of the type URL_DESTINATION.
   */
  public static final class UrlDestinationDetails extends com.google.api.client.json.GenericJson {

    /**
     * Determines if the goal URL must exactly match the capitalization of visited URLs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean caseSensitive;

    /**
     * Determines if the first step in this goal is required.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean firstStepRequired;

    /**
     * Match type for the goal URL. Possible values are HEAD, EXACT, or REGEX.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String matchType;

    /**
     * List of steps configured for this goal funnel.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Steps> steps;

    static {
      // hack to force ProGuard to consider Steps used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Steps.class);
    }

    /**
     * URL for this goal.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String url;

    /**
     * Determines if the goal URL must exactly match the capitalization of visited URLs.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCaseSensitive() {
      return caseSensitive;
    }

    /**
     * Determines if the goal URL must exactly match the capitalization of visited URLs.
     * @param caseSensitive caseSensitive or {@code null} for none
     */
    public UrlDestinationDetails setCaseSensitive(java.lang.Boolean caseSensitive) {
      this.caseSensitive = caseSensitive;
      return this;
    }

    /**
     * Determines if the first step in this goal is required.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getFirstStepRequired() {
      return firstStepRequired;
    }

    /**
     * Determines if the first step in this goal is required.
     * @param firstStepRequired firstStepRequired or {@code null} for none
     */
    public UrlDestinationDetails setFirstStepRequired(java.lang.Boolean firstStepRequired) {
      this.firstStepRequired = firstStepRequired;
      return this;
    }

    /**
     * Match type for the goal URL. Possible values are HEAD, EXACT, or REGEX.
     * @return value or {@code null} for none
     */
    public java.lang.String getMatchType() {
      return matchType;
    }

    /**
     * Match type for the goal URL. Possible values are HEAD, EXACT, or REGEX.
     * @param matchType matchType or {@code null} for none
     */
    public UrlDestinationDetails setMatchType(java.lang.String matchType) {
      this.matchType = matchType;
      return this;
    }

    /**
     * List of steps configured for this goal funnel.
     * @return value or {@code null} for none
     */
    public java.util.List<Steps> getSteps() {
      return steps;
    }

    /**
     * List of steps configured for this goal funnel.
     * @param steps steps or {@code null} for none
     */
    public UrlDestinationDetails setSteps(java.util.List<Steps> steps) {
      this.steps = steps;
      return this;
    }

    /**
     * URL for this goal.
     * @return value or {@code null} for none
     */
    public java.lang.String getUrl() {
      return url;
    }

    /**
     * URL for this goal.
     * @param url url or {@code null} for none
     */
    public UrlDestinationDetails setUrl(java.lang.String url) {
      this.url = url;
      return this;
    }

    @Override
    public UrlDestinationDetails set(String fieldName, Object value) {
      return (UrlDestinationDetails) super.set(fieldName, value);
    }

    @Override
    public UrlDestinationDetails clone() {
      return (UrlDestinationDetails) super.clone();
    }

    /**
     * Model definition for GoalUrlDestinationDetailsSteps.
     */
    public static final class Steps extends com.google.api.client.json.GenericJson {

      /**
       * Step name.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /**
       * Step number.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer number;

      /**
       * URL for this step.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String url;

      /**
       * Step name.
       * @return value or {@code null} for none
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Step name.
       * @param name name or {@code null} for none
       */
      public Steps setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      /**
       * Step number.
       * @return value or {@code null} for none
       */
      public java.lang.Integer getNumber() {
        return number;
      }

      /**
       * Step number.
       * @param number number or {@code null} for none
       */
      public Steps setNumber(java.lang.Integer number) {
        this.number = number;
        return this;
      }

      /**
       * URL for this step.
       * @return value or {@code null} for none
       */
      public java.lang.String getUrl() {
        return url;
      }

      /**
       * URL for this step.
       * @param url url or {@code null} for none
       */
      public Steps setUrl(java.lang.String url) {
        this.url = url;
        return this;
      }

      @Override
      public Steps set(String fieldName, Object value) {
        return (Steps) super.set(fieldName, value);
      }

      @Override
      public Steps clone() {
        return (Steps) super.clone();
      }

    }
  }

  /**
   * Details for the goal of the type VISIT_NUM_PAGES.
   */
  public static final class VisitNumPagesDetails extends com.google.api.client.json.GenericJson {

    /**
     * Type of comparison. Possible values are LESS_THAN, GREATER_THAN, or EQUAL.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String comparisonType;

    /**
     * Value used for this comparison.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long comparisonValue;

    /**
     * Type of comparison. Possible values are LESS_THAN, GREATER_THAN, or EQUAL.
     * @return value or {@code null} for none
     */
    public java.lang.String getComparisonType() {
      return comparisonType;
    }

    /**
     * Type of comparison. Possible values are LESS_THAN, GREATER_THAN, or EQUAL.
     * @param comparisonType comparisonType or {@code null} for none
     */
    public VisitNumPagesDetails setComparisonType(java.lang.String comparisonType) {
      this.comparisonType = comparisonType;
      return this;
    }

    /**
     * Value used for this comparison.
     * @return value or {@code null} for none
     */
    public java.lang.Long getComparisonValue() {
      return comparisonValue;
    }

    /**
     * Value used for this comparison.
     * @param comparisonValue comparisonValue or {@code null} for none
     */
    public VisitNumPagesDetails setComparisonValue(java.lang.Long comparisonValue) {
      this.comparisonValue = comparisonValue;
      return this;
    }

    @Override
    public VisitNumPagesDetails set(String fieldName, Object value) {
      return (VisitNumPagesDetails) super.set(fieldName, value);
    }

    @Override
    public VisitNumPagesDetails clone() {
      return (VisitNumPagesDetails) super.clone();
    }

  }

  /**
   * Details for the goal of the type VISIT_TIME_ON_SITE.
   */
  public static final class VisitTimeOnSiteDetails extends com.google.api.client.json.GenericJson {

    /**
     * Type of comparison. Possible values are LESS_THAN or GREATER_THAN.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String comparisonType;

    /**
     * Value used for this comparison.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long comparisonValue;

    /**
     * Type of comparison. Possible values are LESS_THAN or GREATER_THAN.
     * @return value or {@code null} for none
     */
    public java.lang.String getComparisonType() {
      return comparisonType;
    }

    /**
     * Type of comparison. Possible values are LESS_THAN or GREATER_THAN.
     * @param comparisonType comparisonType or {@code null} for none
     */
    public VisitTimeOnSiteDetails setComparisonType(java.lang.String comparisonType) {
      this.comparisonType = comparisonType;
      return this;
    }

    /**
     * Value used for this comparison.
     * @return value or {@code null} for none
     */
    public java.lang.Long getComparisonValue() {
      return comparisonValue;
    }

    /**
     * Value used for this comparison.
     * @param comparisonValue comparisonValue or {@code null} for none
     */
    public VisitTimeOnSiteDetails setComparisonValue(java.lang.Long comparisonValue) {
      this.comparisonValue = comparisonValue;
      return this;
    }

    @Override
    public VisitTimeOnSiteDetails set(String fieldName, Object value) {
      return (VisitTimeOnSiteDetails) super.set(fieldName, value);
    }

    @Override
    public VisitTimeOnSiteDetails clone() {
      return (VisitTimeOnSiteDetails) super.clone();
    }

  }

}
