/*
 * Decompiled with CFR 0.152.
 */
package com.google.identity.accesscontextmanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccessLevelName
implements ResourceName {
    private static final PathTemplate ACCESS_POLICY_ACCESS_LEVEL = PathTemplate.createWithoutUrlEncoding((String)"accessPolicies/{access_policy}/accessLevels/{access_level}");
    private volatile Map<String, String> fieldValuesMap;
    private final String accessPolicy;
    private final String accessLevel;

    @Deprecated
    protected AccessLevelName() {
        this.accessPolicy = null;
        this.accessLevel = null;
    }

    private AccessLevelName(Builder builder) {
        this.accessPolicy = (String)Preconditions.checkNotNull((Object)builder.getAccessPolicy());
        this.accessLevel = (String)Preconditions.checkNotNull((Object)builder.getAccessLevel());
    }

    public String getAccessPolicy() {
        return this.accessPolicy;
    }

    public String getAccessLevel() {
        return this.accessLevel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AccessLevelName of(String accessPolicy, String accessLevel) {
        return AccessLevelName.newBuilder().setAccessPolicy(accessPolicy).setAccessLevel(accessLevel).build();
    }

    public static String format(String accessPolicy, String accessLevel) {
        return AccessLevelName.newBuilder().setAccessPolicy(accessPolicy).setAccessLevel(accessLevel).build().toString();
    }

    public static AccessLevelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ACCESS_POLICY_ACCESS_LEVEL.validatedMatch(formattedString, "AccessLevelName.parse: formattedString not in valid format");
        return AccessLevelName.of((String)matchMap.get("access_policy"), (String)matchMap.get("access_level"));
    }

    public static List<AccessLevelName> parseList(List<String> formattedStrings) {
        ArrayList<AccessLevelName> list = new ArrayList<AccessLevelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccessLevelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccessLevelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccessLevelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCESS_POLICY_ACCESS_LEVEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccessLevelName accessLevelName = this;
            synchronized (accessLevelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.accessPolicy != null) {
                        fieldMapBuilder.put((Object)"access_policy", (Object)this.accessPolicy);
                    }
                    if (this.accessLevel != null) {
                        fieldMapBuilder.put((Object)"access_level", (Object)this.accessLevel);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ACCESS_POLICY_ACCESS_LEVEL.instantiate(new String[]{"access_policy", this.accessPolicy, "access_level", this.accessLevel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AccessLevelName that = (AccessLevelName)o;
            return Objects.equals(this.accessPolicy, that.accessPolicy) && Objects.equals(this.accessLevel, that.accessLevel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.accessPolicy);
        h *= 1000003;
        return h ^= Objects.hashCode(this.accessLevel);
    }

    public static class Builder {
        private String accessPolicy;
        private String accessLevel;

        protected Builder() {
        }

        public String getAccessPolicy() {
            return this.accessPolicy;
        }

        public String getAccessLevel() {
            return this.accessLevel;
        }

        public Builder setAccessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public Builder setAccessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        private Builder(AccessLevelName accessLevelName) {
            this.accessPolicy = accessLevelName.accessPolicy;
            this.accessLevel = accessLevelName.accessLevel;
        }

        public AccessLevelName build() {
            return new AccessLevelName(this);
        }
    }
}

