/*
 * Decompiled with CFR 0.152.
 */
package com.google.identity.accesscontextmanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccessPolicyName
implements ResourceName {
    private static final PathTemplate ACCESS_POLICY = PathTemplate.createWithoutUrlEncoding((String)"accessPolicies/{access_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String accessPolicy;

    @Deprecated
    protected AccessPolicyName() {
        this.accessPolicy = null;
    }

    private AccessPolicyName(Builder builder) {
        this.accessPolicy = (String)Preconditions.checkNotNull((Object)builder.getAccessPolicy());
    }

    public String getAccessPolicy() {
        return this.accessPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AccessPolicyName of(String accessPolicy) {
        return AccessPolicyName.newBuilder().setAccessPolicy(accessPolicy).build();
    }

    public static String format(String accessPolicy) {
        return AccessPolicyName.newBuilder().setAccessPolicy(accessPolicy).build().toString();
    }

    public static AccessPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ACCESS_POLICY.validatedMatch(formattedString, "AccessPolicyName.parse: formattedString not in valid format");
        return AccessPolicyName.of((String)matchMap.get("access_policy"));
    }

    public static List<AccessPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<AccessPolicyName> list = new ArrayList<AccessPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccessPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccessPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccessPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCESS_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccessPolicyName accessPolicyName = this;
            synchronized (accessPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.accessPolicy != null) {
                        fieldMapBuilder.put((Object)"access_policy", (Object)this.accessPolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ACCESS_POLICY.instantiate(new String[]{"access_policy", this.accessPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AccessPolicyName that = (AccessPolicyName)o;
            return Objects.equals(this.accessPolicy, that.accessPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.accessPolicy);
    }

    public static class Builder {
        private String accessPolicy;

        protected Builder() {
        }

        public String getAccessPolicy() {
            return this.accessPolicy;
        }

        public Builder setAccessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        private Builder(AccessPolicyName accessPolicyName) {
            this.accessPolicy = accessPolicyName.accessPolicy;
        }

        public AccessPolicyName build() {
            return new AccessPolicyName(this);
        }
    }
}

