/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/iam/admin/v1/iam.proto

// Protobuf Java Version: 3.25.8
package com.google.iam.admin.v1;

/**
 *
 *
 * <pre>
 * An IAM service account.
 *
 * A service account is an account for an application or a virtual machine (VM)
 * instance, not a person. You can use a service account to call Google APIs. To
 * learn more, read the [overview of service
 * accounts](https://cloud.google.com/iam/help/service-accounts/overview).
 *
 * When you create a service account, you specify the project ID that owns the
 * service account, as well as a name that must be unique within the project.
 * IAM uses these values to create an email address that identifies the service
 * account.
 * </pre>
 *
 * Protobuf type {@code google.iam.admin.v1.ServiceAccount}
 */
public final class ServiceAccount extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.iam.admin.v1.ServiceAccount)
    ServiceAccountOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ServiceAccount.newBuilder() to construct.
  private ServiceAccount(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServiceAccount() {
    name_ = "";
    projectId_ = "";
    uniqueId_ = "";
    email_ = "";
    displayName_ = "";
    etag_ = com.google.protobuf.ByteString.EMPTY;
    description_ = "";
    oauth2ClientId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServiceAccount();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.iam.admin.v1.Iam
        .internal_static_google_iam_admin_v1_ServiceAccount_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.iam.admin.v1.Iam
        .internal_static_google_iam_admin_v1_ServiceAccount_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.iam.admin.v1.ServiceAccount.class,
            com.google.iam.admin.v1.ServiceAccount.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The resource name of the service account.
   *
   * Use one of the following formats:
   *
   * * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}`
   * * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}`
   *
   * As an alternative, you can use the `-` wildcard character instead of the
   * project ID:
   *
   * * `projects/-/serviceAccounts/{EMAIL_ADDRESS}`
   * * `projects/-/serviceAccounts/{UNIQUE_ID}`
   *
   * When possible, avoid using the `-` wildcard character, because it can cause
   * response messages to contain misleading error codes. For example, if you
   * try to get the service account
   * `projects/-/serviceAccounts/fake&#64;example.com`, which does not exist, the
   * response contains an HTTP `403 Forbidden` error instead of a `404 Not
   * Found` error.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The resource name of the service account.
   *
   * Use one of the following formats:
   *
   * * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}`
   * * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}`
   *
   * As an alternative, you can use the `-` wildcard character instead of the
   * project ID:
   *
   * * `projects/-/serviceAccounts/{EMAIL_ADDRESS}`
   * * `projects/-/serviceAccounts/{UNIQUE_ID}`
   *
   * When possible, avoid using the `-` wildcard character, because it can cause
   * response messages to contain misleading error codes. For example, if you
   * try to get the service account
   * `projects/-/serviceAccounts/fake&#64;example.com`, which does not exist, the
   * response contains an HTTP `403 Forbidden` error instead of a `404 Not
   * Found` error.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The ID of the project that owns the service account.
   * </pre>
   *
   * <code>string project_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The ID of the project that owns the service account.
   * </pre>
   *
   * <code>string project_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNIQUE_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uniqueId_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The unique, stable numeric ID for the service account.
   *
   * Each service account retains its unique ID even if you delete the service
   * account. For example, if you delete a service account, then create a new
   * service account with the same name, the new service account has a different
   * unique ID than the deleted service account.
   * </pre>
   *
   * <code>string unique_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uniqueId.
   */
  @java.lang.Override
  public java.lang.String getUniqueId() {
    java.lang.Object ref = uniqueId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uniqueId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The unique, stable numeric ID for the service account.
   *
   * Each service account retains its unique ID even if you delete the service
   * account. For example, if you delete a service account, then create a new
   * service account with the same name, the new service account has a different
   * unique ID than the deleted service account.
   * </pre>
   *
   * <code>string unique_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uniqueId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUniqueIdBytes() {
    java.lang.Object ref = uniqueId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uniqueId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EMAIL_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object email_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The email address of the service account.
   * </pre>
   *
   * <code>string email = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The email.
   */
  @java.lang.Override
  public java.lang.String getEmail() {
    java.lang.Object ref = email_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      email_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The email address of the service account.
   * </pre>
   *
   * <code>string email = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for email.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEmailBytes() {
    java.lang.Object ref = email_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      email_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A user-specified, human-readable name for the service account. The maximum
   * length is 100 UTF-8 bytes.
   * </pre>
   *
   * <code>string display_name = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A user-specified, human-readable name for the service account. The maximum
   * length is 100 UTF-8 bytes.
   * </pre>
   *
   * <code>string display_name = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 7;
  private com.google.protobuf.ByteString etag_ = com.google.protobuf.ByteString.EMPTY;

  /**
   *
   *
   * <pre>
   * Deprecated. Do not use.
   * </pre>
   *
   * <code>bytes etag = 7 [deprecated = true];</code>
   *
   * @deprecated google.iam.admin.v1.ServiceAccount.etag is deprecated. See
   *     google/iam/admin/v1/iam.proto;l=538
   * @return The etag.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getEtag() {
    return etag_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A user-specified, human-readable description of the service account. The
   * maximum length is 256 UTF-8 bytes.
   * </pre>
   *
   * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A user-specified, human-readable description of the service account. The
   * maximum length is 256 UTF-8 bytes.
   * </pre>
   *
   * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OAUTH2_CLIENT_ID_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object oauth2ClientId_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The OAuth 2.0 client ID for the service account.
   * </pre>
   *
   * <code>string oauth2_client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The oauth2ClientId.
   */
  @java.lang.Override
  public java.lang.String getOauth2ClientId() {
    java.lang.Object ref = oauth2ClientId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      oauth2ClientId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The OAuth 2.0 client ID for the service account.
   * </pre>
   *
   * <code>string oauth2_client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for oauth2ClientId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOauth2ClientIdBytes() {
    java.lang.Object ref = oauth2ClientId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      oauth2ClientId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLED_FIELD_NUMBER = 11;
  private boolean disabled_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Whether the service account is disabled.
   * </pre>
   *
   * <code>bool disabled = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uniqueId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, uniqueId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(email_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, email_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, displayName_);
    }
    if (!etag_.isEmpty()) {
      output.writeBytes(7, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oauth2ClientId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, oauth2ClientId_);
    }
    if (disabled_ != false) {
      output.writeBool(11, disabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uniqueId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, uniqueId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(email_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, email_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, displayName_);
    }
    if (!etag_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(7, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(oauth2ClientId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, oauth2ClientId_);
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, disabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.iam.admin.v1.ServiceAccount)) {
      return super.equals(obj);
    }
    com.google.iam.admin.v1.ServiceAccount other = (com.google.iam.admin.v1.ServiceAccount) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getUniqueId().equals(other.getUniqueId())) return false;
    if (!getEmail().equals(other.getEmail())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getOauth2ClientId().equals(other.getOauth2ClientId())) return false;
    if (getDisabled() != other.getDisabled()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + UNIQUE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getUniqueId().hashCode();
    hash = (37 * hash) + EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getEmail().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + OAUTH2_CLIENT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getOauth2ClientId().hashCode();
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.iam.admin.v1.ServiceAccount parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.ServiceAccount parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ServiceAccount parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.ServiceAccount parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ServiceAccount parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.iam.admin.v1.ServiceAccount parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ServiceAccount parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.ServiceAccount parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ServiceAccount parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.ServiceAccount parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.iam.admin.v1.ServiceAccount parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.iam.admin.v1.ServiceAccount parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.iam.admin.v1.ServiceAccount prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An IAM service account.
   *
   * A service account is an account for an application or a virtual machine (VM)
   * instance, not a person. You can use a service account to call Google APIs. To
   * learn more, read the [overview of service
   * accounts](https://cloud.google.com/iam/help/service-accounts/overview).
   *
   * When you create a service account, you specify the project ID that owns the
   * service account, as well as a name that must be unique within the project.
   * IAM uses these values to create an email address that identifies the service
   * account.
   * </pre>
   *
   * Protobuf type {@code google.iam.admin.v1.ServiceAccount}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.iam.admin.v1.ServiceAccount)
      com.google.iam.admin.v1.ServiceAccountOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_ServiceAccount_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_ServiceAccount_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.iam.admin.v1.ServiceAccount.class,
              com.google.iam.admin.v1.ServiceAccount.Builder.class);
    }

    // Construct using com.google.iam.admin.v1.ServiceAccount.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      projectId_ = "";
      uniqueId_ = "";
      email_ = "";
      displayName_ = "";
      etag_ = com.google.protobuf.ByteString.EMPTY;
      description_ = "";
      oauth2ClientId_ = "";
      disabled_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.iam.admin.v1.Iam
          .internal_static_google_iam_admin_v1_ServiceAccount_descriptor;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.ServiceAccount getDefaultInstanceForType() {
      return com.google.iam.admin.v1.ServiceAccount.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.iam.admin.v1.ServiceAccount build() {
      com.google.iam.admin.v1.ServiceAccount result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.iam.admin.v1.ServiceAccount buildPartial() {
      com.google.iam.admin.v1.ServiceAccount result =
          new com.google.iam.admin.v1.ServiceAccount(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.iam.admin.v1.ServiceAccount result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.uniqueId_ = uniqueId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.email_ = email_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.oauth2ClientId_ = oauth2ClientId_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.disabled_ = disabled_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.iam.admin.v1.ServiceAccount) {
        return mergeFrom((com.google.iam.admin.v1.ServiceAccount) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.iam.admin.v1.ServiceAccount other) {
      if (other == com.google.iam.admin.v1.ServiceAccount.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUniqueId().isEmpty()) {
        uniqueId_ = other.uniqueId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getEmail().isEmpty()) {
        email_ = other.email_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getEtag() != com.google.protobuf.ByteString.EMPTY) {
        setEtag(other.getEtag());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getOauth2ClientId().isEmpty()) {
        oauth2ClientId_ = other.oauth2ClientId_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                uniqueId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                email_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                etag_ = input.readBytes();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 74:
              {
                oauth2ClientId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 88:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 88
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The resource name of the service account.
     *
     * Use one of the following formats:
     *
     * * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}`
     * * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}`
     *
     * As an alternative, you can use the `-` wildcard character instead of the
     * project ID:
     *
     * * `projects/-/serviceAccounts/{EMAIL_ADDRESS}`
     * * `projects/-/serviceAccounts/{UNIQUE_ID}`
     *
     * When possible, avoid using the `-` wildcard character, because it can cause
     * response messages to contain misleading error codes. For example, if you
     * try to get the service account
     * `projects/-/serviceAccounts/fake&#64;example.com`, which does not exist, the
     * response contains an HTTP `403 Forbidden` error instead of a `404 Not
     * Found` error.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the service account.
     *
     * Use one of the following formats:
     *
     * * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}`
     * * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}`
     *
     * As an alternative, you can use the `-` wildcard character instead of the
     * project ID:
     *
     * * `projects/-/serviceAccounts/{EMAIL_ADDRESS}`
     * * `projects/-/serviceAccounts/{UNIQUE_ID}`
     *
     * When possible, avoid using the `-` wildcard character, because it can cause
     * response messages to contain misleading error codes. For example, if you
     * try to get the service account
     * `projects/-/serviceAccounts/fake&#64;example.com`, which does not exist, the
     * response contains an HTTP `403 Forbidden` error instead of a `404 Not
     * Found` error.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the service account.
     *
     * Use one of the following formats:
     *
     * * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}`
     * * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}`
     *
     * As an alternative, you can use the `-` wildcard character instead of the
     * project ID:
     *
     * * `projects/-/serviceAccounts/{EMAIL_ADDRESS}`
     * * `projects/-/serviceAccounts/{UNIQUE_ID}`
     *
     * When possible, avoid using the `-` wildcard character, because it can cause
     * response messages to contain misleading error codes. For example, if you
     * try to get the service account
     * `projects/-/serviceAccounts/fake&#64;example.com`, which does not exist, the
     * response contains an HTTP `403 Forbidden` error instead of a `404 Not
     * Found` error.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the service account.
     *
     * Use one of the following formats:
     *
     * * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}`
     * * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}`
     *
     * As an alternative, you can use the `-` wildcard character instead of the
     * project ID:
     *
     * * `projects/-/serviceAccounts/{EMAIL_ADDRESS}`
     * * `projects/-/serviceAccounts/{UNIQUE_ID}`
     *
     * When possible, avoid using the `-` wildcard character, because it can cause
     * response messages to contain misleading error codes. For example, if you
     * try to get the service account
     * `projects/-/serviceAccounts/fake&#64;example.com`, which does not exist, the
     * response contains an HTTP `403 Forbidden` error instead of a `404 Not
     * Found` error.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the service account.
     *
     * Use one of the following formats:
     *
     * * `projects/{PROJECT_ID}/serviceAccounts/{EMAIL_ADDRESS}`
     * * `projects/{PROJECT_ID}/serviceAccounts/{UNIQUE_ID}`
     *
     * As an alternative, you can use the `-` wildcard character instead of the
     * project ID:
     *
     * * `projects/-/serviceAccounts/{EMAIL_ADDRESS}`
     * * `projects/-/serviceAccounts/{UNIQUE_ID}`
     *
     * When possible, avoid using the `-` wildcard character, because it can cause
     * response messages to contain misleading error codes. For example, if you
     * try to get the service account
     * `projects/-/serviceAccounts/fake&#64;example.com`, which does not exist, the
     * response contains an HTTP `403 Forbidden` error instead of a `404 Not
     * Found` error.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The ID of the project that owns the service account.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The ID of the project that owns the service account.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The ID of the project that owns the service account.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The ID of the project that owns the service account.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The ID of the project that owns the service account.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object uniqueId_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The unique, stable numeric ID for the service account.
     *
     * Each service account retains its unique ID even if you delete the service
     * account. For example, if you delete a service account, then create a new
     * service account with the same name, the new service account has a different
     * unique ID than the deleted service account.
     * </pre>
     *
     * <code>string unique_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uniqueId.
     */
    public java.lang.String getUniqueId() {
      java.lang.Object ref = uniqueId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uniqueId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The unique, stable numeric ID for the service account.
     *
     * Each service account retains its unique ID even if you delete the service
     * account. For example, if you delete a service account, then create a new
     * service account with the same name, the new service account has a different
     * unique ID than the deleted service account.
     * </pre>
     *
     * <code>string unique_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uniqueId.
     */
    public com.google.protobuf.ByteString getUniqueIdBytes() {
      java.lang.Object ref = uniqueId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uniqueId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The unique, stable numeric ID for the service account.
     *
     * Each service account retains its unique ID even if you delete the service
     * account. For example, if you delete a service account, then create a new
     * service account with the same name, the new service account has a different
     * unique ID than the deleted service account.
     * </pre>
     *
     * <code>string unique_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uniqueId to set.
     * @return This builder for chaining.
     */
    public Builder setUniqueId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uniqueId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The unique, stable numeric ID for the service account.
     *
     * Each service account retains its unique ID even if you delete the service
     * account. For example, if you delete a service account, then create a new
     * service account with the same name, the new service account has a different
     * unique ID than the deleted service account.
     * </pre>
     *
     * <code>string unique_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUniqueId() {
      uniqueId_ = getDefaultInstance().getUniqueId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The unique, stable numeric ID for the service account.
     *
     * Each service account retains its unique ID even if you delete the service
     * account. For example, if you delete a service account, then create a new
     * service account with the same name, the new service account has a different
     * unique ID than the deleted service account.
     * </pre>
     *
     * <code>string unique_id = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uniqueId to set.
     * @return This builder for chaining.
     */
    public Builder setUniqueIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uniqueId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object email_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The email address of the service account.
     * </pre>
     *
     * <code>string email = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The email.
     */
    public java.lang.String getEmail() {
      java.lang.Object ref = email_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        email_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The email address of the service account.
     * </pre>
     *
     * <code>string email = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for email.
     */
    public com.google.protobuf.ByteString getEmailBytes() {
      java.lang.Object ref = email_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        email_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The email address of the service account.
     * </pre>
     *
     * <code>string email = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The email to set.
     * @return This builder for chaining.
     */
    public Builder setEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      email_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The email address of the service account.
     * </pre>
     *
     * <code>string email = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEmail() {
      email_ = getDefaultInstance().getEmail();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The email address of the service account.
     * </pre>
     *
     * <code>string email = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for email to set.
     * @return This builder for chaining.
     */
    public Builder setEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      email_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A user-specified, human-readable name for the service account. The maximum
     * length is 100 UTF-8 bytes.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified, human-readable name for the service account. The maximum
     * length is 100 UTF-8 bytes.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified, human-readable name for the service account. The maximum
     * length is 100 UTF-8 bytes.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified, human-readable name for the service account. The maximum
     * length is 100 UTF-8 bytes.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified, human-readable name for the service account. The maximum
     * length is 100 UTF-8 bytes.
     * </pre>
     *
     * <code>string display_name = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString etag_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * Deprecated. Do not use.
     * </pre>
     *
     * <code>bytes etag = 7 [deprecated = true];</code>
     *
     * @deprecated google.iam.admin.v1.ServiceAccount.etag is deprecated. See
     *     google/iam/admin/v1/iam.proto;l=538
     * @return The etag.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getEtag() {
      return etag_;
    }

    /**
     *
     *
     * <pre>
     * Deprecated. Do not use.
     * </pre>
     *
     * <code>bytes etag = 7 [deprecated = true];</code>
     *
     * @deprecated google.iam.admin.v1.ServiceAccount.etag is deprecated. See
     *     google/iam/admin/v1/iam.proto;l=538
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setEtag(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated. Do not use.
     * </pre>
     *
     * <code>bytes etag = 7 [deprecated = true];</code>
     *
     * @deprecated google.iam.admin.v1.ServiceAccount.etag is deprecated. See
     *     google/iam/admin/v1/iam.proto;l=538
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearEtag() {
      bitField0_ = (bitField0_ & ~0x00000020);
      etag_ = getDefaultInstance().getEtag();
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A user-specified, human-readable description of the service account. The
     * maximum length is 256 UTF-8 bytes.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified, human-readable description of the service account. The
     * maximum length is 256 UTF-8 bytes.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified, human-readable description of the service account. The
     * maximum length is 256 UTF-8 bytes.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified, human-readable description of the service account. The
     * maximum length is 256 UTF-8 bytes.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified, human-readable description of the service account. The
     * maximum length is 256 UTF-8 bytes.
     * </pre>
     *
     * <code>string description = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object oauth2ClientId_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The OAuth 2.0 client ID for the service account.
     * </pre>
     *
     * <code>string oauth2_client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The oauth2ClientId.
     */
    public java.lang.String getOauth2ClientId() {
      java.lang.Object ref = oauth2ClientId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        oauth2ClientId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The OAuth 2.0 client ID for the service account.
     * </pre>
     *
     * <code>string oauth2_client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for oauth2ClientId.
     */
    public com.google.protobuf.ByteString getOauth2ClientIdBytes() {
      java.lang.Object ref = oauth2ClientId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        oauth2ClientId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The OAuth 2.0 client ID for the service account.
     * </pre>
     *
     * <code>string oauth2_client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The oauth2ClientId to set.
     * @return This builder for chaining.
     */
    public Builder setOauth2ClientId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      oauth2ClientId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The OAuth 2.0 client ID for the service account.
     * </pre>
     *
     * <code>string oauth2_client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOauth2ClientId() {
      oauth2ClientId_ = getDefaultInstance().getOauth2ClientId();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The OAuth 2.0 client ID for the service account.
     * </pre>
     *
     * <code>string oauth2_client_id = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for oauth2ClientId to set.
     * @return This builder for chaining.
     */
    public Builder setOauth2ClientIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      oauth2ClientId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private boolean disabled_;

    /**
     *
     *
     * <pre>
     * Output only. Whether the service account is disabled.
     * </pre>
     *
     * <code>bool disabled = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether the service account is disabled.
     * </pre>
     *
     * <code>bool disabled = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether the service account is disabled.
     * </pre>
     *
     * <code>bool disabled = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000100);
      disabled_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.iam.admin.v1.ServiceAccount)
  }

  // @@protoc_insertion_point(class_scope:google.iam.admin.v1.ServiceAccount)
  private static final com.google.iam.admin.v1.ServiceAccount DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.iam.admin.v1.ServiceAccount();
  }

  public static com.google.iam.admin.v1.ServiceAccount getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServiceAccount> PARSER =
      new com.google.protobuf.AbstractParser<ServiceAccount>() {
        @java.lang.Override
        public ServiceAccount parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServiceAccount> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServiceAccount> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.iam.admin.v1.ServiceAccount getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
