/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/apps/card/v1/card.proto
// Protobuf Java Version: 4.33.2

package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * A paragraph of text that supports formatting. For an example in
 * Google Chat apps, see [Add a paragraph of formatted
 * text](https://developers.google.com/workspace/chat/add-text-image-card-dialog#add_a_paragraph_of_formatted_text).
 * For more information
 * about formatting text, see
 * [Formatting text in Google Chat
 * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
 * and
 * [Formatting
 * text in Google Workspace
 * add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
 *
 * [Google Workspace add-ons and
 * Chat apps](https://developers.google.com/workspace/extend):
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.TextParagraph}
 */
@com.google.protobuf.Generated
public final class TextParagraph extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.TextParagraph)
    TextParagraphOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "TextParagraph");
  }

  // Use TextParagraph.newBuilder() to construct.
  private TextParagraph(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private TextParagraph() {
    text_ = "";
    textSyntax_ = 0;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_TextParagraph_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_TextParagraph_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.TextParagraph.class,
            com.google.apps.card.v1.TextParagraph.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Syntax to use for formatting text.
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * Protobuf enum {@code google.apps.card.v1.TextParagraph.TextSyntax}
   */
  public enum TextSyntax implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The text is rendered as HTML if unspecified.
     * </pre>
     *
     * <code>TEXT_SYNTAX_UNSPECIFIED = 0;</code>
     */
    TEXT_SYNTAX_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The text is rendered as HTML. This is the default value.
     * </pre>
     *
     * <code>HTML = 1;</code>
     */
    HTML(1),
    /**
     *
     *
     * <pre>
     * The text is rendered as Markdown.
     * </pre>
     *
     * <code>MARKDOWN = 2;</code>
     */
    MARKDOWN(2),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "TextSyntax");
    }

    /**
     *
     *
     * <pre>
     * The text is rendered as HTML if unspecified.
     * </pre>
     *
     * <code>TEXT_SYNTAX_UNSPECIFIED = 0;</code>
     */
    public static final int TEXT_SYNTAX_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The text is rendered as HTML. This is the default value.
     * </pre>
     *
     * <code>HTML = 1;</code>
     */
    public static final int HTML_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The text is rendered as Markdown.
     * </pre>
     *
     * <code>MARKDOWN = 2;</code>
     */
    public static final int MARKDOWN_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TextSyntax valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TextSyntax forNumber(int value) {
      switch (value) {
        case 0:
          return TEXT_SYNTAX_UNSPECIFIED;
        case 1:
          return HTML;
        case 2:
          return MARKDOWN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TextSyntax> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TextSyntax> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TextSyntax>() {
          public TextSyntax findValueByNumber(int number) {
            return TextSyntax.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.apps.card.v1.TextParagraph.getDescriptor().getEnumTypes().get(0);
    }

    private static final TextSyntax[] VALUES = values();

    public static TextSyntax valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TextSyntax(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.apps.card.v1.TextParagraph.TextSyntax)
  }

  public static final int TEXT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object text_ = "";

  /**
   *
   *
   * <pre>
   * The text that's shown in the widget.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return The text.
   */
  @java.lang.Override
  public java.lang.String getText() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      text_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The text that's shown in the widget.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return The bytes for text.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTextBytes() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      text_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_LINES_FIELD_NUMBER = 2;
  private int maxLines_ = 0;

  /**
   *
   *
   * <pre>
   * The maximum number of lines of text that are displayed in the widget. If
   * the text exceeds the specified maximum number of lines, the excess
   * content is concealed behind a **show more** button. If the text is equal or
   * shorter than the specified maximum number of lines, a **show more** button
   * isn't displayed.
   *
   * The default value is 0, in which case
   * all context is displayed. Negative values are ignored.
   * </pre>
   *
   * <code>int32 max_lines = 2;</code>
   *
   * @return The maxLines.
   */
  @java.lang.Override
  public int getMaxLines() {
    return maxLines_;
  }

  public static final int TEXT_SYNTAX_FIELD_NUMBER = 4;
  private int textSyntax_ = 0;

  /**
   *
   *
   * <pre>
   * The syntax of the text. If not set, the text is rendered as HTML.
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>.google.apps.card.v1.TextParagraph.TextSyntax text_syntax = 4;</code>
   *
   * @return The enum numeric value on the wire for textSyntax.
   */
  @java.lang.Override
  public int getTextSyntaxValue() {
    return textSyntax_;
  }

  /**
   *
   *
   * <pre>
   * The syntax of the text. If not set, the text is rendered as HTML.
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>.google.apps.card.v1.TextParagraph.TextSyntax text_syntax = 4;</code>
   *
   * @return The textSyntax.
   */
  @java.lang.Override
  public com.google.apps.card.v1.TextParagraph.TextSyntax getTextSyntax() {
    com.google.apps.card.v1.TextParagraph.TextSyntax result =
        com.google.apps.card.v1.TextParagraph.TextSyntax.forNumber(textSyntax_);
    return result == null ? com.google.apps.card.v1.TextParagraph.TextSyntax.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(text_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, text_);
    }
    if (maxLines_ != 0) {
      output.writeInt32(2, maxLines_);
    }
    if (textSyntax_
        != com.google.apps.card.v1.TextParagraph.TextSyntax.TEXT_SYNTAX_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, textSyntax_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(text_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, text_);
    }
    if (maxLines_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxLines_);
    }
    if (textSyntax_
        != com.google.apps.card.v1.TextParagraph.TextSyntax.TEXT_SYNTAX_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, textSyntax_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.TextParagraph)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.TextParagraph other = (com.google.apps.card.v1.TextParagraph) obj;

    if (!getText().equals(other.getText())) return false;
    if (getMaxLines() != other.getMaxLines()) return false;
    if (textSyntax_ != other.textSyntax_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getText().hashCode();
    hash = (37 * hash) + MAX_LINES_FIELD_NUMBER;
    hash = (53 * hash) + getMaxLines();
    hash = (37 * hash) + TEXT_SYNTAX_FIELD_NUMBER;
    hash = (53 * hash) + textSyntax_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.TextParagraph parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.TextParagraph parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.TextParagraph parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.TextParagraph parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.TextParagraph parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.TextParagraph parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.TextParagraph parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.TextParagraph parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.TextParagraph parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.TextParagraph parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.TextParagraph parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.TextParagraph parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.TextParagraph prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A paragraph of text that supports formatting. For an example in
   * Google Chat apps, see [Add a paragraph of formatted
   * text](https://developers.google.com/workspace/chat/add-text-image-card-dialog#add_a_paragraph_of_formatted_text).
   * For more information
   * about formatting text, see
   * [Formatting text in Google Chat
   * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
   * and
   * [Formatting
   * text in Google Workspace
   * add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
   *
   * [Google Workspace add-ons and
   * Chat apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.TextParagraph}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.TextParagraph)
      com.google.apps.card.v1.TextParagraphOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_TextParagraph_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_TextParagraph_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.TextParagraph.class,
              com.google.apps.card.v1.TextParagraph.Builder.class);
    }

    // Construct using com.google.apps.card.v1.TextParagraph.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      text_ = "";
      maxLines_ = 0;
      textSyntax_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_TextParagraph_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.TextParagraph getDefaultInstanceForType() {
      return com.google.apps.card.v1.TextParagraph.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.TextParagraph build() {
      com.google.apps.card.v1.TextParagraph result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.TextParagraph buildPartial() {
      com.google.apps.card.v1.TextParagraph result =
          new com.google.apps.card.v1.TextParagraph(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.apps.card.v1.TextParagraph result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.text_ = text_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.maxLines_ = maxLines_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.textSyntax_ = textSyntax_;
      }
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.TextParagraph) {
        return mergeFrom((com.google.apps.card.v1.TextParagraph) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.TextParagraph other) {
      if (other == com.google.apps.card.v1.TextParagraph.getDefaultInstance()) return this;
      if (!other.getText().isEmpty()) {
        text_ = other.text_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getMaxLines() != 0) {
        setMaxLines(other.getMaxLines());
      }
      if (other.textSyntax_ != 0) {
        setTextSyntaxValue(other.getTextSyntaxValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                text_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                maxLines_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 32:
              {
                textSyntax_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object text_ = "";

    /**
     *
     *
     * <pre>
     * The text that's shown in the widget.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The text that's shown in the widget.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The text that's shown in the widget.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @param value The text to set.
     * @return This builder for chaining.
     */
    public Builder setText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      text_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The text that's shown in the widget.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearText() {
      text_ = getDefaultInstance().getText();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The text that's shown in the widget.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @param value The bytes for text to set.
     * @return This builder for chaining.
     */
    public Builder setTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      text_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int maxLines_;

    /**
     *
     *
     * <pre>
     * The maximum number of lines of text that are displayed in the widget. If
     * the text exceeds the specified maximum number of lines, the excess
     * content is concealed behind a **show more** button. If the text is equal or
     * shorter than the specified maximum number of lines, a **show more** button
     * isn't displayed.
     *
     * The default value is 0, in which case
     * all context is displayed. Negative values are ignored.
     * </pre>
     *
     * <code>int32 max_lines = 2;</code>
     *
     * @return The maxLines.
     */
    @java.lang.Override
    public int getMaxLines() {
      return maxLines_;
    }

    /**
     *
     *
     * <pre>
     * The maximum number of lines of text that are displayed in the widget. If
     * the text exceeds the specified maximum number of lines, the excess
     * content is concealed behind a **show more** button. If the text is equal or
     * shorter than the specified maximum number of lines, a **show more** button
     * isn't displayed.
     *
     * The default value is 0, in which case
     * all context is displayed. Negative values are ignored.
     * </pre>
     *
     * <code>int32 max_lines = 2;</code>
     *
     * @param value The maxLines to set.
     * @return This builder for chaining.
     */
    public Builder setMaxLines(int value) {

      maxLines_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The maximum number of lines of text that are displayed in the widget. If
     * the text exceeds the specified maximum number of lines, the excess
     * content is concealed behind a **show more** button. If the text is equal or
     * shorter than the specified maximum number of lines, a **show more** button
     * isn't displayed.
     *
     * The default value is 0, in which case
     * all context is displayed. Negative values are ignored.
     * </pre>
     *
     * <code>int32 max_lines = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxLines() {
      bitField0_ = (bitField0_ & ~0x00000002);
      maxLines_ = 0;
      onChanged();
      return this;
    }

    private int textSyntax_ = 0;

    /**
     *
     *
     * <pre>
     * The syntax of the text. If not set, the text is rendered as HTML.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph.TextSyntax text_syntax = 4;</code>
     *
     * @return The enum numeric value on the wire for textSyntax.
     */
    @java.lang.Override
    public int getTextSyntaxValue() {
      return textSyntax_;
    }

    /**
     *
     *
     * <pre>
     * The syntax of the text. If not set, the text is rendered as HTML.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph.TextSyntax text_syntax = 4;</code>
     *
     * @param value The enum numeric value on the wire for textSyntax to set.
     * @return This builder for chaining.
     */
    public Builder setTextSyntaxValue(int value) {
      textSyntax_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The syntax of the text. If not set, the text is rendered as HTML.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph.TextSyntax text_syntax = 4;</code>
     *
     * @return The textSyntax.
     */
    @java.lang.Override
    public com.google.apps.card.v1.TextParagraph.TextSyntax getTextSyntax() {
      com.google.apps.card.v1.TextParagraph.TextSyntax result =
          com.google.apps.card.v1.TextParagraph.TextSyntax.forNumber(textSyntax_);
      return result == null
          ? com.google.apps.card.v1.TextParagraph.TextSyntax.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The syntax of the text. If not set, the text is rendered as HTML.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph.TextSyntax text_syntax = 4;</code>
     *
     * @param value The textSyntax to set.
     * @return This builder for chaining.
     */
    public Builder setTextSyntax(com.google.apps.card.v1.TextParagraph.TextSyntax value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      textSyntax_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The syntax of the text. If not set, the text is rendered as HTML.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph.TextSyntax text_syntax = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTextSyntax() {
      bitField0_ = (bitField0_ & ~0x00000004);
      textSyntax_ = 0;
      onChanged();
      return this;
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.TextParagraph)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.TextParagraph)
  private static final com.google.apps.card.v1.TextParagraph DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.TextParagraph();
  }

  public static com.google.apps.card.v1.TextParagraph getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TextParagraph> PARSER =
      new com.google.protobuf.AbstractParser<TextParagraph>() {
        @java.lang.Override
        public TextParagraph parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TextParagraph> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TextParagraph> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.TextParagraph getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
