/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/apps/card/v1/card.proto
// Protobuf Java Version: 4.33.2

package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * Displays a grid with a collection of items. Items can only include text or
 * images. For responsive columns, or to include more than text or images, use
 * [`Columns`][google.apps.card.v1.Columns]. For an example in Google Chat apps,
 * see [Display a Grid with a collection of
 * items](https://developers.google.com/workspace/chat/format-structure-card-dialog#display_a_grid_with_a_collection_of_items).
 *
 * A grid supports any number of columns and items. The number of rows is
 * determined by items divided by columns. A grid with
 * 10 items and 2 columns has 5 rows. A grid with 11 items and 2 columns
 * has 6 rows.
 *
 * [Google Workspace add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 *
 * For example, the following JSON creates a 2 column grid with a single
 * item:
 *
 * ```
 * "grid": {
 * "title": "A fine collection of items",
 * "columnCount": 2,
 * "borderStyle": {
 * "type": "STROKE",
 * "cornerRadius": 4
 * },
 * "items": [
 * {
 * "image": {
 * "imageUri": "https://www.example.com/image.png",
 * "cropStyle": {
 * "type": "SQUARE"
 * },
 * "borderStyle": {
 * "type": "STROKE"
 * }
 * },
 * "title": "An item",
 * "textAlignment": "CENTER"
 * }
 * ],
 * "onClick": {
 * "openLink": {
 * "url": "https://www.example.com"
 * }
 * }
 * }
 * ```
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.Grid}
 */
@com.google.protobuf.Generated
public final class Grid extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.Grid)
    GridOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "Grid");
  }

  // Use Grid.newBuilder() to construct.
  private Grid(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private Grid() {
    title_ = "";
    items_ = java.util.Collections.emptyList();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Grid_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_Grid_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.Grid.class, com.google.apps.card.v1.Grid.Builder.class);
  }

  public interface GridItemOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.apps.card.v1.Grid.GridItem)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A user-specified identifier for this grid item. This identifier is
     * returned in the parent grid's `onClick` callback parameters.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    java.lang.String getId();

    /**
     *
     *
     * <pre>
     * A user-specified identifier for this grid item. This identifier is
     * returned in the parent grid's `onClick` callback parameters.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * The image that displays in the grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
     *
     * @return Whether the image field is set.
     */
    boolean hasImage();

    /**
     *
     *
     * <pre>
     * The image that displays in the grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
     *
     * @return The image.
     */
    com.google.apps.card.v1.ImageComponent getImage();

    /**
     *
     *
     * <pre>
     * The image that displays in the grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
     */
    com.google.apps.card.v1.ImageComponentOrBuilder getImageOrBuilder();

    /**
     *
     *
     * <pre>
     * The grid item's title.
     * </pre>
     *
     * <code>string title = 3;</code>
     *
     * @return The title.
     */
    java.lang.String getTitle();

    /**
     *
     *
     * <pre>
     * The grid item's title.
     * </pre>
     *
     * <code>string title = 3;</code>
     *
     * @return The bytes for title.
     */
    com.google.protobuf.ByteString getTitleBytes();

    /**
     *
     *
     * <pre>
     * The grid item's subtitle.
     * </pre>
     *
     * <code>string subtitle = 4;</code>
     *
     * @return The subtitle.
     */
    java.lang.String getSubtitle();

    /**
     *
     *
     * <pre>
     * The grid item's subtitle.
     * </pre>
     *
     * <code>string subtitle = 4;</code>
     *
     * @return The bytes for subtitle.
     */
    com.google.protobuf.ByteString getSubtitleBytes();

    /**
     *
     *
     * <pre>
     * The layout to use for the grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.Grid.GridItem.GridItemLayout layout = 9;</code>
     *
     * @return The enum numeric value on the wire for layout.
     */
    int getLayoutValue();

    /**
     *
     *
     * <pre>
     * The layout to use for the grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.Grid.GridItem.GridItemLayout layout = 9;</code>
     *
     * @return The layout.
     */
    com.google.apps.card.v1.Grid.GridItem.GridItemLayout getLayout();
  }

  /**
   *
   *
   * <pre>
   * Represents an item in a grid layout. Items can contain text, an image, or
   * both text and an image.
   *
   * [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Grid.GridItem}
   */
  public static final class GridItem extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.apps.card.v1.Grid.GridItem)
      GridItemOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "GridItem");
    }

    // Use GridItem.newBuilder() to construct.
    private GridItem(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private GridItem() {
      id_ = "";
      title_ = "";
      subtitle_ = "";
      layout_ = 0;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Grid_GridItem_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Grid_GridItem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Grid.GridItem.class,
              com.google.apps.card.v1.Grid.GridItem.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Represents the various layout options available for a grid item.
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * Protobuf enum {@code google.apps.card.v1.Grid.GridItem.GridItemLayout}
     */
    public enum GridItemLayout implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Don't use. Unspecified.
       * </pre>
       *
       * <code>GRID_ITEM_LAYOUT_UNSPECIFIED = 0;</code>
       */
      GRID_ITEM_LAYOUT_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The title and subtitle are shown below the grid item's image.
       * </pre>
       *
       * <code>TEXT_BELOW = 1;</code>
       */
      TEXT_BELOW(1),
      /**
       *
       *
       * <pre>
       * The title and subtitle are shown above the grid item's image.
       * </pre>
       *
       * <code>TEXT_ABOVE = 2;</code>
       */
      TEXT_ABOVE(2),
      UNRECOGNIZED(-1),
      ;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 33,
            /* patch= */ 2,
            /* suffix= */ "",
            "GridItemLayout");
      }

      /**
       *
       *
       * <pre>
       * Don't use. Unspecified.
       * </pre>
       *
       * <code>GRID_ITEM_LAYOUT_UNSPECIFIED = 0;</code>
       */
      public static final int GRID_ITEM_LAYOUT_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * The title and subtitle are shown below the grid item's image.
       * </pre>
       *
       * <code>TEXT_BELOW = 1;</code>
       */
      public static final int TEXT_BELOW_VALUE = 1;

      /**
       *
       *
       * <pre>
       * The title and subtitle are shown above the grid item's image.
       * </pre>
       *
       * <code>TEXT_ABOVE = 2;</code>
       */
      public static final int TEXT_ABOVE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static GridItemLayout valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static GridItemLayout forNumber(int value) {
        switch (value) {
          case 0:
            return GRID_ITEM_LAYOUT_UNSPECIFIED;
          case 1:
            return TEXT_BELOW;
          case 2:
            return TEXT_ABOVE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<GridItemLayout> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<GridItemLayout>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<GridItemLayout>() {
                public GridItemLayout findValueByNumber(int number) {
                  return GridItemLayout.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.apps.card.v1.Grid.GridItem.getDescriptor().getEnumTypes().get(0);
      }

      private static final GridItemLayout[] VALUES = values();

      public static GridItemLayout valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private GridItemLayout(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.apps.card.v1.Grid.GridItem.GridItemLayout)
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";

    /**
     *
     *
     * <pre>
     * A user-specified identifier for this grid item. This identifier is
     * returned in the parent grid's `onClick` callback parameters.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * A user-specified identifier for this grid item. This identifier is
     * returned in the parent grid's `onClick` callback parameters.
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IMAGE_FIELD_NUMBER = 2;
    private com.google.apps.card.v1.ImageComponent image_;

    /**
     *
     *
     * <pre>
     * The image that displays in the grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
     *
     * @return Whether the image field is set.
     */
    @java.lang.Override
    public boolean hasImage() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The image that displays in the grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
     *
     * @return The image.
     */
    @java.lang.Override
    public com.google.apps.card.v1.ImageComponent getImage() {
      return image_ == null ? com.google.apps.card.v1.ImageComponent.getDefaultInstance() : image_;
    }

    /**
     *
     *
     * <pre>
     * The image that displays in the grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.ImageComponentOrBuilder getImageOrBuilder() {
      return image_ == null ? com.google.apps.card.v1.ImageComponent.getDefaultInstance() : image_;
    }

    public static final int TITLE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object title_ = "";

    /**
     *
     *
     * <pre>
     * The grid item's title.
     * </pre>
     *
     * <code>string title = 3;</code>
     *
     * @return The title.
     */
    @java.lang.Override
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The grid item's title.
     * </pre>
     *
     * <code>string title = 3;</code>
     *
     * @return The bytes for title.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUBTITLE_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object subtitle_ = "";

    /**
     *
     *
     * <pre>
     * The grid item's subtitle.
     * </pre>
     *
     * <code>string subtitle = 4;</code>
     *
     * @return The subtitle.
     */
    @java.lang.Override
    public java.lang.String getSubtitle() {
      java.lang.Object ref = subtitle_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subtitle_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The grid item's subtitle.
     * </pre>
     *
     * <code>string subtitle = 4;</code>
     *
     * @return The bytes for subtitle.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSubtitleBytes() {
      java.lang.Object ref = subtitle_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subtitle_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LAYOUT_FIELD_NUMBER = 9;
    private int layout_ = 0;

    /**
     *
     *
     * <pre>
     * The layout to use for the grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.Grid.GridItem.GridItemLayout layout = 9;</code>
     *
     * @return The enum numeric value on the wire for layout.
     */
    @java.lang.Override
    public int getLayoutValue() {
      return layout_;
    }

    /**
     *
     *
     * <pre>
     * The layout to use for the grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.Grid.GridItem.GridItemLayout layout = 9;</code>
     *
     * @return The layout.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Grid.GridItem.GridItemLayout getLayout() {
      com.google.apps.card.v1.Grid.GridItem.GridItemLayout result =
          com.google.apps.card.v1.Grid.GridItem.GridItemLayout.forNumber(layout_);
      return result == null
          ? com.google.apps.card.v1.Grid.GridItem.GridItemLayout.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, id_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getImage());
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(title_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 3, title_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(subtitle_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 4, subtitle_);
      }
      if (layout_
          != com.google.apps.card.v1.Grid.GridItem.GridItemLayout.GRID_ITEM_LAYOUT_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(9, layout_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, id_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getImage());
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(title_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(3, title_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(subtitle_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(4, subtitle_);
      }
      if (layout_
          != com.google.apps.card.v1.Grid.GridItem.GridItemLayout.GRID_ITEM_LAYOUT_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, layout_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.apps.card.v1.Grid.GridItem)) {
        return super.equals(obj);
      }
      com.google.apps.card.v1.Grid.GridItem other = (com.google.apps.card.v1.Grid.GridItem) obj;

      if (!getId().equals(other.getId())) return false;
      if (hasImage() != other.hasImage()) return false;
      if (hasImage()) {
        if (!getImage().equals(other.getImage())) return false;
      }
      if (!getTitle().equals(other.getTitle())) return false;
      if (!getSubtitle().equals(other.getSubtitle())) return false;
      if (layout_ != other.layout_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      if (hasImage()) {
        hash = (37 * hash) + IMAGE_FIELD_NUMBER;
        hash = (53 * hash) + getImage().hashCode();
      }
      hash = (37 * hash) + TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getTitle().hashCode();
      hash = (37 * hash) + SUBTITLE_FIELD_NUMBER;
      hash = (53 * hash) + getSubtitle().hashCode();
      hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
      hash = (53 * hash) + layout_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.apps.card.v1.Grid.GridItem parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Grid.GridItem parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Grid.GridItem parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Grid.GridItem parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Grid.GridItem parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Grid.GridItem parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Grid.GridItem parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Grid.GridItem parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Grid.GridItem parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Grid.GridItem parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Grid.GridItem parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Grid.GridItem parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.apps.card.v1.Grid.GridItem prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents an item in a grid layout. Items can contain text, an image, or
     * both text and an image.
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * Protobuf type {@code google.apps.card.v1.Grid.GridItem}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Grid.GridItem)
        com.google.apps.card.v1.Grid.GridItemOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Grid_GridItem_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Grid_GridItem_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.apps.card.v1.Grid.GridItem.class,
                com.google.apps.card.v1.Grid.GridItem.Builder.class);
      }

      // Construct using com.google.apps.card.v1.Grid.GridItem.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          internalGetImageFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        image_ = null;
        if (imageBuilder_ != null) {
          imageBuilder_.dispose();
          imageBuilder_ = null;
        }
        title_ = "";
        subtitle_ = "";
        layout_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Grid_GridItem_descriptor;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Grid.GridItem getDefaultInstanceForType() {
        return com.google.apps.card.v1.Grid.GridItem.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.apps.card.v1.Grid.GridItem build() {
        com.google.apps.card.v1.Grid.GridItem result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Grid.GridItem buildPartial() {
        com.google.apps.card.v1.Grid.GridItem result =
            new com.google.apps.card.v1.Grid.GridItem(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.apps.card.v1.Grid.GridItem result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.image_ = imageBuilder_ == null ? image_ : imageBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.title_ = title_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.subtitle_ = subtitle_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.layout_ = layout_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.apps.card.v1.Grid.GridItem) {
          return mergeFrom((com.google.apps.card.v1.Grid.GridItem) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.apps.card.v1.Grid.GridItem other) {
        if (other == com.google.apps.card.v1.Grid.GridItem.getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasImage()) {
          mergeImage(other.getImage());
        }
        if (!other.getTitle().isEmpty()) {
          title_ = other.title_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getSubtitle().isEmpty()) {
          subtitle_ = other.subtitle_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.layout_ != 0) {
          setLayoutValue(other.getLayoutValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(internalGetImageFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  title_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  subtitle_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 72:
                {
                  layout_ = input.readEnum();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 72
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";

      /**
       *
       *
       * <pre>
       * A user-specified identifier for this grid item. This identifier is
       * returned in the parent grid's `onClick` callback parameters.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * A user-specified identifier for this grid item. This identifier is
       * returned in the parent grid's `onClick` callback parameters.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * A user-specified identifier for this grid item. This identifier is
       * returned in the parent grid's `onClick` callback parameters.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A user-specified identifier for this grid item. This identifier is
       * returned in the parent grid's `onClick` callback parameters.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A user-specified identifier for this grid item. This identifier is
       * returned in the parent grid's `onClick` callback parameters.
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.apps.card.v1.ImageComponent image_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.ImageComponent,
              com.google.apps.card.v1.ImageComponent.Builder,
              com.google.apps.card.v1.ImageComponentOrBuilder>
          imageBuilder_;

      /**
       *
       *
       * <pre>
       * The image that displays in the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
       *
       * @return Whether the image field is set.
       */
      public boolean hasImage() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * The image that displays in the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
       *
       * @return The image.
       */
      public com.google.apps.card.v1.ImageComponent getImage() {
        if (imageBuilder_ == null) {
          return image_ == null
              ? com.google.apps.card.v1.ImageComponent.getDefaultInstance()
              : image_;
        } else {
          return imageBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The image that displays in the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
       */
      public Builder setImage(com.google.apps.card.v1.ImageComponent value) {
        if (imageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          image_ = value;
        } else {
          imageBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The image that displays in the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
       */
      public Builder setImage(com.google.apps.card.v1.ImageComponent.Builder builderForValue) {
        if (imageBuilder_ == null) {
          image_ = builderForValue.build();
        } else {
          imageBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The image that displays in the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
       */
      public Builder mergeImage(com.google.apps.card.v1.ImageComponent value) {
        if (imageBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && image_ != null
              && image_ != com.google.apps.card.v1.ImageComponent.getDefaultInstance()) {
            getImageBuilder().mergeFrom(value);
          } else {
            image_ = value;
          }
        } else {
          imageBuilder_.mergeFrom(value);
        }
        if (image_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The image that displays in the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
       */
      public Builder clearImage() {
        bitField0_ = (bitField0_ & ~0x00000002);
        image_ = null;
        if (imageBuilder_ != null) {
          imageBuilder_.dispose();
          imageBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The image that displays in the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
       */
      public com.google.apps.card.v1.ImageComponent.Builder getImageBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return internalGetImageFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The image that displays in the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
       */
      public com.google.apps.card.v1.ImageComponentOrBuilder getImageOrBuilder() {
        if (imageBuilder_ != null) {
          return imageBuilder_.getMessageOrBuilder();
        } else {
          return image_ == null
              ? com.google.apps.card.v1.ImageComponent.getDefaultInstance()
              : image_;
        }
      }

      /**
       *
       *
       * <pre>
       * The image that displays in the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.ImageComponent image = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.ImageComponent,
              com.google.apps.card.v1.ImageComponent.Builder,
              com.google.apps.card.v1.ImageComponentOrBuilder>
          internalGetImageFieldBuilder() {
        if (imageBuilder_ == null) {
          imageBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.apps.card.v1.ImageComponent,
                  com.google.apps.card.v1.ImageComponent.Builder,
                  com.google.apps.card.v1.ImageComponentOrBuilder>(
                  getImage(), getParentForChildren(), isClean());
          image_ = null;
        }
        return imageBuilder_;
      }

      private java.lang.Object title_ = "";

      /**
       *
       *
       * <pre>
       * The grid item's title.
       * </pre>
       *
       * <code>string title = 3;</code>
       *
       * @return The title.
       */
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The grid item's title.
       * </pre>
       *
       * <code>string title = 3;</code>
       *
       * @return The bytes for title.
       */
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The grid item's title.
       * </pre>
       *
       * <code>string title = 3;</code>
       *
       * @param value The title to set.
       * @return This builder for chaining.
       */
      public Builder setTitle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        title_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The grid item's title.
       * </pre>
       *
       * <code>string title = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTitle() {
        title_ = getDefaultInstance().getTitle();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The grid item's title.
       * </pre>
       *
       * <code>string title = 3;</code>
       *
       * @param value The bytes for title to set.
       * @return This builder for chaining.
       */
      public Builder setTitleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        title_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object subtitle_ = "";

      /**
       *
       *
       * <pre>
       * The grid item's subtitle.
       * </pre>
       *
       * <code>string subtitle = 4;</code>
       *
       * @return The subtitle.
       */
      public java.lang.String getSubtitle() {
        java.lang.Object ref = subtitle_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subtitle_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The grid item's subtitle.
       * </pre>
       *
       * <code>string subtitle = 4;</code>
       *
       * @return The bytes for subtitle.
       */
      public com.google.protobuf.ByteString getSubtitleBytes() {
        java.lang.Object ref = subtitle_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          subtitle_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The grid item's subtitle.
       * </pre>
       *
       * <code>string subtitle = 4;</code>
       *
       * @param value The subtitle to set.
       * @return This builder for chaining.
       */
      public Builder setSubtitle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        subtitle_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The grid item's subtitle.
       * </pre>
       *
       * <code>string subtitle = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSubtitle() {
        subtitle_ = getDefaultInstance().getSubtitle();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The grid item's subtitle.
       * </pre>
       *
       * <code>string subtitle = 4;</code>
       *
       * @param value The bytes for subtitle to set.
       * @return This builder for chaining.
       */
      public Builder setSubtitleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        subtitle_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private int layout_ = 0;

      /**
       *
       *
       * <pre>
       * The layout to use for the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.Grid.GridItem.GridItemLayout layout = 9;</code>
       *
       * @return The enum numeric value on the wire for layout.
       */
      @java.lang.Override
      public int getLayoutValue() {
        return layout_;
      }

      /**
       *
       *
       * <pre>
       * The layout to use for the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.Grid.GridItem.GridItemLayout layout = 9;</code>
       *
       * @param value The enum numeric value on the wire for layout to set.
       * @return This builder for chaining.
       */
      public Builder setLayoutValue(int value) {
        layout_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The layout to use for the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.Grid.GridItem.GridItemLayout layout = 9;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.apps.card.v1.Grid.GridItem.GridItemLayout getLayout() {
        com.google.apps.card.v1.Grid.GridItem.GridItemLayout result =
            com.google.apps.card.v1.Grid.GridItem.GridItemLayout.forNumber(layout_);
        return result == null
            ? com.google.apps.card.v1.Grid.GridItem.GridItemLayout.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The layout to use for the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.Grid.GridItem.GridItemLayout layout = 9;</code>
       *
       * @param value The layout to set.
       * @return This builder for chaining.
       */
      public Builder setLayout(com.google.apps.card.v1.Grid.GridItem.GridItemLayout value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        layout_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The layout to use for the grid item.
       * </pre>
       *
       * <code>.google.apps.card.v1.Grid.GridItem.GridItemLayout layout = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLayout() {
        bitField0_ = (bitField0_ & ~0x00000010);
        layout_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Grid.GridItem)
    }

    // @@protoc_insertion_point(class_scope:google.apps.card.v1.Grid.GridItem)
    private static final com.google.apps.card.v1.Grid.GridItem DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.apps.card.v1.Grid.GridItem();
    }

    public static com.google.apps.card.v1.Grid.GridItem getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GridItem> PARSER =
        new com.google.protobuf.AbstractParser<GridItem>() {
          @java.lang.Override
          public GridItem parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GridItem> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GridItem> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Grid.GridItem getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int TITLE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object title_ = "";

  /**
   *
   *
   * <pre>
   * The text that displays in the grid header.
   * </pre>
   *
   * <code>string title = 1;</code>
   *
   * @return The title.
   */
  @java.lang.Override
  public java.lang.String getTitle() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      title_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The text that displays in the grid header.
   * </pre>
   *
   * <code>string title = 1;</code>
   *
   * @return The bytes for title.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTitleBytes() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      title_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ITEMS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.apps.card.v1.Grid.GridItem> items_;

  /**
   *
   *
   * <pre>
   * The items to display in the grid.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.apps.card.v1.Grid.GridItem> getItemsList() {
    return items_;
  }

  /**
   *
   *
   * <pre>
   * The items to display in the grid.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.apps.card.v1.Grid.GridItemOrBuilder>
      getItemsOrBuilderList() {
    return items_;
  }

  /**
   *
   *
   * <pre>
   * The items to display in the grid.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
   */
  @java.lang.Override
  public int getItemsCount() {
    return items_.size();
  }

  /**
   *
   *
   * <pre>
   * The items to display in the grid.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Grid.GridItem getItems(int index) {
    return items_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The items to display in the grid.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Grid.GridItemOrBuilder getItemsOrBuilder(int index) {
    return items_.get(index);
  }

  public static final int BORDER_STYLE_FIELD_NUMBER = 3;
  private com.google.apps.card.v1.BorderStyle borderStyle_;

  /**
   *
   *
   * <pre>
   * The border style to apply to each grid item.
   * </pre>
   *
   * <code>.google.apps.card.v1.BorderStyle border_style = 3;</code>
   *
   * @return Whether the borderStyle field is set.
   */
  @java.lang.Override
  public boolean hasBorderStyle() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The border style to apply to each grid item.
   * </pre>
   *
   * <code>.google.apps.card.v1.BorderStyle border_style = 3;</code>
   *
   * @return The borderStyle.
   */
  @java.lang.Override
  public com.google.apps.card.v1.BorderStyle getBorderStyle() {
    return borderStyle_ == null
        ? com.google.apps.card.v1.BorderStyle.getDefaultInstance()
        : borderStyle_;
  }

  /**
   *
   *
   * <pre>
   * The border style to apply to each grid item.
   * </pre>
   *
   * <code>.google.apps.card.v1.BorderStyle border_style = 3;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.BorderStyleOrBuilder getBorderStyleOrBuilder() {
    return borderStyle_ == null
        ? com.google.apps.card.v1.BorderStyle.getDefaultInstance()
        : borderStyle_;
  }

  public static final int COLUMN_COUNT_FIELD_NUMBER = 4;
  private int columnCount_ = 0;

  /**
   *
   *
   * <pre>
   * The number of columns to display in the grid. A default value
   * is used if this field isn't specified, and that default value is
   * different depending on where the grid is shown (dialog versus companion).
   * </pre>
   *
   * <code>int32 column_count = 4;</code>
   *
   * @return The columnCount.
   */
  @java.lang.Override
  public int getColumnCount() {
    return columnCount_;
  }

  public static final int ON_CLICK_FIELD_NUMBER = 5;
  private com.google.apps.card.v1.OnClick onClick_;

  /**
   *
   *
   * <pre>
   * This callback is reused by each individual grid item, but with the
   * item's identifier and index in the items list added to the callback's
   * parameters.
   * </pre>
   *
   * <code>.google.apps.card.v1.OnClick on_click = 5;</code>
   *
   * @return Whether the onClick field is set.
   */
  @java.lang.Override
  public boolean hasOnClick() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * This callback is reused by each individual grid item, but with the
   * item's identifier and index in the items list added to the callback's
   * parameters.
   * </pre>
   *
   * <code>.google.apps.card.v1.OnClick on_click = 5;</code>
   *
   * @return The onClick.
   */
  @java.lang.Override
  public com.google.apps.card.v1.OnClick getOnClick() {
    return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
  }

  /**
   *
   *
   * <pre>
   * This callback is reused by each individual grid item, but with the
   * item's identifier and index in the items list added to the callback's
   * parameters.
   * </pre>
   *
   * <code>.google.apps.card.v1.OnClick on_click = 5;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.OnClickOrBuilder getOnClickOrBuilder() {
    return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(title_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, title_);
    }
    for (int i = 0; i < items_.size(); i++) {
      output.writeMessage(2, items_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getBorderStyle());
    }
    if (columnCount_ != 0) {
      output.writeInt32(4, columnCount_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getOnClick());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(title_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, title_);
    }
    for (int i = 0; i < items_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBorderStyle());
    }
    if (columnCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, columnCount_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getOnClick());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.Grid)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.Grid other = (com.google.apps.card.v1.Grid) obj;

    if (!getTitle().equals(other.getTitle())) return false;
    if (!getItemsList().equals(other.getItemsList())) return false;
    if (hasBorderStyle() != other.hasBorderStyle()) return false;
    if (hasBorderStyle()) {
      if (!getBorderStyle().equals(other.getBorderStyle())) return false;
    }
    if (getColumnCount() != other.getColumnCount()) return false;
    if (hasOnClick() != other.hasOnClick()) return false;
    if (hasOnClick()) {
      if (!getOnClick().equals(other.getOnClick())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TITLE_FIELD_NUMBER;
    hash = (53 * hash) + getTitle().hashCode();
    if (getItemsCount() > 0) {
      hash = (37 * hash) + ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + getItemsList().hashCode();
    }
    if (hasBorderStyle()) {
      hash = (37 * hash) + BORDER_STYLE_FIELD_NUMBER;
      hash = (53 * hash) + getBorderStyle().hashCode();
    }
    hash = (37 * hash) + COLUMN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getColumnCount();
    if (hasOnClick()) {
      hash = (37 * hash) + ON_CLICK_FIELD_NUMBER;
      hash = (53 * hash) + getOnClick().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.Grid parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Grid parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Grid parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Grid parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Grid parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Grid parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Grid parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Grid parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Grid parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Grid parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Grid parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Grid parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.Grid prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Displays a grid with a collection of items. Items can only include text or
   * images. For responsive columns, or to include more than text or images, use
   * [`Columns`][google.apps.card.v1.Columns]. For an example in Google Chat apps,
   * see [Display a Grid with a collection of
   * items](https://developers.google.com/workspace/chat/format-structure-card-dialog#display_a_grid_with_a_collection_of_items).
   *
   * A grid supports any number of columns and items. The number of rows is
   * determined by items divided by columns. A grid with
   * 10 items and 2 columns has 5 rows. A grid with 11 items and 2 columns
   * has 6 rows.
   *
   * [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   *
   * For example, the following JSON creates a 2 column grid with a single
   * item:
   *
   * ```
   * "grid": {
   * "title": "A fine collection of items",
   * "columnCount": 2,
   * "borderStyle": {
   * "type": "STROKE",
   * "cornerRadius": 4
   * },
   * "items": [
   * {
   * "image": {
   * "imageUri": "https://www.example.com/image.png",
   * "cropStyle": {
   * "type": "SQUARE"
   * },
   * "borderStyle": {
   * "type": "STROKE"
   * }
   * },
   * "title": "An item",
   * "textAlignment": "CENTER"
   * }
   * ],
   * "onClick": {
   * "openLink": {
   * "url": "https://www.example.com"
   * }
   * }
   * }
   * ```
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Grid}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Grid)
      com.google.apps.card.v1.GridOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Grid_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Grid_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Grid.class, com.google.apps.card.v1.Grid.Builder.class);
    }

    // Construct using com.google.apps.card.v1.Grid.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        internalGetItemsFieldBuilder();
        internalGetBorderStyleFieldBuilder();
        internalGetOnClickFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      title_ = "";
      if (itemsBuilder_ == null) {
        items_ = java.util.Collections.emptyList();
      } else {
        items_ = null;
        itemsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      borderStyle_ = null;
      if (borderStyleBuilder_ != null) {
        borderStyleBuilder_.dispose();
        borderStyleBuilder_ = null;
      }
      columnCount_ = 0;
      onClick_ = null;
      if (onClickBuilder_ != null) {
        onClickBuilder_.dispose();
        onClickBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Grid_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Grid getDefaultInstanceForType() {
      return com.google.apps.card.v1.Grid.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.Grid build() {
      com.google.apps.card.v1.Grid result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Grid buildPartial() {
      com.google.apps.card.v1.Grid result = new com.google.apps.card.v1.Grid(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.apps.card.v1.Grid result) {
      if (itemsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          items_ = java.util.Collections.unmodifiableList(items_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.items_ = items_;
      } else {
        result.items_ = itemsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.apps.card.v1.Grid result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.title_ = title_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.borderStyle_ =
            borderStyleBuilder_ == null ? borderStyle_ : borderStyleBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.columnCount_ = columnCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.onClick_ = onClickBuilder_ == null ? onClick_ : onClickBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.Grid) {
        return mergeFrom((com.google.apps.card.v1.Grid) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.Grid other) {
      if (other == com.google.apps.card.v1.Grid.getDefaultInstance()) return this;
      if (!other.getTitle().isEmpty()) {
        title_ = other.title_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (itemsBuilder_ == null) {
        if (!other.items_.isEmpty()) {
          if (items_.isEmpty()) {
            items_ = other.items_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureItemsIsMutable();
            items_.addAll(other.items_);
          }
          onChanged();
        }
      } else {
        if (!other.items_.isEmpty()) {
          if (itemsBuilder_.isEmpty()) {
            itemsBuilder_.dispose();
            itemsBuilder_ = null;
            items_ = other.items_;
            bitField0_ = (bitField0_ & ~0x00000002);
            itemsBuilder_ =
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders
                    ? internalGetItemsFieldBuilder()
                    : null;
          } else {
            itemsBuilder_.addAllMessages(other.items_);
          }
        }
      }
      if (other.hasBorderStyle()) {
        mergeBorderStyle(other.getBorderStyle());
      }
      if (other.getColumnCount() != 0) {
        setColumnCount(other.getColumnCount());
      }
      if (other.hasOnClick()) {
        mergeOnClick(other.getOnClick());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                title_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.apps.card.v1.Grid.GridItem m =
                    input.readMessage(
                        com.google.apps.card.v1.Grid.GridItem.parser(), extensionRegistry);
                if (itemsBuilder_ == null) {
                  ensureItemsIsMutable();
                  items_.add(m);
                } else {
                  itemsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    internalGetBorderStyleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                columnCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(internalGetOnClickFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object title_ = "";

    /**
     *
     *
     * <pre>
     * The text that displays in the grid header.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The title.
     */
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The text that displays in the grid header.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The bytes for title.
     */
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The text that displays in the grid header.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @param value The title to set.
     * @return This builder for chaining.
     */
    public Builder setTitle(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      title_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The text that displays in the grid header.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTitle() {
      title_ = getDefaultInstance().getTitle();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The text that displays in the grid header.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @param value The bytes for title to set.
     * @return This builder for chaining.
     */
    public Builder setTitleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      title_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.apps.card.v1.Grid.GridItem> items_ =
        java.util.Collections.emptyList();

    private void ensureItemsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        items_ = new java.util.ArrayList<com.google.apps.card.v1.Grid.GridItem>(items_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
            com.google.apps.card.v1.Grid.GridItem,
            com.google.apps.card.v1.Grid.GridItem.Builder,
            com.google.apps.card.v1.Grid.GridItemOrBuilder>
        itemsBuilder_;

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public java.util.List<com.google.apps.card.v1.Grid.GridItem> getItemsList() {
      if (itemsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(items_);
      } else {
        return itemsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public int getItemsCount() {
      if (itemsBuilder_ == null) {
        return items_.size();
      } else {
        return itemsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public com.google.apps.card.v1.Grid.GridItem getItems(int index) {
      if (itemsBuilder_ == null) {
        return items_.get(index);
      } else {
        return itemsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public Builder setItems(int index, com.google.apps.card.v1.Grid.GridItem value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.set(index, value);
        onChanged();
      } else {
        itemsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public Builder setItems(
        int index, com.google.apps.card.v1.Grid.GridItem.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.set(index, builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public Builder addItems(com.google.apps.card.v1.Grid.GridItem value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.add(value);
        onChanged();
      } else {
        itemsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public Builder addItems(int index, com.google.apps.card.v1.Grid.GridItem value) {
      if (itemsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureItemsIsMutable();
        items_.add(index, value);
        onChanged();
      } else {
        itemsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public Builder addItems(com.google.apps.card.v1.Grid.GridItem.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.add(builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public Builder addItems(
        int index, com.google.apps.card.v1.Grid.GridItem.Builder builderForValue) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.add(index, builderForValue.build());
        onChanged();
      } else {
        itemsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public Builder addAllItems(
        java.lang.Iterable<? extends com.google.apps.card.v1.Grid.GridItem> values) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
        onChanged();
      } else {
        itemsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public Builder clearItems() {
      if (itemsBuilder_ == null) {
        items_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        itemsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public Builder removeItems(int index) {
      if (itemsBuilder_ == null) {
        ensureItemsIsMutable();
        items_.remove(index);
        onChanged();
      } else {
        itemsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public com.google.apps.card.v1.Grid.GridItem.Builder getItemsBuilder(int index) {
      return internalGetItemsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public com.google.apps.card.v1.Grid.GridItemOrBuilder getItemsOrBuilder(int index) {
      if (itemsBuilder_ == null) {
        return items_.get(index);
      } else {
        return itemsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public java.util.List<? extends com.google.apps.card.v1.Grid.GridItemOrBuilder>
        getItemsOrBuilderList() {
      if (itemsBuilder_ != null) {
        return itemsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(items_);
      }
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public com.google.apps.card.v1.Grid.GridItem.Builder addItemsBuilder() {
      return internalGetItemsFieldBuilder()
          .addBuilder(com.google.apps.card.v1.Grid.GridItem.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public com.google.apps.card.v1.Grid.GridItem.Builder addItemsBuilder(int index) {
      return internalGetItemsFieldBuilder()
          .addBuilder(index, com.google.apps.card.v1.Grid.GridItem.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The items to display in the grid.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Grid.GridItem items = 2;</code>
     */
    public java.util.List<com.google.apps.card.v1.Grid.GridItem.Builder> getItemsBuilderList() {
      return internalGetItemsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilder<
            com.google.apps.card.v1.Grid.GridItem,
            com.google.apps.card.v1.Grid.GridItem.Builder,
            com.google.apps.card.v1.Grid.GridItemOrBuilder>
        internalGetItemsFieldBuilder() {
      if (itemsBuilder_ == null) {
        itemsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilder<
                com.google.apps.card.v1.Grid.GridItem,
                com.google.apps.card.v1.Grid.GridItem.Builder,
                com.google.apps.card.v1.Grid.GridItemOrBuilder>(
                items_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        items_ = null;
      }
      return itemsBuilder_;
    }

    private com.google.apps.card.v1.BorderStyle borderStyle_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.apps.card.v1.BorderStyle,
            com.google.apps.card.v1.BorderStyle.Builder,
            com.google.apps.card.v1.BorderStyleOrBuilder>
        borderStyleBuilder_;

    /**
     *
     *
     * <pre>
     * The border style to apply to each grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.BorderStyle border_style = 3;</code>
     *
     * @return Whether the borderStyle field is set.
     */
    public boolean hasBorderStyle() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The border style to apply to each grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.BorderStyle border_style = 3;</code>
     *
     * @return The borderStyle.
     */
    public com.google.apps.card.v1.BorderStyle getBorderStyle() {
      if (borderStyleBuilder_ == null) {
        return borderStyle_ == null
            ? com.google.apps.card.v1.BorderStyle.getDefaultInstance()
            : borderStyle_;
      } else {
        return borderStyleBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The border style to apply to each grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.BorderStyle border_style = 3;</code>
     */
    public Builder setBorderStyle(com.google.apps.card.v1.BorderStyle value) {
      if (borderStyleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        borderStyle_ = value;
      } else {
        borderStyleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The border style to apply to each grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.BorderStyle border_style = 3;</code>
     */
    public Builder setBorderStyle(com.google.apps.card.v1.BorderStyle.Builder builderForValue) {
      if (borderStyleBuilder_ == null) {
        borderStyle_ = builderForValue.build();
      } else {
        borderStyleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The border style to apply to each grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.BorderStyle border_style = 3;</code>
     */
    public Builder mergeBorderStyle(com.google.apps.card.v1.BorderStyle value) {
      if (borderStyleBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && borderStyle_ != null
            && borderStyle_ != com.google.apps.card.v1.BorderStyle.getDefaultInstance()) {
          getBorderStyleBuilder().mergeFrom(value);
        } else {
          borderStyle_ = value;
        }
      } else {
        borderStyleBuilder_.mergeFrom(value);
      }
      if (borderStyle_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The border style to apply to each grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.BorderStyle border_style = 3;</code>
     */
    public Builder clearBorderStyle() {
      bitField0_ = (bitField0_ & ~0x00000004);
      borderStyle_ = null;
      if (borderStyleBuilder_ != null) {
        borderStyleBuilder_.dispose();
        borderStyleBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The border style to apply to each grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.BorderStyle border_style = 3;</code>
     */
    public com.google.apps.card.v1.BorderStyle.Builder getBorderStyleBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return internalGetBorderStyleFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The border style to apply to each grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.BorderStyle border_style = 3;</code>
     */
    public com.google.apps.card.v1.BorderStyleOrBuilder getBorderStyleOrBuilder() {
      if (borderStyleBuilder_ != null) {
        return borderStyleBuilder_.getMessageOrBuilder();
      } else {
        return borderStyle_ == null
            ? com.google.apps.card.v1.BorderStyle.getDefaultInstance()
            : borderStyle_;
      }
    }

    /**
     *
     *
     * <pre>
     * The border style to apply to each grid item.
     * </pre>
     *
     * <code>.google.apps.card.v1.BorderStyle border_style = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.apps.card.v1.BorderStyle,
            com.google.apps.card.v1.BorderStyle.Builder,
            com.google.apps.card.v1.BorderStyleOrBuilder>
        internalGetBorderStyleFieldBuilder() {
      if (borderStyleBuilder_ == null) {
        borderStyleBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.apps.card.v1.BorderStyle,
                com.google.apps.card.v1.BorderStyle.Builder,
                com.google.apps.card.v1.BorderStyleOrBuilder>(
                getBorderStyle(), getParentForChildren(), isClean());
        borderStyle_ = null;
      }
      return borderStyleBuilder_;
    }

    private int columnCount_;

    /**
     *
     *
     * <pre>
     * The number of columns to display in the grid. A default value
     * is used if this field isn't specified, and that default value is
     * different depending on where the grid is shown (dialog versus companion).
     * </pre>
     *
     * <code>int32 column_count = 4;</code>
     *
     * @return The columnCount.
     */
    @java.lang.Override
    public int getColumnCount() {
      return columnCount_;
    }

    /**
     *
     *
     * <pre>
     * The number of columns to display in the grid. A default value
     * is used if this field isn't specified, and that default value is
     * different depending on where the grid is shown (dialog versus companion).
     * </pre>
     *
     * <code>int32 column_count = 4;</code>
     *
     * @param value The columnCount to set.
     * @return This builder for chaining.
     */
    public Builder setColumnCount(int value) {

      columnCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of columns to display in the grid. A default value
     * is used if this field isn't specified, and that default value is
     * different depending on where the grid is shown (dialog versus companion).
     * </pre>
     *
     * <code>int32 column_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColumnCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      columnCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.apps.card.v1.OnClick onClick_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.apps.card.v1.OnClick,
            com.google.apps.card.v1.OnClick.Builder,
            com.google.apps.card.v1.OnClickOrBuilder>
        onClickBuilder_;

    /**
     *
     *
     * <pre>
     * This callback is reused by each individual grid item, but with the
     * item's identifier and index in the items list added to the callback's
     * parameters.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 5;</code>
     *
     * @return Whether the onClick field is set.
     */
    public boolean hasOnClick() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * This callback is reused by each individual grid item, but with the
     * item's identifier and index in the items list added to the callback's
     * parameters.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 5;</code>
     *
     * @return The onClick.
     */
    public com.google.apps.card.v1.OnClick getOnClick() {
      if (onClickBuilder_ == null) {
        return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
      } else {
        return onClickBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * This callback is reused by each individual grid item, but with the
     * item's identifier and index in the items list added to the callback's
     * parameters.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 5;</code>
     */
    public Builder setOnClick(com.google.apps.card.v1.OnClick value) {
      if (onClickBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        onClick_ = value;
      } else {
        onClickBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This callback is reused by each individual grid item, but with the
     * item's identifier and index in the items list added to the callback's
     * parameters.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 5;</code>
     */
    public Builder setOnClick(com.google.apps.card.v1.OnClick.Builder builderForValue) {
      if (onClickBuilder_ == null) {
        onClick_ = builderForValue.build();
      } else {
        onClickBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This callback is reused by each individual grid item, but with the
     * item's identifier and index in the items list added to the callback's
     * parameters.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 5;</code>
     */
    public Builder mergeOnClick(com.google.apps.card.v1.OnClick value) {
      if (onClickBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && onClick_ != null
            && onClick_ != com.google.apps.card.v1.OnClick.getDefaultInstance()) {
          getOnClickBuilder().mergeFrom(value);
        } else {
          onClick_ = value;
        }
      } else {
        onClickBuilder_.mergeFrom(value);
      }
      if (onClick_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * This callback is reused by each individual grid item, but with the
     * item's identifier and index in the items list added to the callback's
     * parameters.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 5;</code>
     */
    public Builder clearOnClick() {
      bitField0_ = (bitField0_ & ~0x00000010);
      onClick_ = null;
      if (onClickBuilder_ != null) {
        onClickBuilder_.dispose();
        onClickBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This callback is reused by each individual grid item, but with the
     * item's identifier and index in the items list added to the callback's
     * parameters.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 5;</code>
     */
    public com.google.apps.card.v1.OnClick.Builder getOnClickBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return internalGetOnClickFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * This callback is reused by each individual grid item, but with the
     * item's identifier and index in the items list added to the callback's
     * parameters.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 5;</code>
     */
    public com.google.apps.card.v1.OnClickOrBuilder getOnClickOrBuilder() {
      if (onClickBuilder_ != null) {
        return onClickBuilder_.getMessageOrBuilder();
      } else {
        return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
      }
    }

    /**
     *
     *
     * <pre>
     * This callback is reused by each individual grid item, but with the
     * item's identifier and index in the items list added to the callback's
     * parameters.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.apps.card.v1.OnClick,
            com.google.apps.card.v1.OnClick.Builder,
            com.google.apps.card.v1.OnClickOrBuilder>
        internalGetOnClickFieldBuilder() {
      if (onClickBuilder_ == null) {
        onClickBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.apps.card.v1.OnClick,
                com.google.apps.card.v1.OnClick.Builder,
                com.google.apps.card.v1.OnClickOrBuilder>(
                getOnClick(), getParentForChildren(), isClean());
        onClick_ = null;
      }
      return onClickBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Grid)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.Grid)
  private static final com.google.apps.card.v1.Grid DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.Grid();
  }

  public static com.google.apps.card.v1.Grid getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Grid> PARSER =
      new com.google.protobuf.AbstractParser<Grid>() {
        @java.lang.Override
        public Grid parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Grid> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Grid> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.Grid getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
