/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/apps/card/v1/card.proto
// Protobuf Java Version: 4.33.2

package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * A card interface displayed in a Google Chat message or Google Workspace
 * add-on.
 *
 * Cards support a defined layout, interactive UI elements like buttons, and
 * rich media like images. Use cards to present detailed information,
 * gather information from users, and guide users to take a next step.
 *
 * [Card builder](https://addons.gsuite.google.com/uikit/builder)
 *
 * To learn how
 * to build cards, see the following documentation:
 *
 * * For Google Chat apps, see [Design the components of a card or
 * dialog](https://developers.google.com/workspace/chat/design-components-card-dialog).
 * * For Google Workspace add-ons, see [Card-based
 * interfaces](https://developers.google.com/apps-script/add-ons/concepts/cards).
 *
 * Note: You can add up to 100 widgets per card. Any widgets beyond this
 * limit are ignored. This limit applies to both card messages and dialogs
 * in Google Chat apps, and to cards in Google Workspace add-ons.
 *
 * **Example: Card message for a Google Chat app**
 *
 * ![Example contact
 * card](https://developers.google.com/workspace/chat/images/card_api_reference.png)
 *
 * To create the sample card message in Google Chat, use the following JSON:
 *
 * ```
 * {
 * "cardsV2": [
 * {
 * "cardId": "unique-card-id",
 * "card": {
 * "header": {
 * "title": "Sasha",
 * "subtitle": "Software Engineer",
 * "imageUrl":
 * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
 * "imageType": "CIRCLE",
 * "imageAltText": "Avatar for Sasha"
 * },
 * "sections": [
 * {
 * "header": "Contact Info",
 * "collapsible": true,
 * "uncollapsibleWidgetsCount": 1,
 * "widgets": [
 * {
 * "decoratedText": {
 * "startIcon": {
 * "knownIcon": "EMAIL"
 * },
 * "text": "sasha&#64;example.com"
 * }
 * },
 * {
 * "decoratedText": {
 * "startIcon": {
 * "knownIcon": "PERSON"
 * },
 * "text": "&lt;font color=&#92;"#80e27e&#92;"&gt;Online&lt;/font&gt;"
 * }
 * },
 * {
 * "decoratedText": {
 * "startIcon": {
 * "knownIcon": "PHONE"
 * },
 * "text": "+1 (555) 555-1234"
 * }
 * },
 * {
 * "buttonList": {
 * "buttons": [
 * {
 * "text": "Share",
 * "onClick": {
 * "openLink": {
 * "url": "https://example.com/share"
 * }
 * }
 * },
 * {
 * "text": "Edit",
 * "onClick": {
 * "action": {
 * "function": "goToView",
 * "parameters": [
 * {
 * "key": "viewType",
 * "value": "EDIT"
 * }
 * ]
 * }
 * }
 * }
 * ]
 * }
 * }
 * ]
 * }
 * ]
 * }
 * }
 * ]
 * }
 * ```
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.Card}
 */
@com.google.protobuf.Generated
public final class Card extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.Card)
    CardOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "Card");
  }

  // Use Card.newBuilder() to construct.
  private Card(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private Card() {
    sections_ = java.util.Collections.emptyList();
    sectionDividerStyle_ = 0;
    cardActions_ = java.util.Collections.emptyList();
    name_ = "";
    displayStyle_ = 0;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Card_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_Card_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.Card.class, com.google.apps.card.v1.Card.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The divider style of a card. Currently only used for dividers betweens card
   * sections.
   *
   * [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf enum {@code google.apps.card.v1.Card.DividerStyle}
   */
  public enum DividerStyle implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Don't use. Unspecified.
     * </pre>
     *
     * <code>DIVIDER_STYLE_UNSPECIFIED = 0;</code>
     */
    DIVIDER_STYLE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Default option. Render a solid divider.
     * </pre>
     *
     * <code>SOLID_DIVIDER = 1;</code>
     */
    SOLID_DIVIDER(1),
    /**
     *
     *
     * <pre>
     * If set, no divider is rendered. This style completely removes the divider
     * from the layout. The result is equivalent to not adding a divider at all.
     * </pre>
     *
     * <code>NO_DIVIDER = 2;</code>
     */
    NO_DIVIDER(2),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "DividerStyle");
    }

    /**
     *
     *
     * <pre>
     * Don't use. Unspecified.
     * </pre>
     *
     * <code>DIVIDER_STYLE_UNSPECIFIED = 0;</code>
     */
    public static final int DIVIDER_STYLE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Default option. Render a solid divider.
     * </pre>
     *
     * <code>SOLID_DIVIDER = 1;</code>
     */
    public static final int SOLID_DIVIDER_VALUE = 1;

    /**
     *
     *
     * <pre>
     * If set, no divider is rendered. This style completely removes the divider
     * from the layout. The result is equivalent to not adding a divider at all.
     * </pre>
     *
     * <code>NO_DIVIDER = 2;</code>
     */
    public static final int NO_DIVIDER_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DividerStyle valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DividerStyle forNumber(int value) {
      switch (value) {
        case 0:
          return DIVIDER_STYLE_UNSPECIFIED;
        case 1:
          return SOLID_DIVIDER;
        case 2:
          return NO_DIVIDER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DividerStyle> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DividerStyle> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DividerStyle>() {
          public DividerStyle findValueByNumber(int number) {
            return DividerStyle.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.apps.card.v1.Card.getDescriptor().getEnumTypes().get(0);
    }

    private static final DividerStyle[] VALUES = values();

    public static DividerStyle valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DividerStyle(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.apps.card.v1.Card.DividerStyle)
  }

  /**
   *
   *
   * <pre>
   * In Google Workspace add-ons,
   * determines how a card is displayed.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * Protobuf enum {@code google.apps.card.v1.Card.DisplayStyle}
   */
  public enum DisplayStyle implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Don't use. Unspecified.
     * </pre>
     *
     * <code>DISPLAY_STYLE_UNSPECIFIED = 0;</code>
     */
    DISPLAY_STYLE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The header of the card appears at the bottom of the
     * sidebar, partially covering the current top card of the stack. Clicking
     * the header pops the card into the card stack. If the card has no header,
     * a generated header is used instead.
     * </pre>
     *
     * <code>PEEK = 1;</code>
     */
    PEEK(1),
    /**
     *
     *
     * <pre>
     * Default value. The card is shown by replacing the view of the top card in
     * the card stack.
     * </pre>
     *
     * <code>REPLACE = 2;</code>
     */
    REPLACE(2),
    UNRECOGNIZED(-1),
    ;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "DisplayStyle");
    }

    /**
     *
     *
     * <pre>
     * Don't use. Unspecified.
     * </pre>
     *
     * <code>DISPLAY_STYLE_UNSPECIFIED = 0;</code>
     */
    public static final int DISPLAY_STYLE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The header of the card appears at the bottom of the
     * sidebar, partially covering the current top card of the stack. Clicking
     * the header pops the card into the card stack. If the card has no header,
     * a generated header is used instead.
     * </pre>
     *
     * <code>PEEK = 1;</code>
     */
    public static final int PEEK_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Default value. The card is shown by replacing the view of the top card in
     * the card stack.
     * </pre>
     *
     * <code>REPLACE = 2;</code>
     */
    public static final int REPLACE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DisplayStyle valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DisplayStyle forNumber(int value) {
      switch (value) {
        case 0:
          return DISPLAY_STYLE_UNSPECIFIED;
        case 1:
          return PEEK;
        case 2:
          return REPLACE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DisplayStyle> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DisplayStyle> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DisplayStyle>() {
          public DisplayStyle findValueByNumber(int number) {
            return DisplayStyle.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.apps.card.v1.Card.getDescriptor().getEnumTypes().get(1);
    }

    private static final DisplayStyle[] VALUES = values();

    public static DisplayStyle valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DisplayStyle(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.apps.card.v1.Card.DisplayStyle)
  }

  public interface CardHeaderOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.apps.card.v1.Card.CardHeader)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The title of the card header.
     * The header has a fixed height: if both a
     * title and subtitle are specified, each takes up one line. If only the
     * title is specified, it takes up both lines.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The title.
     */
    java.lang.String getTitle();

    /**
     *
     *
     * <pre>
     * Required. The title of the card header.
     * The header has a fixed height: if both a
     * title and subtitle are specified, each takes up one line. If only the
     * title is specified, it takes up both lines.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The bytes for title.
     */
    com.google.protobuf.ByteString getTitleBytes();

    /**
     *
     *
     * <pre>
     * The subtitle of the card header. If specified, appears on its own line
     * below the `title`.
     * </pre>
     *
     * <code>string subtitle = 2;</code>
     *
     * @return The subtitle.
     */
    java.lang.String getSubtitle();

    /**
     *
     *
     * <pre>
     * The subtitle of the card header. If specified, appears on its own line
     * below the `title`.
     * </pre>
     *
     * <code>string subtitle = 2;</code>
     *
     * @return The bytes for subtitle.
     */
    com.google.protobuf.ByteString getSubtitleBytes();

    /**
     *
     *
     * <pre>
     * The shape used to crop the image.
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.ImageType image_type = 3;</code>
     *
     * @return The enum numeric value on the wire for imageType.
     */
    int getImageTypeValue();

    /**
     *
     *
     * <pre>
     * The shape used to crop the image.
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.ImageType image_type = 3;</code>
     *
     * @return The imageType.
     */
    com.google.apps.card.v1.Widget.ImageType getImageType();

    /**
     *
     *
     * <pre>
     * The HTTPS URL of the image in the card header.
     * </pre>
     *
     * <code>string image_url = 4;</code>
     *
     * @return The imageUrl.
     */
    java.lang.String getImageUrl();

    /**
     *
     *
     * <pre>
     * The HTTPS URL of the image in the card header.
     * </pre>
     *
     * <code>string image_url = 4;</code>
     *
     * @return The bytes for imageUrl.
     */
    com.google.protobuf.ByteString getImageUrlBytes();

    /**
     *
     *
     * <pre>
     * The alternative text of this image that's used for accessibility.
     * </pre>
     *
     * <code>string image_alt_text = 5;</code>
     *
     * @return The imageAltText.
     */
    java.lang.String getImageAltText();

    /**
     *
     *
     * <pre>
     * The alternative text of this image that's used for accessibility.
     * </pre>
     *
     * <code>string image_alt_text = 5;</code>
     *
     * @return The bytes for imageAltText.
     */
    com.google.protobuf.ByteString getImageAltTextBytes();
  }

  /**
   *
   *
   * <pre>
   * Represents a card header. For an example in Google Chat apps, see [Add a
   * header](https://developers.google.com/workspace/chat/design-components-card-dialog#add_a_header).
   *
   * [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Card.CardHeader}
   */
  public static final class CardHeader extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.apps.card.v1.Card.CardHeader)
      CardHeaderOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "CardHeader");
    }

    // Use CardHeader.newBuilder() to construct.
    private CardHeader(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private CardHeader() {
      title_ = "";
      subtitle_ = "";
      imageType_ = 0;
      imageUrl_ = "";
      imageAltText_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Card_CardHeader_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Card_CardHeader_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Card.CardHeader.class,
              com.google.apps.card.v1.Card.CardHeader.Builder.class);
    }

    public static final int TITLE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object title_ = "";

    /**
     *
     *
     * <pre>
     * Required. The title of the card header.
     * The header has a fixed height: if both a
     * title and subtitle are specified, each takes up one line. If only the
     * title is specified, it takes up both lines.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The title.
     */
    @java.lang.Override
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The title of the card header.
     * The header has a fixed height: if both a
     * title and subtitle are specified, each takes up one line. If only the
     * title is specified, it takes up both lines.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The bytes for title.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUBTITLE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object subtitle_ = "";

    /**
     *
     *
     * <pre>
     * The subtitle of the card header. If specified, appears on its own line
     * below the `title`.
     * </pre>
     *
     * <code>string subtitle = 2;</code>
     *
     * @return The subtitle.
     */
    @java.lang.Override
    public java.lang.String getSubtitle() {
      java.lang.Object ref = subtitle_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subtitle_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The subtitle of the card header. If specified, appears on its own line
     * below the `title`.
     * </pre>
     *
     * <code>string subtitle = 2;</code>
     *
     * @return The bytes for subtitle.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSubtitleBytes() {
      java.lang.Object ref = subtitle_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subtitle_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IMAGE_TYPE_FIELD_NUMBER = 3;
    private int imageType_ = 0;

    /**
     *
     *
     * <pre>
     * The shape used to crop the image.
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.ImageType image_type = 3;</code>
     *
     * @return The enum numeric value on the wire for imageType.
     */
    @java.lang.Override
    public int getImageTypeValue() {
      return imageType_;
    }

    /**
     *
     *
     * <pre>
     * The shape used to crop the image.
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Widget.ImageType image_type = 3;</code>
     *
     * @return The imageType.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Widget.ImageType getImageType() {
      com.google.apps.card.v1.Widget.ImageType result =
          com.google.apps.card.v1.Widget.ImageType.forNumber(imageType_);
      return result == null ? com.google.apps.card.v1.Widget.ImageType.UNRECOGNIZED : result;
    }

    public static final int IMAGE_URL_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object imageUrl_ = "";

    /**
     *
     *
     * <pre>
     * The HTTPS URL of the image in the card header.
     * </pre>
     *
     * <code>string image_url = 4;</code>
     *
     * @return The imageUrl.
     */
    @java.lang.Override
    public java.lang.String getImageUrl() {
      java.lang.Object ref = imageUrl_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageUrl_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The HTTPS URL of the image in the card header.
     * </pre>
     *
     * <code>string image_url = 4;</code>
     *
     * @return The bytes for imageUrl.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getImageUrlBytes() {
      java.lang.Object ref = imageUrl_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IMAGE_ALT_TEXT_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object imageAltText_ = "";

    /**
     *
     *
     * <pre>
     * The alternative text of this image that's used for accessibility.
     * </pre>
     *
     * <code>string image_alt_text = 5;</code>
     *
     * @return The imageAltText.
     */
    @java.lang.Override
    public java.lang.String getImageAltText() {
      java.lang.Object ref = imageAltText_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageAltText_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The alternative text of this image that's used for accessibility.
     * </pre>
     *
     * <code>string image_alt_text = 5;</code>
     *
     * @return The bytes for imageAltText.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getImageAltTextBytes() {
      java.lang.Object ref = imageAltText_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageAltText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(title_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, title_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(subtitle_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, subtitle_);
      }
      if (imageType_ != com.google.apps.card.v1.Widget.ImageType.SQUARE.getNumber()) {
        output.writeEnum(3, imageType_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(imageUrl_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 4, imageUrl_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(imageAltText_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 5, imageAltText_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(title_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, title_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(subtitle_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(2, subtitle_);
      }
      if (imageType_ != com.google.apps.card.v1.Widget.ImageType.SQUARE.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, imageType_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(imageUrl_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(4, imageUrl_);
      }
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(imageAltText_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(5, imageAltText_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.apps.card.v1.Card.CardHeader)) {
        return super.equals(obj);
      }
      com.google.apps.card.v1.Card.CardHeader other = (com.google.apps.card.v1.Card.CardHeader) obj;

      if (!getTitle().equals(other.getTitle())) return false;
      if (!getSubtitle().equals(other.getSubtitle())) return false;
      if (imageType_ != other.imageType_) return false;
      if (!getImageUrl().equals(other.getImageUrl())) return false;
      if (!getImageAltText().equals(other.getImageAltText())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getTitle().hashCode();
      hash = (37 * hash) + SUBTITLE_FIELD_NUMBER;
      hash = (53 * hash) + getSubtitle().hashCode();
      hash = (37 * hash) + IMAGE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + imageType_;
      hash = (37 * hash) + IMAGE_URL_FIELD_NUMBER;
      hash = (53 * hash) + getImageUrl().hashCode();
      hash = (37 * hash) + IMAGE_ALT_TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getImageAltText().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.apps.card.v1.Card.CardHeader parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.CardHeader parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardHeader parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.CardHeader parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardHeader parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.CardHeader parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardHeader parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.CardHeader parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardHeader parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.CardHeader parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardHeader parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.CardHeader parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.apps.card.v1.Card.CardHeader prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents a card header. For an example in Google Chat apps, see [Add a
     * header](https://developers.google.com/workspace/chat/design-components-card-dialog#add_a_header).
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * Protobuf type {@code google.apps.card.v1.Card.CardHeader}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Card.CardHeader)
        com.google.apps.card.v1.Card.CardHeaderOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_CardHeader_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_CardHeader_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.apps.card.v1.Card.CardHeader.class,
                com.google.apps.card.v1.Card.CardHeader.Builder.class);
      }

      // Construct using com.google.apps.card.v1.Card.CardHeader.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        title_ = "";
        subtitle_ = "";
        imageType_ = 0;
        imageUrl_ = "";
        imageAltText_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_CardHeader_descriptor;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.CardHeader getDefaultInstanceForType() {
        return com.google.apps.card.v1.Card.CardHeader.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.CardHeader build() {
        com.google.apps.card.v1.Card.CardHeader result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.CardHeader buildPartial() {
        com.google.apps.card.v1.Card.CardHeader result =
            new com.google.apps.card.v1.Card.CardHeader(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.apps.card.v1.Card.CardHeader result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.title_ = title_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.subtitle_ = subtitle_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.imageType_ = imageType_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.imageUrl_ = imageUrl_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.imageAltText_ = imageAltText_;
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.apps.card.v1.Card.CardHeader) {
          return mergeFrom((com.google.apps.card.v1.Card.CardHeader) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.apps.card.v1.Card.CardHeader other) {
        if (other == com.google.apps.card.v1.Card.CardHeader.getDefaultInstance()) return this;
        if (!other.getTitle().isEmpty()) {
          title_ = other.title_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getSubtitle().isEmpty()) {
          subtitle_ = other.subtitle_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.imageType_ != 0) {
          setImageTypeValue(other.getImageTypeValue());
        }
        if (!other.getImageUrl().isEmpty()) {
          imageUrl_ = other.imageUrl_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getImageAltText().isEmpty()) {
          imageAltText_ = other.imageAltText_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  title_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  subtitle_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  imageType_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  imageUrl_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  imageAltText_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object title_ = "";

      /**
       *
       *
       * <pre>
       * Required. The title of the card header.
       * The header has a fixed height: if both a
       * title and subtitle are specified, each takes up one line. If only the
       * title is specified, it takes up both lines.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The title.
       */
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The title of the card header.
       * The header has a fixed height: if both a
       * title and subtitle are specified, each takes up one line. If only the
       * title is specified, it takes up both lines.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The bytes for title.
       */
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The title of the card header.
       * The header has a fixed height: if both a
       * title and subtitle are specified, each takes up one line. If only the
       * title is specified, it takes up both lines.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @param value The title to set.
       * @return This builder for chaining.
       */
      public Builder setTitle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        title_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The title of the card header.
       * The header has a fixed height: if both a
       * title and subtitle are specified, each takes up one line. If only the
       * title is specified, it takes up both lines.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTitle() {
        title_ = getDefaultInstance().getTitle();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The title of the card header.
       * The header has a fixed height: if both a
       * title and subtitle are specified, each takes up one line. If only the
       * title is specified, it takes up both lines.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @param value The bytes for title to set.
       * @return This builder for chaining.
       */
      public Builder setTitleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        title_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object subtitle_ = "";

      /**
       *
       *
       * <pre>
       * The subtitle of the card header. If specified, appears on its own line
       * below the `title`.
       * </pre>
       *
       * <code>string subtitle = 2;</code>
       *
       * @return The subtitle.
       */
      public java.lang.String getSubtitle() {
        java.lang.Object ref = subtitle_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subtitle_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The subtitle of the card header. If specified, appears on its own line
       * below the `title`.
       * </pre>
       *
       * <code>string subtitle = 2;</code>
       *
       * @return The bytes for subtitle.
       */
      public com.google.protobuf.ByteString getSubtitleBytes() {
        java.lang.Object ref = subtitle_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          subtitle_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The subtitle of the card header. If specified, appears on its own line
       * below the `title`.
       * </pre>
       *
       * <code>string subtitle = 2;</code>
       *
       * @param value The subtitle to set.
       * @return This builder for chaining.
       */
      public Builder setSubtitle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        subtitle_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The subtitle of the card header. If specified, appears on its own line
       * below the `title`.
       * </pre>
       *
       * <code>string subtitle = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSubtitle() {
        subtitle_ = getDefaultInstance().getSubtitle();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The subtitle of the card header. If specified, appears on its own line
       * below the `title`.
       * </pre>
       *
       * <code>string subtitle = 2;</code>
       *
       * @param value The bytes for subtitle to set.
       * @return This builder for chaining.
       */
      public Builder setSubtitleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        subtitle_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int imageType_ = 0;

      /**
       *
       *
       * <pre>
       * The shape used to crop the image.
       *
       * [Google Workspace add-ons and Chat
       * apps](https://developers.google.com/workspace/extend):
       * </pre>
       *
       * <code>.google.apps.card.v1.Widget.ImageType image_type = 3;</code>
       *
       * @return The enum numeric value on the wire for imageType.
       */
      @java.lang.Override
      public int getImageTypeValue() {
        return imageType_;
      }

      /**
       *
       *
       * <pre>
       * The shape used to crop the image.
       *
       * [Google Workspace add-ons and Chat
       * apps](https://developers.google.com/workspace/extend):
       * </pre>
       *
       * <code>.google.apps.card.v1.Widget.ImageType image_type = 3;</code>
       *
       * @param value The enum numeric value on the wire for imageType to set.
       * @return This builder for chaining.
       */
      public Builder setImageTypeValue(int value) {
        imageType_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The shape used to crop the image.
       *
       * [Google Workspace add-ons and Chat
       * apps](https://developers.google.com/workspace/extend):
       * </pre>
       *
       * <code>.google.apps.card.v1.Widget.ImageType image_type = 3;</code>
       *
       * @return The imageType.
       */
      @java.lang.Override
      public com.google.apps.card.v1.Widget.ImageType getImageType() {
        com.google.apps.card.v1.Widget.ImageType result =
            com.google.apps.card.v1.Widget.ImageType.forNumber(imageType_);
        return result == null ? com.google.apps.card.v1.Widget.ImageType.UNRECOGNIZED : result;
      }

      /**
       *
       *
       * <pre>
       * The shape used to crop the image.
       *
       * [Google Workspace add-ons and Chat
       * apps](https://developers.google.com/workspace/extend):
       * </pre>
       *
       * <code>.google.apps.card.v1.Widget.ImageType image_type = 3;</code>
       *
       * @param value The imageType to set.
       * @return This builder for chaining.
       */
      public Builder setImageType(com.google.apps.card.v1.Widget.ImageType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        imageType_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The shape used to crop the image.
       *
       * [Google Workspace add-ons and Chat
       * apps](https://developers.google.com/workspace/extend):
       * </pre>
       *
       * <code>.google.apps.card.v1.Widget.ImageType image_type = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearImageType() {
        bitField0_ = (bitField0_ & ~0x00000004);
        imageType_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object imageUrl_ = "";

      /**
       *
       *
       * <pre>
       * The HTTPS URL of the image in the card header.
       * </pre>
       *
       * <code>string image_url = 4;</code>
       *
       * @return The imageUrl.
       */
      public java.lang.String getImageUrl() {
        java.lang.Object ref = imageUrl_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          imageUrl_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The HTTPS URL of the image in the card header.
       * </pre>
       *
       * <code>string image_url = 4;</code>
       *
       * @return The bytes for imageUrl.
       */
      public com.google.protobuf.ByteString getImageUrlBytes() {
        java.lang.Object ref = imageUrl_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          imageUrl_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The HTTPS URL of the image in the card header.
       * </pre>
       *
       * <code>string image_url = 4;</code>
       *
       * @param value The imageUrl to set.
       * @return This builder for chaining.
       */
      public Builder setImageUrl(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        imageUrl_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The HTTPS URL of the image in the card header.
       * </pre>
       *
       * <code>string image_url = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearImageUrl() {
        imageUrl_ = getDefaultInstance().getImageUrl();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The HTTPS URL of the image in the card header.
       * </pre>
       *
       * <code>string image_url = 4;</code>
       *
       * @param value The bytes for imageUrl to set.
       * @return This builder for chaining.
       */
      public Builder setImageUrlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        imageUrl_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object imageAltText_ = "";

      /**
       *
       *
       * <pre>
       * The alternative text of this image that's used for accessibility.
       * </pre>
       *
       * <code>string image_alt_text = 5;</code>
       *
       * @return The imageAltText.
       */
      public java.lang.String getImageAltText() {
        java.lang.Object ref = imageAltText_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          imageAltText_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The alternative text of this image that's used for accessibility.
       * </pre>
       *
       * <code>string image_alt_text = 5;</code>
       *
       * @return The bytes for imageAltText.
       */
      public com.google.protobuf.ByteString getImageAltTextBytes() {
        java.lang.Object ref = imageAltText_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          imageAltText_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The alternative text of this image that's used for accessibility.
       * </pre>
       *
       * <code>string image_alt_text = 5;</code>
       *
       * @param value The imageAltText to set.
       * @return This builder for chaining.
       */
      public Builder setImageAltText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        imageAltText_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The alternative text of this image that's used for accessibility.
       * </pre>
       *
       * <code>string image_alt_text = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearImageAltText() {
        imageAltText_ = getDefaultInstance().getImageAltText();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The alternative text of this image that's used for accessibility.
       * </pre>
       *
       * <code>string image_alt_text = 5;</code>
       *
       * @param value The bytes for imageAltText to set.
       * @return This builder for chaining.
       */
      public Builder setImageAltTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        imageAltText_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Card.CardHeader)
    }

    // @@protoc_insertion_point(class_scope:google.apps.card.v1.Card.CardHeader)
    private static final com.google.apps.card.v1.Card.CardHeader DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.apps.card.v1.Card.CardHeader();
    }

    public static com.google.apps.card.v1.Card.CardHeader getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CardHeader> PARSER =
        new com.google.protobuf.AbstractParser<CardHeader>() {
          @java.lang.Override
          public CardHeader parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CardHeader> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CardHeader> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Card.CardHeader getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SectionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.apps.card.v1.Card.Section)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Text that appears at the top of a section.
     * Supports simple HTML formatted text. For more information
     * about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string header = 1;</code>
     *
     * @return The header.
     */
    java.lang.String getHeader();

    /**
     *
     *
     * <pre>
     * Text that appears at the top of a section.
     * Supports simple HTML formatted text. For more information
     * about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string header = 1;</code>
     *
     * @return The bytes for header.
     */
    com.google.protobuf.ByteString getHeaderBytes();

    /**
     *
     *
     * <pre>
     * All the widgets in the section.
     * Must contain at least one widget.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
     */
    java.util.List<com.google.apps.card.v1.Widget> getWidgetsList();

    /**
     *
     *
     * <pre>
     * All the widgets in the section.
     * Must contain at least one widget.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
     */
    com.google.apps.card.v1.Widget getWidgets(int index);

    /**
     *
     *
     * <pre>
     * All the widgets in the section.
     * Must contain at least one widget.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
     */
    int getWidgetsCount();

    /**
     *
     *
     * <pre>
     * All the widgets in the section.
     * Must contain at least one widget.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
     */
    java.util.List<? extends com.google.apps.card.v1.WidgetOrBuilder> getWidgetsOrBuilderList();

    /**
     *
     *
     * <pre>
     * All the widgets in the section.
     * Must contain at least one widget.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
     */
    com.google.apps.card.v1.WidgetOrBuilder getWidgetsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Indicates whether this section is collapsible.
     *
     * Collapsible sections hide some or all widgets, but users can expand the
     * section to reveal the hidden widgets by clicking **Show more**. Users
     * can hide the widgets again by clicking **Show less**.
     *
     * To determine which widgets are hidden, specify
     * `uncollapsibleWidgetsCount`.
     * </pre>
     *
     * <code>bool collapsible = 5;</code>
     *
     * @return The collapsible.
     */
    boolean getCollapsible();

    /**
     *
     *
     * <pre>
     * The number of uncollapsible widgets which remain visible even when a
     * section is collapsed.
     *
     * For example, when a section
     * contains five widgets and the `uncollapsibleWidgetsCount` is set to `2`,
     * the first two widgets are always shown and the last three are collapsed
     * by default. The `uncollapsibleWidgetsCount` is taken into account only
     * when `collapsible` is `true`.
     * </pre>
     *
     * <code>int32 uncollapsible_widgets_count = 6;</code>
     *
     * @return The uncollapsibleWidgetsCount.
     */
    int getUncollapsibleWidgetsCount();

    /**
     *
     *
     * <pre>
     * Optional. Define the expand and collapse button of the section.
     * This button will be shown only if the section is collapsible.
     * If this field isn't set, the default button is used.
     * </pre>
     *
     * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
     *
     * @return Whether the collapseControl field is set.
     */
    boolean hasCollapseControl();

    /**
     *
     *
     * <pre>
     * Optional. Define the expand and collapse button of the section.
     * This button will be shown only if the section is collapsible.
     * If this field isn't set, the default button is used.
     * </pre>
     *
     * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
     *
     * @return The collapseControl.
     */
    com.google.apps.card.v1.CollapseControl getCollapseControl();

    /**
     *
     *
     * <pre>
     * Optional. Define the expand and collapse button of the section.
     * This button will be shown only if the section is collapsible.
     * If this field isn't set, the default button is used.
     * </pre>
     *
     * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
     */
    com.google.apps.card.v1.CollapseControlOrBuilder getCollapseControlOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A section contains a collection of widgets that are rendered
   * vertically in the order that they're specified.
   *
   * [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Card.Section}
   */
  public static final class Section extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.apps.card.v1.Card.Section)
      SectionOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "Section");
    }

    // Use Section.newBuilder() to construct.
    private Section(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private Section() {
      header_ = "";
      widgets_ = java.util.Collections.emptyList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Card_Section_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Card_Section_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Card.Section.class,
              com.google.apps.card.v1.Card.Section.Builder.class);
    }

    private int bitField0_;
    public static final int HEADER_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object header_ = "";

    /**
     *
     *
     * <pre>
     * Text that appears at the top of a section.
     * Supports simple HTML formatted text. For more information
     * about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string header = 1;</code>
     *
     * @return The header.
     */
    @java.lang.Override
    public java.lang.String getHeader() {
      java.lang.Object ref = header_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        header_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Text that appears at the top of a section.
     * Supports simple HTML formatted text. For more information
     * about formatting text, see
     * [Formatting text in Google Chat
     * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
     * and
     * [Formatting
     * text in Google Workspace
     * add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
     * </pre>
     *
     * <code>string header = 1;</code>
     *
     * @return The bytes for header.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHeaderBytes() {
      java.lang.Object ref = header_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        header_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int WIDGETS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.apps.card.v1.Widget> widgets_;

    /**
     *
     *
     * <pre>
     * All the widgets in the section.
     * Must contain at least one widget.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.apps.card.v1.Widget> getWidgetsList() {
      return widgets_;
    }

    /**
     *
     *
     * <pre>
     * All the widgets in the section.
     * Must contain at least one widget.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.apps.card.v1.WidgetOrBuilder>
        getWidgetsOrBuilderList() {
      return widgets_;
    }

    /**
     *
     *
     * <pre>
     * All the widgets in the section.
     * Must contain at least one widget.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
     */
    @java.lang.Override
    public int getWidgetsCount() {
      return widgets_.size();
    }

    /**
     *
     *
     * <pre>
     * All the widgets in the section.
     * Must contain at least one widget.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.Widget getWidgets(int index) {
      return widgets_.get(index);
    }

    /**
     *
     *
     * <pre>
     * All the widgets in the section.
     * Must contain at least one widget.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.WidgetOrBuilder getWidgetsOrBuilder(int index) {
      return widgets_.get(index);
    }

    public static final int COLLAPSIBLE_FIELD_NUMBER = 5;
    private boolean collapsible_ = false;

    /**
     *
     *
     * <pre>
     * Indicates whether this section is collapsible.
     *
     * Collapsible sections hide some or all widgets, but users can expand the
     * section to reveal the hidden widgets by clicking **Show more**. Users
     * can hide the widgets again by clicking **Show less**.
     *
     * To determine which widgets are hidden, specify
     * `uncollapsibleWidgetsCount`.
     * </pre>
     *
     * <code>bool collapsible = 5;</code>
     *
     * @return The collapsible.
     */
    @java.lang.Override
    public boolean getCollapsible() {
      return collapsible_;
    }

    public static final int UNCOLLAPSIBLE_WIDGETS_COUNT_FIELD_NUMBER = 6;
    private int uncollapsibleWidgetsCount_ = 0;

    /**
     *
     *
     * <pre>
     * The number of uncollapsible widgets which remain visible even when a
     * section is collapsed.
     *
     * For example, when a section
     * contains five widgets and the `uncollapsibleWidgetsCount` is set to `2`,
     * the first two widgets are always shown and the last three are collapsed
     * by default. The `uncollapsibleWidgetsCount` is taken into account only
     * when `collapsible` is `true`.
     * </pre>
     *
     * <code>int32 uncollapsible_widgets_count = 6;</code>
     *
     * @return The uncollapsibleWidgetsCount.
     */
    @java.lang.Override
    public int getUncollapsibleWidgetsCount() {
      return uncollapsibleWidgetsCount_;
    }

    public static final int COLLAPSE_CONTROL_FIELD_NUMBER = 8;
    private com.google.apps.card.v1.CollapseControl collapseControl_;

    /**
     *
     *
     * <pre>
     * Optional. Define the expand and collapse button of the section.
     * This button will be shown only if the section is collapsible.
     * If this field isn't set, the default button is used.
     * </pre>
     *
     * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
     *
     * @return Whether the collapseControl field is set.
     */
    @java.lang.Override
    public boolean hasCollapseControl() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Define the expand and collapse button of the section.
     * This button will be shown only if the section is collapsible.
     * If this field isn't set, the default button is used.
     * </pre>
     *
     * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
     *
     * @return The collapseControl.
     */
    @java.lang.Override
    public com.google.apps.card.v1.CollapseControl getCollapseControl() {
      return collapseControl_ == null
          ? com.google.apps.card.v1.CollapseControl.getDefaultInstance()
          : collapseControl_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Define the expand and collapse button of the section.
     * This button will be shown only if the section is collapsible.
     * If this field isn't set, the default button is used.
     * </pre>
     *
     * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.CollapseControlOrBuilder getCollapseControlOrBuilder() {
      return collapseControl_ == null
          ? com.google.apps.card.v1.CollapseControl.getDefaultInstance()
          : collapseControl_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(header_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, header_);
      }
      for (int i = 0; i < widgets_.size(); i++) {
        output.writeMessage(2, widgets_.get(i));
      }
      if (collapsible_ != false) {
        output.writeBool(5, collapsible_);
      }
      if (uncollapsibleWidgetsCount_ != 0) {
        output.writeInt32(6, uncollapsibleWidgetsCount_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(8, getCollapseControl());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(header_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, header_);
      }
      for (int i = 0; i < widgets_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, widgets_.get(i));
      }
      if (collapsible_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, collapsible_);
      }
      if (uncollapsibleWidgetsCount_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(6, uncollapsibleWidgetsCount_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCollapseControl());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.apps.card.v1.Card.Section)) {
        return super.equals(obj);
      }
      com.google.apps.card.v1.Card.Section other = (com.google.apps.card.v1.Card.Section) obj;

      if (!getHeader().equals(other.getHeader())) return false;
      if (!getWidgetsList().equals(other.getWidgetsList())) return false;
      if (getCollapsible() != other.getCollapsible()) return false;
      if (getUncollapsibleWidgetsCount() != other.getUncollapsibleWidgetsCount()) return false;
      if (hasCollapseControl() != other.hasCollapseControl()) return false;
      if (hasCollapseControl()) {
        if (!getCollapseControl().equals(other.getCollapseControl())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + HEADER_FIELD_NUMBER;
      hash = (53 * hash) + getHeader().hashCode();
      if (getWidgetsCount() > 0) {
        hash = (37 * hash) + WIDGETS_FIELD_NUMBER;
        hash = (53 * hash) + getWidgetsList().hashCode();
      }
      hash = (37 * hash) + COLLAPSIBLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCollapsible());
      hash = (37 * hash) + UNCOLLAPSIBLE_WIDGETS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getUncollapsibleWidgetsCount();
      if (hasCollapseControl()) {
        hash = (37 * hash) + COLLAPSE_CONTROL_FIELD_NUMBER;
        hash = (53 * hash) + getCollapseControl().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.apps.card.v1.Card.Section parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.Section parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.Section parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.Section parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.Section parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.Section parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.Section parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.Section parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.Section parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.Section parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.Section parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.Section parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.apps.card.v1.Card.Section prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A section contains a collection of widgets that are rendered
     * vertically in the order that they're specified.
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * Protobuf type {@code google.apps.card.v1.Card.Section}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Card.Section)
        com.google.apps.card.v1.Card.SectionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_Section_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_Section_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.apps.card.v1.Card.Section.class,
                com.google.apps.card.v1.Card.Section.Builder.class);
      }

      // Construct using com.google.apps.card.v1.Card.Section.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          internalGetWidgetsFieldBuilder();
          internalGetCollapseControlFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        header_ = "";
        if (widgetsBuilder_ == null) {
          widgets_ = java.util.Collections.emptyList();
        } else {
          widgets_ = null;
          widgetsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        collapsible_ = false;
        uncollapsibleWidgetsCount_ = 0;
        collapseControl_ = null;
        if (collapseControlBuilder_ != null) {
          collapseControlBuilder_.dispose();
          collapseControlBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_Section_descriptor;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.Section getDefaultInstanceForType() {
        return com.google.apps.card.v1.Card.Section.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.Section build() {
        com.google.apps.card.v1.Card.Section result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.Section buildPartial() {
        com.google.apps.card.v1.Card.Section result =
            new com.google.apps.card.v1.Card.Section(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.google.apps.card.v1.Card.Section result) {
        if (widgetsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            widgets_ = java.util.Collections.unmodifiableList(widgets_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.widgets_ = widgets_;
        } else {
          result.widgets_ = widgetsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.apps.card.v1.Card.Section result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.header_ = header_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.collapsible_ = collapsible_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.uncollapsibleWidgetsCount_ = uncollapsibleWidgetsCount_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.collapseControl_ =
              collapseControlBuilder_ == null ? collapseControl_ : collapseControlBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.apps.card.v1.Card.Section) {
          return mergeFrom((com.google.apps.card.v1.Card.Section) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.apps.card.v1.Card.Section other) {
        if (other == com.google.apps.card.v1.Card.Section.getDefaultInstance()) return this;
        if (!other.getHeader().isEmpty()) {
          header_ = other.header_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (widgetsBuilder_ == null) {
          if (!other.widgets_.isEmpty()) {
            if (widgets_.isEmpty()) {
              widgets_ = other.widgets_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureWidgetsIsMutable();
              widgets_.addAll(other.widgets_);
            }
            onChanged();
          }
        } else {
          if (!other.widgets_.isEmpty()) {
            if (widgetsBuilder_.isEmpty()) {
              widgetsBuilder_.dispose();
              widgetsBuilder_ = null;
              widgets_ = other.widgets_;
              bitField0_ = (bitField0_ & ~0x00000002);
              widgetsBuilder_ =
                  com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders
                      ? internalGetWidgetsFieldBuilder()
                      : null;
            } else {
              widgetsBuilder_.addAllMessages(other.widgets_);
            }
          }
        }
        if (other.getCollapsible() != false) {
          setCollapsible(other.getCollapsible());
        }
        if (other.getUncollapsibleWidgetsCount() != 0) {
          setUncollapsibleWidgetsCount(other.getUncollapsibleWidgetsCount());
        }
        if (other.hasCollapseControl()) {
          mergeCollapseControl(other.getCollapseControl());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  header_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.apps.card.v1.Widget m =
                      input.readMessage(com.google.apps.card.v1.Widget.parser(), extensionRegistry);
                  if (widgetsBuilder_ == null) {
                    ensureWidgetsIsMutable();
                    widgets_.add(m);
                  } else {
                    widgetsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 40:
                {
                  collapsible_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 40
              case 48:
                {
                  uncollapsibleWidgetsCount_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 48
              case 66:
                {
                  input.readMessage(
                      internalGetCollapseControlFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 66
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object header_ = "";

      /**
       *
       *
       * <pre>
       * Text that appears at the top of a section.
       * Supports simple HTML formatted text. For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string header = 1;</code>
       *
       * @return The header.
       */
      public java.lang.String getHeader() {
        java.lang.Object ref = header_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          header_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Text that appears at the top of a section.
       * Supports simple HTML formatted text. For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string header = 1;</code>
       *
       * @return The bytes for header.
       */
      public com.google.protobuf.ByteString getHeaderBytes() {
        java.lang.Object ref = header_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          header_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Text that appears at the top of a section.
       * Supports simple HTML formatted text. For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string header = 1;</code>
       *
       * @param value The header to set.
       * @return This builder for chaining.
       */
      public Builder setHeader(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        header_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Text that appears at the top of a section.
       * Supports simple HTML formatted text. For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string header = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHeader() {
        header_ = getDefaultInstance().getHeader();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Text that appears at the top of a section.
       * Supports simple HTML formatted text. For more information
       * about formatting text, see
       * [Formatting text in Google Chat
       * apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
       * and
       * [Formatting
       * text in Google Workspace
       * add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
       * </pre>
       *
       * <code>string header = 1;</code>
       *
       * @param value The bytes for header to set.
       * @return This builder for chaining.
       */
      public Builder setHeaderBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        header_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.apps.card.v1.Widget> widgets_ =
          java.util.Collections.emptyList();

      private void ensureWidgetsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          widgets_ = new java.util.ArrayList<com.google.apps.card.v1.Widget>(widgets_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
              com.google.apps.card.v1.Widget,
              com.google.apps.card.v1.Widget.Builder,
              com.google.apps.card.v1.WidgetOrBuilder>
          widgetsBuilder_;

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public java.util.List<com.google.apps.card.v1.Widget> getWidgetsList() {
        if (widgetsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(widgets_);
        } else {
          return widgetsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public int getWidgetsCount() {
        if (widgetsBuilder_ == null) {
          return widgets_.size();
        } else {
          return widgetsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public com.google.apps.card.v1.Widget getWidgets(int index) {
        if (widgetsBuilder_ == null) {
          return widgets_.get(index);
        } else {
          return widgetsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public Builder setWidgets(int index, com.google.apps.card.v1.Widget value) {
        if (widgetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWidgetsIsMutable();
          widgets_.set(index, value);
          onChanged();
        } else {
          widgetsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public Builder setWidgets(int index, com.google.apps.card.v1.Widget.Builder builderForValue) {
        if (widgetsBuilder_ == null) {
          ensureWidgetsIsMutable();
          widgets_.set(index, builderForValue.build());
          onChanged();
        } else {
          widgetsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public Builder addWidgets(com.google.apps.card.v1.Widget value) {
        if (widgetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWidgetsIsMutable();
          widgets_.add(value);
          onChanged();
        } else {
          widgetsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public Builder addWidgets(int index, com.google.apps.card.v1.Widget value) {
        if (widgetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWidgetsIsMutable();
          widgets_.add(index, value);
          onChanged();
        } else {
          widgetsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public Builder addWidgets(com.google.apps.card.v1.Widget.Builder builderForValue) {
        if (widgetsBuilder_ == null) {
          ensureWidgetsIsMutable();
          widgets_.add(builderForValue.build());
          onChanged();
        } else {
          widgetsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public Builder addWidgets(int index, com.google.apps.card.v1.Widget.Builder builderForValue) {
        if (widgetsBuilder_ == null) {
          ensureWidgetsIsMutable();
          widgets_.add(index, builderForValue.build());
          onChanged();
        } else {
          widgetsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public Builder addAllWidgets(
          java.lang.Iterable<? extends com.google.apps.card.v1.Widget> values) {
        if (widgetsBuilder_ == null) {
          ensureWidgetsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, widgets_);
          onChanged();
        } else {
          widgetsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public Builder clearWidgets() {
        if (widgetsBuilder_ == null) {
          widgets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          widgetsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public Builder removeWidgets(int index) {
        if (widgetsBuilder_ == null) {
          ensureWidgetsIsMutable();
          widgets_.remove(index);
          onChanged();
        } else {
          widgetsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public com.google.apps.card.v1.Widget.Builder getWidgetsBuilder(int index) {
        return internalGetWidgetsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public com.google.apps.card.v1.WidgetOrBuilder getWidgetsOrBuilder(int index) {
        if (widgetsBuilder_ == null) {
          return widgets_.get(index);
        } else {
          return widgetsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public java.util.List<? extends com.google.apps.card.v1.WidgetOrBuilder>
          getWidgetsOrBuilderList() {
        if (widgetsBuilder_ != null) {
          return widgetsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(widgets_);
        }
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public com.google.apps.card.v1.Widget.Builder addWidgetsBuilder() {
        return internalGetWidgetsFieldBuilder()
            .addBuilder(com.google.apps.card.v1.Widget.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public com.google.apps.card.v1.Widget.Builder addWidgetsBuilder(int index) {
        return internalGetWidgetsFieldBuilder()
            .addBuilder(index, com.google.apps.card.v1.Widget.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * All the widgets in the section.
       * Must contain at least one widget.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Widget widgets = 2;</code>
       */
      public java.util.List<com.google.apps.card.v1.Widget.Builder> getWidgetsBuilderList() {
        return internalGetWidgetsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilder<
              com.google.apps.card.v1.Widget,
              com.google.apps.card.v1.Widget.Builder,
              com.google.apps.card.v1.WidgetOrBuilder>
          internalGetWidgetsFieldBuilder() {
        if (widgetsBuilder_ == null) {
          widgetsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilder<
                  com.google.apps.card.v1.Widget,
                  com.google.apps.card.v1.Widget.Builder,
                  com.google.apps.card.v1.WidgetOrBuilder>(
                  widgets_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          widgets_ = null;
        }
        return widgetsBuilder_;
      }

      private boolean collapsible_;

      /**
       *
       *
       * <pre>
       * Indicates whether this section is collapsible.
       *
       * Collapsible sections hide some or all widgets, but users can expand the
       * section to reveal the hidden widgets by clicking **Show more**. Users
       * can hide the widgets again by clicking **Show less**.
       *
       * To determine which widgets are hidden, specify
       * `uncollapsibleWidgetsCount`.
       * </pre>
       *
       * <code>bool collapsible = 5;</code>
       *
       * @return The collapsible.
       */
      @java.lang.Override
      public boolean getCollapsible() {
        return collapsible_;
      }

      /**
       *
       *
       * <pre>
       * Indicates whether this section is collapsible.
       *
       * Collapsible sections hide some or all widgets, but users can expand the
       * section to reveal the hidden widgets by clicking **Show more**. Users
       * can hide the widgets again by clicking **Show less**.
       *
       * To determine which widgets are hidden, specify
       * `uncollapsibleWidgetsCount`.
       * </pre>
       *
       * <code>bool collapsible = 5;</code>
       *
       * @param value The collapsible to set.
       * @return This builder for chaining.
       */
      public Builder setCollapsible(boolean value) {

        collapsible_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates whether this section is collapsible.
       *
       * Collapsible sections hide some or all widgets, but users can expand the
       * section to reveal the hidden widgets by clicking **Show more**. Users
       * can hide the widgets again by clicking **Show less**.
       *
       * To determine which widgets are hidden, specify
       * `uncollapsibleWidgetsCount`.
       * </pre>
       *
       * <code>bool collapsible = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCollapsible() {
        bitField0_ = (bitField0_ & ~0x00000004);
        collapsible_ = false;
        onChanged();
        return this;
      }

      private int uncollapsibleWidgetsCount_;

      /**
       *
       *
       * <pre>
       * The number of uncollapsible widgets which remain visible even when a
       * section is collapsed.
       *
       * For example, when a section
       * contains five widgets and the `uncollapsibleWidgetsCount` is set to `2`,
       * the first two widgets are always shown and the last three are collapsed
       * by default. The `uncollapsibleWidgetsCount` is taken into account only
       * when `collapsible` is `true`.
       * </pre>
       *
       * <code>int32 uncollapsible_widgets_count = 6;</code>
       *
       * @return The uncollapsibleWidgetsCount.
       */
      @java.lang.Override
      public int getUncollapsibleWidgetsCount() {
        return uncollapsibleWidgetsCount_;
      }

      /**
       *
       *
       * <pre>
       * The number of uncollapsible widgets which remain visible even when a
       * section is collapsed.
       *
       * For example, when a section
       * contains five widgets and the `uncollapsibleWidgetsCount` is set to `2`,
       * the first two widgets are always shown and the last three are collapsed
       * by default. The `uncollapsibleWidgetsCount` is taken into account only
       * when `collapsible` is `true`.
       * </pre>
       *
       * <code>int32 uncollapsible_widgets_count = 6;</code>
       *
       * @param value The uncollapsibleWidgetsCount to set.
       * @return This builder for chaining.
       */
      public Builder setUncollapsibleWidgetsCount(int value) {

        uncollapsibleWidgetsCount_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The number of uncollapsible widgets which remain visible even when a
       * section is collapsed.
       *
       * For example, when a section
       * contains five widgets and the `uncollapsibleWidgetsCount` is set to `2`,
       * the first two widgets are always shown and the last three are collapsed
       * by default. The `uncollapsibleWidgetsCount` is taken into account only
       * when `collapsible` is `true`.
       * </pre>
       *
       * <code>int32 uncollapsible_widgets_count = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUncollapsibleWidgetsCount() {
        bitField0_ = (bitField0_ & ~0x00000008);
        uncollapsibleWidgetsCount_ = 0;
        onChanged();
        return this;
      }

      private com.google.apps.card.v1.CollapseControl collapseControl_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.CollapseControl,
              com.google.apps.card.v1.CollapseControl.Builder,
              com.google.apps.card.v1.CollapseControlOrBuilder>
          collapseControlBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Define the expand and collapse button of the section.
       * This button will be shown only if the section is collapsible.
       * If this field isn't set, the default button is used.
       * </pre>
       *
       * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
       *
       * @return Whether the collapseControl field is set.
       */
      public boolean hasCollapseControl() {
        return ((bitField0_ & 0x00000010) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Define the expand and collapse button of the section.
       * This button will be shown only if the section is collapsible.
       * If this field isn't set, the default button is used.
       * </pre>
       *
       * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
       *
       * @return The collapseControl.
       */
      public com.google.apps.card.v1.CollapseControl getCollapseControl() {
        if (collapseControlBuilder_ == null) {
          return collapseControl_ == null
              ? com.google.apps.card.v1.CollapseControl.getDefaultInstance()
              : collapseControl_;
        } else {
          return collapseControlBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Define the expand and collapse button of the section.
       * This button will be shown only if the section is collapsible.
       * If this field isn't set, the default button is used.
       * </pre>
       *
       * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
       */
      public Builder setCollapseControl(com.google.apps.card.v1.CollapseControl value) {
        if (collapseControlBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          collapseControl_ = value;
        } else {
          collapseControlBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Define the expand and collapse button of the section.
       * This button will be shown only if the section is collapsible.
       * If this field isn't set, the default button is used.
       * </pre>
       *
       * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
       */
      public Builder setCollapseControl(
          com.google.apps.card.v1.CollapseControl.Builder builderForValue) {
        if (collapseControlBuilder_ == null) {
          collapseControl_ = builderForValue.build();
        } else {
          collapseControlBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Define the expand and collapse button of the section.
       * This button will be shown only if the section is collapsible.
       * If this field isn't set, the default button is used.
       * </pre>
       *
       * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
       */
      public Builder mergeCollapseControl(com.google.apps.card.v1.CollapseControl value) {
        if (collapseControlBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && collapseControl_ != null
              && collapseControl_ != com.google.apps.card.v1.CollapseControl.getDefaultInstance()) {
            getCollapseControlBuilder().mergeFrom(value);
          } else {
            collapseControl_ = value;
          }
        } else {
          collapseControlBuilder_.mergeFrom(value);
        }
        if (collapseControl_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Define the expand and collapse button of the section.
       * This button will be shown only if the section is collapsible.
       * If this field isn't set, the default button is used.
       * </pre>
       *
       * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
       */
      public Builder clearCollapseControl() {
        bitField0_ = (bitField0_ & ~0x00000010);
        collapseControl_ = null;
        if (collapseControlBuilder_ != null) {
          collapseControlBuilder_.dispose();
          collapseControlBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Define the expand and collapse button of the section.
       * This button will be shown only if the section is collapsible.
       * If this field isn't set, the default button is used.
       * </pre>
       *
       * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
       */
      public com.google.apps.card.v1.CollapseControl.Builder getCollapseControlBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return internalGetCollapseControlFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Define the expand and collapse button of the section.
       * This button will be shown only if the section is collapsible.
       * If this field isn't set, the default button is used.
       * </pre>
       *
       * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
       */
      public com.google.apps.card.v1.CollapseControlOrBuilder getCollapseControlOrBuilder() {
        if (collapseControlBuilder_ != null) {
          return collapseControlBuilder_.getMessageOrBuilder();
        } else {
          return collapseControl_ == null
              ? com.google.apps.card.v1.CollapseControl.getDefaultInstance()
              : collapseControl_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Define the expand and collapse button of the section.
       * This button will be shown only if the section is collapsible.
       * If this field isn't set, the default button is used.
       * </pre>
       *
       * <code>.google.apps.card.v1.CollapseControl collapse_control = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.CollapseControl,
              com.google.apps.card.v1.CollapseControl.Builder,
              com.google.apps.card.v1.CollapseControlOrBuilder>
          internalGetCollapseControlFieldBuilder() {
        if (collapseControlBuilder_ == null) {
          collapseControlBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.apps.card.v1.CollapseControl,
                  com.google.apps.card.v1.CollapseControl.Builder,
                  com.google.apps.card.v1.CollapseControlOrBuilder>(
                  getCollapseControl(), getParentForChildren(), isClean());
          collapseControl_ = null;
        }
        return collapseControlBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Card.Section)
    }

    // @@protoc_insertion_point(class_scope:google.apps.card.v1.Card.Section)
    private static final com.google.apps.card.v1.Card.Section DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.apps.card.v1.Card.Section();
    }

    public static com.google.apps.card.v1.Card.Section getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Section> PARSER =
        new com.google.protobuf.AbstractParser<Section>() {
          @java.lang.Override
          public Section parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Section> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Section> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Card.Section getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CardActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.apps.card.v1.Card.CardAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The label that displays as the action menu item.
     * </pre>
     *
     * <code>string action_label = 1;</code>
     *
     * @return The actionLabel.
     */
    java.lang.String getActionLabel();

    /**
     *
     *
     * <pre>
     * The label that displays as the action menu item.
     * </pre>
     *
     * <code>string action_label = 1;</code>
     *
     * @return The bytes for actionLabel.
     */
    com.google.protobuf.ByteString getActionLabelBytes();

    /**
     *
     *
     * <pre>
     * The `onClick` action for this action item.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     *
     * @return Whether the onClick field is set.
     */
    boolean hasOnClick();

    /**
     *
     *
     * <pre>
     * The `onClick` action for this action item.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     *
     * @return The onClick.
     */
    com.google.apps.card.v1.OnClick getOnClick();

    /**
     *
     *
     * <pre>
     * The `onClick` action for this action item.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     */
    com.google.apps.card.v1.OnClickOrBuilder getOnClickOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A card action is the action associated with the card. For example,
   * an invoice card might include actions such as delete invoice, email
   * invoice, or open the invoice in a browser.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Card.CardAction}
   */
  public static final class CardAction extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.apps.card.v1.Card.CardAction)
      CardActionOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "CardAction");
    }

    // Use CardAction.newBuilder() to construct.
    private CardAction(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private CardAction() {
      actionLabel_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Card_CardAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Card_CardAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Card.CardAction.class,
              com.google.apps.card.v1.Card.CardAction.Builder.class);
    }

    private int bitField0_;
    public static final int ACTION_LABEL_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object actionLabel_ = "";

    /**
     *
     *
     * <pre>
     * The label that displays as the action menu item.
     * </pre>
     *
     * <code>string action_label = 1;</code>
     *
     * @return The actionLabel.
     */
    @java.lang.Override
    public java.lang.String getActionLabel() {
      java.lang.Object ref = actionLabel_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        actionLabel_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The label that displays as the action menu item.
     * </pre>
     *
     * <code>string action_label = 1;</code>
     *
     * @return The bytes for actionLabel.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getActionLabelBytes() {
      java.lang.Object ref = actionLabel_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        actionLabel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ON_CLICK_FIELD_NUMBER = 2;
    private com.google.apps.card.v1.OnClick onClick_;

    /**
     *
     *
     * <pre>
     * The `onClick` action for this action item.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     *
     * @return Whether the onClick field is set.
     */
    @java.lang.Override
    public boolean hasOnClick() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The `onClick` action for this action item.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     *
     * @return The onClick.
     */
    @java.lang.Override
    public com.google.apps.card.v1.OnClick getOnClick() {
      return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
    }

    /**
     *
     *
     * <pre>
     * The `onClick` action for this action item.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.OnClickOrBuilder getOnClickOrBuilder() {
      return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(actionLabel_)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, actionLabel_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getOnClick());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessage.isStringEmpty(actionLabel_)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, actionLabel_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOnClick());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.apps.card.v1.Card.CardAction)) {
        return super.equals(obj);
      }
      com.google.apps.card.v1.Card.CardAction other = (com.google.apps.card.v1.Card.CardAction) obj;

      if (!getActionLabel().equals(other.getActionLabel())) return false;
      if (hasOnClick() != other.hasOnClick()) return false;
      if (hasOnClick()) {
        if (!getOnClick().equals(other.getOnClick())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACTION_LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getActionLabel().hashCode();
      if (hasOnClick()) {
        hash = (37 * hash) + ON_CLICK_FIELD_NUMBER;
        hash = (53 * hash) + getOnClick().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.apps.card.v1.Card.CardAction parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.CardAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.CardAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardAction parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.CardAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardAction parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.CardAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardAction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.CardAction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.CardAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.apps.card.v1.Card.CardAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A card action is the action associated with the card. For example,
     * an invoice card might include actions such as delete invoice, email
     * invoice, or open the invoice in a browser.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * Protobuf type {@code google.apps.card.v1.Card.CardAction}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Card.CardAction)
        com.google.apps.card.v1.Card.CardActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_CardAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_CardAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.apps.card.v1.Card.CardAction.class,
                com.google.apps.card.v1.Card.CardAction.Builder.class);
      }

      // Construct using com.google.apps.card.v1.Card.CardAction.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          internalGetOnClickFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        actionLabel_ = "";
        onClick_ = null;
        if (onClickBuilder_ != null) {
          onClickBuilder_.dispose();
          onClickBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_CardAction_descriptor;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.CardAction getDefaultInstanceForType() {
        return com.google.apps.card.v1.Card.CardAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.CardAction build() {
        com.google.apps.card.v1.Card.CardAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.CardAction buildPartial() {
        com.google.apps.card.v1.Card.CardAction result =
            new com.google.apps.card.v1.Card.CardAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.apps.card.v1.Card.CardAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.actionLabel_ = actionLabel_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.onClick_ = onClickBuilder_ == null ? onClick_ : onClickBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.apps.card.v1.Card.CardAction) {
          return mergeFrom((com.google.apps.card.v1.Card.CardAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.apps.card.v1.Card.CardAction other) {
        if (other == com.google.apps.card.v1.Card.CardAction.getDefaultInstance()) return this;
        if (!other.getActionLabel().isEmpty()) {
          actionLabel_ = other.actionLabel_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasOnClick()) {
          mergeOnClick(other.getOnClick());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  actionLabel_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      internalGetOnClickFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object actionLabel_ = "";

      /**
       *
       *
       * <pre>
       * The label that displays as the action menu item.
       * </pre>
       *
       * <code>string action_label = 1;</code>
       *
       * @return The actionLabel.
       */
      public java.lang.String getActionLabel() {
        java.lang.Object ref = actionLabel_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          actionLabel_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The label that displays as the action menu item.
       * </pre>
       *
       * <code>string action_label = 1;</code>
       *
       * @return The bytes for actionLabel.
       */
      public com.google.protobuf.ByteString getActionLabelBytes() {
        java.lang.Object ref = actionLabel_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          actionLabel_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The label that displays as the action menu item.
       * </pre>
       *
       * <code>string action_label = 1;</code>
       *
       * @param value The actionLabel to set.
       * @return This builder for chaining.
       */
      public Builder setActionLabel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        actionLabel_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The label that displays as the action menu item.
       * </pre>
       *
       * <code>string action_label = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearActionLabel() {
        actionLabel_ = getDefaultInstance().getActionLabel();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The label that displays as the action menu item.
       * </pre>
       *
       * <code>string action_label = 1;</code>
       *
       * @param value The bytes for actionLabel to set.
       * @return This builder for chaining.
       */
      public Builder setActionLabelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        actionLabel_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.apps.card.v1.OnClick onClick_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.OnClick,
              com.google.apps.card.v1.OnClick.Builder,
              com.google.apps.card.v1.OnClickOrBuilder>
          onClickBuilder_;

      /**
       *
       *
       * <pre>
       * The `onClick` action for this action item.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
       *
       * @return Whether the onClick field is set.
       */
      public boolean hasOnClick() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * The `onClick` action for this action item.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
       *
       * @return The onClick.
       */
      public com.google.apps.card.v1.OnClick getOnClick() {
        if (onClickBuilder_ == null) {
          return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
        } else {
          return onClickBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The `onClick` action for this action item.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
       */
      public Builder setOnClick(com.google.apps.card.v1.OnClick value) {
        if (onClickBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          onClick_ = value;
        } else {
          onClickBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The `onClick` action for this action item.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
       */
      public Builder setOnClick(com.google.apps.card.v1.OnClick.Builder builderForValue) {
        if (onClickBuilder_ == null) {
          onClick_ = builderForValue.build();
        } else {
          onClickBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The `onClick` action for this action item.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
       */
      public Builder mergeOnClick(com.google.apps.card.v1.OnClick value) {
        if (onClickBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && onClick_ != null
              && onClick_ != com.google.apps.card.v1.OnClick.getDefaultInstance()) {
            getOnClickBuilder().mergeFrom(value);
          } else {
            onClick_ = value;
          }
        } else {
          onClickBuilder_.mergeFrom(value);
        }
        if (onClick_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The `onClick` action for this action item.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
       */
      public Builder clearOnClick() {
        bitField0_ = (bitField0_ & ~0x00000002);
        onClick_ = null;
        if (onClickBuilder_ != null) {
          onClickBuilder_.dispose();
          onClickBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The `onClick` action for this action item.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
       */
      public com.google.apps.card.v1.OnClick.Builder getOnClickBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return internalGetOnClickFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The `onClick` action for this action item.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
       */
      public com.google.apps.card.v1.OnClickOrBuilder getOnClickOrBuilder() {
        if (onClickBuilder_ != null) {
          return onClickBuilder_.getMessageOrBuilder();
        } else {
          return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
        }
      }

      /**
       *
       *
       * <pre>
       * The `onClick` action for this action item.
       * </pre>
       *
       * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.OnClick,
              com.google.apps.card.v1.OnClick.Builder,
              com.google.apps.card.v1.OnClickOrBuilder>
          internalGetOnClickFieldBuilder() {
        if (onClickBuilder_ == null) {
          onClickBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.apps.card.v1.OnClick,
                  com.google.apps.card.v1.OnClick.Builder,
                  com.google.apps.card.v1.OnClickOrBuilder>(
                  getOnClick(), getParentForChildren(), isClean());
          onClick_ = null;
        }
        return onClickBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Card.CardAction)
    }

    // @@protoc_insertion_point(class_scope:google.apps.card.v1.Card.CardAction)
    private static final com.google.apps.card.v1.Card.CardAction DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.apps.card.v1.Card.CardAction();
    }

    public static com.google.apps.card.v1.Card.CardAction getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CardAction> PARSER =
        new com.google.protobuf.AbstractParser<CardAction>() {
          @java.lang.Override
          public CardAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CardAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CardAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Card.CardAction getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NestedWidgetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.apps.card.v1.Card.NestedWidget)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A text paragraph widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     *
     * @return Whether the textParagraph field is set.
     */
    boolean hasTextParagraph();

    /**
     *
     *
     * <pre>
     * A text paragraph widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     *
     * @return The textParagraph.
     */
    com.google.apps.card.v1.TextParagraph getTextParagraph();

    /**
     *
     *
     * <pre>
     * A text paragraph widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     */
    com.google.apps.card.v1.TextParagraphOrBuilder getTextParagraphOrBuilder();

    /**
     *
     *
     * <pre>
     * A button list widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
     *
     * @return Whether the buttonList field is set.
     */
    boolean hasButtonList();

    /**
     *
     *
     * <pre>
     * A button list widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
     *
     * @return The buttonList.
     */
    com.google.apps.card.v1.ButtonList getButtonList();

    /**
     *
     *
     * <pre>
     * A button list widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
     */
    com.google.apps.card.v1.ButtonListOrBuilder getButtonListOrBuilder();

    /**
     *
     *
     * <pre>
     * An image widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 10;</code>
     *
     * @return Whether the image field is set.
     */
    boolean hasImage();

    /**
     *
     *
     * <pre>
     * An image widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 10;</code>
     *
     * @return The image.
     */
    com.google.apps.card.v1.Image getImage();

    /**
     *
     *
     * <pre>
     * An image widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 10;</code>
     */
    com.google.apps.card.v1.ImageOrBuilder getImageOrBuilder();

    com.google.apps.card.v1.Card.NestedWidget.DataCase getDataCase();
  }

  /**
   *
   *
   * <pre>
   * A list of widgets that can be displayed in a containing layout, such
   * as a `CarouselCard`.
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Card.NestedWidget}
   */
  public static final class NestedWidget extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.apps.card.v1.Card.NestedWidget)
      NestedWidgetOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "NestedWidget");
    }

    // Use NestedWidget.newBuilder() to construct.
    private NestedWidget(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private NestedWidget() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Card_NestedWidget_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Card_NestedWidget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Card.NestedWidget.class,
              com.google.apps.card.v1.Card.NestedWidget.Builder.class);
    }

    private int dataCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object data_;

    public enum DataCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      TEXT_PARAGRAPH(1),
      BUTTON_LIST(3),
      IMAGE(10),
      DATA_NOT_SET(0);
      private final int value;

      private DataCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DataCase valueOf(int value) {
        return forNumber(value);
      }

      public static DataCase forNumber(int value) {
        switch (value) {
          case 1:
            return TEXT_PARAGRAPH;
          case 3:
            return BUTTON_LIST;
          case 10:
            return IMAGE;
          case 0:
            return DATA_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DataCase getDataCase() {
      return DataCase.forNumber(dataCase_);
    }

    public static final int TEXT_PARAGRAPH_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * A text paragraph widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     *
     * @return Whether the textParagraph field is set.
     */
    @java.lang.Override
    public boolean hasTextParagraph() {
      return dataCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * A text paragraph widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     *
     * @return The textParagraph.
     */
    @java.lang.Override
    public com.google.apps.card.v1.TextParagraph getTextParagraph() {
      if (dataCase_ == 1) {
        return (com.google.apps.card.v1.TextParagraph) data_;
      }
      return com.google.apps.card.v1.TextParagraph.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * A text paragraph widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.TextParagraphOrBuilder getTextParagraphOrBuilder() {
      if (dataCase_ == 1) {
        return (com.google.apps.card.v1.TextParagraph) data_;
      }
      return com.google.apps.card.v1.TextParagraph.getDefaultInstance();
    }

    public static final int BUTTON_LIST_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * A button list widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
     *
     * @return Whether the buttonList field is set.
     */
    @java.lang.Override
    public boolean hasButtonList() {
      return dataCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * A button list widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
     *
     * @return The buttonList.
     */
    @java.lang.Override
    public com.google.apps.card.v1.ButtonList getButtonList() {
      if (dataCase_ == 3) {
        return (com.google.apps.card.v1.ButtonList) data_;
      }
      return com.google.apps.card.v1.ButtonList.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * A button list widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.ButtonListOrBuilder getButtonListOrBuilder() {
      if (dataCase_ == 3) {
        return (com.google.apps.card.v1.ButtonList) data_;
      }
      return com.google.apps.card.v1.ButtonList.getDefaultInstance();
    }

    public static final int IMAGE_FIELD_NUMBER = 10;

    /**
     *
     *
     * <pre>
     * An image widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 10;</code>
     *
     * @return Whether the image field is set.
     */
    @java.lang.Override
    public boolean hasImage() {
      return dataCase_ == 10;
    }

    /**
     *
     *
     * <pre>
     * An image widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 10;</code>
     *
     * @return The image.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Image getImage() {
      if (dataCase_ == 10) {
        return (com.google.apps.card.v1.Image) data_;
      }
      return com.google.apps.card.v1.Image.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * An image widget.
     * </pre>
     *
     * <code>.google.apps.card.v1.Image image = 10;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.ImageOrBuilder getImageOrBuilder() {
      if (dataCase_ == 10) {
        return (com.google.apps.card.v1.Image) data_;
      }
      return com.google.apps.card.v1.Image.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (dataCase_ == 1) {
        output.writeMessage(1, (com.google.apps.card.v1.TextParagraph) data_);
      }
      if (dataCase_ == 3) {
        output.writeMessage(3, (com.google.apps.card.v1.ButtonList) data_);
      }
      if (dataCase_ == 10) {
        output.writeMessage(10, (com.google.apps.card.v1.Image) data_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (dataCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.apps.card.v1.TextParagraph) data_);
      }
      if (dataCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.apps.card.v1.ButtonList) data_);
      }
      if (dataCase_ == 10) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                10, (com.google.apps.card.v1.Image) data_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.apps.card.v1.Card.NestedWidget)) {
        return super.equals(obj);
      }
      com.google.apps.card.v1.Card.NestedWidget other =
          (com.google.apps.card.v1.Card.NestedWidget) obj;

      if (!getDataCase().equals(other.getDataCase())) return false;
      switch (dataCase_) {
        case 1:
          if (!getTextParagraph().equals(other.getTextParagraph())) return false;
          break;
        case 3:
          if (!getButtonList().equals(other.getButtonList())) return false;
          break;
        case 10:
          if (!getImage().equals(other.getImage())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (dataCase_) {
        case 1:
          hash = (37 * hash) + TEXT_PARAGRAPH_FIELD_NUMBER;
          hash = (53 * hash) + getTextParagraph().hashCode();
          break;
        case 3:
          hash = (37 * hash) + BUTTON_LIST_FIELD_NUMBER;
          hash = (53 * hash) + getButtonList().hashCode();
          break;
        case 10:
          hash = (37 * hash) + IMAGE_FIELD_NUMBER;
          hash = (53 * hash) + getImage().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.apps.card.v1.Card.NestedWidget parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.NestedWidget parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.NestedWidget parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.NestedWidget parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.NestedWidget parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.NestedWidget parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.NestedWidget parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.NestedWidget parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.NestedWidget parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.NestedWidget parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.NestedWidget parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.NestedWidget parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.apps.card.v1.Card.NestedWidget prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A list of widgets that can be displayed in a containing layout, such
     * as a `CarouselCard`.
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * Protobuf type {@code google.apps.card.v1.Card.NestedWidget}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Card.NestedWidget)
        com.google.apps.card.v1.Card.NestedWidgetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_NestedWidget_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_NestedWidget_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.apps.card.v1.Card.NestedWidget.class,
                com.google.apps.card.v1.Card.NestedWidget.Builder.class);
      }

      // Construct using com.google.apps.card.v1.Card.NestedWidget.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (textParagraphBuilder_ != null) {
          textParagraphBuilder_.clear();
        }
        if (buttonListBuilder_ != null) {
          buttonListBuilder_.clear();
        }
        if (imageBuilder_ != null) {
          imageBuilder_.clear();
        }
        dataCase_ = 0;
        data_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_NestedWidget_descriptor;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.NestedWidget getDefaultInstanceForType() {
        return com.google.apps.card.v1.Card.NestedWidget.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.NestedWidget build() {
        com.google.apps.card.v1.Card.NestedWidget result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.NestedWidget buildPartial() {
        com.google.apps.card.v1.Card.NestedWidget result =
            new com.google.apps.card.v1.Card.NestedWidget(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.apps.card.v1.Card.NestedWidget result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(com.google.apps.card.v1.Card.NestedWidget result) {
        result.dataCase_ = dataCase_;
        result.data_ = this.data_;
        if (dataCase_ == 1 && textParagraphBuilder_ != null) {
          result.data_ = textParagraphBuilder_.build();
        }
        if (dataCase_ == 3 && buttonListBuilder_ != null) {
          result.data_ = buttonListBuilder_.build();
        }
        if (dataCase_ == 10 && imageBuilder_ != null) {
          result.data_ = imageBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.apps.card.v1.Card.NestedWidget) {
          return mergeFrom((com.google.apps.card.v1.Card.NestedWidget) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.apps.card.v1.Card.NestedWidget other) {
        if (other == com.google.apps.card.v1.Card.NestedWidget.getDefaultInstance()) return this;
        switch (other.getDataCase()) {
          case TEXT_PARAGRAPH:
            {
              mergeTextParagraph(other.getTextParagraph());
              break;
            }
          case BUTTON_LIST:
            {
              mergeButtonList(other.getButtonList());
              break;
            }
          case IMAGE:
            {
              mergeImage(other.getImage());
              break;
            }
          case DATA_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      internalGetTextParagraphFieldBuilder().getBuilder(), extensionRegistry);
                  dataCase_ = 1;
                  break;
                } // case 10
              case 26:
                {
                  input.readMessage(
                      internalGetButtonListFieldBuilder().getBuilder(), extensionRegistry);
                  dataCase_ = 3;
                  break;
                } // case 26
              case 82:
                {
                  input.readMessage(internalGetImageFieldBuilder().getBuilder(), extensionRegistry);
                  dataCase_ = 10;
                  break;
                } // case 82
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int dataCase_ = 0;
      private java.lang.Object data_;

      public DataCase getDataCase() {
        return DataCase.forNumber(dataCase_);
      }

      public Builder clearData() {
        dataCase_ = 0;
        data_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.TextParagraph,
              com.google.apps.card.v1.TextParagraph.Builder,
              com.google.apps.card.v1.TextParagraphOrBuilder>
          textParagraphBuilder_;

      /**
       *
       *
       * <pre>
       * A text paragraph widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
       *
       * @return Whether the textParagraph field is set.
       */
      @java.lang.Override
      public boolean hasTextParagraph() {
        return dataCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * A text paragraph widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
       *
       * @return The textParagraph.
       */
      @java.lang.Override
      public com.google.apps.card.v1.TextParagraph getTextParagraph() {
        if (textParagraphBuilder_ == null) {
          if (dataCase_ == 1) {
            return (com.google.apps.card.v1.TextParagraph) data_;
          }
          return com.google.apps.card.v1.TextParagraph.getDefaultInstance();
        } else {
          if (dataCase_ == 1) {
            return textParagraphBuilder_.getMessage();
          }
          return com.google.apps.card.v1.TextParagraph.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * A text paragraph widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
       */
      public Builder setTextParagraph(com.google.apps.card.v1.TextParagraph value) {
        if (textParagraphBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          data_ = value;
          onChanged();
        } else {
          textParagraphBuilder_.setMessage(value);
        }
        dataCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * A text paragraph widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
       */
      public Builder setTextParagraph(
          com.google.apps.card.v1.TextParagraph.Builder builderForValue) {
        if (textParagraphBuilder_ == null) {
          data_ = builderForValue.build();
          onChanged();
        } else {
          textParagraphBuilder_.setMessage(builderForValue.build());
        }
        dataCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * A text paragraph widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
       */
      public Builder mergeTextParagraph(com.google.apps.card.v1.TextParagraph value) {
        if (textParagraphBuilder_ == null) {
          if (dataCase_ == 1
              && data_ != com.google.apps.card.v1.TextParagraph.getDefaultInstance()) {
            data_ =
                com.google.apps.card.v1.TextParagraph.newBuilder(
                        (com.google.apps.card.v1.TextParagraph) data_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            data_ = value;
          }
          onChanged();
        } else {
          if (dataCase_ == 1) {
            textParagraphBuilder_.mergeFrom(value);
          } else {
            textParagraphBuilder_.setMessage(value);
          }
        }
        dataCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * A text paragraph widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
       */
      public Builder clearTextParagraph() {
        if (textParagraphBuilder_ == null) {
          if (dataCase_ == 1) {
            dataCase_ = 0;
            data_ = null;
            onChanged();
          }
        } else {
          if (dataCase_ == 1) {
            dataCase_ = 0;
            data_ = null;
          }
          textParagraphBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A text paragraph widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
       */
      public com.google.apps.card.v1.TextParagraph.Builder getTextParagraphBuilder() {
        return internalGetTextParagraphFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * A text paragraph widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
       */
      @java.lang.Override
      public com.google.apps.card.v1.TextParagraphOrBuilder getTextParagraphOrBuilder() {
        if ((dataCase_ == 1) && (textParagraphBuilder_ != null)) {
          return textParagraphBuilder_.getMessageOrBuilder();
        } else {
          if (dataCase_ == 1) {
            return (com.google.apps.card.v1.TextParagraph) data_;
          }
          return com.google.apps.card.v1.TextParagraph.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * A text paragraph widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.TextParagraph text_paragraph = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.TextParagraph,
              com.google.apps.card.v1.TextParagraph.Builder,
              com.google.apps.card.v1.TextParagraphOrBuilder>
          internalGetTextParagraphFieldBuilder() {
        if (textParagraphBuilder_ == null) {
          if (!(dataCase_ == 1)) {
            data_ = com.google.apps.card.v1.TextParagraph.getDefaultInstance();
          }
          textParagraphBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.apps.card.v1.TextParagraph,
                  com.google.apps.card.v1.TextParagraph.Builder,
                  com.google.apps.card.v1.TextParagraphOrBuilder>(
                  (com.google.apps.card.v1.TextParagraph) data_, getParentForChildren(), isClean());
          data_ = null;
        }
        dataCase_ = 1;
        onChanged();
        return textParagraphBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.ButtonList,
              com.google.apps.card.v1.ButtonList.Builder,
              com.google.apps.card.v1.ButtonListOrBuilder>
          buttonListBuilder_;

      /**
       *
       *
       * <pre>
       * A button list widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
       *
       * @return Whether the buttonList field is set.
       */
      @java.lang.Override
      public boolean hasButtonList() {
        return dataCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * A button list widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
       *
       * @return The buttonList.
       */
      @java.lang.Override
      public com.google.apps.card.v1.ButtonList getButtonList() {
        if (buttonListBuilder_ == null) {
          if (dataCase_ == 3) {
            return (com.google.apps.card.v1.ButtonList) data_;
          }
          return com.google.apps.card.v1.ButtonList.getDefaultInstance();
        } else {
          if (dataCase_ == 3) {
            return buttonListBuilder_.getMessage();
          }
          return com.google.apps.card.v1.ButtonList.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * A button list widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
       */
      public Builder setButtonList(com.google.apps.card.v1.ButtonList value) {
        if (buttonListBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          data_ = value;
          onChanged();
        } else {
          buttonListBuilder_.setMessage(value);
        }
        dataCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * A button list widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
       */
      public Builder setButtonList(com.google.apps.card.v1.ButtonList.Builder builderForValue) {
        if (buttonListBuilder_ == null) {
          data_ = builderForValue.build();
          onChanged();
        } else {
          buttonListBuilder_.setMessage(builderForValue.build());
        }
        dataCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * A button list widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
       */
      public Builder mergeButtonList(com.google.apps.card.v1.ButtonList value) {
        if (buttonListBuilder_ == null) {
          if (dataCase_ == 3 && data_ != com.google.apps.card.v1.ButtonList.getDefaultInstance()) {
            data_ =
                com.google.apps.card.v1.ButtonList.newBuilder(
                        (com.google.apps.card.v1.ButtonList) data_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            data_ = value;
          }
          onChanged();
        } else {
          if (dataCase_ == 3) {
            buttonListBuilder_.mergeFrom(value);
          } else {
            buttonListBuilder_.setMessage(value);
          }
        }
        dataCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * A button list widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
       */
      public Builder clearButtonList() {
        if (buttonListBuilder_ == null) {
          if (dataCase_ == 3) {
            dataCase_ = 0;
            data_ = null;
            onChanged();
          }
        } else {
          if (dataCase_ == 3) {
            dataCase_ = 0;
            data_ = null;
          }
          buttonListBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A button list widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
       */
      public com.google.apps.card.v1.ButtonList.Builder getButtonListBuilder() {
        return internalGetButtonListFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * A button list widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
       */
      @java.lang.Override
      public com.google.apps.card.v1.ButtonListOrBuilder getButtonListOrBuilder() {
        if ((dataCase_ == 3) && (buttonListBuilder_ != null)) {
          return buttonListBuilder_.getMessageOrBuilder();
        } else {
          if (dataCase_ == 3) {
            return (com.google.apps.card.v1.ButtonList) data_;
          }
          return com.google.apps.card.v1.ButtonList.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * A button list widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.ButtonList button_list = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.ButtonList,
              com.google.apps.card.v1.ButtonList.Builder,
              com.google.apps.card.v1.ButtonListOrBuilder>
          internalGetButtonListFieldBuilder() {
        if (buttonListBuilder_ == null) {
          if (!(dataCase_ == 3)) {
            data_ = com.google.apps.card.v1.ButtonList.getDefaultInstance();
          }
          buttonListBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.apps.card.v1.ButtonList,
                  com.google.apps.card.v1.ButtonList.Builder,
                  com.google.apps.card.v1.ButtonListOrBuilder>(
                  (com.google.apps.card.v1.ButtonList) data_, getParentForChildren(), isClean());
          data_ = null;
        }
        dataCase_ = 3;
        onChanged();
        return buttonListBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.Image,
              com.google.apps.card.v1.Image.Builder,
              com.google.apps.card.v1.ImageOrBuilder>
          imageBuilder_;

      /**
       *
       *
       * <pre>
       * An image widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.Image image = 10;</code>
       *
       * @return Whether the image field is set.
       */
      @java.lang.Override
      public boolean hasImage() {
        return dataCase_ == 10;
      }

      /**
       *
       *
       * <pre>
       * An image widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.Image image = 10;</code>
       *
       * @return The image.
       */
      @java.lang.Override
      public com.google.apps.card.v1.Image getImage() {
        if (imageBuilder_ == null) {
          if (dataCase_ == 10) {
            return (com.google.apps.card.v1.Image) data_;
          }
          return com.google.apps.card.v1.Image.getDefaultInstance();
        } else {
          if (dataCase_ == 10) {
            return imageBuilder_.getMessage();
          }
          return com.google.apps.card.v1.Image.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * An image widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.Image image = 10;</code>
       */
      public Builder setImage(com.google.apps.card.v1.Image value) {
        if (imageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          data_ = value;
          onChanged();
        } else {
          imageBuilder_.setMessage(value);
        }
        dataCase_ = 10;
        return this;
      }

      /**
       *
       *
       * <pre>
       * An image widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.Image image = 10;</code>
       */
      public Builder setImage(com.google.apps.card.v1.Image.Builder builderForValue) {
        if (imageBuilder_ == null) {
          data_ = builderForValue.build();
          onChanged();
        } else {
          imageBuilder_.setMessage(builderForValue.build());
        }
        dataCase_ = 10;
        return this;
      }

      /**
       *
       *
       * <pre>
       * An image widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.Image image = 10;</code>
       */
      public Builder mergeImage(com.google.apps.card.v1.Image value) {
        if (imageBuilder_ == null) {
          if (dataCase_ == 10 && data_ != com.google.apps.card.v1.Image.getDefaultInstance()) {
            data_ =
                com.google.apps.card.v1.Image.newBuilder((com.google.apps.card.v1.Image) data_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            data_ = value;
          }
          onChanged();
        } else {
          if (dataCase_ == 10) {
            imageBuilder_.mergeFrom(value);
          } else {
            imageBuilder_.setMessage(value);
          }
        }
        dataCase_ = 10;
        return this;
      }

      /**
       *
       *
       * <pre>
       * An image widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.Image image = 10;</code>
       */
      public Builder clearImage() {
        if (imageBuilder_ == null) {
          if (dataCase_ == 10) {
            dataCase_ = 0;
            data_ = null;
            onChanged();
          }
        } else {
          if (dataCase_ == 10) {
            dataCase_ = 0;
            data_ = null;
          }
          imageBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * An image widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.Image image = 10;</code>
       */
      public com.google.apps.card.v1.Image.Builder getImageBuilder() {
        return internalGetImageFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * An image widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.Image image = 10;</code>
       */
      @java.lang.Override
      public com.google.apps.card.v1.ImageOrBuilder getImageOrBuilder() {
        if ((dataCase_ == 10) && (imageBuilder_ != null)) {
          return imageBuilder_.getMessageOrBuilder();
        } else {
          if (dataCase_ == 10) {
            return (com.google.apps.card.v1.Image) data_;
          }
          return com.google.apps.card.v1.Image.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * An image widget.
       * </pre>
       *
       * <code>.google.apps.card.v1.Image image = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.Image,
              com.google.apps.card.v1.Image.Builder,
              com.google.apps.card.v1.ImageOrBuilder>
          internalGetImageFieldBuilder() {
        if (imageBuilder_ == null) {
          if (!(dataCase_ == 10)) {
            data_ = com.google.apps.card.v1.Image.getDefaultInstance();
          }
          imageBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.apps.card.v1.Image,
                  com.google.apps.card.v1.Image.Builder,
                  com.google.apps.card.v1.ImageOrBuilder>(
                  (com.google.apps.card.v1.Image) data_, getParentForChildren(), isClean());
          data_ = null;
        }
        dataCase_ = 10;
        onChanged();
        return imageBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Card.NestedWidget)
    }

    // @@protoc_insertion_point(class_scope:google.apps.card.v1.Card.NestedWidget)
    private static final com.google.apps.card.v1.Card.NestedWidget DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.apps.card.v1.Card.NestedWidget();
    }

    public static com.google.apps.card.v1.Card.NestedWidget getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NestedWidget> PARSER =
        new com.google.protobuf.AbstractParser<NestedWidget>() {
          @java.lang.Override
          public NestedWidget parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NestedWidget> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NestedWidget> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Card.NestedWidget getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CardFixedFooterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.apps.card.v1.Card.CardFixedFooter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The primary button of the fixed footer. The button must be a text button
     * with text and color set.
     * </pre>
     *
     * <code>.google.apps.card.v1.Button primary_button = 1;</code>
     *
     * @return Whether the primaryButton field is set.
     */
    boolean hasPrimaryButton();

    /**
     *
     *
     * <pre>
     * The primary button of the fixed footer. The button must be a text button
     * with text and color set.
     * </pre>
     *
     * <code>.google.apps.card.v1.Button primary_button = 1;</code>
     *
     * @return The primaryButton.
     */
    com.google.apps.card.v1.Button getPrimaryButton();

    /**
     *
     *
     * <pre>
     * The primary button of the fixed footer. The button must be a text button
     * with text and color set.
     * </pre>
     *
     * <code>.google.apps.card.v1.Button primary_button = 1;</code>
     */
    com.google.apps.card.v1.ButtonOrBuilder getPrimaryButtonOrBuilder();

    /**
     *
     *
     * <pre>
     * The secondary button of the fixed footer.  The button must be a text
     * button with text and color set.
     * If `secondaryButton` is set, you must also set `primaryButton`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
     *
     * @return Whether the secondaryButton field is set.
     */
    boolean hasSecondaryButton();

    /**
     *
     *
     * <pre>
     * The secondary button of the fixed footer.  The button must be a text
     * button with text and color set.
     * If `secondaryButton` is set, you must also set `primaryButton`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
     *
     * @return The secondaryButton.
     */
    com.google.apps.card.v1.Button getSecondaryButton();

    /**
     *
     *
     * <pre>
     * The secondary button of the fixed footer.  The button must be a text
     * button with text and color set.
     * If `secondaryButton` is set, you must also set `primaryButton`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
     */
    com.google.apps.card.v1.ButtonOrBuilder getSecondaryButtonOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A persistent (sticky) footer that that appears at the bottom of the card.
   *
   * Setting `fixedFooter` without specifying a `primaryButton` or a
   * `secondaryButton` causes an error.
   *
   * For Chat apps, you can use fixed footers in
   * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
   * [card
   * messages](https://developers.google.com/workspace/chat/create-messages#create).
   * For an example in Google Chat apps, see [Add a persistent
   * footer](https://developers.google.com/workspace/chat/design-components-card-dialog#add_a_persistent_footer).
   *
   * [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Card.CardFixedFooter}
   */
  public static final class CardFixedFooter extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.apps.card.v1.Card.CardFixedFooter)
      CardFixedFooterOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "CardFixedFooter");
    }

    // Use CardFixedFooter.newBuilder() to construct.
    private CardFixedFooter(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private CardFixedFooter() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Card_CardFixedFooter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Card_CardFixedFooter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Card.CardFixedFooter.class,
              com.google.apps.card.v1.Card.CardFixedFooter.Builder.class);
    }

    private int bitField0_;
    public static final int PRIMARY_BUTTON_FIELD_NUMBER = 1;
    private com.google.apps.card.v1.Button primaryButton_;

    /**
     *
     *
     * <pre>
     * The primary button of the fixed footer. The button must be a text button
     * with text and color set.
     * </pre>
     *
     * <code>.google.apps.card.v1.Button primary_button = 1;</code>
     *
     * @return Whether the primaryButton field is set.
     */
    @java.lang.Override
    public boolean hasPrimaryButton() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The primary button of the fixed footer. The button must be a text button
     * with text and color set.
     * </pre>
     *
     * <code>.google.apps.card.v1.Button primary_button = 1;</code>
     *
     * @return The primaryButton.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Button getPrimaryButton() {
      return primaryButton_ == null
          ? com.google.apps.card.v1.Button.getDefaultInstance()
          : primaryButton_;
    }

    /**
     *
     *
     * <pre>
     * The primary button of the fixed footer. The button must be a text button
     * with text and color set.
     * </pre>
     *
     * <code>.google.apps.card.v1.Button primary_button = 1;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.ButtonOrBuilder getPrimaryButtonOrBuilder() {
      return primaryButton_ == null
          ? com.google.apps.card.v1.Button.getDefaultInstance()
          : primaryButton_;
    }

    public static final int SECONDARY_BUTTON_FIELD_NUMBER = 2;
    private com.google.apps.card.v1.Button secondaryButton_;

    /**
     *
     *
     * <pre>
     * The secondary button of the fixed footer.  The button must be a text
     * button with text and color set.
     * If `secondaryButton` is set, you must also set `primaryButton`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
     *
     * @return Whether the secondaryButton field is set.
     */
    @java.lang.Override
    public boolean hasSecondaryButton() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The secondary button of the fixed footer.  The button must be a text
     * button with text and color set.
     * If `secondaryButton` is set, you must also set `primaryButton`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
     *
     * @return The secondaryButton.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Button getSecondaryButton() {
      return secondaryButton_ == null
          ? com.google.apps.card.v1.Button.getDefaultInstance()
          : secondaryButton_;
    }

    /**
     *
     *
     * <pre>
     * The secondary button of the fixed footer.  The button must be a text
     * button with text and color set.
     * If `secondaryButton` is set, you must also set `primaryButton`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.ButtonOrBuilder getSecondaryButtonOrBuilder() {
      return secondaryButton_ == null
          ? com.google.apps.card.v1.Button.getDefaultInstance()
          : secondaryButton_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getPrimaryButton());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getSecondaryButton());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPrimaryButton());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSecondaryButton());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.apps.card.v1.Card.CardFixedFooter)) {
        return super.equals(obj);
      }
      com.google.apps.card.v1.Card.CardFixedFooter other =
          (com.google.apps.card.v1.Card.CardFixedFooter) obj;

      if (hasPrimaryButton() != other.hasPrimaryButton()) return false;
      if (hasPrimaryButton()) {
        if (!getPrimaryButton().equals(other.getPrimaryButton())) return false;
      }
      if (hasSecondaryButton() != other.hasSecondaryButton()) return false;
      if (hasSecondaryButton()) {
        if (!getSecondaryButton().equals(other.getSecondaryButton())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPrimaryButton()) {
        hash = (37 * hash) + PRIMARY_BUTTON_FIELD_NUMBER;
        hash = (53 * hash) + getPrimaryButton().hashCode();
      }
      if (hasSecondaryButton()) {
        hash = (37 * hash) + SECONDARY_BUTTON_FIELD_NUMBER;
        hash = (53 * hash) + getSecondaryButton().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.apps.card.v1.Card.CardFixedFooter parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.CardFixedFooter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardFixedFooter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.CardFixedFooter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardFixedFooter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Card.CardFixedFooter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardFixedFooter parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.CardFixedFooter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardFixedFooter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.CardFixedFooter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Card.CardFixedFooter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Card.CardFixedFooter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.apps.card.v1.Card.CardFixedFooter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A persistent (sticky) footer that that appears at the bottom of the card.
     *
     * Setting `fixedFooter` without specifying a `primaryButton` or a
     * `secondaryButton` causes an error.
     *
     * For Chat apps, you can use fixed footers in
     * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     * [card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     * For an example in Google Chat apps, see [Add a persistent
     * footer](https://developers.google.com/workspace/chat/design-components-card-dialog#add_a_persistent_footer).
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * Protobuf type {@code google.apps.card.v1.Card.CardFixedFooter}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Card.CardFixedFooter)
        com.google.apps.card.v1.Card.CardFixedFooterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_CardFixedFooter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_CardFixedFooter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.apps.card.v1.Card.CardFixedFooter.class,
                com.google.apps.card.v1.Card.CardFixedFooter.Builder.class);
      }

      // Construct using com.google.apps.card.v1.Card.CardFixedFooter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          internalGetPrimaryButtonFieldBuilder();
          internalGetSecondaryButtonFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        primaryButton_ = null;
        if (primaryButtonBuilder_ != null) {
          primaryButtonBuilder_.dispose();
          primaryButtonBuilder_ = null;
        }
        secondaryButton_ = null;
        if (secondaryButtonBuilder_ != null) {
          secondaryButtonBuilder_.dispose();
          secondaryButtonBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Card_CardFixedFooter_descriptor;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.CardFixedFooter getDefaultInstanceForType() {
        return com.google.apps.card.v1.Card.CardFixedFooter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.CardFixedFooter build() {
        com.google.apps.card.v1.Card.CardFixedFooter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Card.CardFixedFooter buildPartial() {
        com.google.apps.card.v1.Card.CardFixedFooter result =
            new com.google.apps.card.v1.Card.CardFixedFooter(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.apps.card.v1.Card.CardFixedFooter result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.primaryButton_ =
              primaryButtonBuilder_ == null ? primaryButton_ : primaryButtonBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.secondaryButton_ =
              secondaryButtonBuilder_ == null ? secondaryButton_ : secondaryButtonBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.apps.card.v1.Card.CardFixedFooter) {
          return mergeFrom((com.google.apps.card.v1.Card.CardFixedFooter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.apps.card.v1.Card.CardFixedFooter other) {
        if (other == com.google.apps.card.v1.Card.CardFixedFooter.getDefaultInstance()) return this;
        if (other.hasPrimaryButton()) {
          mergePrimaryButton(other.getPrimaryButton());
        }
        if (other.hasSecondaryButton()) {
          mergeSecondaryButton(other.getSecondaryButton());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      internalGetPrimaryButtonFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      internalGetSecondaryButtonFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.apps.card.v1.Button primaryButton_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.Button,
              com.google.apps.card.v1.Button.Builder,
              com.google.apps.card.v1.ButtonOrBuilder>
          primaryButtonBuilder_;

      /**
       *
       *
       * <pre>
       * The primary button of the fixed footer. The button must be a text button
       * with text and color set.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button primary_button = 1;</code>
       *
       * @return Whether the primaryButton field is set.
       */
      public boolean hasPrimaryButton() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The primary button of the fixed footer. The button must be a text button
       * with text and color set.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button primary_button = 1;</code>
       *
       * @return The primaryButton.
       */
      public com.google.apps.card.v1.Button getPrimaryButton() {
        if (primaryButtonBuilder_ == null) {
          return primaryButton_ == null
              ? com.google.apps.card.v1.Button.getDefaultInstance()
              : primaryButton_;
        } else {
          return primaryButtonBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The primary button of the fixed footer. The button must be a text button
       * with text and color set.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button primary_button = 1;</code>
       */
      public Builder setPrimaryButton(com.google.apps.card.v1.Button value) {
        if (primaryButtonBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          primaryButton_ = value;
        } else {
          primaryButtonBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The primary button of the fixed footer. The button must be a text button
       * with text and color set.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button primary_button = 1;</code>
       */
      public Builder setPrimaryButton(com.google.apps.card.v1.Button.Builder builderForValue) {
        if (primaryButtonBuilder_ == null) {
          primaryButton_ = builderForValue.build();
        } else {
          primaryButtonBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The primary button of the fixed footer. The button must be a text button
       * with text and color set.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button primary_button = 1;</code>
       */
      public Builder mergePrimaryButton(com.google.apps.card.v1.Button value) {
        if (primaryButtonBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && primaryButton_ != null
              && primaryButton_ != com.google.apps.card.v1.Button.getDefaultInstance()) {
            getPrimaryButtonBuilder().mergeFrom(value);
          } else {
            primaryButton_ = value;
          }
        } else {
          primaryButtonBuilder_.mergeFrom(value);
        }
        if (primaryButton_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The primary button of the fixed footer. The button must be a text button
       * with text and color set.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button primary_button = 1;</code>
       */
      public Builder clearPrimaryButton() {
        bitField0_ = (bitField0_ & ~0x00000001);
        primaryButton_ = null;
        if (primaryButtonBuilder_ != null) {
          primaryButtonBuilder_.dispose();
          primaryButtonBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The primary button of the fixed footer. The button must be a text button
       * with text and color set.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button primary_button = 1;</code>
       */
      public com.google.apps.card.v1.Button.Builder getPrimaryButtonBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return internalGetPrimaryButtonFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The primary button of the fixed footer. The button must be a text button
       * with text and color set.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button primary_button = 1;</code>
       */
      public com.google.apps.card.v1.ButtonOrBuilder getPrimaryButtonOrBuilder() {
        if (primaryButtonBuilder_ != null) {
          return primaryButtonBuilder_.getMessageOrBuilder();
        } else {
          return primaryButton_ == null
              ? com.google.apps.card.v1.Button.getDefaultInstance()
              : primaryButton_;
        }
      }

      /**
       *
       *
       * <pre>
       * The primary button of the fixed footer. The button must be a text button
       * with text and color set.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button primary_button = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.Button,
              com.google.apps.card.v1.Button.Builder,
              com.google.apps.card.v1.ButtonOrBuilder>
          internalGetPrimaryButtonFieldBuilder() {
        if (primaryButtonBuilder_ == null) {
          primaryButtonBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.apps.card.v1.Button,
                  com.google.apps.card.v1.Button.Builder,
                  com.google.apps.card.v1.ButtonOrBuilder>(
                  getPrimaryButton(), getParentForChildren(), isClean());
          primaryButton_ = null;
        }
        return primaryButtonBuilder_;
      }

      private com.google.apps.card.v1.Button secondaryButton_;
      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.Button,
              com.google.apps.card.v1.Button.Builder,
              com.google.apps.card.v1.ButtonOrBuilder>
          secondaryButtonBuilder_;

      /**
       *
       *
       * <pre>
       * The secondary button of the fixed footer.  The button must be a text
       * button with text and color set.
       * If `secondaryButton` is set, you must also set `primaryButton`.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
       *
       * @return Whether the secondaryButton field is set.
       */
      public boolean hasSecondaryButton() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * The secondary button of the fixed footer.  The button must be a text
       * button with text and color set.
       * If `secondaryButton` is set, you must also set `primaryButton`.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
       *
       * @return The secondaryButton.
       */
      public com.google.apps.card.v1.Button getSecondaryButton() {
        if (secondaryButtonBuilder_ == null) {
          return secondaryButton_ == null
              ? com.google.apps.card.v1.Button.getDefaultInstance()
              : secondaryButton_;
        } else {
          return secondaryButtonBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The secondary button of the fixed footer.  The button must be a text
       * button with text and color set.
       * If `secondaryButton` is set, you must also set `primaryButton`.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
       */
      public Builder setSecondaryButton(com.google.apps.card.v1.Button value) {
        if (secondaryButtonBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          secondaryButton_ = value;
        } else {
          secondaryButtonBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The secondary button of the fixed footer.  The button must be a text
       * button with text and color set.
       * If `secondaryButton` is set, you must also set `primaryButton`.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
       */
      public Builder setSecondaryButton(com.google.apps.card.v1.Button.Builder builderForValue) {
        if (secondaryButtonBuilder_ == null) {
          secondaryButton_ = builderForValue.build();
        } else {
          secondaryButtonBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The secondary button of the fixed footer.  The button must be a text
       * button with text and color set.
       * If `secondaryButton` is set, you must also set `primaryButton`.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
       */
      public Builder mergeSecondaryButton(com.google.apps.card.v1.Button value) {
        if (secondaryButtonBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && secondaryButton_ != null
              && secondaryButton_ != com.google.apps.card.v1.Button.getDefaultInstance()) {
            getSecondaryButtonBuilder().mergeFrom(value);
          } else {
            secondaryButton_ = value;
          }
        } else {
          secondaryButtonBuilder_.mergeFrom(value);
        }
        if (secondaryButton_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The secondary button of the fixed footer.  The button must be a text
       * button with text and color set.
       * If `secondaryButton` is set, you must also set `primaryButton`.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
       */
      public Builder clearSecondaryButton() {
        bitField0_ = (bitField0_ & ~0x00000002);
        secondaryButton_ = null;
        if (secondaryButtonBuilder_ != null) {
          secondaryButtonBuilder_.dispose();
          secondaryButtonBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The secondary button of the fixed footer.  The button must be a text
       * button with text and color set.
       * If `secondaryButton` is set, you must also set `primaryButton`.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
       */
      public com.google.apps.card.v1.Button.Builder getSecondaryButtonBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return internalGetSecondaryButtonFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The secondary button of the fixed footer.  The button must be a text
       * button with text and color set.
       * If `secondaryButton` is set, you must also set `primaryButton`.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
       */
      public com.google.apps.card.v1.ButtonOrBuilder getSecondaryButtonOrBuilder() {
        if (secondaryButtonBuilder_ != null) {
          return secondaryButtonBuilder_.getMessageOrBuilder();
        } else {
          return secondaryButton_ == null
              ? com.google.apps.card.v1.Button.getDefaultInstance()
              : secondaryButton_;
        }
      }

      /**
       *
       *
       * <pre>
       * The secondary button of the fixed footer.  The button must be a text
       * button with text and color set.
       * If `secondaryButton` is set, you must also set `primaryButton`.
       * </pre>
       *
       * <code>.google.apps.card.v1.Button secondary_button = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
              com.google.apps.card.v1.Button,
              com.google.apps.card.v1.Button.Builder,
              com.google.apps.card.v1.ButtonOrBuilder>
          internalGetSecondaryButtonFieldBuilder() {
        if (secondaryButtonBuilder_ == null) {
          secondaryButtonBuilder_ =
              new com.google.protobuf.SingleFieldBuilder<
                  com.google.apps.card.v1.Button,
                  com.google.apps.card.v1.Button.Builder,
                  com.google.apps.card.v1.ButtonOrBuilder>(
                  getSecondaryButton(), getParentForChildren(), isClean());
          secondaryButton_ = null;
        }
        return secondaryButtonBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Card.CardFixedFooter)
    }

    // @@protoc_insertion_point(class_scope:google.apps.card.v1.Card.CardFixedFooter)
    private static final com.google.apps.card.v1.Card.CardFixedFooter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.apps.card.v1.Card.CardFixedFooter();
    }

    public static com.google.apps.card.v1.Card.CardFixedFooter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CardFixedFooter> PARSER =
        new com.google.protobuf.AbstractParser<CardFixedFooter>() {
          @java.lang.Override
          public CardFixedFooter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CardFixedFooter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CardFixedFooter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Card.CardFixedFooter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int HEADER_FIELD_NUMBER = 1;
  private com.google.apps.card.v1.Card.CardHeader header_;

  /**
   *
   *
   * <pre>
   * The header of the card. A header usually contains a leading image and a
   * title. Headers always appear at the top of a card.
   * </pre>
   *
   * <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
   *
   * @return Whether the header field is set.
   */
  @java.lang.Override
  public boolean hasHeader() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The header of the card. A header usually contains a leading image and a
   * title. Headers always appear at the top of a card.
   * </pre>
   *
   * <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
   *
   * @return The header.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Card.CardHeader getHeader() {
    return header_ == null ? com.google.apps.card.v1.Card.CardHeader.getDefaultInstance() : header_;
  }

  /**
   *
   *
   * <pre>
   * The header of the card. A header usually contains a leading image and a
   * title. Headers always appear at the top of a card.
   * </pre>
   *
   * <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Card.CardHeaderOrBuilder getHeaderOrBuilder() {
    return header_ == null ? com.google.apps.card.v1.Card.CardHeader.getDefaultInstance() : header_;
  }

  public static final int SECTIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.apps.card.v1.Card.Section> sections_;

  /**
   *
   *
   * <pre>
   * Contains a collection of widgets. Each section has its own, optional
   * header. Sections are visually separated by a line divider. For an example
   * in Google Chat apps, see [Define a section of a
   * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.apps.card.v1.Card.Section> getSectionsList() {
    return sections_;
  }

  /**
   *
   *
   * <pre>
   * Contains a collection of widgets. Each section has its own, optional
   * header. Sections are visually separated by a line divider. For an example
   * in Google Chat apps, see [Define a section of a
   * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.apps.card.v1.Card.SectionOrBuilder>
      getSectionsOrBuilderList() {
    return sections_;
  }

  /**
   *
   *
   * <pre>
   * Contains a collection of widgets. Each section has its own, optional
   * header. Sections are visually separated by a line divider. For an example
   * in Google Chat apps, see [Define a section of a
   * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
   */
  @java.lang.Override
  public int getSectionsCount() {
    return sections_.size();
  }

  /**
   *
   *
   * <pre>
   * Contains a collection of widgets. Each section has its own, optional
   * header. Sections are visually separated by a line divider. For an example
   * in Google Chat apps, see [Define a section of a
   * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Card.Section getSections(int index) {
    return sections_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Contains a collection of widgets. Each section has its own, optional
   * header. Sections are visually separated by a line divider. For an example
   * in Google Chat apps, see [Define a section of a
   * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Card.SectionOrBuilder getSectionsOrBuilder(int index) {
    return sections_.get(index);
  }

  public static final int SECTION_DIVIDER_STYLE_FIELD_NUMBER = 9;
  private int sectionDividerStyle_ = 0;

  /**
   *
   *
   * <pre>
   * The divider style between the header, sections and footer.
   * </pre>
   *
   * <code>.google.apps.card.v1.Card.DividerStyle section_divider_style = 9;</code>
   *
   * @return The enum numeric value on the wire for sectionDividerStyle.
   */
  @java.lang.Override
  public int getSectionDividerStyleValue() {
    return sectionDividerStyle_;
  }

  /**
   *
   *
   * <pre>
   * The divider style between the header, sections and footer.
   * </pre>
   *
   * <code>.google.apps.card.v1.Card.DividerStyle section_divider_style = 9;</code>
   *
   * @return The sectionDividerStyle.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Card.DividerStyle getSectionDividerStyle() {
    com.google.apps.card.v1.Card.DividerStyle result =
        com.google.apps.card.v1.Card.DividerStyle.forNumber(sectionDividerStyle_);
    return result == null ? com.google.apps.card.v1.Card.DividerStyle.UNRECOGNIZED : result;
  }

  public static final int CARD_ACTIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.apps.card.v1.Card.CardAction> cardActions_;

  /**
   *
   *
   * <pre>
   * The card's actions. Actions are added to the card's toolbar menu.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   *
   * For example, the following JSON constructs a card action menu with
   * `Settings` and `Send Feedback` options:
   *
   * ```
   * "card_actions": [
   * {
   * "actionLabel": "Settings",
   * "onClick": {
   * "action": {
   * "functionName": "goToView",
   * "parameters": [
   * {
   * "key": "viewType",
   * "value": "SETTING"
   * }
   * ],
   * "loadIndicator": "LoadIndicator.SPINNER"
   * }
   * }
   * },
   * {
   * "actionLabel": "Send Feedback",
   * "onClick": {
   * "openLink": {
   * "url": "https://example.com/feedback"
   * }
   * }
   * }
   * ]
   * ```
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.apps.card.v1.Card.CardAction> getCardActionsList() {
    return cardActions_;
  }

  /**
   *
   *
   * <pre>
   * The card's actions. Actions are added to the card's toolbar menu.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   *
   * For example, the following JSON constructs a card action menu with
   * `Settings` and `Send Feedback` options:
   *
   * ```
   * "card_actions": [
   * {
   * "actionLabel": "Settings",
   * "onClick": {
   * "action": {
   * "functionName": "goToView",
   * "parameters": [
   * {
   * "key": "viewType",
   * "value": "SETTING"
   * }
   * ],
   * "loadIndicator": "LoadIndicator.SPINNER"
   * }
   * }
   * },
   * {
   * "actionLabel": "Send Feedback",
   * "onClick": {
   * "openLink": {
   * "url": "https://example.com/feedback"
   * }
   * }
   * }
   * ]
   * ```
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.apps.card.v1.Card.CardActionOrBuilder>
      getCardActionsOrBuilderList() {
    return cardActions_;
  }

  /**
   *
   *
   * <pre>
   * The card's actions. Actions are added to the card's toolbar menu.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   *
   * For example, the following JSON constructs a card action menu with
   * `Settings` and `Send Feedback` options:
   *
   * ```
   * "card_actions": [
   * {
   * "actionLabel": "Settings",
   * "onClick": {
   * "action": {
   * "functionName": "goToView",
   * "parameters": [
   * {
   * "key": "viewType",
   * "value": "SETTING"
   * }
   * ],
   * "loadIndicator": "LoadIndicator.SPINNER"
   * }
   * }
   * },
   * {
   * "actionLabel": "Send Feedback",
   * "onClick": {
   * "openLink": {
   * "url": "https://example.com/feedback"
   * }
   * }
   * }
   * ]
   * ```
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
   */
  @java.lang.Override
  public int getCardActionsCount() {
    return cardActions_.size();
  }

  /**
   *
   *
   * <pre>
   * The card's actions. Actions are added to the card's toolbar menu.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   *
   * For example, the following JSON constructs a card action menu with
   * `Settings` and `Send Feedback` options:
   *
   * ```
   * "card_actions": [
   * {
   * "actionLabel": "Settings",
   * "onClick": {
   * "action": {
   * "functionName": "goToView",
   * "parameters": [
   * {
   * "key": "viewType",
   * "value": "SETTING"
   * }
   * ],
   * "loadIndicator": "LoadIndicator.SPINNER"
   * }
   * }
   * },
   * {
   * "actionLabel": "Send Feedback",
   * "onClick": {
   * "openLink": {
   * "url": "https://example.com/feedback"
   * }
   * }
   * }
   * ]
   * ```
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Card.CardAction getCardActions(int index) {
    return cardActions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The card's actions. Actions are added to the card's toolbar menu.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   *
   * For example, the following JSON constructs a card action menu with
   * `Settings` and `Send Feedback` options:
   *
   * ```
   * "card_actions": [
   * {
   * "actionLabel": "Settings",
   * "onClick": {
   * "action": {
   * "functionName": "goToView",
   * "parameters": [
   * {
   * "key": "viewType",
   * "value": "SETTING"
   * }
   * ],
   * "loadIndicator": "LoadIndicator.SPINNER"
   * }
   * }
   * },
   * {
   * "actionLabel": "Send Feedback",
   * "onClick": {
   * "openLink": {
   * "url": "https://example.com/feedback"
   * }
   * }
   * }
   * ]
   * ```
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Card.CardActionOrBuilder getCardActionsOrBuilder(int index) {
    return cardActions_.get(index);
  }

  public static final int NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the card. Used as a card identifier in card navigation.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>string name = 4;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the card. Used as a card identifier in card navigation.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>string name = 4;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FIXED_FOOTER_FIELD_NUMBER = 5;
  private com.google.apps.card.v1.Card.CardFixedFooter fixedFooter_;

  /**
   *
   *
   * <pre>
   * The fixed footer shown at the bottom of this card.
   *
   * Setting `fixedFooter` without specifying a `primaryButton` or a
   * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
   * in
   * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
   * [card
   * messages](https://developers.google.com/workspace/chat/create-messages#create).
   *
   * [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
   *
   * @return Whether the fixedFooter field is set.
   */
  @java.lang.Override
  public boolean hasFixedFooter() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The fixed footer shown at the bottom of this card.
   *
   * Setting `fixedFooter` without specifying a `primaryButton` or a
   * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
   * in
   * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
   * [card
   * messages](https://developers.google.com/workspace/chat/create-messages#create).
   *
   * [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
   *
   * @return The fixedFooter.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Card.CardFixedFooter getFixedFooter() {
    return fixedFooter_ == null
        ? com.google.apps.card.v1.Card.CardFixedFooter.getDefaultInstance()
        : fixedFooter_;
  }

  /**
   *
   *
   * <pre>
   * The fixed footer shown at the bottom of this card.
   *
   * Setting `fixedFooter` without specifying a `primaryButton` or a
   * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
   * in
   * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
   * [card
   * messages](https://developers.google.com/workspace/chat/create-messages#create).
   *
   * [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Card.CardFixedFooterOrBuilder getFixedFooterOrBuilder() {
    return fixedFooter_ == null
        ? com.google.apps.card.v1.Card.CardFixedFooter.getDefaultInstance()
        : fixedFooter_;
  }

  public static final int DISPLAY_STYLE_FIELD_NUMBER = 6;
  private int displayStyle_ = 0;

  /**
   *
   *
   * <pre>
   * In Google Workspace add-ons, sets the display properties of the
   * `peekCardHeader`.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Card.DisplayStyle display_style = 6;</code>
   *
   * @return The enum numeric value on the wire for displayStyle.
   */
  @java.lang.Override
  public int getDisplayStyleValue() {
    return displayStyle_;
  }

  /**
   *
   *
   * <pre>
   * In Google Workspace add-ons, sets the display properties of the
   * `peekCardHeader`.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Card.DisplayStyle display_style = 6;</code>
   *
   * @return The displayStyle.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Card.DisplayStyle getDisplayStyle() {
    com.google.apps.card.v1.Card.DisplayStyle result =
        com.google.apps.card.v1.Card.DisplayStyle.forNumber(displayStyle_);
    return result == null ? com.google.apps.card.v1.Card.DisplayStyle.UNRECOGNIZED : result;
  }

  public static final int PEEK_CARD_HEADER_FIELD_NUMBER = 7;
  private com.google.apps.card.v1.Card.CardHeader peekCardHeader_;

  /**
   *
   *
   * <pre>
   * When displaying contextual content, the peek card header acts as a
   * placeholder so that the user can navigate forward between the homepage
   * cards and the contextual cards.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
   *
   * @return Whether the peekCardHeader field is set.
   */
  @java.lang.Override
  public boolean hasPeekCardHeader() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * When displaying contextual content, the peek card header acts as a
   * placeholder so that the user can navigate forward between the homepage
   * cards and the contextual cards.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
   *
   * @return The peekCardHeader.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Card.CardHeader getPeekCardHeader() {
    return peekCardHeader_ == null
        ? com.google.apps.card.v1.Card.CardHeader.getDefaultInstance()
        : peekCardHeader_;
  }

  /**
   *
   *
   * <pre>
   * When displaying contextual content, the peek card header acts as a
   * placeholder so that the user can navigate forward between the homepage
   * cards and the contextual cards.
   *
   * [Google Workspace
   * add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Card.CardHeaderOrBuilder getPeekCardHeaderOrBuilder() {
    return peekCardHeader_ == null
        ? com.google.apps.card.v1.Card.CardHeader.getDefaultInstance()
        : peekCardHeader_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getHeader());
    }
    for (int i = 0; i < sections_.size(); i++) {
      output.writeMessage(2, sections_.get(i));
    }
    for (int i = 0; i < cardActions_.size(); i++) {
      output.writeMessage(3, cardActions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 4, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getFixedFooter());
    }
    if (displayStyle_
        != com.google.apps.card.v1.Card.DisplayStyle.DISPLAY_STYLE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, displayStyle_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getPeekCardHeader());
    }
    if (sectionDividerStyle_
        != com.google.apps.card.v1.Card.DividerStyle.DIVIDER_STYLE_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, sectionDividerStyle_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getHeader());
    }
    for (int i = 0; i < sections_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, sections_.get(i));
    }
    for (int i = 0; i < cardActions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, cardActions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(4, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getFixedFooter());
    }
    if (displayStyle_
        != com.google.apps.card.v1.Card.DisplayStyle.DISPLAY_STYLE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, displayStyle_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPeekCardHeader());
    }
    if (sectionDividerStyle_
        != com.google.apps.card.v1.Card.DividerStyle.DIVIDER_STYLE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, sectionDividerStyle_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.Card)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.Card other = (com.google.apps.card.v1.Card) obj;

    if (hasHeader() != other.hasHeader()) return false;
    if (hasHeader()) {
      if (!getHeader().equals(other.getHeader())) return false;
    }
    if (!getSectionsList().equals(other.getSectionsList())) return false;
    if (sectionDividerStyle_ != other.sectionDividerStyle_) return false;
    if (!getCardActionsList().equals(other.getCardActionsList())) return false;
    if (!getName().equals(other.getName())) return false;
    if (hasFixedFooter() != other.hasFixedFooter()) return false;
    if (hasFixedFooter()) {
      if (!getFixedFooter().equals(other.getFixedFooter())) return false;
    }
    if (displayStyle_ != other.displayStyle_) return false;
    if (hasPeekCardHeader() != other.hasPeekCardHeader()) return false;
    if (hasPeekCardHeader()) {
      if (!getPeekCardHeader().equals(other.getPeekCardHeader())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasHeader()) {
      hash = (37 * hash) + HEADER_FIELD_NUMBER;
      hash = (53 * hash) + getHeader().hashCode();
    }
    if (getSectionsCount() > 0) {
      hash = (37 * hash) + SECTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSectionsList().hashCode();
    }
    hash = (37 * hash) + SECTION_DIVIDER_STYLE_FIELD_NUMBER;
    hash = (53 * hash) + sectionDividerStyle_;
    if (getCardActionsCount() > 0) {
      hash = (37 * hash) + CARD_ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getCardActionsList().hashCode();
    }
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasFixedFooter()) {
      hash = (37 * hash) + FIXED_FOOTER_FIELD_NUMBER;
      hash = (53 * hash) + getFixedFooter().hashCode();
    }
    hash = (37 * hash) + DISPLAY_STYLE_FIELD_NUMBER;
    hash = (53 * hash) + displayStyle_;
    if (hasPeekCardHeader()) {
      hash = (37 * hash) + PEEK_CARD_HEADER_FIELD_NUMBER;
      hash = (53 * hash) + getPeekCardHeader().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.Card parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Card parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Card parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Card parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Card parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Card parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Card parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Card parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Card parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Card parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Card parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Card parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.Card prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A card interface displayed in a Google Chat message or Google Workspace
   * add-on.
   *
   * Cards support a defined layout, interactive UI elements like buttons, and
   * rich media like images. Use cards to present detailed information,
   * gather information from users, and guide users to take a next step.
   *
   * [Card builder](https://addons.gsuite.google.com/uikit/builder)
   *
   * To learn how
   * to build cards, see the following documentation:
   *
   * * For Google Chat apps, see [Design the components of a card or
   * dialog](https://developers.google.com/workspace/chat/design-components-card-dialog).
   * * For Google Workspace add-ons, see [Card-based
   * interfaces](https://developers.google.com/apps-script/add-ons/concepts/cards).
   *
   * Note: You can add up to 100 widgets per card. Any widgets beyond this
   * limit are ignored. This limit applies to both card messages and dialogs
   * in Google Chat apps, and to cards in Google Workspace add-ons.
   *
   * **Example: Card message for a Google Chat app**
   *
   * ![Example contact
   * card](https://developers.google.com/workspace/chat/images/card_api_reference.png)
   *
   * To create the sample card message in Google Chat, use the following JSON:
   *
   * ```
   * {
   * "cardsV2": [
   * {
   * "cardId": "unique-card-id",
   * "card": {
   * "header": {
   * "title": "Sasha",
   * "subtitle": "Software Engineer",
   * "imageUrl":
   * "https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png",
   * "imageType": "CIRCLE",
   * "imageAltText": "Avatar for Sasha"
   * },
   * "sections": [
   * {
   * "header": "Contact Info",
   * "collapsible": true,
   * "uncollapsibleWidgetsCount": 1,
   * "widgets": [
   * {
   * "decoratedText": {
   * "startIcon": {
   * "knownIcon": "EMAIL"
   * },
   * "text": "sasha&#64;example.com"
   * }
   * },
   * {
   * "decoratedText": {
   * "startIcon": {
   * "knownIcon": "PERSON"
   * },
   * "text": "&lt;font color=&#92;"#80e27e&#92;"&gt;Online&lt;/font&gt;"
   * }
   * },
   * {
   * "decoratedText": {
   * "startIcon": {
   * "knownIcon": "PHONE"
   * },
   * "text": "+1 (555) 555-1234"
   * }
   * },
   * {
   * "buttonList": {
   * "buttons": [
   * {
   * "text": "Share",
   * "onClick": {
   * "openLink": {
   * "url": "https://example.com/share"
   * }
   * }
   * },
   * {
   * "text": "Edit",
   * "onClick": {
   * "action": {
   * "function": "goToView",
   * "parameters": [
   * {
   * "key": "viewType",
   * "value": "EDIT"
   * }
   * ]
   * }
   * }
   * }
   * ]
   * }
   * }
   * ]
   * }
   * ]
   * }
   * }
   * ]
   * }
   * ```
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Card}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Card)
      com.google.apps.card.v1.CardOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Card_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Card_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Card.class, com.google.apps.card.v1.Card.Builder.class);
    }

    // Construct using com.google.apps.card.v1.Card.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        internalGetHeaderFieldBuilder();
        internalGetSectionsFieldBuilder();
        internalGetCardActionsFieldBuilder();
        internalGetFixedFooterFieldBuilder();
        internalGetPeekCardHeaderFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      header_ = null;
      if (headerBuilder_ != null) {
        headerBuilder_.dispose();
        headerBuilder_ = null;
      }
      if (sectionsBuilder_ == null) {
        sections_ = java.util.Collections.emptyList();
      } else {
        sections_ = null;
        sectionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      sectionDividerStyle_ = 0;
      if (cardActionsBuilder_ == null) {
        cardActions_ = java.util.Collections.emptyList();
      } else {
        cardActions_ = null;
        cardActionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      name_ = "";
      fixedFooter_ = null;
      if (fixedFooterBuilder_ != null) {
        fixedFooterBuilder_.dispose();
        fixedFooterBuilder_ = null;
      }
      displayStyle_ = 0;
      peekCardHeader_ = null;
      if (peekCardHeaderBuilder_ != null) {
        peekCardHeaderBuilder_.dispose();
        peekCardHeaderBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Card_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Card getDefaultInstanceForType() {
      return com.google.apps.card.v1.Card.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.Card build() {
      com.google.apps.card.v1.Card result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Card buildPartial() {
      com.google.apps.card.v1.Card result = new com.google.apps.card.v1.Card(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.apps.card.v1.Card result) {
      if (sectionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          sections_ = java.util.Collections.unmodifiableList(sections_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.sections_ = sections_;
      } else {
        result.sections_ = sectionsBuilder_.build();
      }
      if (cardActionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          cardActions_ = java.util.Collections.unmodifiableList(cardActions_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.cardActions_ = cardActions_;
      } else {
        result.cardActions_ = cardActionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.apps.card.v1.Card result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.header_ = headerBuilder_ == null ? header_ : headerBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.sectionDividerStyle_ = sectionDividerStyle_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.fixedFooter_ =
            fixedFooterBuilder_ == null ? fixedFooter_ : fixedFooterBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.displayStyle_ = displayStyle_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.peekCardHeader_ =
            peekCardHeaderBuilder_ == null ? peekCardHeader_ : peekCardHeaderBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.Card) {
        return mergeFrom((com.google.apps.card.v1.Card) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.Card other) {
      if (other == com.google.apps.card.v1.Card.getDefaultInstance()) return this;
      if (other.hasHeader()) {
        mergeHeader(other.getHeader());
      }
      if (sectionsBuilder_ == null) {
        if (!other.sections_.isEmpty()) {
          if (sections_.isEmpty()) {
            sections_ = other.sections_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSectionsIsMutable();
            sections_.addAll(other.sections_);
          }
          onChanged();
        }
      } else {
        if (!other.sections_.isEmpty()) {
          if (sectionsBuilder_.isEmpty()) {
            sectionsBuilder_.dispose();
            sectionsBuilder_ = null;
            sections_ = other.sections_;
            bitField0_ = (bitField0_ & ~0x00000002);
            sectionsBuilder_ =
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders
                    ? internalGetSectionsFieldBuilder()
                    : null;
          } else {
            sectionsBuilder_.addAllMessages(other.sections_);
          }
        }
      }
      if (other.sectionDividerStyle_ != 0) {
        setSectionDividerStyleValue(other.getSectionDividerStyleValue());
      }
      if (cardActionsBuilder_ == null) {
        if (!other.cardActions_.isEmpty()) {
          if (cardActions_.isEmpty()) {
            cardActions_ = other.cardActions_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureCardActionsIsMutable();
            cardActions_.addAll(other.cardActions_);
          }
          onChanged();
        }
      } else {
        if (!other.cardActions_.isEmpty()) {
          if (cardActionsBuilder_.isEmpty()) {
            cardActionsBuilder_.dispose();
            cardActionsBuilder_ = null;
            cardActions_ = other.cardActions_;
            bitField0_ = (bitField0_ & ~0x00000008);
            cardActionsBuilder_ =
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders
                    ? internalGetCardActionsFieldBuilder()
                    : null;
          } else {
            cardActionsBuilder_.addAllMessages(other.cardActions_);
          }
        }
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasFixedFooter()) {
        mergeFixedFooter(other.getFixedFooter());
      }
      if (other.displayStyle_ != 0) {
        setDisplayStyleValue(other.getDisplayStyleValue());
      }
      if (other.hasPeekCardHeader()) {
        mergePeekCardHeader(other.getPeekCardHeader());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(internalGetHeaderFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.apps.card.v1.Card.Section m =
                    input.readMessage(
                        com.google.apps.card.v1.Card.Section.parser(), extensionRegistry);
                if (sectionsBuilder_ == null) {
                  ensureSectionsIsMutable();
                  sections_.add(m);
                } else {
                  sectionsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.apps.card.v1.Card.CardAction m =
                    input.readMessage(
                        com.google.apps.card.v1.Card.CardAction.parser(), extensionRegistry);
                if (cardActionsBuilder_ == null) {
                  ensureCardActionsIsMutable();
                  cardActions_.add(m);
                } else {
                  cardActionsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    internalGetFixedFooterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 48:
              {
                displayStyle_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(
                    internalGetPeekCardHeaderFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 72:
              {
                sectionDividerStyle_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.apps.card.v1.Card.CardHeader header_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.apps.card.v1.Card.CardHeader,
            com.google.apps.card.v1.Card.CardHeader.Builder,
            com.google.apps.card.v1.Card.CardHeaderOrBuilder>
        headerBuilder_;

    /**
     *
     *
     * <pre>
     * The header of the card. A header usually contains a leading image and a
     * title. Headers always appear at the top of a card.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
     *
     * @return Whether the header field is set.
     */
    public boolean hasHeader() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The header of the card. A header usually contains a leading image and a
     * title. Headers always appear at the top of a card.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
     *
     * @return The header.
     */
    public com.google.apps.card.v1.Card.CardHeader getHeader() {
      if (headerBuilder_ == null) {
        return header_ == null
            ? com.google.apps.card.v1.Card.CardHeader.getDefaultInstance()
            : header_;
      } else {
        return headerBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The header of the card. A header usually contains a leading image and a
     * title. Headers always appear at the top of a card.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
     */
    public Builder setHeader(com.google.apps.card.v1.Card.CardHeader value) {
      if (headerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        header_ = value;
      } else {
        headerBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The header of the card. A header usually contains a leading image and a
     * title. Headers always appear at the top of a card.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
     */
    public Builder setHeader(com.google.apps.card.v1.Card.CardHeader.Builder builderForValue) {
      if (headerBuilder_ == null) {
        header_ = builderForValue.build();
      } else {
        headerBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The header of the card. A header usually contains a leading image and a
     * title. Headers always appear at the top of a card.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
     */
    public Builder mergeHeader(com.google.apps.card.v1.Card.CardHeader value) {
      if (headerBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && header_ != null
            && header_ != com.google.apps.card.v1.Card.CardHeader.getDefaultInstance()) {
          getHeaderBuilder().mergeFrom(value);
        } else {
          header_ = value;
        }
      } else {
        headerBuilder_.mergeFrom(value);
      }
      if (header_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The header of the card. A header usually contains a leading image and a
     * title. Headers always appear at the top of a card.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
     */
    public Builder clearHeader() {
      bitField0_ = (bitField0_ & ~0x00000001);
      header_ = null;
      if (headerBuilder_ != null) {
        headerBuilder_.dispose();
        headerBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The header of the card. A header usually contains a leading image and a
     * title. Headers always appear at the top of a card.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
     */
    public com.google.apps.card.v1.Card.CardHeader.Builder getHeaderBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return internalGetHeaderFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The header of the card. A header usually contains a leading image and a
     * title. Headers always appear at the top of a card.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
     */
    public com.google.apps.card.v1.Card.CardHeaderOrBuilder getHeaderOrBuilder() {
      if (headerBuilder_ != null) {
        return headerBuilder_.getMessageOrBuilder();
      } else {
        return header_ == null
            ? com.google.apps.card.v1.Card.CardHeader.getDefaultInstance()
            : header_;
      }
    }

    /**
     *
     *
     * <pre>
     * The header of the card. A header usually contains a leading image and a
     * title. Headers always appear at the top of a card.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader header = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.apps.card.v1.Card.CardHeader,
            com.google.apps.card.v1.Card.CardHeader.Builder,
            com.google.apps.card.v1.Card.CardHeaderOrBuilder>
        internalGetHeaderFieldBuilder() {
      if (headerBuilder_ == null) {
        headerBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.apps.card.v1.Card.CardHeader,
                com.google.apps.card.v1.Card.CardHeader.Builder,
                com.google.apps.card.v1.Card.CardHeaderOrBuilder>(
                getHeader(), getParentForChildren(), isClean());
        header_ = null;
      }
      return headerBuilder_;
    }

    private java.util.List<com.google.apps.card.v1.Card.Section> sections_ =
        java.util.Collections.emptyList();

    private void ensureSectionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        sections_ = new java.util.ArrayList<com.google.apps.card.v1.Card.Section>(sections_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
            com.google.apps.card.v1.Card.Section,
            com.google.apps.card.v1.Card.Section.Builder,
            com.google.apps.card.v1.Card.SectionOrBuilder>
        sectionsBuilder_;

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public java.util.List<com.google.apps.card.v1.Card.Section> getSectionsList() {
      if (sectionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sections_);
      } else {
        return sectionsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public int getSectionsCount() {
      if (sectionsBuilder_ == null) {
        return sections_.size();
      } else {
        return sectionsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public com.google.apps.card.v1.Card.Section getSections(int index) {
      if (sectionsBuilder_ == null) {
        return sections_.get(index);
      } else {
        return sectionsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public Builder setSections(int index, com.google.apps.card.v1.Card.Section value) {
      if (sectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSectionsIsMutable();
        sections_.set(index, value);
        onChanged();
      } else {
        sectionsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public Builder setSections(
        int index, com.google.apps.card.v1.Card.Section.Builder builderForValue) {
      if (sectionsBuilder_ == null) {
        ensureSectionsIsMutable();
        sections_.set(index, builderForValue.build());
        onChanged();
      } else {
        sectionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public Builder addSections(com.google.apps.card.v1.Card.Section value) {
      if (sectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSectionsIsMutable();
        sections_.add(value);
        onChanged();
      } else {
        sectionsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public Builder addSections(int index, com.google.apps.card.v1.Card.Section value) {
      if (sectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSectionsIsMutable();
        sections_.add(index, value);
        onChanged();
      } else {
        sectionsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public Builder addSections(com.google.apps.card.v1.Card.Section.Builder builderForValue) {
      if (sectionsBuilder_ == null) {
        ensureSectionsIsMutable();
        sections_.add(builderForValue.build());
        onChanged();
      } else {
        sectionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public Builder addSections(
        int index, com.google.apps.card.v1.Card.Section.Builder builderForValue) {
      if (sectionsBuilder_ == null) {
        ensureSectionsIsMutable();
        sections_.add(index, builderForValue.build());
        onChanged();
      } else {
        sectionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public Builder addAllSections(
        java.lang.Iterable<? extends com.google.apps.card.v1.Card.Section> values) {
      if (sectionsBuilder_ == null) {
        ensureSectionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sections_);
        onChanged();
      } else {
        sectionsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public Builder clearSections() {
      if (sectionsBuilder_ == null) {
        sections_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        sectionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public Builder removeSections(int index) {
      if (sectionsBuilder_ == null) {
        ensureSectionsIsMutable();
        sections_.remove(index);
        onChanged();
      } else {
        sectionsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public com.google.apps.card.v1.Card.Section.Builder getSectionsBuilder(int index) {
      return internalGetSectionsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public com.google.apps.card.v1.Card.SectionOrBuilder getSectionsOrBuilder(int index) {
      if (sectionsBuilder_ == null) {
        return sections_.get(index);
      } else {
        return sectionsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public java.util.List<? extends com.google.apps.card.v1.Card.SectionOrBuilder>
        getSectionsOrBuilderList() {
      if (sectionsBuilder_ != null) {
        return sectionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sections_);
      }
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public com.google.apps.card.v1.Card.Section.Builder addSectionsBuilder() {
      return internalGetSectionsFieldBuilder()
          .addBuilder(com.google.apps.card.v1.Card.Section.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public com.google.apps.card.v1.Card.Section.Builder addSectionsBuilder(int index) {
      return internalGetSectionsFieldBuilder()
          .addBuilder(index, com.google.apps.card.v1.Card.Section.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Contains a collection of widgets. Each section has its own, optional
     * header. Sections are visually separated by a line divider. For an example
     * in Google Chat apps, see [Define a section of a
     * card](https://developers.google.com/workspace/chat/design-components-card-dialog#define_a_section_of_a_card).
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.Section sections = 2;</code>
     */
    public java.util.List<com.google.apps.card.v1.Card.Section.Builder> getSectionsBuilderList() {
      return internalGetSectionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilder<
            com.google.apps.card.v1.Card.Section,
            com.google.apps.card.v1.Card.Section.Builder,
            com.google.apps.card.v1.Card.SectionOrBuilder>
        internalGetSectionsFieldBuilder() {
      if (sectionsBuilder_ == null) {
        sectionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilder<
                com.google.apps.card.v1.Card.Section,
                com.google.apps.card.v1.Card.Section.Builder,
                com.google.apps.card.v1.Card.SectionOrBuilder>(
                sections_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        sections_ = null;
      }
      return sectionsBuilder_;
    }

    private int sectionDividerStyle_ = 0;

    /**
     *
     *
     * <pre>
     * The divider style between the header, sections and footer.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.DividerStyle section_divider_style = 9;</code>
     *
     * @return The enum numeric value on the wire for sectionDividerStyle.
     */
    @java.lang.Override
    public int getSectionDividerStyleValue() {
      return sectionDividerStyle_;
    }

    /**
     *
     *
     * <pre>
     * The divider style between the header, sections and footer.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.DividerStyle section_divider_style = 9;</code>
     *
     * @param value The enum numeric value on the wire for sectionDividerStyle to set.
     * @return This builder for chaining.
     */
    public Builder setSectionDividerStyleValue(int value) {
      sectionDividerStyle_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The divider style between the header, sections and footer.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.DividerStyle section_divider_style = 9;</code>
     *
     * @return The sectionDividerStyle.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Card.DividerStyle getSectionDividerStyle() {
      com.google.apps.card.v1.Card.DividerStyle result =
          com.google.apps.card.v1.Card.DividerStyle.forNumber(sectionDividerStyle_);
      return result == null ? com.google.apps.card.v1.Card.DividerStyle.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * The divider style between the header, sections and footer.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.DividerStyle section_divider_style = 9;</code>
     *
     * @param value The sectionDividerStyle to set.
     * @return This builder for chaining.
     */
    public Builder setSectionDividerStyle(com.google.apps.card.v1.Card.DividerStyle value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      sectionDividerStyle_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The divider style between the header, sections and footer.
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.DividerStyle section_divider_style = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSectionDividerStyle() {
      bitField0_ = (bitField0_ & ~0x00000004);
      sectionDividerStyle_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.apps.card.v1.Card.CardAction> cardActions_ =
        java.util.Collections.emptyList();

    private void ensureCardActionsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        cardActions_ =
            new java.util.ArrayList<com.google.apps.card.v1.Card.CardAction>(cardActions_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
            com.google.apps.card.v1.Card.CardAction,
            com.google.apps.card.v1.Card.CardAction.Builder,
            com.google.apps.card.v1.Card.CardActionOrBuilder>
        cardActionsBuilder_;

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public java.util.List<com.google.apps.card.v1.Card.CardAction> getCardActionsList() {
      if (cardActionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(cardActions_);
      } else {
        return cardActionsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public int getCardActionsCount() {
      if (cardActionsBuilder_ == null) {
        return cardActions_.size();
      } else {
        return cardActionsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public com.google.apps.card.v1.Card.CardAction getCardActions(int index) {
      if (cardActionsBuilder_ == null) {
        return cardActions_.get(index);
      } else {
        return cardActionsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public Builder setCardActions(int index, com.google.apps.card.v1.Card.CardAction value) {
      if (cardActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCardActionsIsMutable();
        cardActions_.set(index, value);
        onChanged();
      } else {
        cardActionsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public Builder setCardActions(
        int index, com.google.apps.card.v1.Card.CardAction.Builder builderForValue) {
      if (cardActionsBuilder_ == null) {
        ensureCardActionsIsMutable();
        cardActions_.set(index, builderForValue.build());
        onChanged();
      } else {
        cardActionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public Builder addCardActions(com.google.apps.card.v1.Card.CardAction value) {
      if (cardActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCardActionsIsMutable();
        cardActions_.add(value);
        onChanged();
      } else {
        cardActionsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public Builder addCardActions(int index, com.google.apps.card.v1.Card.CardAction value) {
      if (cardActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCardActionsIsMutable();
        cardActions_.add(index, value);
        onChanged();
      } else {
        cardActionsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public Builder addCardActions(com.google.apps.card.v1.Card.CardAction.Builder builderForValue) {
      if (cardActionsBuilder_ == null) {
        ensureCardActionsIsMutable();
        cardActions_.add(builderForValue.build());
        onChanged();
      } else {
        cardActionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public Builder addCardActions(
        int index, com.google.apps.card.v1.Card.CardAction.Builder builderForValue) {
      if (cardActionsBuilder_ == null) {
        ensureCardActionsIsMutable();
        cardActions_.add(index, builderForValue.build());
        onChanged();
      } else {
        cardActionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public Builder addAllCardActions(
        java.lang.Iterable<? extends com.google.apps.card.v1.Card.CardAction> values) {
      if (cardActionsBuilder_ == null) {
        ensureCardActionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cardActions_);
        onChanged();
      } else {
        cardActionsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public Builder clearCardActions() {
      if (cardActionsBuilder_ == null) {
        cardActions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        cardActionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public Builder removeCardActions(int index) {
      if (cardActionsBuilder_ == null) {
        ensureCardActionsIsMutable();
        cardActions_.remove(index);
        onChanged();
      } else {
        cardActionsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public com.google.apps.card.v1.Card.CardAction.Builder getCardActionsBuilder(int index) {
      return internalGetCardActionsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public com.google.apps.card.v1.Card.CardActionOrBuilder getCardActionsOrBuilder(int index) {
      if (cardActionsBuilder_ == null) {
        return cardActions_.get(index);
      } else {
        return cardActionsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public java.util.List<? extends com.google.apps.card.v1.Card.CardActionOrBuilder>
        getCardActionsOrBuilderList() {
      if (cardActionsBuilder_ != null) {
        return cardActionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(cardActions_);
      }
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public com.google.apps.card.v1.Card.CardAction.Builder addCardActionsBuilder() {
      return internalGetCardActionsFieldBuilder()
          .addBuilder(com.google.apps.card.v1.Card.CardAction.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public com.google.apps.card.v1.Card.CardAction.Builder addCardActionsBuilder(int index) {
      return internalGetCardActionsFieldBuilder()
          .addBuilder(index, com.google.apps.card.v1.Card.CardAction.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The card's actions. Actions are added to the card's toolbar menu.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     *
     * For example, the following JSON constructs a card action menu with
     * `Settings` and `Send Feedback` options:
     *
     * ```
     * "card_actions": [
     * {
     * "actionLabel": "Settings",
     * "onClick": {
     * "action": {
     * "functionName": "goToView",
     * "parameters": [
     * {
     * "key": "viewType",
     * "value": "SETTING"
     * }
     * ],
     * "loadIndicator": "LoadIndicator.SPINNER"
     * }
     * }
     * },
     * {
     * "actionLabel": "Send Feedback",
     * "onClick": {
     * "openLink": {
     * "url": "https://example.com/feedback"
     * }
     * }
     * }
     * ]
     * ```
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.CardAction card_actions = 3;</code>
     */
    public java.util.List<com.google.apps.card.v1.Card.CardAction.Builder>
        getCardActionsBuilderList() {
      return internalGetCardActionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilder<
            com.google.apps.card.v1.Card.CardAction,
            com.google.apps.card.v1.Card.CardAction.Builder,
            com.google.apps.card.v1.Card.CardActionOrBuilder>
        internalGetCardActionsFieldBuilder() {
      if (cardActionsBuilder_ == null) {
        cardActionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilder<
                com.google.apps.card.v1.Card.CardAction,
                com.google.apps.card.v1.Card.CardAction.Builder,
                com.google.apps.card.v1.Card.CardActionOrBuilder>(
                cardActions_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        cardActions_ = null;
      }
      return cardActionsBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the card. Used as a card identifier in card navigation.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the card. Used as a card identifier in card navigation.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the card. Used as a card identifier in card navigation.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the card. Used as a card identifier in card navigation.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the card. Used as a card identifier in card navigation.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.apps.card.v1.Card.CardFixedFooter fixedFooter_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.apps.card.v1.Card.CardFixedFooter,
            com.google.apps.card.v1.Card.CardFixedFooter.Builder,
            com.google.apps.card.v1.Card.CardFixedFooterOrBuilder>
        fixedFooterBuilder_;

    /**
     *
     *
     * <pre>
     * The fixed footer shown at the bottom of this card.
     *
     * Setting `fixedFooter` without specifying a `primaryButton` or a
     * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
     * in
     * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     * [card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
     *
     * @return Whether the fixedFooter field is set.
     */
    public boolean hasFixedFooter() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The fixed footer shown at the bottom of this card.
     *
     * Setting `fixedFooter` without specifying a `primaryButton` or a
     * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
     * in
     * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     * [card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
     *
     * @return The fixedFooter.
     */
    public com.google.apps.card.v1.Card.CardFixedFooter getFixedFooter() {
      if (fixedFooterBuilder_ == null) {
        return fixedFooter_ == null
            ? com.google.apps.card.v1.Card.CardFixedFooter.getDefaultInstance()
            : fixedFooter_;
      } else {
        return fixedFooterBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The fixed footer shown at the bottom of this card.
     *
     * Setting `fixedFooter` without specifying a `primaryButton` or a
     * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
     * in
     * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     * [card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
     */
    public Builder setFixedFooter(com.google.apps.card.v1.Card.CardFixedFooter value) {
      if (fixedFooterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fixedFooter_ = value;
      } else {
        fixedFooterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fixed footer shown at the bottom of this card.
     *
     * Setting `fixedFooter` without specifying a `primaryButton` or a
     * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
     * in
     * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     * [card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
     */
    public Builder setFixedFooter(
        com.google.apps.card.v1.Card.CardFixedFooter.Builder builderForValue) {
      if (fixedFooterBuilder_ == null) {
        fixedFooter_ = builderForValue.build();
      } else {
        fixedFooterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fixed footer shown at the bottom of this card.
     *
     * Setting `fixedFooter` without specifying a `primaryButton` or a
     * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
     * in
     * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     * [card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
     */
    public Builder mergeFixedFooter(com.google.apps.card.v1.Card.CardFixedFooter value) {
      if (fixedFooterBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && fixedFooter_ != null
            && fixedFooter_ != com.google.apps.card.v1.Card.CardFixedFooter.getDefaultInstance()) {
          getFixedFooterBuilder().mergeFrom(value);
        } else {
          fixedFooter_ = value;
        }
      } else {
        fixedFooterBuilder_.mergeFrom(value);
      }
      if (fixedFooter_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fixed footer shown at the bottom of this card.
     *
     * Setting `fixedFooter` without specifying a `primaryButton` or a
     * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
     * in
     * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     * [card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
     */
    public Builder clearFixedFooter() {
      bitField0_ = (bitField0_ & ~0x00000020);
      fixedFooter_ = null;
      if (fixedFooterBuilder_ != null) {
        fixedFooterBuilder_.dispose();
        fixedFooterBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fixed footer shown at the bottom of this card.
     *
     * Setting `fixedFooter` without specifying a `primaryButton` or a
     * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
     * in
     * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     * [card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
     */
    public com.google.apps.card.v1.Card.CardFixedFooter.Builder getFixedFooterBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return internalGetFixedFooterFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The fixed footer shown at the bottom of this card.
     *
     * Setting `fixedFooter` without specifying a `primaryButton` or a
     * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
     * in
     * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     * [card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
     */
    public com.google.apps.card.v1.Card.CardFixedFooterOrBuilder getFixedFooterOrBuilder() {
      if (fixedFooterBuilder_ != null) {
        return fixedFooterBuilder_.getMessageOrBuilder();
      } else {
        return fixedFooter_ == null
            ? com.google.apps.card.v1.Card.CardFixedFooter.getDefaultInstance()
            : fixedFooter_;
      }
    }

    /**
     *
     *
     * <pre>
     * The fixed footer shown at the bottom of this card.
     *
     * Setting `fixedFooter` without specifying a `primaryButton` or a
     * `secondaryButton` causes an error. For Chat apps, you can use fixed footers
     * in
     * [dialogs](https://developers.google.com/workspace/chat/dialogs), but not
     * [card
     * messages](https://developers.google.com/workspace/chat/create-messages#create).
     *
     * [Google Workspace add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardFixedFooter fixed_footer = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.apps.card.v1.Card.CardFixedFooter,
            com.google.apps.card.v1.Card.CardFixedFooter.Builder,
            com.google.apps.card.v1.Card.CardFixedFooterOrBuilder>
        internalGetFixedFooterFieldBuilder() {
      if (fixedFooterBuilder_ == null) {
        fixedFooterBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.apps.card.v1.Card.CardFixedFooter,
                com.google.apps.card.v1.Card.CardFixedFooter.Builder,
                com.google.apps.card.v1.Card.CardFixedFooterOrBuilder>(
                getFixedFooter(), getParentForChildren(), isClean());
        fixedFooter_ = null;
      }
      return fixedFooterBuilder_;
    }

    private int displayStyle_ = 0;

    /**
     *
     *
     * <pre>
     * In Google Workspace add-ons, sets the display properties of the
     * `peekCardHeader`.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.DisplayStyle display_style = 6;</code>
     *
     * @return The enum numeric value on the wire for displayStyle.
     */
    @java.lang.Override
    public int getDisplayStyleValue() {
      return displayStyle_;
    }

    /**
     *
     *
     * <pre>
     * In Google Workspace add-ons, sets the display properties of the
     * `peekCardHeader`.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.DisplayStyle display_style = 6;</code>
     *
     * @param value The enum numeric value on the wire for displayStyle to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayStyleValue(int value) {
      displayStyle_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * In Google Workspace add-ons, sets the display properties of the
     * `peekCardHeader`.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.DisplayStyle display_style = 6;</code>
     *
     * @return The displayStyle.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Card.DisplayStyle getDisplayStyle() {
      com.google.apps.card.v1.Card.DisplayStyle result =
          com.google.apps.card.v1.Card.DisplayStyle.forNumber(displayStyle_);
      return result == null ? com.google.apps.card.v1.Card.DisplayStyle.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * In Google Workspace add-ons, sets the display properties of the
     * `peekCardHeader`.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.DisplayStyle display_style = 6;</code>
     *
     * @param value The displayStyle to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayStyle(com.google.apps.card.v1.Card.DisplayStyle value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      displayStyle_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * In Google Workspace add-ons, sets the display properties of the
     * `peekCardHeader`.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.DisplayStyle display_style = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayStyle() {
      bitField0_ = (bitField0_ & ~0x00000040);
      displayStyle_ = 0;
      onChanged();
      return this;
    }

    private com.google.apps.card.v1.Card.CardHeader peekCardHeader_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.apps.card.v1.Card.CardHeader,
            com.google.apps.card.v1.Card.CardHeader.Builder,
            com.google.apps.card.v1.Card.CardHeaderOrBuilder>
        peekCardHeaderBuilder_;

    /**
     *
     *
     * <pre>
     * When displaying contextual content, the peek card header acts as a
     * placeholder so that the user can navigate forward between the homepage
     * cards and the contextual cards.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
     *
     * @return Whether the peekCardHeader field is set.
     */
    public boolean hasPeekCardHeader() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * When displaying contextual content, the peek card header acts as a
     * placeholder so that the user can navigate forward between the homepage
     * cards and the contextual cards.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
     *
     * @return The peekCardHeader.
     */
    public com.google.apps.card.v1.Card.CardHeader getPeekCardHeader() {
      if (peekCardHeaderBuilder_ == null) {
        return peekCardHeader_ == null
            ? com.google.apps.card.v1.Card.CardHeader.getDefaultInstance()
            : peekCardHeader_;
      } else {
        return peekCardHeaderBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * When displaying contextual content, the peek card header acts as a
     * placeholder so that the user can navigate forward between the homepage
     * cards and the contextual cards.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
     */
    public Builder setPeekCardHeader(com.google.apps.card.v1.Card.CardHeader value) {
      if (peekCardHeaderBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        peekCardHeader_ = value;
      } else {
        peekCardHeaderBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When displaying contextual content, the peek card header acts as a
     * placeholder so that the user can navigate forward between the homepage
     * cards and the contextual cards.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
     */
    public Builder setPeekCardHeader(
        com.google.apps.card.v1.Card.CardHeader.Builder builderForValue) {
      if (peekCardHeaderBuilder_ == null) {
        peekCardHeader_ = builderForValue.build();
      } else {
        peekCardHeaderBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When displaying contextual content, the peek card header acts as a
     * placeholder so that the user can navigate forward between the homepage
     * cards and the contextual cards.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
     */
    public Builder mergePeekCardHeader(com.google.apps.card.v1.Card.CardHeader value) {
      if (peekCardHeaderBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && peekCardHeader_ != null
            && peekCardHeader_ != com.google.apps.card.v1.Card.CardHeader.getDefaultInstance()) {
          getPeekCardHeaderBuilder().mergeFrom(value);
        } else {
          peekCardHeader_ = value;
        }
      } else {
        peekCardHeaderBuilder_.mergeFrom(value);
      }
      if (peekCardHeader_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * When displaying contextual content, the peek card header acts as a
     * placeholder so that the user can navigate forward between the homepage
     * cards and the contextual cards.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
     */
    public Builder clearPeekCardHeader() {
      bitField0_ = (bitField0_ & ~0x00000080);
      peekCardHeader_ = null;
      if (peekCardHeaderBuilder_ != null) {
        peekCardHeaderBuilder_.dispose();
        peekCardHeaderBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When displaying contextual content, the peek card header acts as a
     * placeholder so that the user can navigate forward between the homepage
     * cards and the contextual cards.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
     */
    public com.google.apps.card.v1.Card.CardHeader.Builder getPeekCardHeaderBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return internalGetPeekCardHeaderFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * When displaying contextual content, the peek card header acts as a
     * placeholder so that the user can navigate forward between the homepage
     * cards and the contextual cards.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
     */
    public com.google.apps.card.v1.Card.CardHeaderOrBuilder getPeekCardHeaderOrBuilder() {
      if (peekCardHeaderBuilder_ != null) {
        return peekCardHeaderBuilder_.getMessageOrBuilder();
      } else {
        return peekCardHeader_ == null
            ? com.google.apps.card.v1.Card.CardHeader.getDefaultInstance()
            : peekCardHeader_;
      }
    }

    /**
     *
     *
     * <pre>
     * When displaying contextual content, the peek card header acts as a
     * placeholder so that the user can navigate forward between the homepage
     * cards and the contextual cards.
     *
     * [Google Workspace
     * add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card.CardHeader peek_card_header = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.apps.card.v1.Card.CardHeader,
            com.google.apps.card.v1.Card.CardHeader.Builder,
            com.google.apps.card.v1.Card.CardHeaderOrBuilder>
        internalGetPeekCardHeaderFieldBuilder() {
      if (peekCardHeaderBuilder_ == null) {
        peekCardHeaderBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.apps.card.v1.Card.CardHeader,
                com.google.apps.card.v1.Card.CardHeader.Builder,
                com.google.apps.card.v1.Card.CardHeaderOrBuilder>(
                getPeekCardHeader(), getParentForChildren(), isClean());
        peekCardHeader_ = null;
      }
      return peekCardHeaderBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Card)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.Card)
  private static final com.google.apps.card.v1.Card DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.Card();
  }

  public static com.google.apps.card.v1.Card getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Card> PARSER =
      new com.google.protobuf.AbstractParser<Card>() {
        @java.lang.Override
        public Card parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Card> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Card> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.Card getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
