/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: google/api/client.proto
// Protobuf Java Version: 4.33.2

package com.google.api;

/**
 *
 *
 * <pre>
 * Settings for Python client libraries.
 * </pre>
 *
 * Protobuf type {@code google.api.PythonSettings}
 */
@com.google.protobuf.Generated
public final class PythonSettings extends com.google.protobuf.GeneratedMessage
    implements
    // @@protoc_insertion_point(message_implements:google.api.PythonSettings)
    PythonSettingsOrBuilder {
  private static final long serialVersionUID = 0L;

  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 33,
        /* patch= */ 2,
        /* suffix= */ "",
        "PythonSettings");
  }

  // Use PythonSettings.newBuilder() to construct.
  private PythonSettings(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }

  private PythonSettings() {}

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.ClientProto.internal_static_google_api_PythonSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.ClientProto.internal_static_google_api_PythonSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.PythonSettings.class, com.google.api.PythonSettings.Builder.class);
  }

  public interface ExperimentalFeaturesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.api.PythonSettings.ExperimentalFeatures)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Enables generation of asynchronous REST clients if `rest` transport is
     * enabled. By default, asynchronous REST clients will not be generated.
     * This feature will be enabled by default 1 month after launching the
     * feature in preview packages.
     * </pre>
     *
     * <code>bool rest_async_io_enabled = 1;</code>
     *
     * @return The restAsyncIoEnabled.
     */
    boolean getRestAsyncIoEnabled();

    /**
     *
     *
     * <pre>
     * Enables generation of protobuf code using new types that are more
     * Pythonic which are included in `protobuf&gt;=5.29.x`. This feature will be
     * enabled by default 1 month after launching the feature in preview
     * packages.
     * </pre>
     *
     * <code>bool protobuf_pythonic_types_enabled = 2;</code>
     *
     * @return The protobufPythonicTypesEnabled.
     */
    boolean getProtobufPythonicTypesEnabled();

    /**
     *
     *
     * <pre>
     * Disables generation of an unversioned Python package for this client
     * library. This means that the module names will need to be versioned in
     * import statements. For example `import google.cloud.library_v2` instead
     * of `import google.cloud.library`.
     * </pre>
     *
     * <code>bool unversioned_package_disabled = 3;</code>
     *
     * @return The unversionedPackageDisabled.
     */
    boolean getUnversionedPackageDisabled();
  }

  /**
   *
   *
   * <pre>
   * Experimental features to be included during client library generation.
   * These fields will be deprecated once the feature graduates and is enabled
   * by default.
   * </pre>
   *
   * Protobuf type {@code google.api.PythonSettings.ExperimentalFeatures}
   */
  public static final class ExperimentalFeatures extends com.google.protobuf.GeneratedMessage
      implements
      // @@protoc_insertion_point(message_implements:google.api.PythonSettings.ExperimentalFeatures)
      ExperimentalFeaturesOrBuilder {
    private static final long serialVersionUID = 0L;

    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 33,
          /* patch= */ 2,
          /* suffix= */ "",
          "ExperimentalFeatures");
    }

    // Use ExperimentalFeatures.newBuilder() to construct.
    private ExperimentalFeatures(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }

    private ExperimentalFeatures() {}

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.ClientProto
          .internal_static_google_api_PythonSettings_ExperimentalFeatures_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.ClientProto
          .internal_static_google_api_PythonSettings_ExperimentalFeatures_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.PythonSettings.ExperimentalFeatures.class,
              com.google.api.PythonSettings.ExperimentalFeatures.Builder.class);
    }

    public static final int REST_ASYNC_IO_ENABLED_FIELD_NUMBER = 1;
    private boolean restAsyncIoEnabled_ = false;

    /**
     *
     *
     * <pre>
     * Enables generation of asynchronous REST clients if `rest` transport is
     * enabled. By default, asynchronous REST clients will not be generated.
     * This feature will be enabled by default 1 month after launching the
     * feature in preview packages.
     * </pre>
     *
     * <code>bool rest_async_io_enabled = 1;</code>
     *
     * @return The restAsyncIoEnabled.
     */
    @java.lang.Override
    public boolean getRestAsyncIoEnabled() {
      return restAsyncIoEnabled_;
    }

    public static final int PROTOBUF_PYTHONIC_TYPES_ENABLED_FIELD_NUMBER = 2;
    private boolean protobufPythonicTypesEnabled_ = false;

    /**
     *
     *
     * <pre>
     * Enables generation of protobuf code using new types that are more
     * Pythonic which are included in `protobuf&gt;=5.29.x`. This feature will be
     * enabled by default 1 month after launching the feature in preview
     * packages.
     * </pre>
     *
     * <code>bool protobuf_pythonic_types_enabled = 2;</code>
     *
     * @return The protobufPythonicTypesEnabled.
     */
    @java.lang.Override
    public boolean getProtobufPythonicTypesEnabled() {
      return protobufPythonicTypesEnabled_;
    }

    public static final int UNVERSIONED_PACKAGE_DISABLED_FIELD_NUMBER = 3;
    private boolean unversionedPackageDisabled_ = false;

    /**
     *
     *
     * <pre>
     * Disables generation of an unversioned Python package for this client
     * library. This means that the module names will need to be versioned in
     * import statements. For example `import google.cloud.library_v2` instead
     * of `import google.cloud.library`.
     * </pre>
     *
     * <code>bool unversioned_package_disabled = 3;</code>
     *
     * @return The unversionedPackageDisabled.
     */
    @java.lang.Override
    public boolean getUnversionedPackageDisabled() {
      return unversionedPackageDisabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (restAsyncIoEnabled_ != false) {
        output.writeBool(1, restAsyncIoEnabled_);
      }
      if (protobufPythonicTypesEnabled_ != false) {
        output.writeBool(2, protobufPythonicTypesEnabled_);
      }
      if (unversionedPackageDisabled_ != false) {
        output.writeBool(3, unversionedPackageDisabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (restAsyncIoEnabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, restAsyncIoEnabled_);
      }
      if (protobufPythonicTypesEnabled_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(2, protobufPythonicTypesEnabled_);
      }
      if (unversionedPackageDisabled_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(3, unversionedPackageDisabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.api.PythonSettings.ExperimentalFeatures)) {
        return super.equals(obj);
      }
      com.google.api.PythonSettings.ExperimentalFeatures other =
          (com.google.api.PythonSettings.ExperimentalFeatures) obj;

      if (getRestAsyncIoEnabled() != other.getRestAsyncIoEnabled()) return false;
      if (getProtobufPythonicTypesEnabled() != other.getProtobufPythonicTypesEnabled())
        return false;
      if (getUnversionedPackageDisabled() != other.getUnversionedPackageDisabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REST_ASYNC_IO_ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRestAsyncIoEnabled());
      hash = (37 * hash) + PROTOBUF_PYTHONIC_TYPES_ENABLED_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getProtobufPythonicTypesEnabled());
      hash = (37 * hash) + UNVERSIONED_PACKAGE_DISABLED_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUnversionedPackageDisabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.api.PythonSettings.ExperimentalFeatures parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.PythonSettings.ExperimentalFeatures parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.PythonSettings.ExperimentalFeatures parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.PythonSettings.ExperimentalFeatures parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.PythonSettings.ExperimentalFeatures parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.PythonSettings.ExperimentalFeatures parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.PythonSettings.ExperimentalFeatures parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.api.PythonSettings.ExperimentalFeatures parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.api.PythonSettings.ExperimentalFeatures parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.api.PythonSettings.ExperimentalFeatures parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.api.PythonSettings.ExperimentalFeatures parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static com.google.api.PythonSettings.ExperimentalFeatures parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.api.PythonSettings.ExperimentalFeatures prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Experimental features to be included during client library generation.
     * These fields will be deprecated once the feature graduates and is enabled
     * by default.
     * </pre>
     *
     * Protobuf type {@code google.api.PythonSettings.ExperimentalFeatures}
     */
    public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.api.PythonSettings.ExperimentalFeatures)
        com.google.api.PythonSettings.ExperimentalFeaturesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.api.ClientProto
            .internal_static_google_api_PythonSettings_ExperimentalFeatures_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.ClientProto
            .internal_static_google_api_PythonSettings_ExperimentalFeatures_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.api.PythonSettings.ExperimentalFeatures.class,
                com.google.api.PythonSettings.ExperimentalFeatures.Builder.class);
      }

      // Construct using com.google.api.PythonSettings.ExperimentalFeatures.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        restAsyncIoEnabled_ = false;
        protobufPythonicTypesEnabled_ = false;
        unversionedPackageDisabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.api.ClientProto
            .internal_static_google_api_PythonSettings_ExperimentalFeatures_descriptor;
      }

      @java.lang.Override
      public com.google.api.PythonSettings.ExperimentalFeatures getDefaultInstanceForType() {
        return com.google.api.PythonSettings.ExperimentalFeatures.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.api.PythonSettings.ExperimentalFeatures build() {
        com.google.api.PythonSettings.ExperimentalFeatures result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.api.PythonSettings.ExperimentalFeatures buildPartial() {
        com.google.api.PythonSettings.ExperimentalFeatures result =
            new com.google.api.PythonSettings.ExperimentalFeatures(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.api.PythonSettings.ExperimentalFeatures result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.restAsyncIoEnabled_ = restAsyncIoEnabled_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.protobufPythonicTypesEnabled_ = protobufPythonicTypesEnabled_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.unversionedPackageDisabled_ = unversionedPackageDisabled_;
        }
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.api.PythonSettings.ExperimentalFeatures) {
          return mergeFrom((com.google.api.PythonSettings.ExperimentalFeatures) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.api.PythonSettings.ExperimentalFeatures other) {
        if (other == com.google.api.PythonSettings.ExperimentalFeatures.getDefaultInstance())
          return this;
        if (other.getRestAsyncIoEnabled() != false) {
          setRestAsyncIoEnabled(other.getRestAsyncIoEnabled());
        }
        if (other.getProtobufPythonicTypesEnabled() != false) {
          setProtobufPythonicTypesEnabled(other.getProtobufPythonicTypesEnabled());
        }
        if (other.getUnversionedPackageDisabled() != false) {
          setUnversionedPackageDisabled(other.getUnversionedPackageDisabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  restAsyncIoEnabled_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  protobufPythonicTypesEnabled_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  unversionedPackageDisabled_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean restAsyncIoEnabled_;

      /**
       *
       *
       * <pre>
       * Enables generation of asynchronous REST clients if `rest` transport is
       * enabled. By default, asynchronous REST clients will not be generated.
       * This feature will be enabled by default 1 month after launching the
       * feature in preview packages.
       * </pre>
       *
       * <code>bool rest_async_io_enabled = 1;</code>
       *
       * @return The restAsyncIoEnabled.
       */
      @java.lang.Override
      public boolean getRestAsyncIoEnabled() {
        return restAsyncIoEnabled_;
      }

      /**
       *
       *
       * <pre>
       * Enables generation of asynchronous REST clients if `rest` transport is
       * enabled. By default, asynchronous REST clients will not be generated.
       * This feature will be enabled by default 1 month after launching the
       * feature in preview packages.
       * </pre>
       *
       * <code>bool rest_async_io_enabled = 1;</code>
       *
       * @param value The restAsyncIoEnabled to set.
       * @return This builder for chaining.
       */
      public Builder setRestAsyncIoEnabled(boolean value) {

        restAsyncIoEnabled_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Enables generation of asynchronous REST clients if `rest` transport is
       * enabled. By default, asynchronous REST clients will not be generated.
       * This feature will be enabled by default 1 month after launching the
       * feature in preview packages.
       * </pre>
       *
       * <code>bool rest_async_io_enabled = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRestAsyncIoEnabled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        restAsyncIoEnabled_ = false;
        onChanged();
        return this;
      }

      private boolean protobufPythonicTypesEnabled_;

      /**
       *
       *
       * <pre>
       * Enables generation of protobuf code using new types that are more
       * Pythonic which are included in `protobuf&gt;=5.29.x`. This feature will be
       * enabled by default 1 month after launching the feature in preview
       * packages.
       * </pre>
       *
       * <code>bool protobuf_pythonic_types_enabled = 2;</code>
       *
       * @return The protobufPythonicTypesEnabled.
       */
      @java.lang.Override
      public boolean getProtobufPythonicTypesEnabled() {
        return protobufPythonicTypesEnabled_;
      }

      /**
       *
       *
       * <pre>
       * Enables generation of protobuf code using new types that are more
       * Pythonic which are included in `protobuf&gt;=5.29.x`. This feature will be
       * enabled by default 1 month after launching the feature in preview
       * packages.
       * </pre>
       *
       * <code>bool protobuf_pythonic_types_enabled = 2;</code>
       *
       * @param value The protobufPythonicTypesEnabled to set.
       * @return This builder for chaining.
       */
      public Builder setProtobufPythonicTypesEnabled(boolean value) {

        protobufPythonicTypesEnabled_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Enables generation of protobuf code using new types that are more
       * Pythonic which are included in `protobuf&gt;=5.29.x`. This feature will be
       * enabled by default 1 month after launching the feature in preview
       * packages.
       * </pre>
       *
       * <code>bool protobuf_pythonic_types_enabled = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProtobufPythonicTypesEnabled() {
        bitField0_ = (bitField0_ & ~0x00000002);
        protobufPythonicTypesEnabled_ = false;
        onChanged();
        return this;
      }

      private boolean unversionedPackageDisabled_;

      /**
       *
       *
       * <pre>
       * Disables generation of an unversioned Python package for this client
       * library. This means that the module names will need to be versioned in
       * import statements. For example `import google.cloud.library_v2` instead
       * of `import google.cloud.library`.
       * </pre>
       *
       * <code>bool unversioned_package_disabled = 3;</code>
       *
       * @return The unversionedPackageDisabled.
       */
      @java.lang.Override
      public boolean getUnversionedPackageDisabled() {
        return unversionedPackageDisabled_;
      }

      /**
       *
       *
       * <pre>
       * Disables generation of an unversioned Python package for this client
       * library. This means that the module names will need to be versioned in
       * import statements. For example `import google.cloud.library_v2` instead
       * of `import google.cloud.library`.
       * </pre>
       *
       * <code>bool unversioned_package_disabled = 3;</code>
       *
       * @param value The unversionedPackageDisabled to set.
       * @return This builder for chaining.
       */
      public Builder setUnversionedPackageDisabled(boolean value) {

        unversionedPackageDisabled_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Disables generation of an unversioned Python package for this client
       * library. This means that the module names will need to be versioned in
       * import statements. For example `import google.cloud.library_v2` instead
       * of `import google.cloud.library`.
       * </pre>
       *
       * <code>bool unversioned_package_disabled = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUnversionedPackageDisabled() {
        bitField0_ = (bitField0_ & ~0x00000004);
        unversionedPackageDisabled_ = false;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:google.api.PythonSettings.ExperimentalFeatures)
    }

    // @@protoc_insertion_point(class_scope:google.api.PythonSettings.ExperimentalFeatures)
    private static final com.google.api.PythonSettings.ExperimentalFeatures DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.api.PythonSettings.ExperimentalFeatures();
    }

    public static com.google.api.PythonSettings.ExperimentalFeatures getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExperimentalFeatures> PARSER =
        new com.google.protobuf.AbstractParser<ExperimentalFeatures>() {
          @java.lang.Override
          public ExperimentalFeatures parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExperimentalFeatures> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExperimentalFeatures> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.api.PythonSettings.ExperimentalFeatures getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int COMMON_FIELD_NUMBER = 1;
  private com.google.api.CommonLanguageSettings common_;

  /**
   *
   *
   * <pre>
   * Some settings.
   * </pre>
   *
   * <code>.google.api.CommonLanguageSettings common = 1;</code>
   *
   * @return Whether the common field is set.
   */
  @java.lang.Override
  public boolean hasCommon() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Some settings.
   * </pre>
   *
   * <code>.google.api.CommonLanguageSettings common = 1;</code>
   *
   * @return The common.
   */
  @java.lang.Override
  public com.google.api.CommonLanguageSettings getCommon() {
    return common_ == null ? com.google.api.CommonLanguageSettings.getDefaultInstance() : common_;
  }

  /**
   *
   *
   * <pre>
   * Some settings.
   * </pre>
   *
   * <code>.google.api.CommonLanguageSettings common = 1;</code>
   */
  @java.lang.Override
  public com.google.api.CommonLanguageSettingsOrBuilder getCommonOrBuilder() {
    return common_ == null ? com.google.api.CommonLanguageSettings.getDefaultInstance() : common_;
  }

  public static final int EXPERIMENTAL_FEATURES_FIELD_NUMBER = 2;
  private com.google.api.PythonSettings.ExperimentalFeatures experimentalFeatures_;

  /**
   *
   *
   * <pre>
   * Experimental features to be included during client library generation.
   * </pre>
   *
   * <code>.google.api.PythonSettings.ExperimentalFeatures experimental_features = 2;</code>
   *
   * @return Whether the experimentalFeatures field is set.
   */
  @java.lang.Override
  public boolean hasExperimentalFeatures() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Experimental features to be included during client library generation.
   * </pre>
   *
   * <code>.google.api.PythonSettings.ExperimentalFeatures experimental_features = 2;</code>
   *
   * @return The experimentalFeatures.
   */
  @java.lang.Override
  public com.google.api.PythonSettings.ExperimentalFeatures getExperimentalFeatures() {
    return experimentalFeatures_ == null
        ? com.google.api.PythonSettings.ExperimentalFeatures.getDefaultInstance()
        : experimentalFeatures_;
  }

  /**
   *
   *
   * <pre>
   * Experimental features to be included during client library generation.
   * </pre>
   *
   * <code>.google.api.PythonSettings.ExperimentalFeatures experimental_features = 2;</code>
   */
  @java.lang.Override
  public com.google.api.PythonSettings.ExperimentalFeaturesOrBuilder
      getExperimentalFeaturesOrBuilder() {
    return experimentalFeatures_ == null
        ? com.google.api.PythonSettings.ExperimentalFeatures.getDefaultInstance()
        : experimentalFeatures_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCommon());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getExperimentalFeatures());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCommon());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, getExperimentalFeatures());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.PythonSettings)) {
      return super.equals(obj);
    }
    com.google.api.PythonSettings other = (com.google.api.PythonSettings) obj;

    if (hasCommon() != other.hasCommon()) return false;
    if (hasCommon()) {
      if (!getCommon().equals(other.getCommon())) return false;
    }
    if (hasExperimentalFeatures() != other.hasExperimentalFeatures()) return false;
    if (hasExperimentalFeatures()) {
      if (!getExperimentalFeatures().equals(other.getExperimentalFeatures())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCommon()) {
      hash = (37 * hash) + COMMON_FIELD_NUMBER;
      hash = (53 * hash) + getCommon().hashCode();
    }
    if (hasExperimentalFeatures()) {
      hash = (37 * hash) + EXPERIMENTAL_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getExperimentalFeatures().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.PythonSettings parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.PythonSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.PythonSettings parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.PythonSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.PythonSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.PythonSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.PythonSettings parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.api.PythonSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.PythonSettings parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.PythonSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.PythonSettings parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(PARSER, input);
  }

  public static com.google.api.PythonSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.PythonSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Settings for Python client libraries.
   * </pre>
   *
   * Protobuf type {@code google.api.PythonSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessage.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.PythonSettings)
      com.google.api.PythonSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.ClientProto.internal_static_google_api_PythonSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.ClientProto.internal_static_google_api_PythonSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.PythonSettings.class, com.google.api.PythonSettings.Builder.class);
    }

    // Construct using com.google.api.PythonSettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        internalGetCommonFieldBuilder();
        internalGetExperimentalFeaturesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      common_ = null;
      if (commonBuilder_ != null) {
        commonBuilder_.dispose();
        commonBuilder_ = null;
      }
      experimentalFeatures_ = null;
      if (experimentalFeaturesBuilder_ != null) {
        experimentalFeaturesBuilder_.dispose();
        experimentalFeaturesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.ClientProto.internal_static_google_api_PythonSettings_descriptor;
    }

    @java.lang.Override
    public com.google.api.PythonSettings getDefaultInstanceForType() {
      return com.google.api.PythonSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.PythonSettings build() {
      com.google.api.PythonSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.PythonSettings buildPartial() {
      com.google.api.PythonSettings result = new com.google.api.PythonSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.api.PythonSettings result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.common_ = commonBuilder_ == null ? common_ : commonBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.experimentalFeatures_ =
            experimentalFeaturesBuilder_ == null
                ? experimentalFeatures_
                : experimentalFeaturesBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.PythonSettings) {
        return mergeFrom((com.google.api.PythonSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.PythonSettings other) {
      if (other == com.google.api.PythonSettings.getDefaultInstance()) return this;
      if (other.hasCommon()) {
        mergeCommon(other.getCommon());
      }
      if (other.hasExperimentalFeatures()) {
        mergeExperimentalFeatures(other.getExperimentalFeatures());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(internalGetCommonFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    internalGetExperimentalFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.api.CommonLanguageSettings common_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.api.CommonLanguageSettings,
            com.google.api.CommonLanguageSettings.Builder,
            com.google.api.CommonLanguageSettingsOrBuilder>
        commonBuilder_;

    /**
     *
     *
     * <pre>
     * Some settings.
     * </pre>
     *
     * <code>.google.api.CommonLanguageSettings common = 1;</code>
     *
     * @return Whether the common field is set.
     */
    public boolean hasCommon() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Some settings.
     * </pre>
     *
     * <code>.google.api.CommonLanguageSettings common = 1;</code>
     *
     * @return The common.
     */
    public com.google.api.CommonLanguageSettings getCommon() {
      if (commonBuilder_ == null) {
        return common_ == null
            ? com.google.api.CommonLanguageSettings.getDefaultInstance()
            : common_;
      } else {
        return commonBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Some settings.
     * </pre>
     *
     * <code>.google.api.CommonLanguageSettings common = 1;</code>
     */
    public Builder setCommon(com.google.api.CommonLanguageSettings value) {
      if (commonBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        common_ = value;
      } else {
        commonBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Some settings.
     * </pre>
     *
     * <code>.google.api.CommonLanguageSettings common = 1;</code>
     */
    public Builder setCommon(com.google.api.CommonLanguageSettings.Builder builderForValue) {
      if (commonBuilder_ == null) {
        common_ = builderForValue.build();
      } else {
        commonBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Some settings.
     * </pre>
     *
     * <code>.google.api.CommonLanguageSettings common = 1;</code>
     */
    public Builder mergeCommon(com.google.api.CommonLanguageSettings value) {
      if (commonBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && common_ != null
            && common_ != com.google.api.CommonLanguageSettings.getDefaultInstance()) {
          getCommonBuilder().mergeFrom(value);
        } else {
          common_ = value;
        }
      } else {
        commonBuilder_.mergeFrom(value);
      }
      if (common_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Some settings.
     * </pre>
     *
     * <code>.google.api.CommonLanguageSettings common = 1;</code>
     */
    public Builder clearCommon() {
      bitField0_ = (bitField0_ & ~0x00000001);
      common_ = null;
      if (commonBuilder_ != null) {
        commonBuilder_.dispose();
        commonBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Some settings.
     * </pre>
     *
     * <code>.google.api.CommonLanguageSettings common = 1;</code>
     */
    public com.google.api.CommonLanguageSettings.Builder getCommonBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return internalGetCommonFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Some settings.
     * </pre>
     *
     * <code>.google.api.CommonLanguageSettings common = 1;</code>
     */
    public com.google.api.CommonLanguageSettingsOrBuilder getCommonOrBuilder() {
      if (commonBuilder_ != null) {
        return commonBuilder_.getMessageOrBuilder();
      } else {
        return common_ == null
            ? com.google.api.CommonLanguageSettings.getDefaultInstance()
            : common_;
      }
    }

    /**
     *
     *
     * <pre>
     * Some settings.
     * </pre>
     *
     * <code>.google.api.CommonLanguageSettings common = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.api.CommonLanguageSettings,
            com.google.api.CommonLanguageSettings.Builder,
            com.google.api.CommonLanguageSettingsOrBuilder>
        internalGetCommonFieldBuilder() {
      if (commonBuilder_ == null) {
        commonBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.api.CommonLanguageSettings,
                com.google.api.CommonLanguageSettings.Builder,
                com.google.api.CommonLanguageSettingsOrBuilder>(
                getCommon(), getParentForChildren(), isClean());
        common_ = null;
      }
      return commonBuilder_;
    }

    private com.google.api.PythonSettings.ExperimentalFeatures experimentalFeatures_;
    private com.google.protobuf.SingleFieldBuilder<
            com.google.api.PythonSettings.ExperimentalFeatures,
            com.google.api.PythonSettings.ExperimentalFeatures.Builder,
            com.google.api.PythonSettings.ExperimentalFeaturesOrBuilder>
        experimentalFeaturesBuilder_;

    /**
     *
     *
     * <pre>
     * Experimental features to be included during client library generation.
     * </pre>
     *
     * <code>.google.api.PythonSettings.ExperimentalFeatures experimental_features = 2;</code>
     *
     * @return Whether the experimentalFeatures field is set.
     */
    public boolean hasExperimentalFeatures() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Experimental features to be included during client library generation.
     * </pre>
     *
     * <code>.google.api.PythonSettings.ExperimentalFeatures experimental_features = 2;</code>
     *
     * @return The experimentalFeatures.
     */
    public com.google.api.PythonSettings.ExperimentalFeatures getExperimentalFeatures() {
      if (experimentalFeaturesBuilder_ == null) {
        return experimentalFeatures_ == null
            ? com.google.api.PythonSettings.ExperimentalFeatures.getDefaultInstance()
            : experimentalFeatures_;
      } else {
        return experimentalFeaturesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Experimental features to be included during client library generation.
     * </pre>
     *
     * <code>.google.api.PythonSettings.ExperimentalFeatures experimental_features = 2;</code>
     */
    public Builder setExperimentalFeatures(
        com.google.api.PythonSettings.ExperimentalFeatures value) {
      if (experimentalFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        experimentalFeatures_ = value;
      } else {
        experimentalFeaturesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Experimental features to be included during client library generation.
     * </pre>
     *
     * <code>.google.api.PythonSettings.ExperimentalFeatures experimental_features = 2;</code>
     */
    public Builder setExperimentalFeatures(
        com.google.api.PythonSettings.ExperimentalFeatures.Builder builderForValue) {
      if (experimentalFeaturesBuilder_ == null) {
        experimentalFeatures_ = builderForValue.build();
      } else {
        experimentalFeaturesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Experimental features to be included during client library generation.
     * </pre>
     *
     * <code>.google.api.PythonSettings.ExperimentalFeatures experimental_features = 2;</code>
     */
    public Builder mergeExperimentalFeatures(
        com.google.api.PythonSettings.ExperimentalFeatures value) {
      if (experimentalFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && experimentalFeatures_ != null
            && experimentalFeatures_
                != com.google.api.PythonSettings.ExperimentalFeatures.getDefaultInstance()) {
          getExperimentalFeaturesBuilder().mergeFrom(value);
        } else {
          experimentalFeatures_ = value;
        }
      } else {
        experimentalFeaturesBuilder_.mergeFrom(value);
      }
      if (experimentalFeatures_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Experimental features to be included during client library generation.
     * </pre>
     *
     * <code>.google.api.PythonSettings.ExperimentalFeatures experimental_features = 2;</code>
     */
    public Builder clearExperimentalFeatures() {
      bitField0_ = (bitField0_ & ~0x00000002);
      experimentalFeatures_ = null;
      if (experimentalFeaturesBuilder_ != null) {
        experimentalFeaturesBuilder_.dispose();
        experimentalFeaturesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Experimental features to be included during client library generation.
     * </pre>
     *
     * <code>.google.api.PythonSettings.ExperimentalFeatures experimental_features = 2;</code>
     */
    public com.google.api.PythonSettings.ExperimentalFeatures.Builder
        getExperimentalFeaturesBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return internalGetExperimentalFeaturesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Experimental features to be included during client library generation.
     * </pre>
     *
     * <code>.google.api.PythonSettings.ExperimentalFeatures experimental_features = 2;</code>
     */
    public com.google.api.PythonSettings.ExperimentalFeaturesOrBuilder
        getExperimentalFeaturesOrBuilder() {
      if (experimentalFeaturesBuilder_ != null) {
        return experimentalFeaturesBuilder_.getMessageOrBuilder();
      } else {
        return experimentalFeatures_ == null
            ? com.google.api.PythonSettings.ExperimentalFeatures.getDefaultInstance()
            : experimentalFeatures_;
      }
    }

    /**
     *
     *
     * <pre>
     * Experimental features to be included during client library generation.
     * </pre>
     *
     * <code>.google.api.PythonSettings.ExperimentalFeatures experimental_features = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
            com.google.api.PythonSettings.ExperimentalFeatures,
            com.google.api.PythonSettings.ExperimentalFeatures.Builder,
            com.google.api.PythonSettings.ExperimentalFeaturesOrBuilder>
        internalGetExperimentalFeaturesFieldBuilder() {
      if (experimentalFeaturesBuilder_ == null) {
        experimentalFeaturesBuilder_ =
            new com.google.protobuf.SingleFieldBuilder<
                com.google.api.PythonSettings.ExperimentalFeatures,
                com.google.api.PythonSettings.ExperimentalFeatures.Builder,
                com.google.api.PythonSettings.ExperimentalFeaturesOrBuilder>(
                getExperimentalFeatures(), getParentForChildren(), isClean());
        experimentalFeatures_ = null;
      }
      return experimentalFeaturesBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:google.api.PythonSettings)
  }

  // @@protoc_insertion_point(class_scope:google.api.PythonSettings)
  private static final com.google.api.PythonSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.PythonSettings();
  }

  public static com.google.api.PythonSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PythonSettings> PARSER =
      new com.google.protobuf.AbstractParser<PythonSettings>() {
        @java.lang.Override
        public PythonSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PythonSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PythonSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.PythonSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
