/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/audit/audit_log.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.audit;

/**
 *
 *
 * <pre>
 * Common audit log format for Google Cloud Platform API operations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.audit.AuditLog}
 */
public final class AuditLog extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.audit.AuditLog)
    AuditLogOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AuditLog.newBuilder() to construct.
  private AuditLog(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AuditLog() {
    serviceName_ = "";
    methodName_ = "";
    resourceName_ = "";
    authorizationInfo_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AuditLog();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.audit.AuditLogProto
        .internal_static_google_cloud_audit_AuditLog_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.audit.AuditLogProto
        .internal_static_google_cloud_audit_AuditLog_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.audit.AuditLog.class, com.google.cloud.audit.AuditLog.Builder.class);
  }

  private int bitField0_;
  public static final int SERVICE_NAME_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceName_ = "";
  /**
   *
   *
   * <pre>
   * The name of the API service performing the operation. For example,
   * `"compute.googleapis.com"`.
   * </pre>
   *
   * <code>string service_name = 7;</code>
   *
   * @return The serviceName.
   */
  @java.lang.Override
  public java.lang.String getServiceName() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the API service performing the operation. For example,
   * `"compute.googleapis.com"`.
   * </pre>
   *
   * <code>string service_name = 7;</code>
   *
   * @return The bytes for serviceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceNameBytes() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METHOD_NAME_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object methodName_ = "";
  /**
   *
   *
   * <pre>
   * The name of the service method or operation.
   * For API calls, this should be the name of the API method.
   * For example,
   *
   *     "google.cloud.bigquery.v2.TableService.InsertTable"
   *     "google.logging.v2.ConfigServiceV2.CreateSink"
   * </pre>
   *
   * <code>string method_name = 8;</code>
   *
   * @return The methodName.
   */
  @java.lang.Override
  public java.lang.String getMethodName() {
    java.lang.Object ref = methodName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      methodName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the service method or operation.
   * For API calls, this should be the name of the API method.
   * For example,
   *
   *     "google.cloud.bigquery.v2.TableService.InsertTable"
   *     "google.logging.v2.ConfigServiceV2.CreateSink"
   * </pre>
   *
   * <code>string method_name = 8;</code>
   *
   * @return The bytes for methodName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMethodNameBytes() {
    java.lang.Object ref = methodName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      methodName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   *
   *
   * <pre>
   * The resource or collection that is the target of the operation.
   * The name is a scheme-less URI, not including the API service name.
   * For example:
   *
   *     "projects/PROJECT_ID/zones/us-central1-a/instances"
   *     "projects/PROJECT_ID/datasets/DATASET_ID"
   * </pre>
   *
   * <code>string resource_name = 11;</code>
   *
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource or collection that is the target of the operation.
   * The name is a scheme-less URI, not including the API service name.
   * For example:
   *
   *     "projects/PROJECT_ID/zones/us-central1-a/instances"
   *     "projects/PROJECT_ID/datasets/DATASET_ID"
   * </pre>
   *
   * <code>string resource_name = 11;</code>
   *
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_LOCATION_FIELD_NUMBER = 20;
  private com.google.cloud.audit.ResourceLocation resourceLocation_;
  /**
   *
   *
   * <pre>
   * The resource location information.
   * </pre>
   *
   * <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
   *
   * @return Whether the resourceLocation field is set.
   */
  @java.lang.Override
  public boolean hasResourceLocation() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The resource location information.
   * </pre>
   *
   * <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
   *
   * @return The resourceLocation.
   */
  @java.lang.Override
  public com.google.cloud.audit.ResourceLocation getResourceLocation() {
    return resourceLocation_ == null
        ? com.google.cloud.audit.ResourceLocation.getDefaultInstance()
        : resourceLocation_;
  }
  /**
   *
   *
   * <pre>
   * The resource location information.
   * </pre>
   *
   * <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
   */
  @java.lang.Override
  public com.google.cloud.audit.ResourceLocationOrBuilder getResourceLocationOrBuilder() {
    return resourceLocation_ == null
        ? com.google.cloud.audit.ResourceLocation.getDefaultInstance()
        : resourceLocation_;
  }

  public static final int RESOURCE_ORIGINAL_STATE_FIELD_NUMBER = 19;
  private com.google.protobuf.Struct resourceOriginalState_;
  /**
   *
   *
   * <pre>
   * The resource's original state before mutation. Present only for
   * operations which have successfully modified the targeted resource(s).
   * In general, this field should contain all changed fields, except those
   * that are already been included in `request`, `response`, `metadata` or
   * `service_data` fields.
   * When the JSON object represented here has a proto equivalent,
   * the proto name will be indicated in the `&#64;type` property.
   * </pre>
   *
   * <code>.google.protobuf.Struct resource_original_state = 19;</code>
   *
   * @return Whether the resourceOriginalState field is set.
   */
  @java.lang.Override
  public boolean hasResourceOriginalState() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The resource's original state before mutation. Present only for
   * operations which have successfully modified the targeted resource(s).
   * In general, this field should contain all changed fields, except those
   * that are already been included in `request`, `response`, `metadata` or
   * `service_data` fields.
   * When the JSON object represented here has a proto equivalent,
   * the proto name will be indicated in the `&#64;type` property.
   * </pre>
   *
   * <code>.google.protobuf.Struct resource_original_state = 19;</code>
   *
   * @return The resourceOriginalState.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getResourceOriginalState() {
    return resourceOriginalState_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : resourceOriginalState_;
  }
  /**
   *
   *
   * <pre>
   * The resource's original state before mutation. Present only for
   * operations which have successfully modified the targeted resource(s).
   * In general, this field should contain all changed fields, except those
   * that are already been included in `request`, `response`, `metadata` or
   * `service_data` fields.
   * When the JSON object represented here has a proto equivalent,
   * the proto name will be indicated in the `&#64;type` property.
   * </pre>
   *
   * <code>.google.protobuf.Struct resource_original_state = 19;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getResourceOriginalStateOrBuilder() {
    return resourceOriginalState_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : resourceOriginalState_;
  }

  public static final int NUM_RESPONSE_ITEMS_FIELD_NUMBER = 12;
  private long numResponseItems_ = 0L;
  /**
   *
   *
   * <pre>
   * The number of items returned from a List or Query API method,
   * if applicable.
   * </pre>
   *
   * <code>int64 num_response_items = 12;</code>
   *
   * @return The numResponseItems.
   */
  @java.lang.Override
  public long getNumResponseItems() {
    return numResponseItems_;
  }

  public static final int STATUS_FIELD_NUMBER = 2;
  private com.google.rpc.Status status_;
  /**
   *
   *
   * <pre>
   * The status of the overall operation.
   * </pre>
   *
   * <code>.google.rpc.Status status = 2;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The status of the overall operation.
   * </pre>
   *
   * <code>.google.rpc.Status status = 2;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.rpc.Status getStatus() {
    return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
  }
  /**
   *
   *
   * <pre>
   * The status of the overall operation.
   * </pre>
   *
   * <code>.google.rpc.Status status = 2;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
    return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
  }

  public static final int AUTHENTICATION_INFO_FIELD_NUMBER = 3;
  private com.google.cloud.audit.AuthenticationInfo authenticationInfo_;
  /**
   *
   *
   * <pre>
   * Authentication information.
   * </pre>
   *
   * <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
   *
   * @return Whether the authenticationInfo field is set.
   */
  @java.lang.Override
  public boolean hasAuthenticationInfo() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Authentication information.
   * </pre>
   *
   * <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
   *
   * @return The authenticationInfo.
   */
  @java.lang.Override
  public com.google.cloud.audit.AuthenticationInfo getAuthenticationInfo() {
    return authenticationInfo_ == null
        ? com.google.cloud.audit.AuthenticationInfo.getDefaultInstance()
        : authenticationInfo_;
  }
  /**
   *
   *
   * <pre>
   * Authentication information.
   * </pre>
   *
   * <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.audit.AuthenticationInfoOrBuilder getAuthenticationInfoOrBuilder() {
    return authenticationInfo_ == null
        ? com.google.cloud.audit.AuthenticationInfo.getDefaultInstance()
        : authenticationInfo_;
  }

  public static final int AUTHORIZATION_INFO_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.audit.AuthorizationInfo> authorizationInfo_;
  /**
   *
   *
   * <pre>
   * Authorization information. If there are multiple
   * resources or permissions involved, then there is
   * one AuthorizationInfo element for each {resource, permission} tuple.
   * </pre>
   *
   * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.audit.AuthorizationInfo> getAuthorizationInfoList() {
    return authorizationInfo_;
  }
  /**
   *
   *
   * <pre>
   * Authorization information. If there are multiple
   * resources or permissions involved, then there is
   * one AuthorizationInfo element for each {resource, permission} tuple.
   * </pre>
   *
   * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.audit.AuthorizationInfoOrBuilder>
      getAuthorizationInfoOrBuilderList() {
    return authorizationInfo_;
  }
  /**
   *
   *
   * <pre>
   * Authorization information. If there are multiple
   * resources or permissions involved, then there is
   * one AuthorizationInfo element for each {resource, permission} tuple.
   * </pre>
   *
   * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
   */
  @java.lang.Override
  public int getAuthorizationInfoCount() {
    return authorizationInfo_.size();
  }
  /**
   *
   *
   * <pre>
   * Authorization information. If there are multiple
   * resources or permissions involved, then there is
   * one AuthorizationInfo element for each {resource, permission} tuple.
   * </pre>
   *
   * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.audit.AuthorizationInfo getAuthorizationInfo(int index) {
    return authorizationInfo_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Authorization information. If there are multiple
   * resources or permissions involved, then there is
   * one AuthorizationInfo element for each {resource, permission} tuple.
   * </pre>
   *
   * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.audit.AuthorizationInfoOrBuilder getAuthorizationInfoOrBuilder(
      int index) {
    return authorizationInfo_.get(index);
  }

  public static final int POLICY_VIOLATION_INFO_FIELD_NUMBER = 25;
  private com.google.cloud.audit.PolicyViolationInfo policyViolationInfo_;
  /**
   *
   *
   * <pre>
   * Indicates the policy violations for this request. If the request
   * is denied by the policy, violation information will be logged
   * here.
   * </pre>
   *
   * <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
   *
   * @return Whether the policyViolationInfo field is set.
   */
  @java.lang.Override
  public boolean hasPolicyViolationInfo() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Indicates the policy violations for this request. If the request
   * is denied by the policy, violation information will be logged
   * here.
   * </pre>
   *
   * <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
   *
   * @return The policyViolationInfo.
   */
  @java.lang.Override
  public com.google.cloud.audit.PolicyViolationInfo getPolicyViolationInfo() {
    return policyViolationInfo_ == null
        ? com.google.cloud.audit.PolicyViolationInfo.getDefaultInstance()
        : policyViolationInfo_;
  }
  /**
   *
   *
   * <pre>
   * Indicates the policy violations for this request. If the request
   * is denied by the policy, violation information will be logged
   * here.
   * </pre>
   *
   * <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
   */
  @java.lang.Override
  public com.google.cloud.audit.PolicyViolationInfoOrBuilder getPolicyViolationInfoOrBuilder() {
    return policyViolationInfo_ == null
        ? com.google.cloud.audit.PolicyViolationInfo.getDefaultInstance()
        : policyViolationInfo_;
  }

  public static final int REQUEST_METADATA_FIELD_NUMBER = 4;
  private com.google.cloud.audit.RequestMetadata requestMetadata_;
  /**
   *
   *
   * <pre>
   * Metadata about the operation.
   * </pre>
   *
   * <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
   *
   * @return Whether the requestMetadata field is set.
   */
  @java.lang.Override
  public boolean hasRequestMetadata() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Metadata about the operation.
   * </pre>
   *
   * <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
   *
   * @return The requestMetadata.
   */
  @java.lang.Override
  public com.google.cloud.audit.RequestMetadata getRequestMetadata() {
    return requestMetadata_ == null
        ? com.google.cloud.audit.RequestMetadata.getDefaultInstance()
        : requestMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Metadata about the operation.
   * </pre>
   *
   * <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.audit.RequestMetadataOrBuilder getRequestMetadataOrBuilder() {
    return requestMetadata_ == null
        ? com.google.cloud.audit.RequestMetadata.getDefaultInstance()
        : requestMetadata_;
  }

  public static final int REQUEST_FIELD_NUMBER = 16;
  private com.google.protobuf.Struct request_;
  /**
   *
   *
   * <pre>
   * The operation request. This may not include all request parameters,
   * such as those that are too large, privacy-sensitive, or duplicated
   * elsewhere in the log record.
   * It should never include user-generated data, such as file contents.
   * When the JSON object represented here has a proto equivalent, the proto
   * name will be indicated in the `&#64;type` property.
   * </pre>
   *
   * <code>.google.protobuf.Struct request = 16;</code>
   *
   * @return Whether the request field is set.
   */
  @java.lang.Override
  public boolean hasRequest() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The operation request. This may not include all request parameters,
   * such as those that are too large, privacy-sensitive, or duplicated
   * elsewhere in the log record.
   * It should never include user-generated data, such as file contents.
   * When the JSON object represented here has a proto equivalent, the proto
   * name will be indicated in the `&#64;type` property.
   * </pre>
   *
   * <code>.google.protobuf.Struct request = 16;</code>
   *
   * @return The request.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getRequest() {
    return request_ == null ? com.google.protobuf.Struct.getDefaultInstance() : request_;
  }
  /**
   *
   *
   * <pre>
   * The operation request. This may not include all request parameters,
   * such as those that are too large, privacy-sensitive, or duplicated
   * elsewhere in the log record.
   * It should never include user-generated data, such as file contents.
   * When the JSON object represented here has a proto equivalent, the proto
   * name will be indicated in the `&#64;type` property.
   * </pre>
   *
   * <code>.google.protobuf.Struct request = 16;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getRequestOrBuilder() {
    return request_ == null ? com.google.protobuf.Struct.getDefaultInstance() : request_;
  }

  public static final int RESPONSE_FIELD_NUMBER = 17;
  private com.google.protobuf.Struct response_;
  /**
   *
   *
   * <pre>
   * The operation response. This may not include all response elements,
   * such as those that are too large, privacy-sensitive, or duplicated
   * elsewhere in the log record.
   * It should never include user-generated data, such as file contents.
   * When the JSON object represented here has a proto equivalent, the proto
   * name will be indicated in the `&#64;type` property.
   * </pre>
   *
   * <code>.google.protobuf.Struct response = 17;</code>
   *
   * @return Whether the response field is set.
   */
  @java.lang.Override
  public boolean hasResponse() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * The operation response. This may not include all response elements,
   * such as those that are too large, privacy-sensitive, or duplicated
   * elsewhere in the log record.
   * It should never include user-generated data, such as file contents.
   * When the JSON object represented here has a proto equivalent, the proto
   * name will be indicated in the `&#64;type` property.
   * </pre>
   *
   * <code>.google.protobuf.Struct response = 17;</code>
   *
   * @return The response.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getResponse() {
    return response_ == null ? com.google.protobuf.Struct.getDefaultInstance() : response_;
  }
  /**
   *
   *
   * <pre>
   * The operation response. This may not include all response elements,
   * such as those that are too large, privacy-sensitive, or duplicated
   * elsewhere in the log record.
   * It should never include user-generated data, such as file contents.
   * When the JSON object represented here has a proto equivalent, the proto
   * name will be indicated in the `&#64;type` property.
   * </pre>
   *
   * <code>.google.protobuf.Struct response = 17;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getResponseOrBuilder() {
    return response_ == null ? com.google.protobuf.Struct.getDefaultInstance() : response_;
  }

  public static final int METADATA_FIELD_NUMBER = 18;
  private com.google.protobuf.Struct metadata_;
  /**
   *
   *
   * <pre>
   * Other service-specific data about the request, response, and other
   * information associated with the current audited event.
   * </pre>
   *
   * <code>.google.protobuf.Struct metadata = 18;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Other service-specific data about the request, response, and other
   * information associated with the current audited event.
   * </pre>
   *
   * <code>.google.protobuf.Struct metadata = 18;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getMetadata() {
    return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Other service-specific data about the request, response, and other
   * information associated with the current audited event.
   * </pre>
   *
   * <code>.google.protobuf.Struct metadata = 18;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getMetadataOrBuilder() {
    return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
  }

  public static final int SERVICE_DATA_FIELD_NUMBER = 15;
  private com.google.protobuf.Any serviceData_;
  /**
   *
   *
   * <pre>
   * Deprecated. Use the `metadata` field instead.
   * Other service-specific data about the request, response, and other
   * activities.
   * </pre>
   *
   * <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
   *
   * @deprecated google.cloud.audit.AuditLog.service_data is deprecated. See
   *     google/cloud/audit/audit_log.proto;l=110
   * @return Whether the serviceData field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasServiceData() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Deprecated. Use the `metadata` field instead.
   * Other service-specific data about the request, response, and other
   * activities.
   * </pre>
   *
   * <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
   *
   * @deprecated google.cloud.audit.AuditLog.service_data is deprecated. See
   *     google/cloud/audit/audit_log.proto;l=110
   * @return The serviceData.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.Any getServiceData() {
    return serviceData_ == null ? com.google.protobuf.Any.getDefaultInstance() : serviceData_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated. Use the `metadata` field instead.
   * Other service-specific data about the request, response, and other
   * activities.
   * </pre>
   *
   * <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.AnyOrBuilder getServiceDataOrBuilder() {
    return serviceData_ == null ? com.google.protobuf.Any.getDefaultInstance() : serviceData_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(2, getStatus());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(3, getAuthenticationInfo());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(4, getRequestMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, serviceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(methodName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, methodName_);
    }
    for (int i = 0; i < authorizationInfo_.size(); i++) {
      output.writeMessage(9, authorizationInfo_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, resourceName_);
    }
    if (numResponseItems_ != 0L) {
      output.writeInt64(12, numResponseItems_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeMessage(15, getServiceData());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(16, getRequest());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(17, getResponse());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(18, getMetadata());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(19, getResourceOriginalState());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(20, getResourceLocation());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(25, getPolicyViolationInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStatus());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAuthenticationInfo());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRequestMetadata());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, serviceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(methodName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, methodName_);
    }
    for (int i = 0; i < authorizationInfo_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(9, authorizationInfo_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, resourceName_);
    }
    if (numResponseItems_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(12, numResponseItems_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getServiceData());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getRequest());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getResponse());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getMetadata());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(19, getResourceOriginalState());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getResourceLocation());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(25, getPolicyViolationInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.audit.AuditLog)) {
      return super.equals(obj);
    }
    com.google.cloud.audit.AuditLog other = (com.google.cloud.audit.AuditLog) obj;

    if (!getServiceName().equals(other.getServiceName())) return false;
    if (!getMethodName().equals(other.getMethodName())) return false;
    if (!getResourceName().equals(other.getResourceName())) return false;
    if (hasResourceLocation() != other.hasResourceLocation()) return false;
    if (hasResourceLocation()) {
      if (!getResourceLocation().equals(other.getResourceLocation())) return false;
    }
    if (hasResourceOriginalState() != other.hasResourceOriginalState()) return false;
    if (hasResourceOriginalState()) {
      if (!getResourceOriginalState().equals(other.getResourceOriginalState())) return false;
    }
    if (getNumResponseItems() != other.getNumResponseItems()) return false;
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasAuthenticationInfo() != other.hasAuthenticationInfo()) return false;
    if (hasAuthenticationInfo()) {
      if (!getAuthenticationInfo().equals(other.getAuthenticationInfo())) return false;
    }
    if (!getAuthorizationInfoList().equals(other.getAuthorizationInfoList())) return false;
    if (hasPolicyViolationInfo() != other.hasPolicyViolationInfo()) return false;
    if (hasPolicyViolationInfo()) {
      if (!getPolicyViolationInfo().equals(other.getPolicyViolationInfo())) return false;
    }
    if (hasRequestMetadata() != other.hasRequestMetadata()) return false;
    if (hasRequestMetadata()) {
      if (!getRequestMetadata().equals(other.getRequestMetadata())) return false;
    }
    if (hasRequest() != other.hasRequest()) return false;
    if (hasRequest()) {
      if (!getRequest().equals(other.getRequest())) return false;
    }
    if (hasResponse() != other.hasResponse()) return false;
    if (hasResponse()) {
      if (!getResponse().equals(other.getResponse())) return false;
    }
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (hasServiceData() != other.hasServiceData()) return false;
    if (hasServiceData()) {
      if (!getServiceData().equals(other.getServiceData())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getServiceName().hashCode();
    hash = (37 * hash) + METHOD_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getMethodName().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    if (hasResourceLocation()) {
      hash = (37 * hash) + RESOURCE_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getResourceLocation().hashCode();
    }
    if (hasResourceOriginalState()) {
      hash = (37 * hash) + RESOURCE_ORIGINAL_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getResourceOriginalState().hashCode();
    }
    hash = (37 * hash) + NUM_RESPONSE_ITEMS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getNumResponseItems());
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasAuthenticationInfo()) {
      hash = (37 * hash) + AUTHENTICATION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getAuthenticationInfo().hashCode();
    }
    if (getAuthorizationInfoCount() > 0) {
      hash = (37 * hash) + AUTHORIZATION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getAuthorizationInfoList().hashCode();
    }
    if (hasPolicyViolationInfo()) {
      hash = (37 * hash) + POLICY_VIOLATION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getPolicyViolationInfo().hashCode();
    }
    if (hasRequestMetadata()) {
      hash = (37 * hash) + REQUEST_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getRequestMetadata().hashCode();
    }
    if (hasRequest()) {
      hash = (37 * hash) + REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getRequest().hashCode();
    }
    if (hasResponse()) {
      hash = (37 * hash) + RESPONSE_FIELD_NUMBER;
      hash = (53 * hash) + getResponse().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (hasServiceData()) {
      hash = (37 * hash) + SERVICE_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getServiceData().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.audit.AuditLog parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.audit.AuditLog parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.audit.AuditLog parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.audit.AuditLog parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.audit.AuditLog parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.audit.AuditLog parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.audit.AuditLog parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.audit.AuditLog parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.audit.AuditLog parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.audit.AuditLog parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.audit.AuditLog parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.audit.AuditLog parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.audit.AuditLog prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Common audit log format for Google Cloud Platform API operations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.audit.AuditLog}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.audit.AuditLog)
      com.google.cloud.audit.AuditLogOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_AuditLog_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_AuditLog_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.audit.AuditLog.class, com.google.cloud.audit.AuditLog.Builder.class);
    }

    // Construct using com.google.cloud.audit.AuditLog.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResourceLocationFieldBuilder();
        getResourceOriginalStateFieldBuilder();
        getStatusFieldBuilder();
        getAuthenticationInfoFieldBuilder();
        getAuthorizationInfoFieldBuilder();
        getPolicyViolationInfoFieldBuilder();
        getRequestMetadataFieldBuilder();
        getRequestFieldBuilder();
        getResponseFieldBuilder();
        getMetadataFieldBuilder();
        getServiceDataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      serviceName_ = "";
      methodName_ = "";
      resourceName_ = "";
      resourceLocation_ = null;
      if (resourceLocationBuilder_ != null) {
        resourceLocationBuilder_.dispose();
        resourceLocationBuilder_ = null;
      }
      resourceOriginalState_ = null;
      if (resourceOriginalStateBuilder_ != null) {
        resourceOriginalStateBuilder_.dispose();
        resourceOriginalStateBuilder_ = null;
      }
      numResponseItems_ = 0L;
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      authenticationInfo_ = null;
      if (authenticationInfoBuilder_ != null) {
        authenticationInfoBuilder_.dispose();
        authenticationInfoBuilder_ = null;
      }
      if (authorizationInfoBuilder_ == null) {
        authorizationInfo_ = java.util.Collections.emptyList();
      } else {
        authorizationInfo_ = null;
        authorizationInfoBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      policyViolationInfo_ = null;
      if (policyViolationInfoBuilder_ != null) {
        policyViolationInfoBuilder_.dispose();
        policyViolationInfoBuilder_ = null;
      }
      requestMetadata_ = null;
      if (requestMetadataBuilder_ != null) {
        requestMetadataBuilder_.dispose();
        requestMetadataBuilder_ = null;
      }
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      response_ = null;
      if (responseBuilder_ != null) {
        responseBuilder_.dispose();
        responseBuilder_ = null;
      }
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      serviceData_ = null;
      if (serviceDataBuilder_ != null) {
        serviceDataBuilder_.dispose();
        serviceDataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_AuditLog_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.audit.AuditLog getDefaultInstanceForType() {
      return com.google.cloud.audit.AuditLog.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.audit.AuditLog build() {
      com.google.cloud.audit.AuditLog result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.audit.AuditLog buildPartial() {
      com.google.cloud.audit.AuditLog result = new com.google.cloud.audit.AuditLog(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.audit.AuditLog result) {
      if (authorizationInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          authorizationInfo_ = java.util.Collections.unmodifiableList(authorizationInfo_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.authorizationInfo_ = authorizationInfo_;
      } else {
        result.authorizationInfo_ = authorizationInfoBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.audit.AuditLog result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.serviceName_ = serviceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.methodName_ = methodName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.resourceName_ = resourceName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.resourceLocation_ =
            resourceLocationBuilder_ == null ? resourceLocation_ : resourceLocationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.resourceOriginalState_ =
            resourceOriginalStateBuilder_ == null
                ? resourceOriginalState_
                : resourceOriginalStateBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.numResponseItems_ = numResponseItems_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.authenticationInfo_ =
            authenticationInfoBuilder_ == null
                ? authenticationInfo_
                : authenticationInfoBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.policyViolationInfo_ =
            policyViolationInfoBuilder_ == null
                ? policyViolationInfo_
                : policyViolationInfoBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.requestMetadata_ =
            requestMetadataBuilder_ == null ? requestMetadata_ : requestMetadataBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.request_ = requestBuilder_ == null ? request_ : requestBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.response_ = responseBuilder_ == null ? response_ : responseBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.serviceData_ =
            serviceDataBuilder_ == null ? serviceData_ : serviceDataBuilder_.build();
        to_bitField0_ |= 0x00000200;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.audit.AuditLog) {
        return mergeFrom((com.google.cloud.audit.AuditLog) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.audit.AuditLog other) {
      if (other == com.google.cloud.audit.AuditLog.getDefaultInstance()) return this;
      if (!other.getServiceName().isEmpty()) {
        serviceName_ = other.serviceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getMethodName().isEmpty()) {
        methodName_ = other.methodName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasResourceLocation()) {
        mergeResourceLocation(other.getResourceLocation());
      }
      if (other.hasResourceOriginalState()) {
        mergeResourceOriginalState(other.getResourceOriginalState());
      }
      if (other.getNumResponseItems() != 0L) {
        setNumResponseItems(other.getNumResponseItems());
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (other.hasAuthenticationInfo()) {
        mergeAuthenticationInfo(other.getAuthenticationInfo());
      }
      if (authorizationInfoBuilder_ == null) {
        if (!other.authorizationInfo_.isEmpty()) {
          if (authorizationInfo_.isEmpty()) {
            authorizationInfo_ = other.authorizationInfo_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureAuthorizationInfoIsMutable();
            authorizationInfo_.addAll(other.authorizationInfo_);
          }
          onChanged();
        }
      } else {
        if (!other.authorizationInfo_.isEmpty()) {
          if (authorizationInfoBuilder_.isEmpty()) {
            authorizationInfoBuilder_.dispose();
            authorizationInfoBuilder_ = null;
            authorizationInfo_ = other.authorizationInfo_;
            bitField0_ = (bitField0_ & ~0x00000100);
            authorizationInfoBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAuthorizationInfoFieldBuilder()
                    : null;
          } else {
            authorizationInfoBuilder_.addAllMessages(other.authorizationInfo_);
          }
        }
      }
      if (other.hasPolicyViolationInfo()) {
        mergePolicyViolationInfo(other.getPolicyViolationInfo());
      }
      if (other.hasRequestMetadata()) {
        mergeRequestMetadata(other.getRequestMetadata());
      }
      if (other.hasRequest()) {
        mergeRequest(other.getRequest());
      }
      if (other.hasResponse()) {
        mergeResponse(other.getResponse());
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (other.hasServiceData()) {
        mergeServiceData(other.getServiceData());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getAuthenticationInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getRequestMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 34
            case 58:
              {
                serviceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 58
            case 66:
              {
                methodName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.audit.AuthorizationInfo m =
                    input.readMessage(
                        com.google.cloud.audit.AuthorizationInfo.parser(), extensionRegistry);
                if (authorizationInfoBuilder_ == null) {
                  ensureAuthorizationInfoIsMutable();
                  authorizationInfo_.add(m);
                } else {
                  authorizationInfoBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 90:
              {
                resourceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 90
            case 96:
              {
                numResponseItems_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 96
            case 122:
              {
                input.readMessage(getServiceDataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getRequestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getResponseFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(
                    getResourceOriginalStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 154
            case 162:
              {
                input.readMessage(
                    getResourceLocationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 162
            case 202:
              {
                input.readMessage(
                    getPolicyViolationInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 202
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object serviceName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the API service performing the operation. For example,
     * `"compute.googleapis.com"`.
     * </pre>
     *
     * <code>string service_name = 7;</code>
     *
     * @return The serviceName.
     */
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the API service performing the operation. For example,
     * `"compute.googleapis.com"`.
     * </pre>
     *
     * <code>string service_name = 7;</code>
     *
     * @return The bytes for serviceName.
     */
    public com.google.protobuf.ByteString getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the API service performing the operation. For example,
     * `"compute.googleapis.com"`.
     * </pre>
     *
     * <code>string service_name = 7;</code>
     *
     * @param value The serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the API service performing the operation. For example,
     * `"compute.googleapis.com"`.
     * </pre>
     *
     * <code>string service_name = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceName() {
      serviceName_ = getDefaultInstance().getServiceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the API service performing the operation. For example,
     * `"compute.googleapis.com"`.
     * </pre>
     *
     * <code>string service_name = 7;</code>
     *
     * @param value The bytes for serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object methodName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the service method or operation.
     * For API calls, this should be the name of the API method.
     * For example,
     *
     *     "google.cloud.bigquery.v2.TableService.InsertTable"
     *     "google.logging.v2.ConfigServiceV2.CreateSink"
     * </pre>
     *
     * <code>string method_name = 8;</code>
     *
     * @return The methodName.
     */
    public java.lang.String getMethodName() {
      java.lang.Object ref = methodName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        methodName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the service method or operation.
     * For API calls, this should be the name of the API method.
     * For example,
     *
     *     "google.cloud.bigquery.v2.TableService.InsertTable"
     *     "google.logging.v2.ConfigServiceV2.CreateSink"
     * </pre>
     *
     * <code>string method_name = 8;</code>
     *
     * @return The bytes for methodName.
     */
    public com.google.protobuf.ByteString getMethodNameBytes() {
      java.lang.Object ref = methodName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        methodName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the service method or operation.
     * For API calls, this should be the name of the API method.
     * For example,
     *
     *     "google.cloud.bigquery.v2.TableService.InsertTable"
     *     "google.logging.v2.ConfigServiceV2.CreateSink"
     * </pre>
     *
     * <code>string method_name = 8;</code>
     *
     * @param value The methodName to set.
     * @return This builder for chaining.
     */
    public Builder setMethodName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      methodName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the service method or operation.
     * For API calls, this should be the name of the API method.
     * For example,
     *
     *     "google.cloud.bigquery.v2.TableService.InsertTable"
     *     "google.logging.v2.ConfigServiceV2.CreateSink"
     * </pre>
     *
     * <code>string method_name = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMethodName() {
      methodName_ = getDefaultInstance().getMethodName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the service method or operation.
     * For API calls, this should be the name of the API method.
     * For example,
     *
     *     "google.cloud.bigquery.v2.TableService.InsertTable"
     *     "google.logging.v2.ConfigServiceV2.CreateSink"
     * </pre>
     *
     * <code>string method_name = 8;</code>
     *
     * @param value The bytes for methodName to set.
     * @return This builder for chaining.
     */
    public Builder setMethodNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      methodName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object resourceName_ = "";
    /**
     *
     *
     * <pre>
     * The resource or collection that is the target of the operation.
     * The name is a scheme-less URI, not including the API service name.
     * For example:
     *
     *     "projects/PROJECT_ID/zones/us-central1-a/instances"
     *     "projects/PROJECT_ID/datasets/DATASET_ID"
     * </pre>
     *
     * <code>string resource_name = 11;</code>
     *
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource or collection that is the target of the operation.
     * The name is a scheme-less URI, not including the API service name.
     * For example:
     *
     *     "projects/PROJECT_ID/zones/us-central1-a/instances"
     *     "projects/PROJECT_ID/datasets/DATASET_ID"
     * </pre>
     *
     * <code>string resource_name = 11;</code>
     *
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource or collection that is the target of the operation.
     * The name is a scheme-less URI, not including the API service name.
     * For example:
     *
     *     "projects/PROJECT_ID/zones/us-central1-a/instances"
     *     "projects/PROJECT_ID/datasets/DATASET_ID"
     * </pre>
     *
     * <code>string resource_name = 11;</code>
     *
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resourceName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource or collection that is the target of the operation.
     * The name is a scheme-less URI, not including the API service name.
     * For example:
     *
     *     "projects/PROJECT_ID/zones/us-central1-a/instances"
     *     "projects/PROJECT_ID/datasets/DATASET_ID"
     * </pre>
     *
     * <code>string resource_name = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource or collection that is the target of the operation.
     * The name is a scheme-less URI, not including the API service name.
     * For example:
     *
     *     "projects/PROJECT_ID/zones/us-central1-a/instances"
     *     "projects/PROJECT_ID/datasets/DATASET_ID"
     * </pre>
     *
     * <code>string resource_name = 11;</code>
     *
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.audit.ResourceLocation resourceLocation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.audit.ResourceLocation,
            com.google.cloud.audit.ResourceLocation.Builder,
            com.google.cloud.audit.ResourceLocationOrBuilder>
        resourceLocationBuilder_;
    /**
     *
     *
     * <pre>
     * The resource location information.
     * </pre>
     *
     * <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
     *
     * @return Whether the resourceLocation field is set.
     */
    public boolean hasResourceLocation() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The resource location information.
     * </pre>
     *
     * <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
     *
     * @return The resourceLocation.
     */
    public com.google.cloud.audit.ResourceLocation getResourceLocation() {
      if (resourceLocationBuilder_ == null) {
        return resourceLocation_ == null
            ? com.google.cloud.audit.ResourceLocation.getDefaultInstance()
            : resourceLocation_;
      } else {
        return resourceLocationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The resource location information.
     * </pre>
     *
     * <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
     */
    public Builder setResourceLocation(com.google.cloud.audit.ResourceLocation value) {
      if (resourceLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceLocation_ = value;
      } else {
        resourceLocationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource location information.
     * </pre>
     *
     * <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
     */
    public Builder setResourceLocation(
        com.google.cloud.audit.ResourceLocation.Builder builderForValue) {
      if (resourceLocationBuilder_ == null) {
        resourceLocation_ = builderForValue.build();
      } else {
        resourceLocationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource location information.
     * </pre>
     *
     * <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
     */
    public Builder mergeResourceLocation(com.google.cloud.audit.ResourceLocation value) {
      if (resourceLocationBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && resourceLocation_ != null
            && resourceLocation_ != com.google.cloud.audit.ResourceLocation.getDefaultInstance()) {
          getResourceLocationBuilder().mergeFrom(value);
        } else {
          resourceLocation_ = value;
        }
      } else {
        resourceLocationBuilder_.mergeFrom(value);
      }
      if (resourceLocation_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource location information.
     * </pre>
     *
     * <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
     */
    public Builder clearResourceLocation() {
      bitField0_ = (bitField0_ & ~0x00000008);
      resourceLocation_ = null;
      if (resourceLocationBuilder_ != null) {
        resourceLocationBuilder_.dispose();
        resourceLocationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource location information.
     * </pre>
     *
     * <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
     */
    public com.google.cloud.audit.ResourceLocation.Builder getResourceLocationBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getResourceLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The resource location information.
     * </pre>
     *
     * <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
     */
    public com.google.cloud.audit.ResourceLocationOrBuilder getResourceLocationOrBuilder() {
      if (resourceLocationBuilder_ != null) {
        return resourceLocationBuilder_.getMessageOrBuilder();
      } else {
        return resourceLocation_ == null
            ? com.google.cloud.audit.ResourceLocation.getDefaultInstance()
            : resourceLocation_;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource location information.
     * </pre>
     *
     * <code>.google.cloud.audit.ResourceLocation resource_location = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.audit.ResourceLocation,
            com.google.cloud.audit.ResourceLocation.Builder,
            com.google.cloud.audit.ResourceLocationOrBuilder>
        getResourceLocationFieldBuilder() {
      if (resourceLocationBuilder_ == null) {
        resourceLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.audit.ResourceLocation,
                com.google.cloud.audit.ResourceLocation.Builder,
                com.google.cloud.audit.ResourceLocationOrBuilder>(
                getResourceLocation(), getParentForChildren(), isClean());
        resourceLocation_ = null;
      }
      return resourceLocationBuilder_;
    }

    private com.google.protobuf.Struct resourceOriginalState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        resourceOriginalStateBuilder_;
    /**
     *
     *
     * <pre>
     * The resource's original state before mutation. Present only for
     * operations which have successfully modified the targeted resource(s).
     * In general, this field should contain all changed fields, except those
     * that are already been included in `request`, `response`, `metadata` or
     * `service_data` fields.
     * When the JSON object represented here has a proto equivalent,
     * the proto name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_original_state = 19;</code>
     *
     * @return Whether the resourceOriginalState field is set.
     */
    public boolean hasResourceOriginalState() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The resource's original state before mutation. Present only for
     * operations which have successfully modified the targeted resource(s).
     * In general, this field should contain all changed fields, except those
     * that are already been included in `request`, `response`, `metadata` or
     * `service_data` fields.
     * When the JSON object represented here has a proto equivalent,
     * the proto name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_original_state = 19;</code>
     *
     * @return The resourceOriginalState.
     */
    public com.google.protobuf.Struct getResourceOriginalState() {
      if (resourceOriginalStateBuilder_ == null) {
        return resourceOriginalState_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : resourceOriginalState_;
      } else {
        return resourceOriginalStateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The resource's original state before mutation. Present only for
     * operations which have successfully modified the targeted resource(s).
     * In general, this field should contain all changed fields, except those
     * that are already been included in `request`, `response`, `metadata` or
     * `service_data` fields.
     * When the JSON object represented here has a proto equivalent,
     * the proto name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_original_state = 19;</code>
     */
    public Builder setResourceOriginalState(com.google.protobuf.Struct value) {
      if (resourceOriginalStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceOriginalState_ = value;
      } else {
        resourceOriginalStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource's original state before mutation. Present only for
     * operations which have successfully modified the targeted resource(s).
     * In general, this field should contain all changed fields, except those
     * that are already been included in `request`, `response`, `metadata` or
     * `service_data` fields.
     * When the JSON object represented here has a proto equivalent,
     * the proto name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_original_state = 19;</code>
     */
    public Builder setResourceOriginalState(com.google.protobuf.Struct.Builder builderForValue) {
      if (resourceOriginalStateBuilder_ == null) {
        resourceOriginalState_ = builderForValue.build();
      } else {
        resourceOriginalStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource's original state before mutation. Present only for
     * operations which have successfully modified the targeted resource(s).
     * In general, this field should contain all changed fields, except those
     * that are already been included in `request`, `response`, `metadata` or
     * `service_data` fields.
     * When the JSON object represented here has a proto equivalent,
     * the proto name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_original_state = 19;</code>
     */
    public Builder mergeResourceOriginalState(com.google.protobuf.Struct value) {
      if (resourceOriginalStateBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && resourceOriginalState_ != null
            && resourceOriginalState_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getResourceOriginalStateBuilder().mergeFrom(value);
        } else {
          resourceOriginalState_ = value;
        }
      } else {
        resourceOriginalStateBuilder_.mergeFrom(value);
      }
      if (resourceOriginalState_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource's original state before mutation. Present only for
     * operations which have successfully modified the targeted resource(s).
     * In general, this field should contain all changed fields, except those
     * that are already been included in `request`, `response`, `metadata` or
     * `service_data` fields.
     * When the JSON object represented here has a proto equivalent,
     * the proto name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_original_state = 19;</code>
     */
    public Builder clearResourceOriginalState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      resourceOriginalState_ = null;
      if (resourceOriginalStateBuilder_ != null) {
        resourceOriginalStateBuilder_.dispose();
        resourceOriginalStateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource's original state before mutation. Present only for
     * operations which have successfully modified the targeted resource(s).
     * In general, this field should contain all changed fields, except those
     * that are already been included in `request`, `response`, `metadata` or
     * `service_data` fields.
     * When the JSON object represented here has a proto equivalent,
     * the proto name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_original_state = 19;</code>
     */
    public com.google.protobuf.Struct.Builder getResourceOriginalStateBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getResourceOriginalStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The resource's original state before mutation. Present only for
     * operations which have successfully modified the targeted resource(s).
     * In general, this field should contain all changed fields, except those
     * that are already been included in `request`, `response`, `metadata` or
     * `service_data` fields.
     * When the JSON object represented here has a proto equivalent,
     * the proto name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_original_state = 19;</code>
     */
    public com.google.protobuf.StructOrBuilder getResourceOriginalStateOrBuilder() {
      if (resourceOriginalStateBuilder_ != null) {
        return resourceOriginalStateBuilder_.getMessageOrBuilder();
      } else {
        return resourceOriginalState_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : resourceOriginalState_;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource's original state before mutation. Present only for
     * operations which have successfully modified the targeted resource(s).
     * In general, this field should contain all changed fields, except those
     * that are already been included in `request`, `response`, `metadata` or
     * `service_data` fields.
     * When the JSON object represented here has a proto equivalent,
     * the proto name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct resource_original_state = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getResourceOriginalStateFieldBuilder() {
      if (resourceOriginalStateBuilder_ == null) {
        resourceOriginalStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getResourceOriginalState(), getParentForChildren(), isClean());
        resourceOriginalState_ = null;
      }
      return resourceOriginalStateBuilder_;
    }

    private long numResponseItems_;
    /**
     *
     *
     * <pre>
     * The number of items returned from a List or Query API method,
     * if applicable.
     * </pre>
     *
     * <code>int64 num_response_items = 12;</code>
     *
     * @return The numResponseItems.
     */
    @java.lang.Override
    public long getNumResponseItems() {
      return numResponseItems_;
    }
    /**
     *
     *
     * <pre>
     * The number of items returned from a List or Query API method,
     * if applicable.
     * </pre>
     *
     * <code>int64 num_response_items = 12;</code>
     *
     * @param value The numResponseItems to set.
     * @return This builder for chaining.
     */
    public Builder setNumResponseItems(long value) {

      numResponseItems_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of items returned from a List or Query API method,
     * if applicable.
     * </pre>
     *
     * <code>int64 num_response_items = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumResponseItems() {
      bitField0_ = (bitField0_ & ~0x00000020);
      numResponseItems_ = 0L;
      onChanged();
      return this;
    }

    private com.google.rpc.Status status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * The status of the overall operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The status of the overall operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return The status.
     */
    public com.google.rpc.Status getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The status of the overall operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    public Builder setStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
      } else {
        statusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status of the overall operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status of the overall operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    public Builder mergeStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && status_ != null
            && status_ != com.google.rpc.Status.getDefaultInstance()) {
          getStatusBuilder().mergeFrom(value);
        } else {
          status_ = value;
        }
      } else {
        statusBuilder_.mergeFrom(value);
      }
      if (status_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status of the overall operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000040);
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status of the overall operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    public com.google.rpc.Status.Builder getStatusBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The status of the overall operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * The status of the overall operation.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private com.google.cloud.audit.AuthenticationInfo authenticationInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.audit.AuthenticationInfo,
            com.google.cloud.audit.AuthenticationInfo.Builder,
            com.google.cloud.audit.AuthenticationInfoOrBuilder>
        authenticationInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Authentication information.
     * </pre>
     *
     * <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     *
     * @return Whether the authenticationInfo field is set.
     */
    public boolean hasAuthenticationInfo() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Authentication information.
     * </pre>
     *
     * <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     *
     * @return The authenticationInfo.
     */
    public com.google.cloud.audit.AuthenticationInfo getAuthenticationInfo() {
      if (authenticationInfoBuilder_ == null) {
        return authenticationInfo_ == null
            ? com.google.cloud.audit.AuthenticationInfo.getDefaultInstance()
            : authenticationInfo_;
      } else {
        return authenticationInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Authentication information.
     * </pre>
     *
     * <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     */
    public Builder setAuthenticationInfo(com.google.cloud.audit.AuthenticationInfo value) {
      if (authenticationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authenticationInfo_ = value;
      } else {
        authenticationInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Authentication information.
     * </pre>
     *
     * <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     */
    public Builder setAuthenticationInfo(
        com.google.cloud.audit.AuthenticationInfo.Builder builderForValue) {
      if (authenticationInfoBuilder_ == null) {
        authenticationInfo_ = builderForValue.build();
      } else {
        authenticationInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Authentication information.
     * </pre>
     *
     * <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     */
    public Builder mergeAuthenticationInfo(com.google.cloud.audit.AuthenticationInfo value) {
      if (authenticationInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && authenticationInfo_ != null
            && authenticationInfo_
                != com.google.cloud.audit.AuthenticationInfo.getDefaultInstance()) {
          getAuthenticationInfoBuilder().mergeFrom(value);
        } else {
          authenticationInfo_ = value;
        }
      } else {
        authenticationInfoBuilder_.mergeFrom(value);
      }
      if (authenticationInfo_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Authentication information.
     * </pre>
     *
     * <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     */
    public Builder clearAuthenticationInfo() {
      bitField0_ = (bitField0_ & ~0x00000080);
      authenticationInfo_ = null;
      if (authenticationInfoBuilder_ != null) {
        authenticationInfoBuilder_.dispose();
        authenticationInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Authentication information.
     * </pre>
     *
     * <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     */
    public com.google.cloud.audit.AuthenticationInfo.Builder getAuthenticationInfoBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getAuthenticationInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Authentication information.
     * </pre>
     *
     * <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     */
    public com.google.cloud.audit.AuthenticationInfoOrBuilder getAuthenticationInfoOrBuilder() {
      if (authenticationInfoBuilder_ != null) {
        return authenticationInfoBuilder_.getMessageOrBuilder();
      } else {
        return authenticationInfo_ == null
            ? com.google.cloud.audit.AuthenticationInfo.getDefaultInstance()
            : authenticationInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Authentication information.
     * </pre>
     *
     * <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.audit.AuthenticationInfo,
            com.google.cloud.audit.AuthenticationInfo.Builder,
            com.google.cloud.audit.AuthenticationInfoOrBuilder>
        getAuthenticationInfoFieldBuilder() {
      if (authenticationInfoBuilder_ == null) {
        authenticationInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.audit.AuthenticationInfo,
                com.google.cloud.audit.AuthenticationInfo.Builder,
                com.google.cloud.audit.AuthenticationInfoOrBuilder>(
                getAuthenticationInfo(), getParentForChildren(), isClean());
        authenticationInfo_ = null;
      }
      return authenticationInfoBuilder_;
    }

    private java.util.List<com.google.cloud.audit.AuthorizationInfo> authorizationInfo_ =
        java.util.Collections.emptyList();

    private void ensureAuthorizationInfoIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        authorizationInfo_ =
            new java.util.ArrayList<com.google.cloud.audit.AuthorizationInfo>(authorizationInfo_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.audit.AuthorizationInfo,
            com.google.cloud.audit.AuthorizationInfo.Builder,
            com.google.cloud.audit.AuthorizationInfoOrBuilder>
        authorizationInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public java.util.List<com.google.cloud.audit.AuthorizationInfo> getAuthorizationInfoList() {
      if (authorizationInfoBuilder_ == null) {
        return java.util.Collections.unmodifiableList(authorizationInfo_);
      } else {
        return authorizationInfoBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public int getAuthorizationInfoCount() {
      if (authorizationInfoBuilder_ == null) {
        return authorizationInfo_.size();
      } else {
        return authorizationInfoBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public com.google.cloud.audit.AuthorizationInfo getAuthorizationInfo(int index) {
      if (authorizationInfoBuilder_ == null) {
        return authorizationInfo_.get(index);
      } else {
        return authorizationInfoBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public Builder setAuthorizationInfo(int index, com.google.cloud.audit.AuthorizationInfo value) {
      if (authorizationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuthorizationInfoIsMutable();
        authorizationInfo_.set(index, value);
        onChanged();
      } else {
        authorizationInfoBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public Builder setAuthorizationInfo(
        int index, com.google.cloud.audit.AuthorizationInfo.Builder builderForValue) {
      if (authorizationInfoBuilder_ == null) {
        ensureAuthorizationInfoIsMutable();
        authorizationInfo_.set(index, builderForValue.build());
        onChanged();
      } else {
        authorizationInfoBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public Builder addAuthorizationInfo(com.google.cloud.audit.AuthorizationInfo value) {
      if (authorizationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuthorizationInfoIsMutable();
        authorizationInfo_.add(value);
        onChanged();
      } else {
        authorizationInfoBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public Builder addAuthorizationInfo(int index, com.google.cloud.audit.AuthorizationInfo value) {
      if (authorizationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAuthorizationInfoIsMutable();
        authorizationInfo_.add(index, value);
        onChanged();
      } else {
        authorizationInfoBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public Builder addAuthorizationInfo(
        com.google.cloud.audit.AuthorizationInfo.Builder builderForValue) {
      if (authorizationInfoBuilder_ == null) {
        ensureAuthorizationInfoIsMutable();
        authorizationInfo_.add(builderForValue.build());
        onChanged();
      } else {
        authorizationInfoBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public Builder addAuthorizationInfo(
        int index, com.google.cloud.audit.AuthorizationInfo.Builder builderForValue) {
      if (authorizationInfoBuilder_ == null) {
        ensureAuthorizationInfoIsMutable();
        authorizationInfo_.add(index, builderForValue.build());
        onChanged();
      } else {
        authorizationInfoBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public Builder addAllAuthorizationInfo(
        java.lang.Iterable<? extends com.google.cloud.audit.AuthorizationInfo> values) {
      if (authorizationInfoBuilder_ == null) {
        ensureAuthorizationInfoIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, authorizationInfo_);
        onChanged();
      } else {
        authorizationInfoBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public Builder clearAuthorizationInfo() {
      if (authorizationInfoBuilder_ == null) {
        authorizationInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        authorizationInfoBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public Builder removeAuthorizationInfo(int index) {
      if (authorizationInfoBuilder_ == null) {
        ensureAuthorizationInfoIsMutable();
        authorizationInfo_.remove(index);
        onChanged();
      } else {
        authorizationInfoBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public com.google.cloud.audit.AuthorizationInfo.Builder getAuthorizationInfoBuilder(int index) {
      return getAuthorizationInfoFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public com.google.cloud.audit.AuthorizationInfoOrBuilder getAuthorizationInfoOrBuilder(
        int index) {
      if (authorizationInfoBuilder_ == null) {
        return authorizationInfo_.get(index);
      } else {
        return authorizationInfoBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.audit.AuthorizationInfoOrBuilder>
        getAuthorizationInfoOrBuilderList() {
      if (authorizationInfoBuilder_ != null) {
        return authorizationInfoBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(authorizationInfo_);
      }
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public com.google.cloud.audit.AuthorizationInfo.Builder addAuthorizationInfoBuilder() {
      return getAuthorizationInfoFieldBuilder()
          .addBuilder(com.google.cloud.audit.AuthorizationInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public com.google.cloud.audit.AuthorizationInfo.Builder addAuthorizationInfoBuilder(int index) {
      return getAuthorizationInfoFieldBuilder()
          .addBuilder(index, com.google.cloud.audit.AuthorizationInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     * </pre>
     *
     * <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    public java.util.List<com.google.cloud.audit.AuthorizationInfo.Builder>
        getAuthorizationInfoBuilderList() {
      return getAuthorizationInfoFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.audit.AuthorizationInfo,
            com.google.cloud.audit.AuthorizationInfo.Builder,
            com.google.cloud.audit.AuthorizationInfoOrBuilder>
        getAuthorizationInfoFieldBuilder() {
      if (authorizationInfoBuilder_ == null) {
        authorizationInfoBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.audit.AuthorizationInfo,
                com.google.cloud.audit.AuthorizationInfo.Builder,
                com.google.cloud.audit.AuthorizationInfoOrBuilder>(
                authorizationInfo_,
                ((bitField0_ & 0x00000100) != 0),
                getParentForChildren(),
                isClean());
        authorizationInfo_ = null;
      }
      return authorizationInfoBuilder_;
    }

    private com.google.cloud.audit.PolicyViolationInfo policyViolationInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.audit.PolicyViolationInfo,
            com.google.cloud.audit.PolicyViolationInfo.Builder,
            com.google.cloud.audit.PolicyViolationInfoOrBuilder>
        policyViolationInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Indicates the policy violations for this request. If the request
     * is denied by the policy, violation information will be logged
     * here.
     * </pre>
     *
     * <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
     *
     * @return Whether the policyViolationInfo field is set.
     */
    public boolean hasPolicyViolationInfo() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indicates the policy violations for this request. If the request
     * is denied by the policy, violation information will be logged
     * here.
     * </pre>
     *
     * <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
     *
     * @return The policyViolationInfo.
     */
    public com.google.cloud.audit.PolicyViolationInfo getPolicyViolationInfo() {
      if (policyViolationInfoBuilder_ == null) {
        return policyViolationInfo_ == null
            ? com.google.cloud.audit.PolicyViolationInfo.getDefaultInstance()
            : policyViolationInfo_;
      } else {
        return policyViolationInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates the policy violations for this request. If the request
     * is denied by the policy, violation information will be logged
     * here.
     * </pre>
     *
     * <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
     */
    public Builder setPolicyViolationInfo(com.google.cloud.audit.PolicyViolationInfo value) {
      if (policyViolationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        policyViolationInfo_ = value;
      } else {
        policyViolationInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the policy violations for this request. If the request
     * is denied by the policy, violation information will be logged
     * here.
     * </pre>
     *
     * <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
     */
    public Builder setPolicyViolationInfo(
        com.google.cloud.audit.PolicyViolationInfo.Builder builderForValue) {
      if (policyViolationInfoBuilder_ == null) {
        policyViolationInfo_ = builderForValue.build();
      } else {
        policyViolationInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the policy violations for this request. If the request
     * is denied by the policy, violation information will be logged
     * here.
     * </pre>
     *
     * <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
     */
    public Builder mergePolicyViolationInfo(com.google.cloud.audit.PolicyViolationInfo value) {
      if (policyViolationInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && policyViolationInfo_ != null
            && policyViolationInfo_
                != com.google.cloud.audit.PolicyViolationInfo.getDefaultInstance()) {
          getPolicyViolationInfoBuilder().mergeFrom(value);
        } else {
          policyViolationInfo_ = value;
        }
      } else {
        policyViolationInfoBuilder_.mergeFrom(value);
      }
      if (policyViolationInfo_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the policy violations for this request. If the request
     * is denied by the policy, violation information will be logged
     * here.
     * </pre>
     *
     * <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
     */
    public Builder clearPolicyViolationInfo() {
      bitField0_ = (bitField0_ & ~0x00000200);
      policyViolationInfo_ = null;
      if (policyViolationInfoBuilder_ != null) {
        policyViolationInfoBuilder_.dispose();
        policyViolationInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the policy violations for this request. If the request
     * is denied by the policy, violation information will be logged
     * here.
     * </pre>
     *
     * <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
     */
    public com.google.cloud.audit.PolicyViolationInfo.Builder getPolicyViolationInfoBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getPolicyViolationInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Indicates the policy violations for this request. If the request
     * is denied by the policy, violation information will be logged
     * here.
     * </pre>
     *
     * <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
     */
    public com.google.cloud.audit.PolicyViolationInfoOrBuilder getPolicyViolationInfoOrBuilder() {
      if (policyViolationInfoBuilder_ != null) {
        return policyViolationInfoBuilder_.getMessageOrBuilder();
      } else {
        return policyViolationInfo_ == null
            ? com.google.cloud.audit.PolicyViolationInfo.getDefaultInstance()
            : policyViolationInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates the policy violations for this request. If the request
     * is denied by the policy, violation information will be logged
     * here.
     * </pre>
     *
     * <code>.google.cloud.audit.PolicyViolationInfo policy_violation_info = 25;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.audit.PolicyViolationInfo,
            com.google.cloud.audit.PolicyViolationInfo.Builder,
            com.google.cloud.audit.PolicyViolationInfoOrBuilder>
        getPolicyViolationInfoFieldBuilder() {
      if (policyViolationInfoBuilder_ == null) {
        policyViolationInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.audit.PolicyViolationInfo,
                com.google.cloud.audit.PolicyViolationInfo.Builder,
                com.google.cloud.audit.PolicyViolationInfoOrBuilder>(
                getPolicyViolationInfo(), getParentForChildren(), isClean());
        policyViolationInfo_ = null;
      }
      return policyViolationInfoBuilder_;
    }

    private com.google.cloud.audit.RequestMetadata requestMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.audit.RequestMetadata,
            com.google.cloud.audit.RequestMetadata.Builder,
            com.google.cloud.audit.RequestMetadataOrBuilder>
        requestMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata about the operation.
     * </pre>
     *
     * <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     *
     * @return Whether the requestMetadata field is set.
     */
    public boolean hasRequestMetadata() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metadata about the operation.
     * </pre>
     *
     * <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     *
     * @return The requestMetadata.
     */
    public com.google.cloud.audit.RequestMetadata getRequestMetadata() {
      if (requestMetadataBuilder_ == null) {
        return requestMetadata_ == null
            ? com.google.cloud.audit.RequestMetadata.getDefaultInstance()
            : requestMetadata_;
      } else {
        return requestMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata about the operation.
     * </pre>
     *
     * <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     */
    public Builder setRequestMetadata(com.google.cloud.audit.RequestMetadata value) {
      if (requestMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestMetadata_ = value;
      } else {
        requestMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the operation.
     * </pre>
     *
     * <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     */
    public Builder setRequestMetadata(
        com.google.cloud.audit.RequestMetadata.Builder builderForValue) {
      if (requestMetadataBuilder_ == null) {
        requestMetadata_ = builderForValue.build();
      } else {
        requestMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the operation.
     * </pre>
     *
     * <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     */
    public Builder mergeRequestMetadata(com.google.cloud.audit.RequestMetadata value) {
      if (requestMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && requestMetadata_ != null
            && requestMetadata_ != com.google.cloud.audit.RequestMetadata.getDefaultInstance()) {
          getRequestMetadataBuilder().mergeFrom(value);
        } else {
          requestMetadata_ = value;
        }
      } else {
        requestMetadataBuilder_.mergeFrom(value);
      }
      if (requestMetadata_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the operation.
     * </pre>
     *
     * <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     */
    public Builder clearRequestMetadata() {
      bitField0_ = (bitField0_ & ~0x00000400);
      requestMetadata_ = null;
      if (requestMetadataBuilder_ != null) {
        requestMetadataBuilder_.dispose();
        requestMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the operation.
     * </pre>
     *
     * <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     */
    public com.google.cloud.audit.RequestMetadata.Builder getRequestMetadataBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getRequestMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata about the operation.
     * </pre>
     *
     * <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     */
    public com.google.cloud.audit.RequestMetadataOrBuilder getRequestMetadataOrBuilder() {
      if (requestMetadataBuilder_ != null) {
        return requestMetadataBuilder_.getMessageOrBuilder();
      } else {
        return requestMetadata_ == null
            ? com.google.cloud.audit.RequestMetadata.getDefaultInstance()
            : requestMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata about the operation.
     * </pre>
     *
     * <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.audit.RequestMetadata,
            com.google.cloud.audit.RequestMetadata.Builder,
            com.google.cloud.audit.RequestMetadataOrBuilder>
        getRequestMetadataFieldBuilder() {
      if (requestMetadataBuilder_ == null) {
        requestMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.audit.RequestMetadata,
                com.google.cloud.audit.RequestMetadata.Builder,
                com.google.cloud.audit.RequestMetadataOrBuilder>(
                getRequestMetadata(), getParentForChildren(), isClean());
        requestMetadata_ = null;
      }
      return requestMetadataBuilder_;
    }

    private com.google.protobuf.Struct request_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        requestBuilder_;
    /**
     *
     *
     * <pre>
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct request = 16;</code>
     *
     * @return Whether the request field is set.
     */
    public boolean hasRequest() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct request = 16;</code>
     *
     * @return The request.
     */
    public com.google.protobuf.Struct getRequest() {
      if (requestBuilder_ == null) {
        return request_ == null ? com.google.protobuf.Struct.getDefaultInstance() : request_;
      } else {
        return requestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct request = 16;</code>
     */
    public Builder setRequest(com.google.protobuf.Struct value) {
      if (requestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
      } else {
        requestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct request = 16;</code>
     */
    public Builder setRequest(com.google.protobuf.Struct.Builder builderForValue) {
      if (requestBuilder_ == null) {
        request_ = builderForValue.build();
      } else {
        requestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct request = 16;</code>
     */
    public Builder mergeRequest(com.google.protobuf.Struct value) {
      if (requestBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && request_ != null
            && request_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getRequestBuilder().mergeFrom(value);
        } else {
          request_ = value;
        }
      } else {
        requestBuilder_.mergeFrom(value);
      }
      if (request_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct request = 16;</code>
     */
    public Builder clearRequest() {
      bitField0_ = (bitField0_ & ~0x00000800);
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct request = 16;</code>
     */
    public com.google.protobuf.Struct.Builder getRequestBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct request = 16;</code>
     */
    public com.google.protobuf.StructOrBuilder getRequestOrBuilder() {
      if (requestBuilder_ != null) {
        return requestBuilder_.getMessageOrBuilder();
      } else {
        return request_ == null ? com.google.protobuf.Struct.getDefaultInstance() : request_;
      }
    }
    /**
     *
     *
     * <pre>
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct request = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getRequestFieldBuilder() {
      if (requestBuilder_ == null) {
        requestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getRequest(), getParentForChildren(), isClean());
        request_ = null;
      }
      return requestBuilder_;
    }

    private com.google.protobuf.Struct response_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        responseBuilder_;
    /**
     *
     *
     * <pre>
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct response = 17;</code>
     *
     * @return Whether the response field is set.
     */
    public boolean hasResponse() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct response = 17;</code>
     *
     * @return The response.
     */
    public com.google.protobuf.Struct getResponse() {
      if (responseBuilder_ == null) {
        return response_ == null ? com.google.protobuf.Struct.getDefaultInstance() : response_;
      } else {
        return responseBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct response = 17;</code>
     */
    public Builder setResponse(com.google.protobuf.Struct value) {
      if (responseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        response_ = value;
      } else {
        responseBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct response = 17;</code>
     */
    public Builder setResponse(com.google.protobuf.Struct.Builder builderForValue) {
      if (responseBuilder_ == null) {
        response_ = builderForValue.build();
      } else {
        responseBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct response = 17;</code>
     */
    public Builder mergeResponse(com.google.protobuf.Struct value) {
      if (responseBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && response_ != null
            && response_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getResponseBuilder().mergeFrom(value);
        } else {
          response_ = value;
        }
      } else {
        responseBuilder_.mergeFrom(value);
      }
      if (response_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct response = 17;</code>
     */
    public Builder clearResponse() {
      bitField0_ = (bitField0_ & ~0x00001000);
      response_ = null;
      if (responseBuilder_ != null) {
        responseBuilder_.dispose();
        responseBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct response = 17;</code>
     */
    public com.google.protobuf.Struct.Builder getResponseBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getResponseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct response = 17;</code>
     */
    public com.google.protobuf.StructOrBuilder getResponseOrBuilder() {
      if (responseBuilder_ != null) {
        return responseBuilder_.getMessageOrBuilder();
      } else {
        return response_ == null ? com.google.protobuf.Struct.getDefaultInstance() : response_;
      }
    }
    /**
     *
     *
     * <pre>
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     * </pre>
     *
     * <code>.google.protobuf.Struct response = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getResponseFieldBuilder() {
      if (responseBuilder_ == null) {
        responseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getResponse(), getParentForChildren(), isClean());
        response_ = null;
      }
      return responseBuilder_;
    }

    private com.google.protobuf.Struct metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Other service-specific data about the request, response, and other
     * information associated with the current audited event.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 18;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Other service-specific data about the request, response, and other
     * information associated with the current audited event.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 18;</code>
     *
     * @return The metadata.
     */
    public com.google.protobuf.Struct getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Other service-specific data about the request, response, and other
     * information associated with the current audited event.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 18;</code>
     */
    public Builder setMetadata(com.google.protobuf.Struct value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other service-specific data about the request, response, and other
     * information associated with the current audited event.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 18;</code>
     */
    public Builder setMetadata(com.google.protobuf.Struct.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other service-specific data about the request, response, and other
     * information associated with the current audited event.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 18;</code>
     */
    public Builder mergeMetadata(com.google.protobuf.Struct value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && metadata_ != null
            && metadata_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other service-specific data about the request, response, and other
     * information associated with the current audited event.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 18;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00002000);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Other service-specific data about the request, response, and other
     * information associated with the current audited event.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 18;</code>
     */
    public com.google.protobuf.Struct.Builder getMetadataBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Other service-specific data about the request, response, and other
     * information associated with the current audited event.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 18;</code>
     */
    public com.google.protobuf.StructOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Other service-specific data about the request, response, and other
     * information associated with the current audited event.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private com.google.protobuf.Any serviceData_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Any,
            com.google.protobuf.Any.Builder,
            com.google.protobuf.AnyOrBuilder>
        serviceDataBuilder_;
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `metadata` field instead.
     * Other service-specific data about the request, response, and other
     * activities.
     * </pre>
     *
     * <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
     *
     * @deprecated google.cloud.audit.AuditLog.service_data is deprecated. See
     *     google/cloud/audit/audit_log.proto;l=110
     * @return Whether the serviceData field is set.
     */
    @java.lang.Deprecated
    public boolean hasServiceData() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `metadata` field instead.
     * Other service-specific data about the request, response, and other
     * activities.
     * </pre>
     *
     * <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
     *
     * @deprecated google.cloud.audit.AuditLog.service_data is deprecated. See
     *     google/cloud/audit/audit_log.proto;l=110
     * @return The serviceData.
     */
    @java.lang.Deprecated
    public com.google.protobuf.Any getServiceData() {
      if (serviceDataBuilder_ == null) {
        return serviceData_ == null ? com.google.protobuf.Any.getDefaultInstance() : serviceData_;
      } else {
        return serviceDataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `metadata` field instead.
     * Other service-specific data about the request, response, and other
     * activities.
     * </pre>
     *
     * <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setServiceData(com.google.protobuf.Any value) {
      if (serviceDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceData_ = value;
      } else {
        serviceDataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `metadata` field instead.
     * Other service-specific data about the request, response, and other
     * activities.
     * </pre>
     *
     * <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setServiceData(com.google.protobuf.Any.Builder builderForValue) {
      if (serviceDataBuilder_ == null) {
        serviceData_ = builderForValue.build();
      } else {
        serviceDataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `metadata` field instead.
     * Other service-specific data about the request, response, and other
     * activities.
     * </pre>
     *
     * <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder mergeServiceData(com.google.protobuf.Any value) {
      if (serviceDataBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && serviceData_ != null
            && serviceData_ != com.google.protobuf.Any.getDefaultInstance()) {
          getServiceDataBuilder().mergeFrom(value);
        } else {
          serviceData_ = value;
        }
      } else {
        serviceDataBuilder_.mergeFrom(value);
      }
      if (serviceData_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `metadata` field instead.
     * Other service-specific data about the request, response, and other
     * activities.
     * </pre>
     *
     * <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder clearServiceData() {
      bitField0_ = (bitField0_ & ~0x00004000);
      serviceData_ = null;
      if (serviceDataBuilder_ != null) {
        serviceDataBuilder_.dispose();
        serviceDataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `metadata` field instead.
     * Other service-specific data about the request, response, and other
     * activities.
     * </pre>
     *
     * <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.protobuf.Any.Builder getServiceDataBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getServiceDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `metadata` field instead.
     * Other service-specific data about the request, response, and other
     * activities.
     * </pre>
     *
     * <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.protobuf.AnyOrBuilder getServiceDataOrBuilder() {
      if (serviceDataBuilder_ != null) {
        return serviceDataBuilder_.getMessageOrBuilder();
      } else {
        return serviceData_ == null ? com.google.protobuf.Any.getDefaultInstance() : serviceData_;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use the `metadata` field instead.
     * Other service-specific data about the request, response, and other
     * activities.
     * </pre>
     *
     * <code>.google.protobuf.Any service_data = 15 [deprecated = true];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Any,
            com.google.protobuf.Any.Builder,
            com.google.protobuf.AnyOrBuilder>
        getServiceDataFieldBuilder() {
      if (serviceDataBuilder_ == null) {
        serviceDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Any,
                com.google.protobuf.Any.Builder,
                com.google.protobuf.AnyOrBuilder>(
                getServiceData(), getParentForChildren(), isClean());
        serviceData_ = null;
      }
      return serviceDataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.audit.AuditLog)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.audit.AuditLog)
  private static final com.google.cloud.audit.AuditLog DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.audit.AuditLog();
  }

  public static com.google.cloud.audit.AuditLog getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AuditLog> PARSER =
      new com.google.protobuf.AbstractParser<AuditLog>() {
        @java.lang.Override
        public AuditLog parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AuditLog> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AuditLog> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.audit.AuditLog getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
