/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/logging.proto

// Protobuf Java Version: 3.25.3
package com.google.api;

/**
 *
 *
 * <pre>
 * Logging configuration of the service.
 *
 * The following example shows how to configure logs to be sent to the
 * producer and consumer projects. In the example, the `activity_history`
 * log is sent to both the producer and consumer projects, whereas the
 * `purchase_history` log is only sent to the producer project.
 *
 *     monitored_resources:
 *     - type: library.googleapis.com/branch
 *       labels:
 *       - key: /city
 *         description: The city where the library branch is located in.
 *       - key: /name
 *         description: The name of the branch.
 *     logs:
 *     - name: activity_history
 *       labels:
 *       - key: /customer_id
 *     - name: purchase_history
 *     logging:
 *       producer_destinations:
 *       - monitored_resource: library.googleapis.com/branch
 *         logs:
 *         - activity_history
 *         - purchase_history
 *       consumer_destinations:
 *       - monitored_resource: library.googleapis.com/branch
 *         logs:
 *         - activity_history
 * </pre>
 *
 * Protobuf type {@code google.api.Logging}
 */
public final class Logging extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.Logging)
    LoggingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Logging.newBuilder() to construct.
  private Logging(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Logging() {
    producerDestinations_ = java.util.Collections.emptyList();
    consumerDestinations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Logging();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.LoggingProto.internal_static_google_api_Logging_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.LoggingProto.internal_static_google_api_Logging_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.Logging.class, com.google.api.Logging.Builder.class);
  }

  public interface LoggingDestinationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.api.Logging.LoggingDestination)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The monitored resource type. The type must be defined in the
     * [Service.monitored_resources][google.api.Service.monitored_resources]
     * section.
     * </pre>
     *
     * <code>string monitored_resource = 3;</code>
     *
     * @return The monitoredResource.
     */
    java.lang.String getMonitoredResource();
    /**
     *
     *
     * <pre>
     * The monitored resource type. The type must be defined in the
     * [Service.monitored_resources][google.api.Service.monitored_resources]
     * section.
     * </pre>
     *
     * <code>string monitored_resource = 3;</code>
     *
     * @return The bytes for monitoredResource.
     */
    com.google.protobuf.ByteString getMonitoredResourceBytes();

    /**
     *
     *
     * <pre>
     * Names of the logs to be sent to this destination. Each name must
     * be defined in the [Service.logs][google.api.Service.logs] section. If the
     * log name is not a domain scoped name, it will be automatically prefixed
     * with the service name followed by "/".
     * </pre>
     *
     * <code>repeated string logs = 1;</code>
     *
     * @return A list containing the logs.
     */
    java.util.List<java.lang.String> getLogsList();
    /**
     *
     *
     * <pre>
     * Names of the logs to be sent to this destination. Each name must
     * be defined in the [Service.logs][google.api.Service.logs] section. If the
     * log name is not a domain scoped name, it will be automatically prefixed
     * with the service name followed by "/".
     * </pre>
     *
     * <code>repeated string logs = 1;</code>
     *
     * @return The count of logs.
     */
    int getLogsCount();
    /**
     *
     *
     * <pre>
     * Names of the logs to be sent to this destination. Each name must
     * be defined in the [Service.logs][google.api.Service.logs] section. If the
     * log name is not a domain scoped name, it will be automatically prefixed
     * with the service name followed by "/".
     * </pre>
     *
     * <code>repeated string logs = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The logs at the given index.
     */
    java.lang.String getLogs(int index);
    /**
     *
     *
     * <pre>
     * Names of the logs to be sent to this destination. Each name must
     * be defined in the [Service.logs][google.api.Service.logs] section. If the
     * log name is not a domain scoped name, it will be automatically prefixed
     * with the service name followed by "/".
     * </pre>
     *
     * <code>repeated string logs = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the logs at the given index.
     */
    com.google.protobuf.ByteString getLogsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Configuration of a specific logging destination (the producer project
   * or the consumer project).
   * </pre>
   *
   * Protobuf type {@code google.api.Logging.LoggingDestination}
   */
  public static final class LoggingDestination extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.api.Logging.LoggingDestination)
      LoggingDestinationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LoggingDestination.newBuilder() to construct.
    private LoggingDestination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LoggingDestination() {
      monitoredResource_ = "";
      logs_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LoggingDestination();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.LoggingProto
          .internal_static_google_api_Logging_LoggingDestination_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.LoggingProto
          .internal_static_google_api_Logging_LoggingDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.Logging.LoggingDestination.class,
              com.google.api.Logging.LoggingDestination.Builder.class);
    }

    public static final int MONITORED_RESOURCE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object monitoredResource_ = "";
    /**
     *
     *
     * <pre>
     * The monitored resource type. The type must be defined in the
     * [Service.monitored_resources][google.api.Service.monitored_resources]
     * section.
     * </pre>
     *
     * <code>string monitored_resource = 3;</code>
     *
     * @return The monitoredResource.
     */
    @java.lang.Override
    public java.lang.String getMonitoredResource() {
      java.lang.Object ref = monitoredResource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        monitoredResource_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The monitored resource type. The type must be defined in the
     * [Service.monitored_resources][google.api.Service.monitored_resources]
     * section.
     * </pre>
     *
     * <code>string monitored_resource = 3;</code>
     *
     * @return The bytes for monitoredResource.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMonitoredResourceBytes() {
      java.lang.Object ref = monitoredResource_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        monitoredResource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOGS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList logs_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Names of the logs to be sent to this destination. Each name must
     * be defined in the [Service.logs][google.api.Service.logs] section. If the
     * log name is not a domain scoped name, it will be automatically prefixed
     * with the service name followed by "/".
     * </pre>
     *
     * <code>repeated string logs = 1;</code>
     *
     * @return A list containing the logs.
     */
    public com.google.protobuf.ProtocolStringList getLogsList() {
      return logs_;
    }
    /**
     *
     *
     * <pre>
     * Names of the logs to be sent to this destination. Each name must
     * be defined in the [Service.logs][google.api.Service.logs] section. If the
     * log name is not a domain scoped name, it will be automatically prefixed
     * with the service name followed by "/".
     * </pre>
     *
     * <code>repeated string logs = 1;</code>
     *
     * @return The count of logs.
     */
    public int getLogsCount() {
      return logs_.size();
    }
    /**
     *
     *
     * <pre>
     * Names of the logs to be sent to this destination. Each name must
     * be defined in the [Service.logs][google.api.Service.logs] section. If the
     * log name is not a domain scoped name, it will be automatically prefixed
     * with the service name followed by "/".
     * </pre>
     *
     * <code>repeated string logs = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The logs at the given index.
     */
    public java.lang.String getLogs(int index) {
      return logs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Names of the logs to be sent to this destination. Each name must
     * be defined in the [Service.logs][google.api.Service.logs] section. If the
     * log name is not a domain scoped name, it will be automatically prefixed
     * with the service name followed by "/".
     * </pre>
     *
     * <code>repeated string logs = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the logs at the given index.
     */
    public com.google.protobuf.ByteString getLogsBytes(int index) {
      return logs_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < logs_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, logs_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(monitoredResource_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, monitoredResource_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < logs_.size(); i++) {
          dataSize += computeStringSizeNoTag(logs_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getLogsList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(monitoredResource_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, monitoredResource_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.api.Logging.LoggingDestination)) {
        return super.equals(obj);
      }
      com.google.api.Logging.LoggingDestination other =
          (com.google.api.Logging.LoggingDestination) obj;

      if (!getMonitoredResource().equals(other.getMonitoredResource())) return false;
      if (!getLogsList().equals(other.getLogsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MONITORED_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoredResource().hashCode();
      if (getLogsCount() > 0) {
        hash = (37 * hash) + LOGS_FIELD_NUMBER;
        hash = (53 * hash) + getLogsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.api.Logging.LoggingDestination parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.Logging.LoggingDestination parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.Logging.LoggingDestination parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.Logging.LoggingDestination parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.Logging.LoggingDestination parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.api.Logging.LoggingDestination parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.api.Logging.LoggingDestination parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.api.Logging.LoggingDestination parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.api.Logging.LoggingDestination parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.api.Logging.LoggingDestination parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.api.Logging.LoggingDestination parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.api.Logging.LoggingDestination parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.api.Logging.LoggingDestination prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration of a specific logging destination (the producer project
     * or the consumer project).
     * </pre>
     *
     * Protobuf type {@code google.api.Logging.LoggingDestination}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.api.Logging.LoggingDestination)
        com.google.api.Logging.LoggingDestinationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.api.LoggingProto
            .internal_static_google_api_Logging_LoggingDestination_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.LoggingProto
            .internal_static_google_api_Logging_LoggingDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.api.Logging.LoggingDestination.class,
                com.google.api.Logging.LoggingDestination.Builder.class);
      }

      // Construct using com.google.api.Logging.LoggingDestination.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        monitoredResource_ = "";
        logs_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.api.LoggingProto
            .internal_static_google_api_Logging_LoggingDestination_descriptor;
      }

      @java.lang.Override
      public com.google.api.Logging.LoggingDestination getDefaultInstanceForType() {
        return com.google.api.Logging.LoggingDestination.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.api.Logging.LoggingDestination build() {
        com.google.api.Logging.LoggingDestination result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.api.Logging.LoggingDestination buildPartial() {
        com.google.api.Logging.LoggingDestination result =
            new com.google.api.Logging.LoggingDestination(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.api.Logging.LoggingDestination result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.monitoredResource_ = monitoredResource_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          logs_.makeImmutable();
          result.logs_ = logs_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.api.Logging.LoggingDestination) {
          return mergeFrom((com.google.api.Logging.LoggingDestination) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.api.Logging.LoggingDestination other) {
        if (other == com.google.api.Logging.LoggingDestination.getDefaultInstance()) return this;
        if (!other.getMonitoredResource().isEmpty()) {
          monitoredResource_ = other.monitoredResource_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.logs_.isEmpty()) {
          if (logs_.isEmpty()) {
            logs_ = other.logs_;
            bitField0_ |= 0x00000002;
          } else {
            ensureLogsIsMutable();
            logs_.addAll(other.logs_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureLogsIsMutable();
                  logs_.add(s);
                  break;
                } // case 10
              case 26:
                {
                  monitoredResource_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object monitoredResource_ = "";
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in the
       * [Service.monitored_resources][google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 3;</code>
       *
       * @return The monitoredResource.
       */
      public java.lang.String getMonitoredResource() {
        java.lang.Object ref = monitoredResource_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          monitoredResource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in the
       * [Service.monitored_resources][google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 3;</code>
       *
       * @return The bytes for monitoredResource.
       */
      public com.google.protobuf.ByteString getMonitoredResourceBytes() {
        java.lang.Object ref = monitoredResource_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          monitoredResource_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in the
       * [Service.monitored_resources][google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 3;</code>
       *
       * @param value The monitoredResource to set.
       * @return This builder for chaining.
       */
      public Builder setMonitoredResource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        monitoredResource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in the
       * [Service.monitored_resources][google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMonitoredResource() {
        monitoredResource_ = getDefaultInstance().getMonitoredResource();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in the
       * [Service.monitored_resources][google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 3;</code>
       *
       * @param value The bytes for monitoredResource to set.
       * @return This builder for chaining.
       */
      public Builder setMonitoredResourceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        monitoredResource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList logs_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureLogsIsMutable() {
        if (!logs_.isModifiable()) {
          logs_ = new com.google.protobuf.LazyStringArrayList(logs_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Names of the logs to be sent to this destination. Each name must
       * be defined in the [Service.logs][google.api.Service.logs] section. If the
       * log name is not a domain scoped name, it will be automatically prefixed
       * with the service name followed by "/".
       * </pre>
       *
       * <code>repeated string logs = 1;</code>
       *
       * @return A list containing the logs.
       */
      public com.google.protobuf.ProtocolStringList getLogsList() {
        logs_.makeImmutable();
        return logs_;
      }
      /**
       *
       *
       * <pre>
       * Names of the logs to be sent to this destination. Each name must
       * be defined in the [Service.logs][google.api.Service.logs] section. If the
       * log name is not a domain scoped name, it will be automatically prefixed
       * with the service name followed by "/".
       * </pre>
       *
       * <code>repeated string logs = 1;</code>
       *
       * @return The count of logs.
       */
      public int getLogsCount() {
        return logs_.size();
      }
      /**
       *
       *
       * <pre>
       * Names of the logs to be sent to this destination. Each name must
       * be defined in the [Service.logs][google.api.Service.logs] section. If the
       * log name is not a domain scoped name, it will be automatically prefixed
       * with the service name followed by "/".
       * </pre>
       *
       * <code>repeated string logs = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The logs at the given index.
       */
      public java.lang.String getLogs(int index) {
        return logs_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Names of the logs to be sent to this destination. Each name must
       * be defined in the [Service.logs][google.api.Service.logs] section. If the
       * log name is not a domain scoped name, it will be automatically prefixed
       * with the service name followed by "/".
       * </pre>
       *
       * <code>repeated string logs = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the logs at the given index.
       */
      public com.google.protobuf.ByteString getLogsBytes(int index) {
        return logs_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Names of the logs to be sent to this destination. Each name must
       * be defined in the [Service.logs][google.api.Service.logs] section. If the
       * log name is not a domain scoped name, it will be automatically prefixed
       * with the service name followed by "/".
       * </pre>
       *
       * <code>repeated string logs = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The logs to set.
       * @return This builder for chaining.
       */
      public Builder setLogs(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogsIsMutable();
        logs_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Names of the logs to be sent to this destination. Each name must
       * be defined in the [Service.logs][google.api.Service.logs] section. If the
       * log name is not a domain scoped name, it will be automatically prefixed
       * with the service name followed by "/".
       * </pre>
       *
       * <code>repeated string logs = 1;</code>
       *
       * @param value The logs to add.
       * @return This builder for chaining.
       */
      public Builder addLogs(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogsIsMutable();
        logs_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Names of the logs to be sent to this destination. Each name must
       * be defined in the [Service.logs][google.api.Service.logs] section. If the
       * log name is not a domain scoped name, it will be automatically prefixed
       * with the service name followed by "/".
       * </pre>
       *
       * <code>repeated string logs = 1;</code>
       *
       * @param values The logs to add.
       * @return This builder for chaining.
       */
      public Builder addAllLogs(java.lang.Iterable<java.lang.String> values) {
        ensureLogsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, logs_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Names of the logs to be sent to this destination. Each name must
       * be defined in the [Service.logs][google.api.Service.logs] section. If the
       * log name is not a domain scoped name, it will be automatically prefixed
       * with the service name followed by "/".
       * </pre>
       *
       * <code>repeated string logs = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLogs() {
        logs_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Names of the logs to be sent to this destination. Each name must
       * be defined in the [Service.logs][google.api.Service.logs] section. If the
       * log name is not a domain scoped name, it will be automatically prefixed
       * with the service name followed by "/".
       * </pre>
       *
       * <code>repeated string logs = 1;</code>
       *
       * @param value The bytes of the logs to add.
       * @return This builder for chaining.
       */
      public Builder addLogsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureLogsIsMutable();
        logs_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.api.Logging.LoggingDestination)
    }

    // @@protoc_insertion_point(class_scope:google.api.Logging.LoggingDestination)
    private static final com.google.api.Logging.LoggingDestination DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.api.Logging.LoggingDestination();
    }

    public static com.google.api.Logging.LoggingDestination getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LoggingDestination> PARSER =
        new com.google.protobuf.AbstractParser<LoggingDestination>() {
          @java.lang.Override
          public LoggingDestination parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LoggingDestination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LoggingDestination> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.api.Logging.LoggingDestination getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PRODUCER_DESTINATIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.Logging.LoggingDestination> producerDestinations_;
  /**
   *
   *
   * <pre>
   * Logging configurations for sending logs to the producer project.
   * There can be multiple producer destinations, each one must have a
   * different monitored resource type. A log can be used in at most
   * one producer destination.
   * </pre>
   *
   * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.Logging.LoggingDestination> getProducerDestinationsList() {
    return producerDestinations_;
  }
  /**
   *
   *
   * <pre>
   * Logging configurations for sending logs to the producer project.
   * There can be multiple producer destinations, each one must have a
   * different monitored resource type. A log can be used in at most
   * one producer destination.
   * </pre>
   *
   * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.Logging.LoggingDestinationOrBuilder>
      getProducerDestinationsOrBuilderList() {
    return producerDestinations_;
  }
  /**
   *
   *
   * <pre>
   * Logging configurations for sending logs to the producer project.
   * There can be multiple producer destinations, each one must have a
   * different monitored resource type. A log can be used in at most
   * one producer destination.
   * </pre>
   *
   * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
   */
  @java.lang.Override
  public int getProducerDestinationsCount() {
    return producerDestinations_.size();
  }
  /**
   *
   *
   * <pre>
   * Logging configurations for sending logs to the producer project.
   * There can be multiple producer destinations, each one must have a
   * different monitored resource type. A log can be used in at most
   * one producer destination.
   * </pre>
   *
   * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
   */
  @java.lang.Override
  public com.google.api.Logging.LoggingDestination getProducerDestinations(int index) {
    return producerDestinations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Logging configurations for sending logs to the producer project.
   * There can be multiple producer destinations, each one must have a
   * different monitored resource type. A log can be used in at most
   * one producer destination.
   * </pre>
   *
   * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
   */
  @java.lang.Override
  public com.google.api.Logging.LoggingDestinationOrBuilder getProducerDestinationsOrBuilder(
      int index) {
    return producerDestinations_.get(index);
  }

  public static final int CONSUMER_DESTINATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.Logging.LoggingDestination> consumerDestinations_;
  /**
   *
   *
   * <pre>
   * Logging configurations for sending logs to the consumer project.
   * There can be multiple consumer destinations, each one must have a
   * different monitored resource type. A log can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.Logging.LoggingDestination> getConsumerDestinationsList() {
    return consumerDestinations_;
  }
  /**
   *
   *
   * <pre>
   * Logging configurations for sending logs to the consumer project.
   * There can be multiple consumer destinations, each one must have a
   * different monitored resource type. A log can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.Logging.LoggingDestinationOrBuilder>
      getConsumerDestinationsOrBuilderList() {
    return consumerDestinations_;
  }
  /**
   *
   *
   * <pre>
   * Logging configurations for sending logs to the consumer project.
   * There can be multiple consumer destinations, each one must have a
   * different monitored resource type. A log can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
   */
  @java.lang.Override
  public int getConsumerDestinationsCount() {
    return consumerDestinations_.size();
  }
  /**
   *
   *
   * <pre>
   * Logging configurations for sending logs to the consumer project.
   * There can be multiple consumer destinations, each one must have a
   * different monitored resource type. A log can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
   */
  @java.lang.Override
  public com.google.api.Logging.LoggingDestination getConsumerDestinations(int index) {
    return consumerDestinations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Logging configurations for sending logs to the consumer project.
   * There can be multiple consumer destinations, each one must have a
   * different monitored resource type. A log can be used in at most
   * one consumer destination.
   * </pre>
   *
   * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
   */
  @java.lang.Override
  public com.google.api.Logging.LoggingDestinationOrBuilder getConsumerDestinationsOrBuilder(
      int index) {
    return consumerDestinations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < producerDestinations_.size(); i++) {
      output.writeMessage(1, producerDestinations_.get(i));
    }
    for (int i = 0; i < consumerDestinations_.size(); i++) {
      output.writeMessage(2, consumerDestinations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < producerDestinations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, producerDestinations_.get(i));
    }
    for (int i = 0; i < consumerDestinations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, consumerDestinations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.Logging)) {
      return super.equals(obj);
    }
    com.google.api.Logging other = (com.google.api.Logging) obj;

    if (!getProducerDestinationsList().equals(other.getProducerDestinationsList())) return false;
    if (!getConsumerDestinationsList().equals(other.getConsumerDestinationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getProducerDestinationsCount() > 0) {
      hash = (37 * hash) + PRODUCER_DESTINATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getProducerDestinationsList().hashCode();
    }
    if (getConsumerDestinationsCount() > 0) {
      hash = (37 * hash) + CONSUMER_DESTINATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConsumerDestinationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.Logging parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.Logging parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.Logging parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.Logging parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.Logging parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.Logging parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.Logging parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.Logging parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.Logging parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.Logging parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.Logging parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.Logging parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.Logging prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Logging configuration of the service.
   *
   * The following example shows how to configure logs to be sent to the
   * producer and consumer projects. In the example, the `activity_history`
   * log is sent to both the producer and consumer projects, whereas the
   * `purchase_history` log is only sent to the producer project.
   *
   *     monitored_resources:
   *     - type: library.googleapis.com/branch
   *       labels:
   *       - key: /city
   *         description: The city where the library branch is located in.
   *       - key: /name
   *         description: The name of the branch.
   *     logs:
   *     - name: activity_history
   *       labels:
   *       - key: /customer_id
   *     - name: purchase_history
   *     logging:
   *       producer_destinations:
   *       - monitored_resource: library.googleapis.com/branch
   *         logs:
   *         - activity_history
   *         - purchase_history
   *       consumer_destinations:
   *       - monitored_resource: library.googleapis.com/branch
   *         logs:
   *         - activity_history
   * </pre>
   *
   * Protobuf type {@code google.api.Logging}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.Logging)
      com.google.api.LoggingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.LoggingProto.internal_static_google_api_Logging_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.LoggingProto.internal_static_google_api_Logging_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.Logging.class, com.google.api.Logging.Builder.class);
    }

    // Construct using com.google.api.Logging.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (producerDestinationsBuilder_ == null) {
        producerDestinations_ = java.util.Collections.emptyList();
      } else {
        producerDestinations_ = null;
        producerDestinationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinations_ = java.util.Collections.emptyList();
      } else {
        consumerDestinations_ = null;
        consumerDestinationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.LoggingProto.internal_static_google_api_Logging_descriptor;
    }

    @java.lang.Override
    public com.google.api.Logging getDefaultInstanceForType() {
      return com.google.api.Logging.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.Logging build() {
      com.google.api.Logging result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.Logging buildPartial() {
      com.google.api.Logging result = new com.google.api.Logging(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.api.Logging result) {
      if (producerDestinationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          producerDestinations_ = java.util.Collections.unmodifiableList(producerDestinations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.producerDestinations_ = producerDestinations_;
      } else {
        result.producerDestinations_ = producerDestinationsBuilder_.build();
      }
      if (consumerDestinationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          consumerDestinations_ = java.util.Collections.unmodifiableList(consumerDestinations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.consumerDestinations_ = consumerDestinations_;
      } else {
        result.consumerDestinations_ = consumerDestinationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.api.Logging result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.Logging) {
        return mergeFrom((com.google.api.Logging) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.Logging other) {
      if (other == com.google.api.Logging.getDefaultInstance()) return this;
      if (producerDestinationsBuilder_ == null) {
        if (!other.producerDestinations_.isEmpty()) {
          if (producerDestinations_.isEmpty()) {
            producerDestinations_ = other.producerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureProducerDestinationsIsMutable();
            producerDestinations_.addAll(other.producerDestinations_);
          }
          onChanged();
        }
      } else {
        if (!other.producerDestinations_.isEmpty()) {
          if (producerDestinationsBuilder_.isEmpty()) {
            producerDestinationsBuilder_.dispose();
            producerDestinationsBuilder_ = null;
            producerDestinations_ = other.producerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            producerDestinationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getProducerDestinationsFieldBuilder()
                    : null;
          } else {
            producerDestinationsBuilder_.addAllMessages(other.producerDestinations_);
          }
        }
      }
      if (consumerDestinationsBuilder_ == null) {
        if (!other.consumerDestinations_.isEmpty()) {
          if (consumerDestinations_.isEmpty()) {
            consumerDestinations_ = other.consumerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureConsumerDestinationsIsMutable();
            consumerDestinations_.addAll(other.consumerDestinations_);
          }
          onChanged();
        }
      } else {
        if (!other.consumerDestinations_.isEmpty()) {
          if (consumerDestinationsBuilder_.isEmpty()) {
            consumerDestinationsBuilder_.dispose();
            consumerDestinationsBuilder_ = null;
            consumerDestinations_ = other.consumerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            consumerDestinationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConsumerDestinationsFieldBuilder()
                    : null;
          } else {
            consumerDestinationsBuilder_.addAllMessages(other.consumerDestinations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.api.Logging.LoggingDestination m =
                    input.readMessage(
                        com.google.api.Logging.LoggingDestination.parser(), extensionRegistry);
                if (producerDestinationsBuilder_ == null) {
                  ensureProducerDestinationsIsMutable();
                  producerDestinations_.add(m);
                } else {
                  producerDestinationsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.api.Logging.LoggingDestination m =
                    input.readMessage(
                        com.google.api.Logging.LoggingDestination.parser(), extensionRegistry);
                if (consumerDestinationsBuilder_ == null) {
                  ensureConsumerDestinationsIsMutable();
                  consumerDestinations_.add(m);
                } else {
                  consumerDestinationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.api.Logging.LoggingDestination> producerDestinations_ =
        java.util.Collections.emptyList();

    private void ensureProducerDestinationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        producerDestinations_ =
            new java.util.ArrayList<com.google.api.Logging.LoggingDestination>(
                producerDestinations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Logging.LoggingDestination,
            com.google.api.Logging.LoggingDestination.Builder,
            com.google.api.Logging.LoggingDestinationOrBuilder>
        producerDestinationsBuilder_;

    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public java.util.List<com.google.api.Logging.LoggingDestination> getProducerDestinationsList() {
      if (producerDestinationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(producerDestinations_);
      } else {
        return producerDestinationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public int getProducerDestinationsCount() {
      if (producerDestinationsBuilder_ == null) {
        return producerDestinations_.size();
      } else {
        return producerDestinationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public com.google.api.Logging.LoggingDestination getProducerDestinations(int index) {
      if (producerDestinationsBuilder_ == null) {
        return producerDestinations_.get(index);
      } else {
        return producerDestinationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public Builder setProducerDestinations(
        int index, com.google.api.Logging.LoggingDestination value) {
      if (producerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProducerDestinationsIsMutable();
        producerDestinations_.set(index, value);
        onChanged();
      } else {
        producerDestinationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public Builder setProducerDestinations(
        int index, com.google.api.Logging.LoggingDestination.Builder builderForValue) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.set(index, builderForValue.build());
        onChanged();
      } else {
        producerDestinationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(com.google.api.Logging.LoggingDestination value) {
      if (producerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(value);
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(
        int index, com.google.api.Logging.LoggingDestination value) {
      if (producerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(index, value);
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(
        com.google.api.Logging.LoggingDestination.Builder builderForValue) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(builderForValue.build());
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(
        int index, com.google.api.Logging.LoggingDestination.Builder builderForValue) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(index, builderForValue.build());
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public Builder addAllProducerDestinations(
        java.lang.Iterable<? extends com.google.api.Logging.LoggingDestination> values) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, producerDestinations_);
        onChanged();
      } else {
        producerDestinationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public Builder clearProducerDestinations() {
      if (producerDestinationsBuilder_ == null) {
        producerDestinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        producerDestinationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public Builder removeProducerDestinations(int index) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.remove(index);
        onChanged();
      } else {
        producerDestinationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public com.google.api.Logging.LoggingDestination.Builder getProducerDestinationsBuilder(
        int index) {
      return getProducerDestinationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public com.google.api.Logging.LoggingDestinationOrBuilder getProducerDestinationsOrBuilder(
        int index) {
      if (producerDestinationsBuilder_ == null) {
        return producerDestinations_.get(index);
      } else {
        return producerDestinationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public java.util.List<? extends com.google.api.Logging.LoggingDestinationOrBuilder>
        getProducerDestinationsOrBuilderList() {
      if (producerDestinationsBuilder_ != null) {
        return producerDestinationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(producerDestinations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public com.google.api.Logging.LoggingDestination.Builder addProducerDestinationsBuilder() {
      return getProducerDestinationsFieldBuilder()
          .addBuilder(com.google.api.Logging.LoggingDestination.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public com.google.api.Logging.LoggingDestination.Builder addProducerDestinationsBuilder(
        int index) {
      return getProducerDestinationsFieldBuilder()
          .addBuilder(index, com.google.api.Logging.LoggingDestination.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the producer project.
     * There can be multiple producer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one producer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination producer_destinations = 1;</code>
     */
    public java.util.List<com.google.api.Logging.LoggingDestination.Builder>
        getProducerDestinationsBuilderList() {
      return getProducerDestinationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Logging.LoggingDestination,
            com.google.api.Logging.LoggingDestination.Builder,
            com.google.api.Logging.LoggingDestinationOrBuilder>
        getProducerDestinationsFieldBuilder() {
      if (producerDestinationsBuilder_ == null) {
        producerDestinationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.Logging.LoggingDestination,
                com.google.api.Logging.LoggingDestination.Builder,
                com.google.api.Logging.LoggingDestinationOrBuilder>(
                producerDestinations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        producerDestinations_ = null;
      }
      return producerDestinationsBuilder_;
    }

    private java.util.List<com.google.api.Logging.LoggingDestination> consumerDestinations_ =
        java.util.Collections.emptyList();

    private void ensureConsumerDestinationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        consumerDestinations_ =
            new java.util.ArrayList<com.google.api.Logging.LoggingDestination>(
                consumerDestinations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Logging.LoggingDestination,
            com.google.api.Logging.LoggingDestination.Builder,
            com.google.api.Logging.LoggingDestinationOrBuilder>
        consumerDestinationsBuilder_;

    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public java.util.List<com.google.api.Logging.LoggingDestination> getConsumerDestinationsList() {
      if (consumerDestinationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(consumerDestinations_);
      } else {
        return consumerDestinationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public int getConsumerDestinationsCount() {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.size();
      } else {
        return consumerDestinationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public com.google.api.Logging.LoggingDestination getConsumerDestinations(int index) {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.get(index);
      } else {
        return consumerDestinationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public Builder setConsumerDestinations(
        int index, com.google.api.Logging.LoggingDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.set(index, value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public Builder setConsumerDestinations(
        int index, com.google.api.Logging.LoggingDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.set(index, builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(com.google.api.Logging.LoggingDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(
        int index, com.google.api.Logging.LoggingDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(index, value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(
        com.google.api.Logging.LoggingDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(
        int index, com.google.api.Logging.LoggingDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(index, builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public Builder addAllConsumerDestinations(
        java.lang.Iterable<? extends com.google.api.Logging.LoggingDestination> values) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, consumerDestinations_);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public Builder clearConsumerDestinations() {
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        consumerDestinationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public Builder removeConsumerDestinations(int index) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.remove(index);
        onChanged();
      } else {
        consumerDestinationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public com.google.api.Logging.LoggingDestination.Builder getConsumerDestinationsBuilder(
        int index) {
      return getConsumerDestinationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public com.google.api.Logging.LoggingDestinationOrBuilder getConsumerDestinationsOrBuilder(
        int index) {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.get(index);
      } else {
        return consumerDestinationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public java.util.List<? extends com.google.api.Logging.LoggingDestinationOrBuilder>
        getConsumerDestinationsOrBuilderList() {
      if (consumerDestinationsBuilder_ != null) {
        return consumerDestinationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(consumerDestinations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public com.google.api.Logging.LoggingDestination.Builder addConsumerDestinationsBuilder() {
      return getConsumerDestinationsFieldBuilder()
          .addBuilder(com.google.api.Logging.LoggingDestination.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public com.google.api.Logging.LoggingDestination.Builder addConsumerDestinationsBuilder(
        int index) {
      return getConsumerDestinationsFieldBuilder()
          .addBuilder(index, com.google.api.Logging.LoggingDestination.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Logging configurations for sending logs to the consumer project.
     * There can be multiple consumer destinations, each one must have a
     * different monitored resource type. A log can be used in at most
     * one consumer destination.
     * </pre>
     *
     * <code>repeated .google.api.Logging.LoggingDestination consumer_destinations = 2;</code>
     */
    public java.util.List<com.google.api.Logging.LoggingDestination.Builder>
        getConsumerDestinationsBuilderList() {
      return getConsumerDestinationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Logging.LoggingDestination,
            com.google.api.Logging.LoggingDestination.Builder,
            com.google.api.Logging.LoggingDestinationOrBuilder>
        getConsumerDestinationsFieldBuilder() {
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.Logging.LoggingDestination,
                com.google.api.Logging.LoggingDestination.Builder,
                com.google.api.Logging.LoggingDestinationOrBuilder>(
                consumerDestinations_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        consumerDestinations_ = null;
      }
      return consumerDestinationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.Logging)
  }

  // @@protoc_insertion_point(class_scope:google.api.Logging)
  private static final com.google.api.Logging DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.Logging();
  }

  public static com.google.api.Logging getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Logging> PARSER =
      new com.google.protobuf.AbstractParser<Logging>() {
        @java.lang.Override
        public Logging parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Logging> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Logging> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.Logging getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
