/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/usage.proto

// Protobuf Java Version: 3.25.2
package com.google.api;

public interface UsageOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.api.Usage)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Requirements that must be satisfied before a consumer project can use the
   * service. Each requirement is of the form &lt;service.name&gt;/&lt;requirement-id&gt;;
   * for example 'serviceusage.googleapis.com/billing-enabled'.
   *
   * For Google APIs, a Terms of Service requirement must be included here.
   * Google Cloud APIs must include "serviceusage.googleapis.com/tos/cloud".
   * Other Google APIs should include
   * "serviceusage.googleapis.com/tos/universal". Additional ToS can be
   * included based on the business needs.
   * </pre>
   *
   * <code>repeated string requirements = 1;</code>
   *
   * @return A list containing the requirements.
   */
  java.util.List<java.lang.String> getRequirementsList();
  /**
   *
   *
   * <pre>
   * Requirements that must be satisfied before a consumer project can use the
   * service. Each requirement is of the form &lt;service.name&gt;/&lt;requirement-id&gt;;
   * for example 'serviceusage.googleapis.com/billing-enabled'.
   *
   * For Google APIs, a Terms of Service requirement must be included here.
   * Google Cloud APIs must include "serviceusage.googleapis.com/tos/cloud".
   * Other Google APIs should include
   * "serviceusage.googleapis.com/tos/universal". Additional ToS can be
   * included based on the business needs.
   * </pre>
   *
   * <code>repeated string requirements = 1;</code>
   *
   * @return The count of requirements.
   */
  int getRequirementsCount();
  /**
   *
   *
   * <pre>
   * Requirements that must be satisfied before a consumer project can use the
   * service. Each requirement is of the form &lt;service.name&gt;/&lt;requirement-id&gt;;
   * for example 'serviceusage.googleapis.com/billing-enabled'.
   *
   * For Google APIs, a Terms of Service requirement must be included here.
   * Google Cloud APIs must include "serviceusage.googleapis.com/tos/cloud".
   * Other Google APIs should include
   * "serviceusage.googleapis.com/tos/universal". Additional ToS can be
   * included based on the business needs.
   * </pre>
   *
   * <code>repeated string requirements = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The requirements at the given index.
   */
  java.lang.String getRequirements(int index);
  /**
   *
   *
   * <pre>
   * Requirements that must be satisfied before a consumer project can use the
   * service. Each requirement is of the form &lt;service.name&gt;/&lt;requirement-id&gt;;
   * for example 'serviceusage.googleapis.com/billing-enabled'.
   *
   * For Google APIs, a Terms of Service requirement must be included here.
   * Google Cloud APIs must include "serviceusage.googleapis.com/tos/cloud".
   * Other Google APIs should include
   * "serviceusage.googleapis.com/tos/universal". Additional ToS can be
   * included based on the business needs.
   * </pre>
   *
   * <code>repeated string requirements = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the requirements at the given index.
   */
  com.google.protobuf.ByteString getRequirementsBytes(int index);

  /**
   *
   *
   * <pre>
   * A list of usage rules that apply to individual API methods.
   *
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.UsageRule rules = 6;</code>
   */
  java.util.List<com.google.api.UsageRule> getRulesList();
  /**
   *
   *
   * <pre>
   * A list of usage rules that apply to individual API methods.
   *
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.UsageRule rules = 6;</code>
   */
  com.google.api.UsageRule getRules(int index);
  /**
   *
   *
   * <pre>
   * A list of usage rules that apply to individual API methods.
   *
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.UsageRule rules = 6;</code>
   */
  int getRulesCount();
  /**
   *
   *
   * <pre>
   * A list of usage rules that apply to individual API methods.
   *
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.UsageRule rules = 6;</code>
   */
  java.util.List<? extends com.google.api.UsageRuleOrBuilder> getRulesOrBuilderList();
  /**
   *
   *
   * <pre>
   * A list of usage rules that apply to individual API methods.
   *
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.UsageRule rules = 6;</code>
   */
  com.google.api.UsageRuleOrBuilder getRulesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * The full resource name of a channel used for sending notifications to the
   * service producer.
   *
   * Google Service Management currently only supports
   * [Google Cloud Pub/Sub](https://cloud.google.com/pubsub) as a notification
   * channel. To use Google Cloud Pub/Sub as the channel, this must be the name
   * of a Cloud Pub/Sub topic that uses the Cloud Pub/Sub topic name format
   * documented in https://cloud.google.com/pubsub/docs/overview.
   * </pre>
   *
   * <code>string producer_notification_channel = 7;</code>
   *
   * @return The producerNotificationChannel.
   */
  java.lang.String getProducerNotificationChannel();
  /**
   *
   *
   * <pre>
   * The full resource name of a channel used for sending notifications to the
   * service producer.
   *
   * Google Service Management currently only supports
   * [Google Cloud Pub/Sub](https://cloud.google.com/pubsub) as a notification
   * channel. To use Google Cloud Pub/Sub as the channel, this must be the name
   * of a Cloud Pub/Sub topic that uses the Cloud Pub/Sub topic name format
   * documented in https://cloud.google.com/pubsub/docs/overview.
   * </pre>
   *
   * <code>string producer_notification_channel = 7;</code>
   *
   * @return The bytes for producerNotificationChannel.
   */
  com.google.protobuf.ByteString getProducerNotificationChannelBytes();
}
