// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/endpoint.proto

package com.google.api;

/**
 * <pre>
 * `Endpoint` describes a network endpoint that serves a set of APIs.
 * A service may expose any number of endpoints, and all endpoints share the
 * same service configuration, such as quota configuration and monitoring
 * configuration.
 * Example service configuration:
 *     name: library-example.googleapis.com
 *     endpoints:
 *       # Below entry makes 'google.example.library.v1.Library'
 *       # API be served from endpoint address library-example.googleapis.com.
 *       # It also allows HTTP OPTIONS calls to be passed to the backend, for
 *       # it to decide whether the subsequent cross-origin request is
 *       # allowed to proceed.
 *     - name: library-example.googleapis.com
 *       allow_cors: true
 * </pre>
 *
 * Protobuf type {@code google.api.Endpoint}
 */
public  final class Endpoint extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.api.Endpoint)
    EndpointOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Endpoint.newBuilder() to construct.
  private Endpoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Endpoint() {
    name_ = "";
    aliases_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    apis_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    features_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    target_ = "";
    allowCors_ = false;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Endpoint(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            name_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
              aliases_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000002;
            }
            aliases_.add(s);
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
              apis_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000004;
            }
            apis_.add(s);
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
              features_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000008;
            }
            features_.add(s);
            break;
          }
          case 40: {

            allowCors_ = input.readBool();
            break;
          }
          case 810: {
            java.lang.String s = input.readStringRequireUtf8();

            target_ = s;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
        aliases_ = aliases_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
        apis_ = apis_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
        features_ = features_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.api.EndpointProto.internal_static_google_api_Endpoint_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.EndpointProto.internal_static_google_api_Endpoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.Endpoint.class, com.google.api.Endpoint.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   * <pre>
   * The canonical name of this endpoint.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The canonical name of this endpoint.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALIASES_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList aliases_;
  /**
   * <pre>
   * DEPRECATED: This field is no longer supported. Instead of using aliases,
   * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
   * alias.
   * Additional names that this endpoint will be hosted on.
   * </pre>
   *
   * <code>repeated string aliases = 2;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getAliasesList() {
    return aliases_;
  }
  /**
   * <pre>
   * DEPRECATED: This field is no longer supported. Instead of using aliases,
   * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
   * alias.
   * Additional names that this endpoint will be hosted on.
   * </pre>
   *
   * <code>repeated string aliases = 2;</code>
   */
  public int getAliasesCount() {
    return aliases_.size();
  }
  /**
   * <pre>
   * DEPRECATED: This field is no longer supported. Instead of using aliases,
   * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
   * alias.
   * Additional names that this endpoint will be hosted on.
   * </pre>
   *
   * <code>repeated string aliases = 2;</code>
   */
  public java.lang.String getAliases(int index) {
    return aliases_.get(index);
  }
  /**
   * <pre>
   * DEPRECATED: This field is no longer supported. Instead of using aliases,
   * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
   * alias.
   * Additional names that this endpoint will be hosted on.
   * </pre>
   *
   * <code>repeated string aliases = 2;</code>
   */
  public com.google.protobuf.ByteString
      getAliasesBytes(int index) {
    return aliases_.getByteString(index);
  }

  public static final int APIS_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList apis_;
  /**
   * <pre>
   * The list of APIs served by this endpoint.
   * </pre>
   *
   * <code>repeated string apis = 3;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getApisList() {
    return apis_;
  }
  /**
   * <pre>
   * The list of APIs served by this endpoint.
   * </pre>
   *
   * <code>repeated string apis = 3;</code>
   */
  public int getApisCount() {
    return apis_.size();
  }
  /**
   * <pre>
   * The list of APIs served by this endpoint.
   * </pre>
   *
   * <code>repeated string apis = 3;</code>
   */
  public java.lang.String getApis(int index) {
    return apis_.get(index);
  }
  /**
   * <pre>
   * The list of APIs served by this endpoint.
   * </pre>
   *
   * <code>repeated string apis = 3;</code>
   */
  public com.google.protobuf.ByteString
      getApisBytes(int index) {
    return apis_.getByteString(index);
  }

  public static final int FEATURES_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList features_;
  /**
   * <pre>
   * The list of features enabled on this endpoint.
   * </pre>
   *
   * <code>repeated string features = 4;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getFeaturesList() {
    return features_;
  }
  /**
   * <pre>
   * The list of features enabled on this endpoint.
   * </pre>
   *
   * <code>repeated string features = 4;</code>
   */
  public int getFeaturesCount() {
    return features_.size();
  }
  /**
   * <pre>
   * The list of features enabled on this endpoint.
   * </pre>
   *
   * <code>repeated string features = 4;</code>
   */
  public java.lang.String getFeatures(int index) {
    return features_.get(index);
  }
  /**
   * <pre>
   * The list of features enabled on this endpoint.
   * </pre>
   *
   * <code>repeated string features = 4;</code>
   */
  public com.google.protobuf.ByteString
      getFeaturesBytes(int index) {
    return features_.getByteString(index);
  }

  public static final int TARGET_FIELD_NUMBER = 101;
  private volatile java.lang.Object target_;
  /**
   * <pre>
   * The specification of an Internet routable address of API frontend that will
   * handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary).
   * It should be either a valid IPv4 address or a fully-qualified domain name.
   * For example, "8.8.8.8" or "myservice.appspot.com".
   * </pre>
   *
   * <code>string target = 101;</code>
   */
  public java.lang.String getTarget() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      target_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The specification of an Internet routable address of API frontend that will
   * handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary).
   * It should be either a valid IPv4 address or a fully-qualified domain name.
   * For example, "8.8.8.8" or "myservice.appspot.com".
   * </pre>
   *
   * <code>string target = 101;</code>
   */
  public com.google.protobuf.ByteString
      getTargetBytes() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      target_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALLOW_CORS_FIELD_NUMBER = 5;
  private boolean allowCors_;
  /**
   * <pre>
   * Allowing
   * [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka
   * cross-domain traffic, would allow the backends served from this endpoint to
   * receive and respond to HTTP OPTIONS requests. The response will be used by
   * the browser to determine whether the subsequent cross-origin request is
   * allowed to proceed.
   * </pre>
   *
   * <code>bool allow_cors = 5;</code>
   */
  public boolean getAllowCors() {
    return allowCors_;
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < aliases_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, aliases_.getRaw(i));
    }
    for (int i = 0; i < apis_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, apis_.getRaw(i));
    }
    for (int i = 0; i < features_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, features_.getRaw(i));
    }
    if (allowCors_ != false) {
      output.writeBool(5, allowCors_);
    }
    if (!getTargetBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 101, target_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < aliases_.size(); i++) {
        dataSize += computeStringSizeNoTag(aliases_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAliasesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < apis_.size(); i++) {
        dataSize += computeStringSizeNoTag(apis_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getApisList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < features_.size(); i++) {
        dataSize += computeStringSizeNoTag(features_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFeaturesList().size();
    }
    if (allowCors_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(5, allowCors_);
    }
    if (!getTargetBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(101, target_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.api.Endpoint)) {
      return super.equals(obj);
    }
    com.google.api.Endpoint other = (com.google.api.Endpoint) obj;

    boolean result = true;
    result = result && getName()
        .equals(other.getName());
    result = result && getAliasesList()
        .equals(other.getAliasesList());
    result = result && getApisList()
        .equals(other.getApisList());
    result = result && getFeaturesList()
        .equals(other.getFeaturesList());
    result = result && getTarget()
        .equals(other.getTarget());
    result = result && (getAllowCors()
        == other.getAllowCors());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getAliasesCount() > 0) {
      hash = (37 * hash) + ALIASES_FIELD_NUMBER;
      hash = (53 * hash) + getAliasesList().hashCode();
    }
    if (getApisCount() > 0) {
      hash = (37 * hash) + APIS_FIELD_NUMBER;
      hash = (53 * hash) + getApisList().hashCode();
    }
    if (getFeaturesCount() > 0) {
      hash = (37 * hash) + FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getFeaturesList().hashCode();
    }
    hash = (37 * hash) + TARGET_FIELD_NUMBER;
    hash = (53 * hash) + getTarget().hashCode();
    hash = (37 * hash) + ALLOW_CORS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getAllowCors());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.Endpoint parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.Endpoint parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.Endpoint parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.Endpoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.Endpoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.Endpoint parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.Endpoint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.Endpoint parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.Endpoint parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.api.Endpoint parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.Endpoint parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.Endpoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.api.Endpoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * `Endpoint` describes a network endpoint that serves a set of APIs.
   * A service may expose any number of endpoints, and all endpoints share the
   * same service configuration, such as quota configuration and monitoring
   * configuration.
   * Example service configuration:
   *     name: library-example.googleapis.com
   *     endpoints:
   *       # Below entry makes 'google.example.library.v1.Library'
   *       # API be served from endpoint address library-example.googleapis.com.
   *       # It also allows HTTP OPTIONS calls to be passed to the backend, for
   *       # it to decide whether the subsequent cross-origin request is
   *       # allowed to proceed.
   *     - name: library-example.googleapis.com
   *       allow_cors: true
   * </pre>
   *
   * Protobuf type {@code google.api.Endpoint}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.api.Endpoint)
      com.google.api.EndpointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.api.EndpointProto.internal_static_google_api_Endpoint_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.EndpointProto.internal_static_google_api_Endpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.Endpoint.class, com.google.api.Endpoint.Builder.class);
    }

    // Construct using com.google.api.Endpoint.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      name_ = "";

      aliases_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      apis_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      features_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      target_ = "";

      allowCors_ = false;

      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.api.EndpointProto.internal_static_google_api_Endpoint_descriptor;
    }

    public com.google.api.Endpoint getDefaultInstanceForType() {
      return com.google.api.Endpoint.getDefaultInstance();
    }

    public com.google.api.Endpoint build() {
      com.google.api.Endpoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.api.Endpoint buildPartial() {
      com.google.api.Endpoint result = new com.google.api.Endpoint(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.name_ = name_;
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        aliases_ = aliases_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.aliases_ = aliases_;
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        apis_ = apis_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.apis_ = apis_;
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        features_ = features_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.features_ = features_;
      result.target_ = target_;
      result.allowCors_ = allowCors_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.Endpoint) {
        return mergeFrom((com.google.api.Endpoint)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.Endpoint other) {
      if (other == com.google.api.Endpoint.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.aliases_.isEmpty()) {
        if (aliases_.isEmpty()) {
          aliases_ = other.aliases_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureAliasesIsMutable();
          aliases_.addAll(other.aliases_);
        }
        onChanged();
      }
      if (!other.apis_.isEmpty()) {
        if (apis_.isEmpty()) {
          apis_ = other.apis_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureApisIsMutable();
          apis_.addAll(other.apis_);
        }
        onChanged();
      }
      if (!other.features_.isEmpty()) {
        if (features_.isEmpty()) {
          features_ = other.features_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureFeaturesIsMutable();
          features_.addAll(other.features_);
        }
        onChanged();
      }
      if (!other.getTarget().isEmpty()) {
        target_ = other.target_;
        onChanged();
      }
      if (other.getAllowCors() != false) {
        setAllowCors(other.getAllowCors());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.api.Endpoint parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.api.Endpoint) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * The canonical name of this endpoint.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The canonical name of this endpoint.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The canonical name of this endpoint.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      name_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The canonical name of this endpoint.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder clearName() {
      
      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The canonical name of this endpoint.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList aliases_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureAliasesIsMutable() {
      if (!((bitField0_ & 0x00000002) == 0x00000002)) {
        aliases_ = new com.google.protobuf.LazyStringArrayList(aliases_);
        bitField0_ |= 0x00000002;
       }
    }
    /**
     * <pre>
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
     * alias.
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getAliasesList() {
      return aliases_.getUnmodifiableView();
    }
    /**
     * <pre>
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
     * alias.
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2;</code>
     */
    public int getAliasesCount() {
      return aliases_.size();
    }
    /**
     * <pre>
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
     * alias.
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2;</code>
     */
    public java.lang.String getAliases(int index) {
      return aliases_.get(index);
    }
    /**
     * <pre>
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
     * alias.
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2;</code>
     */
    public com.google.protobuf.ByteString
        getAliasesBytes(int index) {
      return aliases_.getByteString(index);
    }
    /**
     * <pre>
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
     * alias.
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2;</code>
     */
    public Builder setAliases(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureAliasesIsMutable();
      aliases_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
     * alias.
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2;</code>
     */
    public Builder addAliases(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureAliasesIsMutable();
      aliases_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
     * alias.
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2;</code>
     */
    public Builder addAllAliases(
        java.lang.Iterable<java.lang.String> values) {
      ensureAliasesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, aliases_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
     * alias.
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2;</code>
     */
    public Builder clearAliases() {
      aliases_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intented
     * alias.
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2;</code>
     */
    public Builder addAliasesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureAliasesIsMutable();
      aliases_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList apis_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureApisIsMutable() {
      if (!((bitField0_ & 0x00000004) == 0x00000004)) {
        apis_ = new com.google.protobuf.LazyStringArrayList(apis_);
        bitField0_ |= 0x00000004;
       }
    }
    /**
     * <pre>
     * The list of APIs served by this endpoint.
     * </pre>
     *
     * <code>repeated string apis = 3;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getApisList() {
      return apis_.getUnmodifiableView();
    }
    /**
     * <pre>
     * The list of APIs served by this endpoint.
     * </pre>
     *
     * <code>repeated string apis = 3;</code>
     */
    public int getApisCount() {
      return apis_.size();
    }
    /**
     * <pre>
     * The list of APIs served by this endpoint.
     * </pre>
     *
     * <code>repeated string apis = 3;</code>
     */
    public java.lang.String getApis(int index) {
      return apis_.get(index);
    }
    /**
     * <pre>
     * The list of APIs served by this endpoint.
     * </pre>
     *
     * <code>repeated string apis = 3;</code>
     */
    public com.google.protobuf.ByteString
        getApisBytes(int index) {
      return apis_.getByteString(index);
    }
    /**
     * <pre>
     * The list of APIs served by this endpoint.
     * </pre>
     *
     * <code>repeated string apis = 3;</code>
     */
    public Builder setApis(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureApisIsMutable();
      apis_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of APIs served by this endpoint.
     * </pre>
     *
     * <code>repeated string apis = 3;</code>
     */
    public Builder addApis(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureApisIsMutable();
      apis_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of APIs served by this endpoint.
     * </pre>
     *
     * <code>repeated string apis = 3;</code>
     */
    public Builder addAllApis(
        java.lang.Iterable<java.lang.String> values) {
      ensureApisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, apis_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of APIs served by this endpoint.
     * </pre>
     *
     * <code>repeated string apis = 3;</code>
     */
    public Builder clearApis() {
      apis_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of APIs served by this endpoint.
     * </pre>
     *
     * <code>repeated string apis = 3;</code>
     */
    public Builder addApisBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureApisIsMutable();
      apis_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList features_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureFeaturesIsMutable() {
      if (!((bitField0_ & 0x00000008) == 0x00000008)) {
        features_ = new com.google.protobuf.LazyStringArrayList(features_);
        bitField0_ |= 0x00000008;
       }
    }
    /**
     * <pre>
     * The list of features enabled on this endpoint.
     * </pre>
     *
     * <code>repeated string features = 4;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getFeaturesList() {
      return features_.getUnmodifiableView();
    }
    /**
     * <pre>
     * The list of features enabled on this endpoint.
     * </pre>
     *
     * <code>repeated string features = 4;</code>
     */
    public int getFeaturesCount() {
      return features_.size();
    }
    /**
     * <pre>
     * The list of features enabled on this endpoint.
     * </pre>
     *
     * <code>repeated string features = 4;</code>
     */
    public java.lang.String getFeatures(int index) {
      return features_.get(index);
    }
    /**
     * <pre>
     * The list of features enabled on this endpoint.
     * </pre>
     *
     * <code>repeated string features = 4;</code>
     */
    public com.google.protobuf.ByteString
        getFeaturesBytes(int index) {
      return features_.getByteString(index);
    }
    /**
     * <pre>
     * The list of features enabled on this endpoint.
     * </pre>
     *
     * <code>repeated string features = 4;</code>
     */
    public Builder setFeatures(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureFeaturesIsMutable();
      features_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of features enabled on this endpoint.
     * </pre>
     *
     * <code>repeated string features = 4;</code>
     */
    public Builder addFeatures(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureFeaturesIsMutable();
      features_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of features enabled on this endpoint.
     * </pre>
     *
     * <code>repeated string features = 4;</code>
     */
    public Builder addAllFeatures(
        java.lang.Iterable<java.lang.String> values) {
      ensureFeaturesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, features_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of features enabled on this endpoint.
     * </pre>
     *
     * <code>repeated string features = 4;</code>
     */
    public Builder clearFeatures() {
      features_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The list of features enabled on this endpoint.
     * </pre>
     *
     * <code>repeated string features = 4;</code>
     */
    public Builder addFeaturesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureFeaturesIsMutable();
      features_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object target_ = "";
    /**
     * <pre>
     * The specification of an Internet routable address of API frontend that will
     * handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary).
     * It should be either a valid IPv4 address or a fully-qualified domain name.
     * For example, "8.8.8.8" or "myservice.appspot.com".
     * </pre>
     *
     * <code>string target = 101;</code>
     */
    public java.lang.String getTarget() {
      java.lang.Object ref = target_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        target_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The specification of an Internet routable address of API frontend that will
     * handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary).
     * It should be either a valid IPv4 address or a fully-qualified domain name.
     * For example, "8.8.8.8" or "myservice.appspot.com".
     * </pre>
     *
     * <code>string target = 101;</code>
     */
    public com.google.protobuf.ByteString
        getTargetBytes() {
      java.lang.Object ref = target_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        target_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The specification of an Internet routable address of API frontend that will
     * handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary).
     * It should be either a valid IPv4 address or a fully-qualified domain name.
     * For example, "8.8.8.8" or "myservice.appspot.com".
     * </pre>
     *
     * <code>string target = 101;</code>
     */
    public Builder setTarget(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      target_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The specification of an Internet routable address of API frontend that will
     * handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary).
     * It should be either a valid IPv4 address or a fully-qualified domain name.
     * For example, "8.8.8.8" or "myservice.appspot.com".
     * </pre>
     *
     * <code>string target = 101;</code>
     */
    public Builder clearTarget() {
      
      target_ = getDefaultInstance().getTarget();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The specification of an Internet routable address of API frontend that will
     * handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary).
     * It should be either a valid IPv4 address or a fully-qualified domain name.
     * For example, "8.8.8.8" or "myservice.appspot.com".
     * </pre>
     *
     * <code>string target = 101;</code>
     */
    public Builder setTargetBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      target_ = value;
      onChanged();
      return this;
    }

    private boolean allowCors_ ;
    /**
     * <pre>
     * Allowing
     * [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka
     * cross-domain traffic, would allow the backends served from this endpoint to
     * receive and respond to HTTP OPTIONS requests. The response will be used by
     * the browser to determine whether the subsequent cross-origin request is
     * allowed to proceed.
     * </pre>
     *
     * <code>bool allow_cors = 5;</code>
     */
    public boolean getAllowCors() {
      return allowCors_;
    }
    /**
     * <pre>
     * Allowing
     * [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka
     * cross-domain traffic, would allow the backends served from this endpoint to
     * receive and respond to HTTP OPTIONS requests. The response will be used by
     * the browser to determine whether the subsequent cross-origin request is
     * allowed to proceed.
     * </pre>
     *
     * <code>bool allow_cors = 5;</code>
     */
    public Builder setAllowCors(boolean value) {
      
      allowCors_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Allowing
     * [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka
     * cross-domain traffic, would allow the backends served from this endpoint to
     * receive and respond to HTTP OPTIONS requests. The response will be used by
     * the browser to determine whether the subsequent cross-origin request is
     * allowed to proceed.
     * </pre>
     *
     * <code>bool allow_cors = 5;</code>
     */
    public Builder clearAllowCors() {
      
      allowCors_ = false;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.api.Endpoint)
  }

  // @@protoc_insertion_point(class_scope:google.api.Endpoint)
  private static final com.google.api.Endpoint DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.api.Endpoint();
  }

  public static com.google.api.Endpoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Endpoint>
      PARSER = new com.google.protobuf.AbstractParser<Endpoint>() {
    public Endpoint parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
        return new Endpoint(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Endpoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Endpoint> getParserForType() {
    return PARSER;
  }

  public com.google.api.Endpoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

