/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/quota.proto

package com.google.api;

/**
 *
 *
 * <pre>
 * Quota configuration helps to achieve fairness and budgeting in service
 * usage.
 * The metric based quota configuration works this way:
 * - The service configuration defines a set of metrics.
 * - For API calls, the quota.metric_rules maps methods to metrics with
 *   corresponding costs.
 * - The quota.limits defines limits on the metrics, which will be used for
 *   quota checks at runtime.
 * An example quota configuration in yaml format:
 *    quota:
 *      limits:
 *      - name: apiWriteQpsPerProject
 *        metric: library.googleapis.com/write_calls
 *        unit: "1/min/{project}"  # rate limit for consumer projects
 *        values:
 *          STANDARD: 10000
 *      # The metric rules bind all methods to the read_calls metric,
 *      # except for the UpdateBook and DeleteBook methods. These two methods
 *      # are mapped to the write_calls metric, with the UpdateBook method
 *      # consuming at twice rate as the DeleteBook method.
 *      metric_rules:
 *      - selector: "*"
 *        metric_costs:
 *          library.googleapis.com/read_calls: 1
 *      - selector: google.example.library.v1.LibraryService.UpdateBook
 *        metric_costs:
 *          library.googleapis.com/write_calls: 2
 *      - selector: google.example.library.v1.LibraryService.DeleteBook
 *        metric_costs:
 *          library.googleapis.com/write_calls: 1
 *  Corresponding Metric definition:
 *      metrics:
 *      - name: library.googleapis.com/read_calls
 *        display_name: Read requests
 *        metric_kind: DELTA
 *        value_type: INT64
 *      - name: library.googleapis.com/write_calls
 *        display_name: Write requests
 *        metric_kind: DELTA
 *        value_type: INT64
 * </pre>
 *
 * Protobuf type {@code google.api.Quota}
 */
public final class Quota extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.Quota)
    QuotaOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Quota.newBuilder() to construct.
  private Quota(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Quota() {
    limits_ = java.util.Collections.emptyList();
    metricRules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Quota();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Quota(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                limits_ = new java.util.ArrayList<com.google.api.QuotaLimit>();
                mutable_bitField0_ |= 0x00000001;
              }
              limits_.add(input.readMessage(com.google.api.QuotaLimit.parser(), extensionRegistry));
              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                metricRules_ = new java.util.ArrayList<com.google.api.MetricRule>();
                mutable_bitField0_ |= 0x00000002;
              }
              metricRules_.add(
                  input.readMessage(com.google.api.MetricRule.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        limits_ = java.util.Collections.unmodifiableList(limits_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        metricRules_ = java.util.Collections.unmodifiableList(metricRules_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.QuotaProto.internal_static_google_api_Quota_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.QuotaProto.internal_static_google_api_Quota_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.Quota.class, com.google.api.Quota.Builder.class);
  }

  public static final int LIMITS_FIELD_NUMBER = 3;
  private java.util.List<com.google.api.QuotaLimit> limits_;
  /**
   *
   *
   * <pre>
   * List of `QuotaLimit` definitions for the service.
   * </pre>
   *
   * <code>repeated .google.api.QuotaLimit limits = 3;</code>
   */
  public java.util.List<com.google.api.QuotaLimit> getLimitsList() {
    return limits_;
  }
  /**
   *
   *
   * <pre>
   * List of `QuotaLimit` definitions for the service.
   * </pre>
   *
   * <code>repeated .google.api.QuotaLimit limits = 3;</code>
   */
  public java.util.List<? extends com.google.api.QuotaLimitOrBuilder> getLimitsOrBuilderList() {
    return limits_;
  }
  /**
   *
   *
   * <pre>
   * List of `QuotaLimit` definitions for the service.
   * </pre>
   *
   * <code>repeated .google.api.QuotaLimit limits = 3;</code>
   */
  public int getLimitsCount() {
    return limits_.size();
  }
  /**
   *
   *
   * <pre>
   * List of `QuotaLimit` definitions for the service.
   * </pre>
   *
   * <code>repeated .google.api.QuotaLimit limits = 3;</code>
   */
  public com.google.api.QuotaLimit getLimits(int index) {
    return limits_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of `QuotaLimit` definitions for the service.
   * </pre>
   *
   * <code>repeated .google.api.QuotaLimit limits = 3;</code>
   */
  public com.google.api.QuotaLimitOrBuilder getLimitsOrBuilder(int index) {
    return limits_.get(index);
  }

  public static final int METRIC_RULES_FIELD_NUMBER = 4;
  private java.util.List<com.google.api.MetricRule> metricRules_;
  /**
   *
   *
   * <pre>
   * List of `MetricRule` definitions, each one mapping a selected method to one
   * or more metrics.
   * </pre>
   *
   * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
   */
  public java.util.List<com.google.api.MetricRule> getMetricRulesList() {
    return metricRules_;
  }
  /**
   *
   *
   * <pre>
   * List of `MetricRule` definitions, each one mapping a selected method to one
   * or more metrics.
   * </pre>
   *
   * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
   */
  public java.util.List<? extends com.google.api.MetricRuleOrBuilder>
      getMetricRulesOrBuilderList() {
    return metricRules_;
  }
  /**
   *
   *
   * <pre>
   * List of `MetricRule` definitions, each one mapping a selected method to one
   * or more metrics.
   * </pre>
   *
   * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
   */
  public int getMetricRulesCount() {
    return metricRules_.size();
  }
  /**
   *
   *
   * <pre>
   * List of `MetricRule` definitions, each one mapping a selected method to one
   * or more metrics.
   * </pre>
   *
   * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
   */
  public com.google.api.MetricRule getMetricRules(int index) {
    return metricRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of `MetricRule` definitions, each one mapping a selected method to one
   * or more metrics.
   * </pre>
   *
   * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
   */
  public com.google.api.MetricRuleOrBuilder getMetricRulesOrBuilder(int index) {
    return metricRules_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < limits_.size(); i++) {
      output.writeMessage(3, limits_.get(i));
    }
    for (int i = 0; i < metricRules_.size(); i++) {
      output.writeMessage(4, metricRules_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < limits_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, limits_.get(i));
    }
    for (int i = 0; i < metricRules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, metricRules_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.Quota)) {
      return super.equals(obj);
    }
    com.google.api.Quota other = (com.google.api.Quota) obj;

    if (!getLimitsList().equals(other.getLimitsList())) return false;
    if (!getMetricRulesList().equals(other.getMetricRulesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getLimitsCount() > 0) {
      hash = (37 * hash) + LIMITS_FIELD_NUMBER;
      hash = (53 * hash) + getLimitsList().hashCode();
    }
    if (getMetricRulesCount() > 0) {
      hash = (37 * hash) + METRIC_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getMetricRulesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.Quota parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.Quota parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.Quota parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.Quota parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.Quota parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.Quota parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.Quota parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.Quota parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.Quota parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.Quota parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.Quota parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.Quota parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.Quota prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Quota configuration helps to achieve fairness and budgeting in service
   * usage.
   * The metric based quota configuration works this way:
   * - The service configuration defines a set of metrics.
   * - For API calls, the quota.metric_rules maps methods to metrics with
   *   corresponding costs.
   * - The quota.limits defines limits on the metrics, which will be used for
   *   quota checks at runtime.
   * An example quota configuration in yaml format:
   *    quota:
   *      limits:
   *      - name: apiWriteQpsPerProject
   *        metric: library.googleapis.com/write_calls
   *        unit: "1/min/{project}"  # rate limit for consumer projects
   *        values:
   *          STANDARD: 10000
   *      # The metric rules bind all methods to the read_calls metric,
   *      # except for the UpdateBook and DeleteBook methods. These two methods
   *      # are mapped to the write_calls metric, with the UpdateBook method
   *      # consuming at twice rate as the DeleteBook method.
   *      metric_rules:
   *      - selector: "*"
   *        metric_costs:
   *          library.googleapis.com/read_calls: 1
   *      - selector: google.example.library.v1.LibraryService.UpdateBook
   *        metric_costs:
   *          library.googleapis.com/write_calls: 2
   *      - selector: google.example.library.v1.LibraryService.DeleteBook
   *        metric_costs:
   *          library.googleapis.com/write_calls: 1
   *  Corresponding Metric definition:
   *      metrics:
   *      - name: library.googleapis.com/read_calls
   *        display_name: Read requests
   *        metric_kind: DELTA
   *        value_type: INT64
   *      - name: library.googleapis.com/write_calls
   *        display_name: Write requests
   *        metric_kind: DELTA
   *        value_type: INT64
   * </pre>
   *
   * Protobuf type {@code google.api.Quota}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.Quota)
      com.google.api.QuotaOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.QuotaProto.internal_static_google_api_Quota_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.QuotaProto.internal_static_google_api_Quota_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.Quota.class, com.google.api.Quota.Builder.class);
    }

    // Construct using com.google.api.Quota.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLimitsFieldBuilder();
        getMetricRulesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (limitsBuilder_ == null) {
        limits_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        limitsBuilder_.clear();
      }
      if (metricRulesBuilder_ == null) {
        metricRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        metricRulesBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.QuotaProto.internal_static_google_api_Quota_descriptor;
    }

    @java.lang.Override
    public com.google.api.Quota getDefaultInstanceForType() {
      return com.google.api.Quota.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.Quota build() {
      com.google.api.Quota result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.Quota buildPartial() {
      com.google.api.Quota result = new com.google.api.Quota(this);
      int from_bitField0_ = bitField0_;
      if (limitsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          limits_ = java.util.Collections.unmodifiableList(limits_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.limits_ = limits_;
      } else {
        result.limits_ = limitsBuilder_.build();
      }
      if (metricRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          metricRules_ = java.util.Collections.unmodifiableList(metricRules_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.metricRules_ = metricRules_;
      } else {
        result.metricRules_ = metricRulesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.Quota) {
        return mergeFrom((com.google.api.Quota) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.Quota other) {
      if (other == com.google.api.Quota.getDefaultInstance()) return this;
      if (limitsBuilder_ == null) {
        if (!other.limits_.isEmpty()) {
          if (limits_.isEmpty()) {
            limits_ = other.limits_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureLimitsIsMutable();
            limits_.addAll(other.limits_);
          }
          onChanged();
        }
      } else {
        if (!other.limits_.isEmpty()) {
          if (limitsBuilder_.isEmpty()) {
            limitsBuilder_.dispose();
            limitsBuilder_ = null;
            limits_ = other.limits_;
            bitField0_ = (bitField0_ & ~0x00000001);
            limitsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLimitsFieldBuilder()
                    : null;
          } else {
            limitsBuilder_.addAllMessages(other.limits_);
          }
        }
      }
      if (metricRulesBuilder_ == null) {
        if (!other.metricRules_.isEmpty()) {
          if (metricRules_.isEmpty()) {
            metricRules_ = other.metricRules_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMetricRulesIsMutable();
            metricRules_.addAll(other.metricRules_);
          }
          onChanged();
        }
      } else {
        if (!other.metricRules_.isEmpty()) {
          if (metricRulesBuilder_.isEmpty()) {
            metricRulesBuilder_.dispose();
            metricRulesBuilder_ = null;
            metricRules_ = other.metricRules_;
            bitField0_ = (bitField0_ & ~0x00000002);
            metricRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricRulesFieldBuilder()
                    : null;
          } else {
            metricRulesBuilder_.addAllMessages(other.metricRules_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.api.Quota parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.api.Quota) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.api.QuotaLimit> limits_ = java.util.Collections.emptyList();

    private void ensureLimitsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        limits_ = new java.util.ArrayList<com.google.api.QuotaLimit>(limits_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.QuotaLimit,
            com.google.api.QuotaLimit.Builder,
            com.google.api.QuotaLimitOrBuilder>
        limitsBuilder_;

    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public java.util.List<com.google.api.QuotaLimit> getLimitsList() {
      if (limitsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(limits_);
      } else {
        return limitsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public int getLimitsCount() {
      if (limitsBuilder_ == null) {
        return limits_.size();
      } else {
        return limitsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public com.google.api.QuotaLimit getLimits(int index) {
      if (limitsBuilder_ == null) {
        return limits_.get(index);
      } else {
        return limitsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder setLimits(int index, com.google.api.QuotaLimit value) {
      if (limitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLimitsIsMutable();
        limits_.set(index, value);
        onChanged();
      } else {
        limitsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder setLimits(int index, com.google.api.QuotaLimit.Builder builderForValue) {
      if (limitsBuilder_ == null) {
        ensureLimitsIsMutable();
        limits_.set(index, builderForValue.build());
        onChanged();
      } else {
        limitsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder addLimits(com.google.api.QuotaLimit value) {
      if (limitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLimitsIsMutable();
        limits_.add(value);
        onChanged();
      } else {
        limitsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder addLimits(int index, com.google.api.QuotaLimit value) {
      if (limitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLimitsIsMutable();
        limits_.add(index, value);
        onChanged();
      } else {
        limitsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder addLimits(com.google.api.QuotaLimit.Builder builderForValue) {
      if (limitsBuilder_ == null) {
        ensureLimitsIsMutable();
        limits_.add(builderForValue.build());
        onChanged();
      } else {
        limitsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder addLimits(int index, com.google.api.QuotaLimit.Builder builderForValue) {
      if (limitsBuilder_ == null) {
        ensureLimitsIsMutable();
        limits_.add(index, builderForValue.build());
        onChanged();
      } else {
        limitsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder addAllLimits(java.lang.Iterable<? extends com.google.api.QuotaLimit> values) {
      if (limitsBuilder_ == null) {
        ensureLimitsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, limits_);
        onChanged();
      } else {
        limitsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder clearLimits() {
      if (limitsBuilder_ == null) {
        limits_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        limitsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public Builder removeLimits(int index) {
      if (limitsBuilder_ == null) {
        ensureLimitsIsMutable();
        limits_.remove(index);
        onChanged();
      } else {
        limitsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public com.google.api.QuotaLimit.Builder getLimitsBuilder(int index) {
      return getLimitsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public com.google.api.QuotaLimitOrBuilder getLimitsOrBuilder(int index) {
      if (limitsBuilder_ == null) {
        return limits_.get(index);
      } else {
        return limitsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public java.util.List<? extends com.google.api.QuotaLimitOrBuilder> getLimitsOrBuilderList() {
      if (limitsBuilder_ != null) {
        return limitsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(limits_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public com.google.api.QuotaLimit.Builder addLimitsBuilder() {
      return getLimitsFieldBuilder().addBuilder(com.google.api.QuotaLimit.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public com.google.api.QuotaLimit.Builder addLimitsBuilder(int index) {
      return getLimitsFieldBuilder()
          .addBuilder(index, com.google.api.QuotaLimit.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of `QuotaLimit` definitions for the service.
     * </pre>
     *
     * <code>repeated .google.api.QuotaLimit limits = 3;</code>
     */
    public java.util.List<com.google.api.QuotaLimit.Builder> getLimitsBuilderList() {
      return getLimitsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.QuotaLimit,
            com.google.api.QuotaLimit.Builder,
            com.google.api.QuotaLimitOrBuilder>
        getLimitsFieldBuilder() {
      if (limitsBuilder_ == null) {
        limitsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.QuotaLimit,
                com.google.api.QuotaLimit.Builder,
                com.google.api.QuotaLimitOrBuilder>(
                limits_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        limits_ = null;
      }
      return limitsBuilder_;
    }

    private java.util.List<com.google.api.MetricRule> metricRules_ =
        java.util.Collections.emptyList();

    private void ensureMetricRulesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        metricRules_ = new java.util.ArrayList<com.google.api.MetricRule>(metricRules_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.MetricRule,
            com.google.api.MetricRule.Builder,
            com.google.api.MetricRuleOrBuilder>
        metricRulesBuilder_;

    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public java.util.List<com.google.api.MetricRule> getMetricRulesList() {
      if (metricRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metricRules_);
      } else {
        return metricRulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public int getMetricRulesCount() {
      if (metricRulesBuilder_ == null) {
        return metricRules_.size();
      } else {
        return metricRulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public com.google.api.MetricRule getMetricRules(int index) {
      if (metricRulesBuilder_ == null) {
        return metricRules_.get(index);
      } else {
        return metricRulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder setMetricRules(int index, com.google.api.MetricRule value) {
      if (metricRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricRulesIsMutable();
        metricRules_.set(index, value);
        onChanged();
      } else {
        metricRulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder setMetricRules(int index, com.google.api.MetricRule.Builder builderForValue) {
      if (metricRulesBuilder_ == null) {
        ensureMetricRulesIsMutable();
        metricRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder addMetricRules(com.google.api.MetricRule value) {
      if (metricRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricRulesIsMutable();
        metricRules_.add(value);
        onChanged();
      } else {
        metricRulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder addMetricRules(int index, com.google.api.MetricRule value) {
      if (metricRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricRulesIsMutable();
        metricRules_.add(index, value);
        onChanged();
      } else {
        metricRulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder addMetricRules(com.google.api.MetricRule.Builder builderForValue) {
      if (metricRulesBuilder_ == null) {
        ensureMetricRulesIsMutable();
        metricRules_.add(builderForValue.build());
        onChanged();
      } else {
        metricRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder addMetricRules(int index, com.google.api.MetricRule.Builder builderForValue) {
      if (metricRulesBuilder_ == null) {
        ensureMetricRulesIsMutable();
        metricRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder addAllMetricRules(
        java.lang.Iterable<? extends com.google.api.MetricRule> values) {
      if (metricRulesBuilder_ == null) {
        ensureMetricRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metricRules_);
        onChanged();
      } else {
        metricRulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder clearMetricRules() {
      if (metricRulesBuilder_ == null) {
        metricRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        metricRulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public Builder removeMetricRules(int index) {
      if (metricRulesBuilder_ == null) {
        ensureMetricRulesIsMutable();
        metricRules_.remove(index);
        onChanged();
      } else {
        metricRulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public com.google.api.MetricRule.Builder getMetricRulesBuilder(int index) {
      return getMetricRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public com.google.api.MetricRuleOrBuilder getMetricRulesOrBuilder(int index) {
      if (metricRulesBuilder_ == null) {
        return metricRules_.get(index);
      } else {
        return metricRulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public java.util.List<? extends com.google.api.MetricRuleOrBuilder>
        getMetricRulesOrBuilderList() {
      if (metricRulesBuilder_ != null) {
        return metricRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metricRules_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public com.google.api.MetricRule.Builder addMetricRulesBuilder() {
      return getMetricRulesFieldBuilder()
          .addBuilder(com.google.api.MetricRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public com.google.api.MetricRule.Builder addMetricRulesBuilder(int index) {
      return getMetricRulesFieldBuilder()
          .addBuilder(index, com.google.api.MetricRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of `MetricRule` definitions, each one mapping a selected method to one
     * or more metrics.
     * </pre>
     *
     * <code>repeated .google.api.MetricRule metric_rules = 4;</code>
     */
    public java.util.List<com.google.api.MetricRule.Builder> getMetricRulesBuilderList() {
      return getMetricRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.MetricRule,
            com.google.api.MetricRule.Builder,
            com.google.api.MetricRuleOrBuilder>
        getMetricRulesFieldBuilder() {
      if (metricRulesBuilder_ == null) {
        metricRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.MetricRule,
                com.google.api.MetricRule.Builder,
                com.google.api.MetricRuleOrBuilder>(
                metricRules_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        metricRules_ = null;
      }
      return metricRulesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.Quota)
  }

  // @@protoc_insertion_point(class_scope:google.api.Quota)
  private static final com.google.api.Quota DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.Quota();
  }

  public static com.google.api.Quota getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Quota> PARSER =
      new com.google.protobuf.AbstractParser<Quota>() {
        @java.lang.Override
        public Quota parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Quota(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Quota> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Quota> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.Quota getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
