/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workflows.executions.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkflowName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_WORKFLOW = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/workflows/{workflow}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String workflow;

    @Deprecated
    protected WorkflowName() {
        this.project = null;
        this.location = null;
        this.workflow = null;
    }

    private WorkflowName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.workflow = (String)Preconditions.checkNotNull((Object)builder.getWorkflow());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WorkflowName of(String project, String location, String workflow) {
        return WorkflowName.newBuilder().setProject(project).setLocation(location).setWorkflow(workflow).build();
    }

    public static String format(String project, String location, String workflow) {
        return WorkflowName.newBuilder().setProject(project).setLocation(location).setWorkflow(workflow).build().toString();
    }

    public static WorkflowName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_WORKFLOW.validatedMatch(formattedString, "WorkflowName.parse: formattedString not in valid format");
        return WorkflowName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("workflow"));
    }

    public static List<WorkflowName> parseList(List<String> formattedStrings) {
        ArrayList<WorkflowName> list = new ArrayList<WorkflowName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkflowName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkflowName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkflowName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_WORKFLOW.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkflowName workflowName = this;
            synchronized (workflowName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.workflow != null) {
                        fieldMapBuilder.put((Object)"workflow", (Object)this.workflow);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_WORKFLOW.instantiate(new String[]{"project", this.project, "location", this.location, "workflow", this.workflow});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WorkflowName that = (WorkflowName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.workflow, that.workflow);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.workflow);
    }

    public static class Builder {
        private String project;
        private String location;
        private String workflow;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWorkflow() {
            return this.workflow;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWorkflow(String workflow) {
            this.workflow = workflow;
            return this;
        }

        private Builder(WorkflowName workflowName) {
            this.project = workflowName.project;
            this.location = workflowName.location;
            this.workflow = workflowName.workflow;
        }

        public WorkflowName build() {
            return new WorkflowName(this);
        }
    }
}

