/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmwareengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExternalAccessRuleName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_NETWORK_POLICY_EXTERNAL_ACCESS_RULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/networkPolicies/{network_policy}/externalAccessRules/{external_access_rule}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String networkPolicy;
    private final String externalAccessRule;

    @Deprecated
    protected ExternalAccessRuleName() {
        this.project = null;
        this.location = null;
        this.networkPolicy = null;
        this.externalAccessRule = null;
    }

    private ExternalAccessRuleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.networkPolicy = (String)Preconditions.checkNotNull((Object)builder.getNetworkPolicy());
        this.externalAccessRule = (String)Preconditions.checkNotNull((Object)builder.getExternalAccessRule());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNetworkPolicy() {
        return this.networkPolicy;
    }

    public String getExternalAccessRule() {
        return this.externalAccessRule;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExternalAccessRuleName of(String project, String location, String networkPolicy, String externalAccessRule) {
        return ExternalAccessRuleName.newBuilder().setProject(project).setLocation(location).setNetworkPolicy(networkPolicy).setExternalAccessRule(externalAccessRule).build();
    }

    public static String format(String project, String location, String networkPolicy, String externalAccessRule) {
        return ExternalAccessRuleName.newBuilder().setProject(project).setLocation(location).setNetworkPolicy(networkPolicy).setExternalAccessRule(externalAccessRule).build().toString();
    }

    public static ExternalAccessRuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_NETWORK_POLICY_EXTERNAL_ACCESS_RULE.validatedMatch(formattedString, "ExternalAccessRuleName.parse: formattedString not in valid format");
        return ExternalAccessRuleName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("network_policy"), (String)matchMap.get("external_access_rule"));
    }

    public static List<ExternalAccessRuleName> parseList(List<String> formattedStrings) {
        ArrayList<ExternalAccessRuleName> list = new ArrayList<ExternalAccessRuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExternalAccessRuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExternalAccessRuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExternalAccessRuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_NETWORK_POLICY_EXTERNAL_ACCESS_RULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExternalAccessRuleName externalAccessRuleName = this;
            synchronized (externalAccessRuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.networkPolicy != null) {
                        fieldMapBuilder.put((Object)"network_policy", (Object)this.networkPolicy);
                    }
                    if (this.externalAccessRule != null) {
                        fieldMapBuilder.put((Object)"external_access_rule", (Object)this.externalAccessRule);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_NETWORK_POLICY_EXTERNAL_ACCESS_RULE.instantiate(new String[]{"project", this.project, "location", this.location, "network_policy", this.networkPolicy, "external_access_rule", this.externalAccessRule});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ExternalAccessRuleName that = (ExternalAccessRuleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.networkPolicy, that.networkPolicy) && Objects.equals(this.externalAccessRule, that.externalAccessRule);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.networkPolicy);
        h *= 1000003;
        return h ^= Objects.hashCode(this.externalAccessRule);
    }

    public static class Builder {
        private String project;
        private String location;
        private String networkPolicy;
        private String externalAccessRule;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNetworkPolicy() {
            return this.networkPolicy;
        }

        public String getExternalAccessRule() {
            return this.externalAccessRule;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNetworkPolicy(String networkPolicy) {
            this.networkPolicy = networkPolicy;
            return this;
        }

        public Builder setExternalAccessRule(String externalAccessRule) {
            this.externalAccessRule = externalAccessRule;
            return this;
        }

        private Builder(ExternalAccessRuleName externalAccessRuleName) {
            this.project = externalAccessRuleName.project;
            this.location = externalAccessRuleName.location;
            this.networkPolicy = externalAccessRuleName.networkPolicy;
            this.externalAccessRule = externalAccessRuleName.externalAccessRule;
        }

        public ExternalAccessRuleName build() {
            return new ExternalAccessRuleName(this);
        }
    }
}

