/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmwareengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VmwareEngineNetworkName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_VMWARE_ENGINE_NETWORK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String vmwareEngineNetwork;

    @Deprecated
    protected VmwareEngineNetworkName() {
        this.project = null;
        this.location = null;
        this.vmwareEngineNetwork = null;
    }

    private VmwareEngineNetworkName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.vmwareEngineNetwork = (String)Preconditions.checkNotNull((Object)builder.getVmwareEngineNetwork());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVmwareEngineNetwork() {
        return this.vmwareEngineNetwork;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VmwareEngineNetworkName of(String project, String location, String vmwareEngineNetwork) {
        return VmwareEngineNetworkName.newBuilder().setProject(project).setLocation(location).setVmwareEngineNetwork(vmwareEngineNetwork).build();
    }

    public static String format(String project, String location, String vmwareEngineNetwork) {
        return VmwareEngineNetworkName.newBuilder().setProject(project).setLocation(location).setVmwareEngineNetwork(vmwareEngineNetwork).build().toString();
    }

    public static VmwareEngineNetworkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_VMWARE_ENGINE_NETWORK.validatedMatch(formattedString, "VmwareEngineNetworkName.parse: formattedString not in valid format");
        return VmwareEngineNetworkName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("vmware_engine_network"));
    }

    public static List<VmwareEngineNetworkName> parseList(List<String> formattedStrings) {
        ArrayList<VmwareEngineNetworkName> list = new ArrayList<VmwareEngineNetworkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VmwareEngineNetworkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VmwareEngineNetworkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VmwareEngineNetworkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_VMWARE_ENGINE_NETWORK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VmwareEngineNetworkName vmwareEngineNetworkName = this;
            synchronized (vmwareEngineNetworkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.vmwareEngineNetwork != null) {
                        fieldMapBuilder.put((Object)"vmware_engine_network", (Object)this.vmwareEngineNetwork);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_VMWARE_ENGINE_NETWORK.instantiate(new String[]{"project", this.project, "location", this.location, "vmware_engine_network", this.vmwareEngineNetwork});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            VmwareEngineNetworkName that = (VmwareEngineNetworkName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.vmwareEngineNetwork, that.vmwareEngineNetwork);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.vmwareEngineNetwork);
    }

    public static class Builder {
        private String project;
        private String location;
        private String vmwareEngineNetwork;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVmwareEngineNetwork() {
            return this.vmwareEngineNetwork;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVmwareEngineNetwork(String vmwareEngineNetwork) {
            this.vmwareEngineNetwork = vmwareEngineNetwork;
            return this;
        }

        private Builder(VmwareEngineNetworkName vmwareEngineNetworkName) {
            this.project = vmwareEngineNetworkName.project;
            this.location = vmwareEngineNetworkName.location;
            this.vmwareEngineNetwork = vmwareEngineNetworkName.vmwareEngineNetwork;
        }

        public VmwareEngineNetworkName build() {
            return new VmwareEngineNetworkName(this);
        }
    }
}

