/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmwareengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ManagementDnsZoneBindingName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PRIVATE_CLOUD_MANAGEMENT_DNS_ZONE_BINDING = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/privateClouds/{private_cloud}/managementDnsZoneBindings/{management_dns_zone_binding}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String privateCloud;
    private final String managementDnsZoneBinding;

    @Deprecated
    protected ManagementDnsZoneBindingName() {
        this.project = null;
        this.location = null;
        this.privateCloud = null;
        this.managementDnsZoneBinding = null;
    }

    private ManagementDnsZoneBindingName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.privateCloud = (String)Preconditions.checkNotNull((Object)builder.getPrivateCloud());
        this.managementDnsZoneBinding = (String)Preconditions.checkNotNull((Object)builder.getManagementDnsZoneBinding());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPrivateCloud() {
        return this.privateCloud;
    }

    public String getManagementDnsZoneBinding() {
        return this.managementDnsZoneBinding;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ManagementDnsZoneBindingName of(String project, String location, String privateCloud, String managementDnsZoneBinding) {
        return ManagementDnsZoneBindingName.newBuilder().setProject(project).setLocation(location).setPrivateCloud(privateCloud).setManagementDnsZoneBinding(managementDnsZoneBinding).build();
    }

    public static String format(String project, String location, String privateCloud, String managementDnsZoneBinding) {
        return ManagementDnsZoneBindingName.newBuilder().setProject(project).setLocation(location).setPrivateCloud(privateCloud).setManagementDnsZoneBinding(managementDnsZoneBinding).build().toString();
    }

    public static ManagementDnsZoneBindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PRIVATE_CLOUD_MANAGEMENT_DNS_ZONE_BINDING.validatedMatch(formattedString, "ManagementDnsZoneBindingName.parse: formattedString not in valid format");
        return ManagementDnsZoneBindingName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("private_cloud"), (String)matchMap.get("management_dns_zone_binding"));
    }

    public static List<ManagementDnsZoneBindingName> parseList(List<String> formattedStrings) {
        ArrayList<ManagementDnsZoneBindingName> list = new ArrayList<ManagementDnsZoneBindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ManagementDnsZoneBindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ManagementDnsZoneBindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ManagementDnsZoneBindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PRIVATE_CLOUD_MANAGEMENT_DNS_ZONE_BINDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ManagementDnsZoneBindingName managementDnsZoneBindingName = this;
            synchronized (managementDnsZoneBindingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.privateCloud != null) {
                        fieldMapBuilder.put((Object)"private_cloud", (Object)this.privateCloud);
                    }
                    if (this.managementDnsZoneBinding != null) {
                        fieldMapBuilder.put((Object)"management_dns_zone_binding", (Object)this.managementDnsZoneBinding);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PRIVATE_CLOUD_MANAGEMENT_DNS_ZONE_BINDING.instantiate(new String[]{"project", this.project, "location", this.location, "private_cloud", this.privateCloud, "management_dns_zone_binding", this.managementDnsZoneBinding});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ManagementDnsZoneBindingName that = (ManagementDnsZoneBindingName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.privateCloud, that.privateCloud) && Objects.equals(this.managementDnsZoneBinding, that.managementDnsZoneBinding);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.privateCloud);
        h *= 1000003;
        return h ^= Objects.hashCode(this.managementDnsZoneBinding);
    }

    public static class Builder {
        private String project;
        private String location;
        private String privateCloud;
        private String managementDnsZoneBinding;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPrivateCloud() {
            return this.privateCloud;
        }

        public String getManagementDnsZoneBinding() {
            return this.managementDnsZoneBinding;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPrivateCloud(String privateCloud) {
            this.privateCloud = privateCloud;
            return this;
        }

        public Builder setManagementDnsZoneBinding(String managementDnsZoneBinding) {
            this.managementDnsZoneBinding = managementDnsZoneBinding;
            return this;
        }

        private Builder(ManagementDnsZoneBindingName managementDnsZoneBindingName) {
            this.project = managementDnsZoneBindingName.project;
            this.location = managementDnsZoneBindingName.location;
            this.privateCloud = managementDnsZoneBindingName.privateCloud;
            this.managementDnsZoneBinding = managementDnsZoneBindingName.managementDnsZoneBinding;
        }

        public ManagementDnsZoneBindingName build() {
            return new ManagementDnsZoneBindingName(this);
        }
    }
}

