/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmwareengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NetworkPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_NETWORK_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/networkPolicies/{network_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String networkPolicy;

    @Deprecated
    protected NetworkPolicyName() {
        this.project = null;
        this.location = null;
        this.networkPolicy = null;
    }

    private NetworkPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.networkPolicy = (String)Preconditions.checkNotNull((Object)builder.getNetworkPolicy());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNetworkPolicy() {
        return this.networkPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NetworkPolicyName of(String project, String location, String networkPolicy) {
        return NetworkPolicyName.newBuilder().setProject(project).setLocation(location).setNetworkPolicy(networkPolicy).build();
    }

    public static String format(String project, String location, String networkPolicy) {
        return NetworkPolicyName.newBuilder().setProject(project).setLocation(location).setNetworkPolicy(networkPolicy).build().toString();
    }

    public static NetworkPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_NETWORK_POLICY.validatedMatch(formattedString, "NetworkPolicyName.parse: formattedString not in valid format");
        return NetworkPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("network_policy"));
    }

    public static List<NetworkPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<NetworkPolicyName> list = new ArrayList<NetworkPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NetworkPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NetworkPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NetworkPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_NETWORK_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NetworkPolicyName networkPolicyName = this;
            synchronized (networkPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.networkPolicy != null) {
                        fieldMapBuilder.put((Object)"network_policy", (Object)this.networkPolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_NETWORK_POLICY.instantiate(new String[]{"project", this.project, "location", this.location, "network_policy", this.networkPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NetworkPolicyName that = (NetworkPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.networkPolicy, that.networkPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.networkPolicy);
    }

    public static class Builder {
        private String project;
        private String location;
        private String networkPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNetworkPolicy() {
            return this.networkPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNetworkPolicy(String networkPolicy) {
            this.networkPolicy = networkPolicy;
            return this;
        }

        private Builder(NetworkPolicyName networkPolicyName) {
            this.project = networkPolicyName.project;
            this.location = networkPolicyName.location;
            this.networkPolicy = networkPolicyName.networkPolicy;
        }

        public NetworkPolicyName build() {
            return new NetworkPolicyName(this);
        }
    }
}

