/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmwareengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NodeTypeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_NODE_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/nodeTypes/{node_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String nodeType;

    @Deprecated
    protected NodeTypeName() {
        this.project = null;
        this.location = null;
        this.nodeType = null;
    }

    private NodeTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.nodeType = (String)Preconditions.checkNotNull((Object)builder.getNodeType());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NodeTypeName of(String project, String location, String nodeType) {
        return NodeTypeName.newBuilder().setProject(project).setLocation(location).setNodeType(nodeType).build();
    }

    public static String format(String project, String location, String nodeType) {
        return NodeTypeName.newBuilder().setProject(project).setLocation(location).setNodeType(nodeType).build().toString();
    }

    public static NodeTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_NODE_TYPE.validatedMatch(formattedString, "NodeTypeName.parse: formattedString not in valid format");
        return NodeTypeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("node_type"));
    }

    public static List<NodeTypeName> parseList(List<String> formattedStrings) {
        ArrayList<NodeTypeName> list = new ArrayList<NodeTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NodeTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NodeTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NodeTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_NODE_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NodeTypeName nodeTypeName = this;
            synchronized (nodeTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.nodeType != null) {
                        fieldMapBuilder.put((Object)"node_type", (Object)this.nodeType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_NODE_TYPE.instantiate(new String[]{"project", this.project, "location", this.location, "node_type", this.nodeType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            NodeTypeName that = (NodeTypeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.nodeType, that.nodeType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.nodeType);
    }

    public static class Builder {
        private String project;
        private String location;
        private String nodeType;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        private Builder(NodeTypeName nodeTypeName) {
            this.project = nodeTypeName.project;
            this.location = nodeTypeName.location;
            this.nodeType = nodeTypeName.nodeType;
        }

        public NodeTypeName build() {
            return new NodeTypeName(this);
        }
    }
}

