/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmmigration.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReplicationCycleName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SOURCE_MIGRATING_VM_REPLICATION_CYCLE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}/replicationCycles/{replication_cycle}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String source;
    private final String migratingVm;
    private final String replicationCycle;

    @Deprecated
    protected ReplicationCycleName() {
        this.project = null;
        this.location = null;
        this.source = null;
        this.migratingVm = null;
        this.replicationCycle = null;
    }

    private ReplicationCycleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.migratingVm = (String)Preconditions.checkNotNull((Object)builder.getMigratingVm());
        this.replicationCycle = (String)Preconditions.checkNotNull((Object)builder.getReplicationCycle());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSource() {
        return this.source;
    }

    public String getMigratingVm() {
        return this.migratingVm;
    }

    public String getReplicationCycle() {
        return this.replicationCycle;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReplicationCycleName of(String project, String location, String source, String migratingVm, String replicationCycle) {
        return ReplicationCycleName.newBuilder().setProject(project).setLocation(location).setSource(source).setMigratingVm(migratingVm).setReplicationCycle(replicationCycle).build();
    }

    public static String format(String project, String location, String source, String migratingVm, String replicationCycle) {
        return ReplicationCycleName.newBuilder().setProject(project).setLocation(location).setSource(source).setMigratingVm(migratingVm).setReplicationCycle(replicationCycle).build().toString();
    }

    public static ReplicationCycleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SOURCE_MIGRATING_VM_REPLICATION_CYCLE.validatedMatch(formattedString, "ReplicationCycleName.parse: formattedString not in valid format");
        return ReplicationCycleName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("source"), (String)matchMap.get("migrating_vm"), (String)matchMap.get("replication_cycle"));
    }

    public static List<ReplicationCycleName> parseList(List<String> formattedStrings) {
        ArrayList<ReplicationCycleName> list = new ArrayList<ReplicationCycleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReplicationCycleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReplicationCycleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReplicationCycleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SOURCE_MIGRATING_VM_REPLICATION_CYCLE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReplicationCycleName replicationCycleName = this;
            synchronized (replicationCycleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    if (this.migratingVm != null) {
                        fieldMapBuilder.put((Object)"migrating_vm", (Object)this.migratingVm);
                    }
                    if (this.replicationCycle != null) {
                        fieldMapBuilder.put((Object)"replication_cycle", (Object)this.replicationCycle);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SOURCE_MIGRATING_VM_REPLICATION_CYCLE.instantiate(new String[]{"project", this.project, "location", this.location, "source", this.source, "migrating_vm", this.migratingVm, "replication_cycle", this.replicationCycle});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ReplicationCycleName that = (ReplicationCycleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.source, that.source) && Objects.equals(this.migratingVm, that.migratingVm) && Objects.equals(this.replicationCycle, that.replicationCycle);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.source);
        h *= 1000003;
        h ^= Objects.hashCode(this.migratingVm);
        h *= 1000003;
        return h ^= Objects.hashCode(this.replicationCycle);
    }

    public static class Builder {
        private String project;
        private String location;
        private String source;
        private String migratingVm;
        private String replicationCycle;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSource() {
            return this.source;
        }

        public String getMigratingVm() {
            return this.migratingVm;
        }

        public String getReplicationCycle() {
            return this.replicationCycle;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setMigratingVm(String migratingVm) {
            this.migratingVm = migratingVm;
            return this;
        }

        public Builder setReplicationCycle(String replicationCycle) {
            this.replicationCycle = replicationCycle;
            return this;
        }

        private Builder(ReplicationCycleName replicationCycleName) {
            this.project = replicationCycleName.project;
            this.location = replicationCycleName.location;
            this.source = replicationCycleName.source;
            this.migratingVm = replicationCycleName.migratingVm;
            this.replicationCycle = replicationCycleName.replicationCycle;
        }

        public ReplicationCycleName build() {
            return new ReplicationCycleName(this);
        }
    }
}

