/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmmigration.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DiskMigrationJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SOURCE_DISK_MIGRATION_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sources/{source}/diskMigrationJobs/{disk_migration_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String source;
    private final String diskMigrationJob;

    @Deprecated
    protected DiskMigrationJobName() {
        this.project = null;
        this.location = null;
        this.source = null;
        this.diskMigrationJob = null;
    }

    private DiskMigrationJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.diskMigrationJob = (String)Preconditions.checkNotNull((Object)builder.getDiskMigrationJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSource() {
        return this.source;
    }

    public String getDiskMigrationJob() {
        return this.diskMigrationJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DiskMigrationJobName of(String project, String location, String source, String diskMigrationJob) {
        return DiskMigrationJobName.newBuilder().setProject(project).setLocation(location).setSource(source).setDiskMigrationJob(diskMigrationJob).build();
    }

    public static String format(String project, String location, String source, String diskMigrationJob) {
        return DiskMigrationJobName.newBuilder().setProject(project).setLocation(location).setSource(source).setDiskMigrationJob(diskMigrationJob).build().toString();
    }

    public static DiskMigrationJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SOURCE_DISK_MIGRATION_JOB.validatedMatch(formattedString, "DiskMigrationJobName.parse: formattedString not in valid format");
        return DiskMigrationJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("source"), (String)matchMap.get("disk_migration_job"));
    }

    public static List<DiskMigrationJobName> parseList(List<String> formattedStrings) {
        ArrayList<DiskMigrationJobName> list = new ArrayList<DiskMigrationJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DiskMigrationJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DiskMigrationJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DiskMigrationJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SOURCE_DISK_MIGRATION_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DiskMigrationJobName diskMigrationJobName = this;
            synchronized (diskMigrationJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    if (this.diskMigrationJob != null) {
                        fieldMapBuilder.put((Object)"disk_migration_job", (Object)this.diskMigrationJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SOURCE_DISK_MIGRATION_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "source", this.source, "disk_migration_job", this.diskMigrationJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DiskMigrationJobName that = (DiskMigrationJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.source, that.source) && Objects.equals(this.diskMigrationJob, that.diskMigrationJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.source);
        h *= 1000003;
        return h ^= Objects.hashCode(this.diskMigrationJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String source;
        private String diskMigrationJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSource() {
            return this.source;
        }

        public String getDiskMigrationJob() {
            return this.diskMigrationJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setDiskMigrationJob(String diskMigrationJob) {
            this.diskMigrationJob = diskMigrationJob;
            return this;
        }

        private Builder(DiskMigrationJobName diskMigrationJobName) {
            this.project = diskMigrationJobName.project;
            this.location = diskMigrationJobName.location;
            this.source = diskMigrationJobName.source;
            this.diskMigrationJob = diskMigrationJobName.diskMigrationJob;
        }

        public DiskMigrationJobName build() {
            return new DiskMigrationJobName(this);
        }
    }
}

