/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmmigration.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MigratingVmName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SOURCE_MIGRATING_VM = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String source;
    private final String migratingVm;

    @Deprecated
    protected MigratingVmName() {
        this.project = null;
        this.location = null;
        this.source = null;
        this.migratingVm = null;
    }

    private MigratingVmName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.migratingVm = (String)Preconditions.checkNotNull((Object)builder.getMigratingVm());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSource() {
        return this.source;
    }

    public String getMigratingVm() {
        return this.migratingVm;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MigratingVmName of(String project, String location, String source, String migratingVm) {
        return MigratingVmName.newBuilder().setProject(project).setLocation(location).setSource(source).setMigratingVm(migratingVm).build();
    }

    public static String format(String project, String location, String source, String migratingVm) {
        return MigratingVmName.newBuilder().setProject(project).setLocation(location).setSource(source).setMigratingVm(migratingVm).build().toString();
    }

    public static MigratingVmName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SOURCE_MIGRATING_VM.validatedMatch(formattedString, "MigratingVmName.parse: formattedString not in valid format");
        return MigratingVmName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("source"), (String)matchMap.get("migrating_vm"));
    }

    public static List<MigratingVmName> parseList(List<String> formattedStrings) {
        ArrayList<MigratingVmName> list = new ArrayList<MigratingVmName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MigratingVmName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MigratingVmName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MigratingVmName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SOURCE_MIGRATING_VM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MigratingVmName migratingVmName = this;
            synchronized (migratingVmName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    if (this.migratingVm != null) {
                        fieldMapBuilder.put((Object)"migrating_vm", (Object)this.migratingVm);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SOURCE_MIGRATING_VM.instantiate(new String[]{"project", this.project, "location", this.location, "source", this.source, "migrating_vm", this.migratingVm});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MigratingVmName that = (MigratingVmName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.source, that.source) && Objects.equals(this.migratingVm, that.migratingVm);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.source);
        h *= 1000003;
        return h ^= Objects.hashCode(this.migratingVm);
    }

    public static class Builder {
        private String project;
        private String location;
        private String source;
        private String migratingVm;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSource() {
            return this.source;
        }

        public String getMigratingVm() {
            return this.migratingVm;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setMigratingVm(String migratingVm) {
            this.migratingVm = migratingVm;
            return this;
        }

        private Builder(MigratingVmName migratingVmName) {
            this.project = migratingVmName.project;
            this.location = migratingVmName.location;
            this.source = migratingVmName.source;
            this.migratingVm = migratingVmName.migratingVm;
        }

        public MigratingVmName build() {
            return new MigratingVmName(this);
        }
    }
}

