/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmmigration.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GroupName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_GROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/groups/{group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String group;

    @Deprecated
    protected GroupName() {
        this.project = null;
        this.location = null;
        this.group = null;
    }

    private GroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.group = (String)Preconditions.checkNotNull((Object)builder.getGroup());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGroup() {
        return this.group;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GroupName of(String project, String location, String group) {
        return GroupName.newBuilder().setProject(project).setLocation(location).setGroup(group).build();
    }

    public static String format(String project, String location, String group) {
        return GroupName.newBuilder().setProject(project).setLocation(location).setGroup(group).build().toString();
    }

    public static GroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_GROUP.validatedMatch(formattedString, "GroupName.parse: formattedString not in valid format");
        return GroupName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("group"));
    }

    public static List<GroupName> parseList(List<String> formattedStrings) {
        ArrayList<GroupName> list = new ArrayList<GroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GroupName groupName = this;
            synchronized (groupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.group != null) {
                        fieldMapBuilder.put((Object)"group", (Object)this.group);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_GROUP.instantiate(new String[]{"project", this.project, "location", this.location, "group", this.group});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GroupName that = (GroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.group, that.group);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.group);
    }

    public static class Builder {
        private String project;
        private String location;
        private String group;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGroup() {
            return this.group;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        private Builder(GroupName groupName) {
            this.project = groupName.project;
            this.location = groupName.location;
            this.group = groupName.group;
        }

        public GroupName build() {
            return new GroupName(this);
        }
    }
}

