/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmmigration.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SourceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SOURCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sources/{source}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String source;

    @Deprecated
    protected SourceName() {
        this.project = null;
        this.location = null;
        this.source = null;
    }

    private SourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSource() {
        return this.source;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SourceName of(String project, String location, String source) {
        return SourceName.newBuilder().setProject(project).setLocation(location).setSource(source).build();
    }

    public static String format(String project, String location, String source) {
        return SourceName.newBuilder().setProject(project).setLocation(location).setSource(source).build().toString();
    }

    public static SourceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SOURCE.validatedMatch(formattedString, "SourceName.parse: formattedString not in valid format");
        return SourceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("source"));
    }

    public static List<SourceName> parseList(List<String> formattedStrings) {
        ArrayList<SourceName> list = new ArrayList<SourceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SourceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SourceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SourceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SOURCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SourceName sourceName = this;
            synchronized (sourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SOURCE.instantiate(new String[]{"project", this.project, "location", this.location, "source", this.source});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SourceName that = (SourceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.source, that.source);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.source);
    }

    public static class Builder {
        private String project;
        private String location;
        private String source;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        private Builder(SourceName sourceName) {
            this.project = sourceName.project;
            this.location = sourceName.location;
            this.source = sourceName.source;
        }

        public SourceName build() {
            return new SourceName(this);
        }
    }
}

