/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmmigration.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CloneJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SOURCE_MIGRATING_VM_CLONE_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}/cloneJobs/{clone_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String source;
    private final String migratingVm;
    private final String cloneJob;

    @Deprecated
    protected CloneJobName() {
        this.project = null;
        this.location = null;
        this.source = null;
        this.migratingVm = null;
        this.cloneJob = null;
    }

    private CloneJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.migratingVm = (String)Preconditions.checkNotNull((Object)builder.getMigratingVm());
        this.cloneJob = (String)Preconditions.checkNotNull((Object)builder.getCloneJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSource() {
        return this.source;
    }

    public String getMigratingVm() {
        return this.migratingVm;
    }

    public String getCloneJob() {
        return this.cloneJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CloneJobName of(String project, String location, String source, String migratingVm, String cloneJob) {
        return CloneJobName.newBuilder().setProject(project).setLocation(location).setSource(source).setMigratingVm(migratingVm).setCloneJob(cloneJob).build();
    }

    public static String format(String project, String location, String source, String migratingVm, String cloneJob) {
        return CloneJobName.newBuilder().setProject(project).setLocation(location).setSource(source).setMigratingVm(migratingVm).setCloneJob(cloneJob).build().toString();
    }

    public static CloneJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SOURCE_MIGRATING_VM_CLONE_JOB.validatedMatch(formattedString, "CloneJobName.parse: formattedString not in valid format");
        return CloneJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("source"), (String)matchMap.get("migrating_vm"), (String)matchMap.get("clone_job"));
    }

    public static List<CloneJobName> parseList(List<String> formattedStrings) {
        ArrayList<CloneJobName> list = new ArrayList<CloneJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CloneJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CloneJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CloneJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SOURCE_MIGRATING_VM_CLONE_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CloneJobName cloneJobName = this;
            synchronized (cloneJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    if (this.migratingVm != null) {
                        fieldMapBuilder.put((Object)"migrating_vm", (Object)this.migratingVm);
                    }
                    if (this.cloneJob != null) {
                        fieldMapBuilder.put((Object)"clone_job", (Object)this.cloneJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SOURCE_MIGRATING_VM_CLONE_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "source", this.source, "migrating_vm", this.migratingVm, "clone_job", this.cloneJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CloneJobName that = (CloneJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.source, that.source) && Objects.equals(this.migratingVm, that.migratingVm) && Objects.equals(this.cloneJob, that.cloneJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.source);
        h *= 1000003;
        h ^= Objects.hashCode(this.migratingVm);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cloneJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String source;
        private String migratingVm;
        private String cloneJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSource() {
            return this.source;
        }

        public String getMigratingVm() {
            return this.migratingVm;
        }

        public String getCloneJob() {
            return this.cloneJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setMigratingVm(String migratingVm) {
            this.migratingVm = migratingVm;
            return this;
        }

        public Builder setCloneJob(String cloneJob) {
            this.cloneJob = cloneJob;
            return this;
        }

        private Builder(CloneJobName cloneJobName) {
            this.project = cloneJobName.project;
            this.location = cloneJobName.location;
            this.source = cloneJobName.source;
            this.migratingVm = cloneJobName.migratingVm;
            this.cloneJob = cloneJobName.cloneJob;
        }

        public CloneJobName build() {
            return new CloneJobName(this);
        }
    }
}

