/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmmigration.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UtilizationReportName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SOURCE_UTILIZATION_REPORT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sources/{source}/utilizationReports/{utilization_report}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String source;
    private final String utilizationReport;

    @Deprecated
    protected UtilizationReportName() {
        this.project = null;
        this.location = null;
        this.source = null;
        this.utilizationReport = null;
    }

    private UtilizationReportName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.utilizationReport = (String)Preconditions.checkNotNull((Object)builder.getUtilizationReport());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSource() {
        return this.source;
    }

    public String getUtilizationReport() {
        return this.utilizationReport;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UtilizationReportName of(String project, String location, String source, String utilizationReport) {
        return UtilizationReportName.newBuilder().setProject(project).setLocation(location).setSource(source).setUtilizationReport(utilizationReport).build();
    }

    public static String format(String project, String location, String source, String utilizationReport) {
        return UtilizationReportName.newBuilder().setProject(project).setLocation(location).setSource(source).setUtilizationReport(utilizationReport).build().toString();
    }

    public static UtilizationReportName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SOURCE_UTILIZATION_REPORT.validatedMatch(formattedString, "UtilizationReportName.parse: formattedString not in valid format");
        return UtilizationReportName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("source"), (String)matchMap.get("utilization_report"));
    }

    public static List<UtilizationReportName> parseList(List<String> formattedStrings) {
        ArrayList<UtilizationReportName> list = new ArrayList<UtilizationReportName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UtilizationReportName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UtilizationReportName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UtilizationReportName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SOURCE_UTILIZATION_REPORT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UtilizationReportName utilizationReportName = this;
            synchronized (utilizationReportName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    if (this.utilizationReport != null) {
                        fieldMapBuilder.put((Object)"utilization_report", (Object)this.utilizationReport);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SOURCE_UTILIZATION_REPORT.instantiate(new String[]{"project", this.project, "location", this.location, "source", this.source, "utilization_report", this.utilizationReport});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            UtilizationReportName that = (UtilizationReportName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.source, that.source) && Objects.equals(this.utilizationReport, that.utilizationReport);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.source);
        h *= 1000003;
        return h ^= Objects.hashCode(this.utilizationReport);
    }

    public static class Builder {
        private String project;
        private String location;
        private String source;
        private String utilizationReport;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSource() {
            return this.source;
        }

        public String getUtilizationReport() {
            return this.utilizationReport;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setUtilizationReport(String utilizationReport) {
            this.utilizationReport = utilizationReport;
            return this;
        }

        private Builder(UtilizationReportName utilizationReportName) {
            this.project = utilizationReportName.project;
            this.location = utilizationReportName.location;
            this.source = utilizationReportName.source;
            this.utilizationReport = utilizationReportName.utilizationReport;
        }

        public UtilizationReportName build() {
            return new UtilizationReportName(this);
        }
    }
}

