/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmmigration.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DatacenterConnectorName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SOURCE_DATACENTER_CONNECTOR = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sources/{source}/datacenterConnectors/{datacenter_connector}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String source;
    private final String datacenterConnector;

    @Deprecated
    protected DatacenterConnectorName() {
        this.project = null;
        this.location = null;
        this.source = null;
        this.datacenterConnector = null;
    }

    private DatacenterConnectorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.datacenterConnector = (String)Preconditions.checkNotNull((Object)builder.getDatacenterConnector());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSource() {
        return this.source;
    }

    public String getDatacenterConnector() {
        return this.datacenterConnector;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DatacenterConnectorName of(String project, String location, String source, String datacenterConnector) {
        return DatacenterConnectorName.newBuilder().setProject(project).setLocation(location).setSource(source).setDatacenterConnector(datacenterConnector).build();
    }

    public static String format(String project, String location, String source, String datacenterConnector) {
        return DatacenterConnectorName.newBuilder().setProject(project).setLocation(location).setSource(source).setDatacenterConnector(datacenterConnector).build().toString();
    }

    public static DatacenterConnectorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SOURCE_DATACENTER_CONNECTOR.validatedMatch(formattedString, "DatacenterConnectorName.parse: formattedString not in valid format");
        return DatacenterConnectorName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("source"), (String)matchMap.get("datacenter_connector"));
    }

    public static List<DatacenterConnectorName> parseList(List<String> formattedStrings) {
        ArrayList<DatacenterConnectorName> list = new ArrayList<DatacenterConnectorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DatacenterConnectorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DatacenterConnectorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DatacenterConnectorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SOURCE_DATACENTER_CONNECTOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DatacenterConnectorName datacenterConnectorName = this;
            synchronized (datacenterConnectorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    if (this.datacenterConnector != null) {
                        fieldMapBuilder.put((Object)"datacenter_connector", (Object)this.datacenterConnector);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SOURCE_DATACENTER_CONNECTOR.instantiate(new String[]{"project", this.project, "location", this.location, "source", this.source, "datacenter_connector", this.datacenterConnector});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DatacenterConnectorName that = (DatacenterConnectorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.source, that.source) && Objects.equals(this.datacenterConnector, that.datacenterConnector);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.source);
        h *= 1000003;
        return h ^= Objects.hashCode(this.datacenterConnector);
    }

    public static class Builder {
        private String project;
        private String location;
        private String source;
        private String datacenterConnector;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSource() {
            return this.source;
        }

        public String getDatacenterConnector() {
            return this.datacenterConnector;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setDatacenterConnector(String datacenterConnector) {
            this.datacenterConnector = datacenterConnector;
            return this;
        }

        private Builder(DatacenterConnectorName datacenterConnectorName) {
            this.project = datacenterConnectorName.project;
            this.location = datacenterConnectorName.location;
            this.source = datacenterConnectorName.source;
            this.datacenterConnector = datacenterConnectorName.datacenterConnector;
        }

        public DatacenterConnectorName build() {
            return new DatacenterConnectorName(this);
        }
    }
}

