/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ImageName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/products/{product}/referenceImages/{image}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String product;
    private final String image;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProduct() {
        return this.product;
    }

    public String getImage() {
        return this.image;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ImageName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.product = (String)Preconditions.checkNotNull((Object)builder.getProduct());
        this.image = (String)Preconditions.checkNotNull((Object)builder.getImage());
    }

    public static ImageName of(String project, String location, String product, String image) {
        return ImageName.newBuilder().setProject(project).setLocation(location).setProduct(product).setImage(image).build();
    }

    public static String format(String project, String location, String product, String image) {
        return ImageName.newBuilder().setProject(project).setLocation(location).setProduct(product).setImage(image).build().toString();
    }

    public static ImageName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ImageName.parse: formattedString not in valid format");
        return ImageName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("product"), (String)matchMap.get("image"));
    }

    public static List<ImageName> parseList(List<String> formattedStrings) {
        ArrayList<ImageName> list = new ArrayList<ImageName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ImageName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ImageName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ImageName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ImageName imageName = this;
            synchronized (imageName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"product", (Object)this.product);
                    fieldMapBuilder.put((Object)"image", (Object)this.image);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "product", this.product, "image", this.image});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImageName) {
            ImageName that = (ImageName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.product.equals(that.product) && this.image.equals(that.image);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.product.hashCode();
        h *= 1000003;
        return h ^= this.image.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String product;
        private String image;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProduct() {
            return this.product;
        }

        public String getImage() {
            return this.image;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProduct(String product) {
            this.product = product;
            return this;
        }

        public Builder setImage(String image) {
            this.image = image;
            return this;
        }

        private Builder() {
        }

        private Builder(ImageName imageName) {
            this.project = imageName.project;
            this.location = imageName.location;
            this.product = imageName.product;
            this.image = imageName.image;
        }

        public ImageName build() {
            return new ImageName(this);
        }
    }
}

