/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProductName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/products/{product}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String product;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProduct() {
        return this.product;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProductName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.product = (String)Preconditions.checkNotNull((Object)builder.getProduct());
    }

    public static ProductName of(String project, String location, String product) {
        return ProductName.newBuilder().setProject(project).setLocation(location).setProduct(product).build();
    }

    public static String format(String project, String location, String product) {
        return ProductName.newBuilder().setProject(project).setLocation(location).setProduct(product).build().toString();
    }

    public static ProductName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProductName.parse: formattedString not in valid format");
        return ProductName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("product"));
    }

    public static List<ProductName> parseList(List<String> formattedStrings) {
        ArrayList<ProductName> list = new ArrayList<ProductName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProductName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProductName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProductName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProductName productName = this;
            synchronized (productName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"product", (Object)this.product);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "product", this.product});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProductName) {
            ProductName that = (ProductName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.product.equals(that.product);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.product.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String product;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProduct() {
            return this.product;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProduct(String product) {
            this.product = product;
            return this;
        }

        private Builder() {
        }

        private Builder(ProductName productName) {
            this.project = productName.project;
            this.location = productName.location;
            this.product = productName.product;
        }

        public ProductName build() {
            return new ProductName(this);
        }
    }
}

