/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.transcoder.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JobTemplateName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_JOB_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/jobTemplates/{job_template}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String jobTemplate;

    @Deprecated
    protected JobTemplateName() {
        this.project = null;
        this.location = null;
        this.jobTemplate = null;
    }

    private JobTemplateName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.jobTemplate = (String)Preconditions.checkNotNull((Object)builder.getJobTemplate());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getJobTemplate() {
        return this.jobTemplate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static JobTemplateName of(String project, String location, String jobTemplate) {
        return JobTemplateName.newBuilder().setProject(project).setLocation(location).setJobTemplate(jobTemplate).build();
    }

    public static String format(String project, String location, String jobTemplate) {
        return JobTemplateName.newBuilder().setProject(project).setLocation(location).setJobTemplate(jobTemplate).build().toString();
    }

    public static JobTemplateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_JOB_TEMPLATE.validatedMatch(formattedString, "JobTemplateName.parse: formattedString not in valid format");
        return JobTemplateName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("job_template"));
    }

    public static List<JobTemplateName> parseList(List<String> formattedStrings) {
        ArrayList<JobTemplateName> list = new ArrayList<JobTemplateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(JobTemplateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<JobTemplateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (JobTemplateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_JOB_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            JobTemplateName jobTemplateName = this;
            synchronized (jobTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.jobTemplate != null) {
                        fieldMapBuilder.put((Object)"job_template", (Object)this.jobTemplate);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_JOB_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "job_template", this.jobTemplate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            JobTemplateName that = (JobTemplateName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.jobTemplate, that.jobTemplate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.jobTemplate);
    }

    public static class Builder {
        private String project;
        private String location;
        private String jobTemplate;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getJobTemplate() {
            return this.jobTemplate;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setJobTemplate(String jobTemplate) {
            this.jobTemplate = jobTemplate;
            return this;
        }

        private Builder(JobTemplateName jobTemplateName) {
            this.project = jobTemplateName.project;
            this.location = jobTemplateName.location;
            this.jobTemplate = jobTemplateName.jobTemplate;
        }

        public JobTemplateName build() {
            return new JobTemplateName(this);
        }
    }
}

