/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.stitcher.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SlateName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/slates/{slate}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String slate;

    @Deprecated
    protected SlateName() {
        this.project = null;
        this.location = null;
        this.slate = null;
    }

    private SlateName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.slate = (String)Preconditions.checkNotNull((Object)builder.getSlate());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSlate() {
        return this.slate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SlateName of(String project, String location, String slate) {
        return SlateName.newBuilder().setProject(project).setLocation(location).setSlate(slate).build();
    }

    public static String format(String project, String location, String slate) {
        return SlateName.newBuilder().setProject(project).setLocation(location).setSlate(slate).build().toString();
    }

    public static SlateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SLATE.validatedMatch(formattedString, "SlateName.parse: formattedString not in valid format");
        return SlateName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("slate"));
    }

    public static List<SlateName> parseList(List<String> formattedStrings) {
        ArrayList<SlateName> list = new ArrayList<SlateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SlateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SlateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SlateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SlateName slateName = this;
            synchronized (slateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.slate != null) {
                        fieldMapBuilder.put((Object)"slate", (Object)this.slate);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SLATE.instantiate(new String[]{"project", this.project, "location", this.location, "slate", this.slate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SlateName that = (SlateName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.slate, that.slate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.slate);
    }

    public static class Builder {
        private String project;
        private String location;
        private String slate;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSlate() {
            return this.slate;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSlate(String slate) {
            this.slate = slate;
            return this;
        }

        private Builder(SlateName slateName) {
            this.project = slateName.project;
            this.location = slateName.location;
            this.slate = slateName.slate;
        }

        public SlateName build() {
            return new SlateName(this);
        }
    }
}

