/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.stitcher.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VodConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_VOD_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/vodConfigs/{vod_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String vodConfig;

    @Deprecated
    protected VodConfigName() {
        this.project = null;
        this.location = null;
        this.vodConfig = null;
    }

    private VodConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.vodConfig = (String)Preconditions.checkNotNull((Object)builder.getVodConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVodConfig() {
        return this.vodConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VodConfigName of(String project, String location, String vodConfig) {
        return VodConfigName.newBuilder().setProject(project).setLocation(location).setVodConfig(vodConfig).build();
    }

    public static String format(String project, String location, String vodConfig) {
        return VodConfigName.newBuilder().setProject(project).setLocation(location).setVodConfig(vodConfig).build().toString();
    }

    public static VodConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_VOD_CONFIG.validatedMatch(formattedString, "VodConfigName.parse: formattedString not in valid format");
        return VodConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("vod_config"));
    }

    public static List<VodConfigName> parseList(List<String> formattedStrings) {
        ArrayList<VodConfigName> list = new ArrayList<VodConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VodConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VodConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VodConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_VOD_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VodConfigName vodConfigName = this;
            synchronized (vodConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.vodConfig != null) {
                        fieldMapBuilder.put((Object)"vod_config", (Object)this.vodConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_VOD_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "vod_config", this.vodConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            VodConfigName that = (VodConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.vodConfig, that.vodConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.vodConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String vodConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVodConfig() {
            return this.vodConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVodConfig(String vodConfig) {
            this.vodConfig = vodConfig;
            return this;
        }

        private Builder(VodConfigName vodConfigName) {
            this.project = vodConfigName.project;
            this.location = vodConfigName.location;
            this.vodConfig = vodConfigName.vodConfig;
        }

        public VodConfigName build() {
            return new VodConfigName(this);
        }
    }
}

