/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.stitcher.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LiveSessionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_LIVE_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/liveSessions/{live_session}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String liveSession;

    @Deprecated
    protected LiveSessionName() {
        this.project = null;
        this.location = null;
        this.liveSession = null;
    }

    private LiveSessionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.liveSession = (String)Preconditions.checkNotNull((Object)builder.getLiveSession());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLiveSession() {
        return this.liveSession;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LiveSessionName of(String project, String location, String liveSession) {
        return LiveSessionName.newBuilder().setProject(project).setLocation(location).setLiveSession(liveSession).build();
    }

    public static String format(String project, String location, String liveSession) {
        return LiveSessionName.newBuilder().setProject(project).setLocation(location).setLiveSession(liveSession).build().toString();
    }

    public static LiveSessionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_LIVE_SESSION.validatedMatch(formattedString, "LiveSessionName.parse: formattedString not in valid format");
        return LiveSessionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("live_session"));
    }

    public static List<LiveSessionName> parseList(List<String> formattedStrings) {
        ArrayList<LiveSessionName> list = new ArrayList<LiveSessionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LiveSessionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LiveSessionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LiveSessionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_LIVE_SESSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LiveSessionName liveSessionName = this;
            synchronized (liveSessionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.liveSession != null) {
                        fieldMapBuilder.put((Object)"live_session", (Object)this.liveSession);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_LIVE_SESSION.instantiate(new String[]{"project", this.project, "location", this.location, "live_session", this.liveSession});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            LiveSessionName that = (LiveSessionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.liveSession, that.liveSession);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.liveSession);
    }

    public static class Builder {
        private String project;
        private String location;
        private String liveSession;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getLiveSession() {
            return this.liveSession;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLiveSession(String liveSession) {
            this.liveSession = liveSession;
            return this;
        }

        private Builder(LiveSessionName liveSessionName) {
            this.project = liveSessionName.project;
            this.location = liveSessionName.location;
            this.liveSession = liveSessionName.liveSession;
        }

        public LiveSessionName build() {
            return new LiveSessionName(this);
        }
    }
}

