/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.stitcher.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VodSessionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_VOD_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/vodSessions/{vod_session}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String vodSession;

    @Deprecated
    protected VodSessionName() {
        this.project = null;
        this.location = null;
        this.vodSession = null;
    }

    private VodSessionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.vodSession = (String)Preconditions.checkNotNull((Object)builder.getVodSession());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVodSession() {
        return this.vodSession;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VodSessionName of(String project, String location, String vodSession) {
        return VodSessionName.newBuilder().setProject(project).setLocation(location).setVodSession(vodSession).build();
    }

    public static String format(String project, String location, String vodSession) {
        return VodSessionName.newBuilder().setProject(project).setLocation(location).setVodSession(vodSession).build().toString();
    }

    public static VodSessionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_VOD_SESSION.validatedMatch(formattedString, "VodSessionName.parse: formattedString not in valid format");
        return VodSessionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("vod_session"));
    }

    public static List<VodSessionName> parseList(List<String> formattedStrings) {
        ArrayList<VodSessionName> list = new ArrayList<VodSessionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VodSessionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VodSessionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VodSessionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_VOD_SESSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VodSessionName vodSessionName = this;
            synchronized (vodSessionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.vodSession != null) {
                        fieldMapBuilder.put((Object)"vod_session", (Object)this.vodSession);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_VOD_SESSION.instantiate(new String[]{"project", this.project, "location", this.location, "vod_session", this.vodSession});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            VodSessionName that = (VodSessionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.vodSession, that.vodSession);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.vodSession);
    }

    public static class Builder {
        private String project;
        private String location;
        private String vodSession;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVodSession() {
            return this.vodSession;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVodSession(String vodSession) {
            this.vodSession = vodSession;
            return this;
        }

        private Builder(VodSessionName vodSessionName) {
            this.project = vodSessionName.project;
            this.location = vodSessionName.location;
            this.vodSession = vodSessionName.vodSession;
        }

        public VodSessionName build() {
            return new VodSessionName(this);
        }
    }
}

