/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.stitcher.v1;

import com.google.cloud.video.stitcher.v1.AdTag;
import com.google.cloud.video.stitcher.v1.LiveSessionOrBuilder;
import com.google.cloud.video.stitcher.v1.ManifestOptions;
import com.google.cloud.video.stitcher.v1.ManifestOptionsOrBuilder;
import com.google.cloud.video.stitcher.v1.SessionsProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public final class LiveSession
extends GeneratedMessageV3
implements LiveSessionOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_;
    public static final int PLAY_URI_FIELD_NUMBER = 2;
    private volatile Object playUri_;
    public static final int SOURCE_URI_FIELD_NUMBER = 3;
    private volatile Object sourceUri_;
    public static final int DEFAULT_AD_TAG_ID_FIELD_NUMBER = 4;
    private volatile Object defaultAdTagId_;
    public static final int AD_TAG_MAP_FIELD_NUMBER = 5;
    private MapField<String, AdTag> adTagMap_;
    public static final int AD_TAG_MACROS_FIELD_NUMBER = 6;
    private MapField<String, String> adTagMacros_;
    public static final int CLIENT_AD_TRACKING_FIELD_NUMBER = 7;
    private boolean clientAdTracking_;
    public static final int DEFAULT_SLATE_ID_FIELD_NUMBER = 8;
    private volatile Object defaultSlateId_;
    public static final int STITCHING_POLICY_FIELD_NUMBER = 9;
    private int stitchingPolicy_;
    public static final int MANIFEST_OPTIONS_FIELD_NUMBER = 10;
    private ManifestOptions manifestOptions_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final LiveSession DEFAULT_INSTANCE = new LiveSession();
    private static final Parser<LiveSession> PARSER = new AbstractParser<LiveSession>(){

        public LiveSession parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new LiveSession(input, extensionRegistry);
        }
    };

    private LiveSession(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private LiveSession() {
        this.name_ = "";
        this.playUri_ = "";
        this.sourceUri_ = "";
        this.defaultAdTagId_ = "";
        this.defaultSlateId_ = "";
        this.stitchingPolicy_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new LiveSession();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private LiveSession(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block19: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block19;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.name_ = s;
                        continue block19;
                    }
                    case 18: {
                        String s = input.readStringRequireUtf8();
                        this.playUri_ = s;
                        continue block19;
                    }
                    case 26: {
                        String s = input.readStringRequireUtf8();
                        this.sourceUri_ = s;
                        continue block19;
                    }
                    case 34: {
                        String s = input.readStringRequireUtf8();
                        this.defaultAdTagId_ = s;
                        continue block19;
                    }
                    case 42: {
                        if (!(mutable_bitField0_ & true)) {
                            this.adTagMap_ = MapField.newMapField(AdTagMapDefaultEntryHolder.defaultEntry);
                            mutable_bitField0_ |= 1;
                        }
                        MapEntry adTagMap__ = (MapEntry)input.readMessage(AdTagMapDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                        this.adTagMap_.getMutableMap().put(adTagMap__.getKey(), adTagMap__.getValue());
                        continue block19;
                    }
                    case 50: {
                        if ((mutable_bitField0_ & 2) == 0) {
                            this.adTagMacros_ = MapField.newMapField(AdTagMacrosDefaultEntryHolder.defaultEntry);
                            mutable_bitField0_ |= 2;
                        }
                        MapEntry adTagMacros__ = (MapEntry)input.readMessage(AdTagMacrosDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                        this.adTagMacros_.getMutableMap().put(adTagMacros__.getKey(), adTagMacros__.getValue());
                        continue block19;
                    }
                    case 56: {
                        this.clientAdTracking_ = input.readBool();
                        continue block19;
                    }
                    case 66: {
                        String s = input.readStringRequireUtf8();
                        this.defaultSlateId_ = s;
                        continue block19;
                    }
                    case 72: {
                        int rawValue;
                        this.stitchingPolicy_ = rawValue = input.readEnum();
                        continue block19;
                    }
                    case 82: {
                        ManifestOptions.Builder subBuilder = null;
                        if (this.manifestOptions_ != null) {
                            subBuilder = this.manifestOptions_.toBuilder();
                        }
                        this.manifestOptions_ = (ManifestOptions)input.readMessage(ManifestOptions.parser(), extensionRegistry);
                        if (subBuilder == null) continue block19;
                        subBuilder.mergeFrom(this.manifestOptions_);
                        this.manifestOptions_ = subBuilder.buildPartial();
                        continue block19;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return SessionsProto.internal_static_google_cloud_video_stitcher_v1_LiveSession_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 5: {
                return this.internalGetAdTagMap();
            }
            case 6: {
                return this.internalGetAdTagMacros();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return SessionsProto.internal_static_google_cloud_video_stitcher_v1_LiveSession_fieldAccessorTable.ensureFieldAccessorsInitialized(LiveSession.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getPlayUri() {
        Object ref = this.playUri_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.playUri_ = s;
        return s;
    }

    @Override
    public ByteString getPlayUriBytes() {
        Object ref = this.playUri_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.playUri_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getSourceUri() {
        Object ref = this.sourceUri_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.sourceUri_ = s;
        return s;
    }

    @Override
    public ByteString getSourceUriBytes() {
        Object ref = this.sourceUri_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.sourceUri_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDefaultAdTagId() {
        Object ref = this.defaultAdTagId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.defaultAdTagId_ = s;
        return s;
    }

    @Override
    public ByteString getDefaultAdTagIdBytes() {
        Object ref = this.defaultAdTagId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.defaultAdTagId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    private MapField<String, AdTag> internalGetAdTagMap() {
        if (this.adTagMap_ == null) {
            return MapField.emptyMapField(AdTagMapDefaultEntryHolder.defaultEntry);
        }
        return this.adTagMap_;
    }

    @Override
    public int getAdTagMapCount() {
        return this.internalGetAdTagMap().getMap().size();
    }

    @Override
    public boolean containsAdTagMap(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.internalGetAdTagMap().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, AdTag> getAdTagMap() {
        return this.getAdTagMapMap();
    }

    @Override
    public Map<String, AdTag> getAdTagMapMap() {
        return this.internalGetAdTagMap().getMap();
    }

    @Override
    public AdTag getAdTagMapOrDefault(String key, AdTag defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetAdTagMap().getMap();
        return map.containsKey(key) ? (AdTag)map.get(key) : defaultValue;
    }

    @Override
    public AdTag getAdTagMapOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetAdTagMap().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (AdTag)map.get(key);
    }

    private MapField<String, String> internalGetAdTagMacros() {
        if (this.adTagMacros_ == null) {
            return MapField.emptyMapField(AdTagMacrosDefaultEntryHolder.defaultEntry);
        }
        return this.adTagMacros_;
    }

    @Override
    public int getAdTagMacrosCount() {
        return this.internalGetAdTagMacros().getMap().size();
    }

    @Override
    public boolean containsAdTagMacros(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.internalGetAdTagMacros().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getAdTagMacros() {
        return this.getAdTagMacrosMap();
    }

    @Override
    public Map<String, String> getAdTagMacrosMap() {
        return this.internalGetAdTagMacros().getMap();
    }

    @Override
    public String getAdTagMacrosOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetAdTagMacros().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getAdTagMacrosOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        Map map = this.internalGetAdTagMacros().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public boolean getClientAdTracking() {
        return this.clientAdTracking_;
    }

    @Override
    public String getDefaultSlateId() {
        Object ref = this.defaultSlateId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.defaultSlateId_ = s;
        return s;
    }

    @Override
    public ByteString getDefaultSlateIdBytes() {
        Object ref = this.defaultSlateId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.defaultSlateId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getStitchingPolicyValue() {
        return this.stitchingPolicy_;
    }

    @Override
    public StitchingPolicy getStitchingPolicy() {
        StitchingPolicy result = StitchingPolicy.valueOf(this.stitchingPolicy_);
        return result == null ? StitchingPolicy.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasManifestOptions() {
        return this.manifestOptions_ != null;
    }

    @Override
    public ManifestOptions getManifestOptions() {
        return this.manifestOptions_ == null ? ManifestOptions.getDefaultInstance() : this.manifestOptions_;
    }

    @Override
    public ManifestOptionsOrBuilder getManifestOptionsOrBuilder() {
        return this.getManifestOptions();
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.playUri_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.playUri_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.sourceUri_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.sourceUri_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.defaultAdTagId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.defaultAdTagId_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetAdTagMap(), AdTagMapDefaultEntryHolder.defaultEntry, (int)5);
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetAdTagMacros(), AdTagMacrosDefaultEntryHolder.defaultEntry, (int)6);
        if (this.clientAdTracking_) {
            output.writeBool(7, this.clientAdTracking_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.defaultSlateId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.defaultSlateId_);
        }
        if (this.stitchingPolicy_ != StitchingPolicy.STITCHING_POLICY_UNSPECIFIED.getNumber()) {
            output.writeEnum(9, this.stitchingPolicy_);
        }
        if (this.manifestOptions_ != null) {
            output.writeMessage(10, (MessageLite)this.getManifestOptions());
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.playUri_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.playUri_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.sourceUri_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.sourceUri_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.defaultAdTagId_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.defaultAdTagId_);
        }
        for (Map.Entry entry : this.internalGetAdTagMap().getMap().entrySet()) {
            MapEntry adTagMap__ = AdTagMapDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)adTagMap__);
        }
        for (Map.Entry entry : this.internalGetAdTagMacros().getMap().entrySet()) {
            MapEntry adTagMacros__ = AdTagMacrosDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)adTagMacros__);
        }
        if (this.clientAdTracking_) {
            size += CodedOutputStream.computeBoolSize((int)7, (boolean)this.clientAdTracking_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.defaultSlateId_)) {
            size += GeneratedMessageV3.computeStringSize((int)8, (Object)this.defaultSlateId_);
        }
        if (this.stitchingPolicy_ != StitchingPolicy.STITCHING_POLICY_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)9, (int)this.stitchingPolicy_);
        }
        if (this.manifestOptions_ != null) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getManifestOptions());
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LiveSession)) {
            return super.equals(obj);
        }
        LiveSession other = (LiveSession)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getPlayUri().equals(other.getPlayUri())) {
            return false;
        }
        if (!this.getSourceUri().equals(other.getSourceUri())) {
            return false;
        }
        if (!this.getDefaultAdTagId().equals(other.getDefaultAdTagId())) {
            return false;
        }
        if (!this.internalGetAdTagMap().equals(other.internalGetAdTagMap())) {
            return false;
        }
        if (!this.internalGetAdTagMacros().equals(other.internalGetAdTagMacros())) {
            return false;
        }
        if (this.getClientAdTracking() != other.getClientAdTracking()) {
            return false;
        }
        if (!this.getDefaultSlateId().equals(other.getDefaultSlateId())) {
            return false;
        }
        if (this.stitchingPolicy_ != other.stitchingPolicy_) {
            return false;
        }
        if (this.hasManifestOptions() != other.hasManifestOptions()) {
            return false;
        }
        if (this.hasManifestOptions() && !this.getManifestOptions().equals(other.getManifestOptions())) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + LiveSession.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getPlayUri().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getSourceUri().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getDefaultAdTagId().hashCode();
        if (!this.internalGetAdTagMap().getMap().isEmpty()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.internalGetAdTagMap().hashCode();
        }
        if (!this.internalGetAdTagMacros().getMap().isEmpty()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.internalGetAdTagMacros().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getClientAdTracking());
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getDefaultSlateId().hashCode();
        hash = 37 * hash + 9;
        hash = 53 * hash + this.stitchingPolicy_;
        if (this.hasManifestOptions()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getManifestOptions().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static LiveSession parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (LiveSession)PARSER.parseFrom(data);
    }

    public static LiveSession parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (LiveSession)PARSER.parseFrom(data, extensionRegistry);
    }

    public static LiveSession parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (LiveSession)PARSER.parseFrom(data);
    }

    public static LiveSession parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (LiveSession)PARSER.parseFrom(data, extensionRegistry);
    }

    public static LiveSession parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (LiveSession)PARSER.parseFrom(data);
    }

    public static LiveSession parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (LiveSession)PARSER.parseFrom(data, extensionRegistry);
    }

    public static LiveSession parseFrom(InputStream input) throws IOException {
        return (LiveSession)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static LiveSession parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (LiveSession)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static LiveSession parseDelimitedFrom(InputStream input) throws IOException {
        return (LiveSession)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static LiveSession parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (LiveSession)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static LiveSession parseFrom(CodedInputStream input) throws IOException {
        return (LiveSession)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static LiveSession parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (LiveSession)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return LiveSession.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(LiveSession prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static LiveSession getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<LiveSession> parser() {
        return PARSER;
    }

    public Parser<LiveSession> getParserForType() {
        return PARSER;
    }

    public LiveSession getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements LiveSessionOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private Object playUri_ = "";
        private Object sourceUri_ = "";
        private Object defaultAdTagId_ = "";
        private MapField<String, AdTag> adTagMap_;
        private MapField<String, String> adTagMacros_;
        private boolean clientAdTracking_;
        private Object defaultSlateId_ = "";
        private int stitchingPolicy_ = 0;
        private ManifestOptions manifestOptions_;
        private SingleFieldBuilderV3<ManifestOptions, ManifestOptions.Builder, ManifestOptionsOrBuilder> manifestOptionsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return SessionsProto.internal_static_google_cloud_video_stitcher_v1_LiveSession_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 5: {
                    return this.internalGetAdTagMap();
                }
                case 6: {
                    return this.internalGetAdTagMacros();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 5: {
                    return this.internalGetMutableAdTagMap();
                }
                case 6: {
                    return this.internalGetMutableAdTagMacros();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return SessionsProto.internal_static_google_cloud_video_stitcher_v1_LiveSession_fieldAccessorTable.ensureFieldAccessorsInitialized(LiveSession.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            this.name_ = "";
            this.playUri_ = "";
            this.sourceUri_ = "";
            this.defaultAdTagId_ = "";
            this.internalGetMutableAdTagMap().clear();
            this.internalGetMutableAdTagMacros().clear();
            this.clientAdTracking_ = false;
            this.defaultSlateId_ = "";
            this.stitchingPolicy_ = 0;
            if (this.manifestOptionsBuilder_ == null) {
                this.manifestOptions_ = null;
            } else {
                this.manifestOptions_ = null;
                this.manifestOptionsBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return SessionsProto.internal_static_google_cloud_video_stitcher_v1_LiveSession_descriptor;
        }

        public LiveSession getDefaultInstanceForType() {
            return LiveSession.getDefaultInstance();
        }

        public LiveSession build() {
            LiveSession result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public LiveSession buildPartial() {
            LiveSession result = new LiveSession(this);
            int from_bitField0_ = this.bitField0_;
            result.name_ = this.name_;
            result.playUri_ = this.playUri_;
            result.sourceUri_ = this.sourceUri_;
            result.defaultAdTagId_ = this.defaultAdTagId_;
            result.adTagMap_ = this.internalGetAdTagMap();
            result.adTagMap_.makeImmutable();
            result.adTagMacros_ = this.internalGetAdTagMacros();
            result.adTagMacros_.makeImmutable();
            result.clientAdTracking_ = this.clientAdTracking_;
            result.defaultSlateId_ = this.defaultSlateId_;
            result.stitchingPolicy_ = this.stitchingPolicy_;
            if (this.manifestOptionsBuilder_ == null) {
                result.manifestOptions_ = this.manifestOptions_;
            } else {
                result.manifestOptions_ = (ManifestOptions)this.manifestOptionsBuilder_.build();
            }
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof LiveSession) {
                return this.mergeFrom((LiveSession)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(LiveSession other) {
            if (other == LiveSession.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.onChanged();
            }
            if (!other.getPlayUri().isEmpty()) {
                this.playUri_ = other.playUri_;
                this.onChanged();
            }
            if (!other.getSourceUri().isEmpty()) {
                this.sourceUri_ = other.sourceUri_;
                this.onChanged();
            }
            if (!other.getDefaultAdTagId().isEmpty()) {
                this.defaultAdTagId_ = other.defaultAdTagId_;
                this.onChanged();
            }
            this.internalGetMutableAdTagMap().mergeFrom(other.internalGetAdTagMap());
            this.internalGetMutableAdTagMacros().mergeFrom(other.internalGetAdTagMacros());
            if (other.getClientAdTracking()) {
                this.setClientAdTracking(other.getClientAdTracking());
            }
            if (!other.getDefaultSlateId().isEmpty()) {
                this.defaultSlateId_ = other.defaultSlateId_;
                this.onChanged();
            }
            if (other.stitchingPolicy_ != 0) {
                this.setStitchingPolicyValue(other.getStitchingPolicyValue());
            }
            if (other.hasManifestOptions()) {
                this.mergeManifestOptions(other.getManifestOptions());
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            LiveSession parsedMessage = null;
            try {
                parsedMessage = (LiveSession)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (LiveSession)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = LiveSession.getDefaultInstance().getName();
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            LiveSession.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getPlayUri() {
            Object ref = this.playUri_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.playUri_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPlayUriBytes() {
            Object ref = this.playUri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.playUri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPlayUri(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.playUri_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearPlayUri() {
            this.playUri_ = LiveSession.getDefaultInstance().getPlayUri();
            this.onChanged();
            return this;
        }

        public Builder setPlayUriBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            LiveSession.checkByteStringIsUtf8((ByteString)value);
            this.playUri_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getSourceUri() {
            Object ref = this.sourceUri_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.sourceUri_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getSourceUriBytes() {
            Object ref = this.sourceUri_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.sourceUri_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setSourceUri(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.sourceUri_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearSourceUri() {
            this.sourceUri_ = LiveSession.getDefaultInstance().getSourceUri();
            this.onChanged();
            return this;
        }

        public Builder setSourceUriBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            LiveSession.checkByteStringIsUtf8((ByteString)value);
            this.sourceUri_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getDefaultAdTagId() {
            Object ref = this.defaultAdTagId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.defaultAdTagId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDefaultAdTagIdBytes() {
            Object ref = this.defaultAdTagId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.defaultAdTagId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDefaultAdTagId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.defaultAdTagId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearDefaultAdTagId() {
            this.defaultAdTagId_ = LiveSession.getDefaultInstance().getDefaultAdTagId();
            this.onChanged();
            return this;
        }

        public Builder setDefaultAdTagIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            LiveSession.checkByteStringIsUtf8((ByteString)value);
            this.defaultAdTagId_ = value;
            this.onChanged();
            return this;
        }

        private MapField<String, AdTag> internalGetAdTagMap() {
            if (this.adTagMap_ == null) {
                return MapField.emptyMapField(AdTagMapDefaultEntryHolder.defaultEntry);
            }
            return this.adTagMap_;
        }

        private MapField<String, AdTag> internalGetMutableAdTagMap() {
            this.onChanged();
            if (this.adTagMap_ == null) {
                this.adTagMap_ = MapField.newMapField(AdTagMapDefaultEntryHolder.defaultEntry);
            }
            if (!this.adTagMap_.isMutable()) {
                this.adTagMap_ = this.adTagMap_.copy();
            }
            return this.adTagMap_;
        }

        @Override
        public int getAdTagMapCount() {
            return this.internalGetAdTagMap().getMap().size();
        }

        @Override
        public boolean containsAdTagMap(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return this.internalGetAdTagMap().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, AdTag> getAdTagMap() {
            return this.getAdTagMapMap();
        }

        @Override
        public Map<String, AdTag> getAdTagMapMap() {
            return this.internalGetAdTagMap().getMap();
        }

        @Override
        public AdTag getAdTagMapOrDefault(String key, AdTag defaultValue) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetAdTagMap().getMap();
            return map.containsKey(key) ? (AdTag)map.get(key) : defaultValue;
        }

        @Override
        public AdTag getAdTagMapOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetAdTagMap().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (AdTag)map.get(key);
        }

        public Builder clearAdTagMap() {
            this.internalGetMutableAdTagMap().getMutableMap().clear();
            return this;
        }

        public Builder removeAdTagMap(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableAdTagMap().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, AdTag> getMutableAdTagMap() {
            return this.internalGetMutableAdTagMap().getMutableMap();
        }

        public Builder putAdTagMap(String key, AdTag value) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableAdTagMap().getMutableMap().put(key, value);
            return this;
        }

        public Builder putAllAdTagMap(Map<String, AdTag> values) {
            this.internalGetMutableAdTagMap().getMutableMap().putAll(values);
            return this;
        }

        private MapField<String, String> internalGetAdTagMacros() {
            if (this.adTagMacros_ == null) {
                return MapField.emptyMapField(AdTagMacrosDefaultEntryHolder.defaultEntry);
            }
            return this.adTagMacros_;
        }

        private MapField<String, String> internalGetMutableAdTagMacros() {
            this.onChanged();
            if (this.adTagMacros_ == null) {
                this.adTagMacros_ = MapField.newMapField(AdTagMacrosDefaultEntryHolder.defaultEntry);
            }
            if (!this.adTagMacros_.isMutable()) {
                this.adTagMacros_ = this.adTagMacros_.copy();
            }
            return this.adTagMacros_;
        }

        @Override
        public int getAdTagMacrosCount() {
            return this.internalGetAdTagMacros().getMap().size();
        }

        @Override
        public boolean containsAdTagMacros(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return this.internalGetAdTagMacros().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getAdTagMacros() {
            return this.getAdTagMacrosMap();
        }

        @Override
        public Map<String, String> getAdTagMacrosMap() {
            return this.internalGetAdTagMacros().getMap();
        }

        @Override
        public String getAdTagMacrosOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetAdTagMacros().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getAdTagMacrosOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Map map = this.internalGetAdTagMacros().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearAdTagMacros() {
            this.internalGetMutableAdTagMacros().getMutableMap().clear();
            return this;
        }

        public Builder removeAdTagMacros(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableAdTagMacros().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableAdTagMacros() {
            return this.internalGetMutableAdTagMacros().getMutableMap();
        }

        public Builder putAdTagMacros(String key, String value) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                throw new NullPointerException();
            }
            this.internalGetMutableAdTagMacros().getMutableMap().put(key, value);
            return this;
        }

        public Builder putAllAdTagMacros(Map<String, String> values) {
            this.internalGetMutableAdTagMacros().getMutableMap().putAll(values);
            return this;
        }

        @Override
        public boolean getClientAdTracking() {
            return this.clientAdTracking_;
        }

        public Builder setClientAdTracking(boolean value) {
            this.clientAdTracking_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearClientAdTracking() {
            this.clientAdTracking_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public String getDefaultSlateId() {
            Object ref = this.defaultSlateId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.defaultSlateId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDefaultSlateIdBytes() {
            Object ref = this.defaultSlateId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.defaultSlateId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDefaultSlateId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.defaultSlateId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearDefaultSlateId() {
            this.defaultSlateId_ = LiveSession.getDefaultInstance().getDefaultSlateId();
            this.onChanged();
            return this;
        }

        public Builder setDefaultSlateIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            LiveSession.checkByteStringIsUtf8((ByteString)value);
            this.defaultSlateId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getStitchingPolicyValue() {
            return this.stitchingPolicy_;
        }

        public Builder setStitchingPolicyValue(int value) {
            this.stitchingPolicy_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public StitchingPolicy getStitchingPolicy() {
            StitchingPolicy result = StitchingPolicy.valueOf(this.stitchingPolicy_);
            return result == null ? StitchingPolicy.UNRECOGNIZED : result;
        }

        public Builder setStitchingPolicy(StitchingPolicy value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.stitchingPolicy_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStitchingPolicy() {
            this.stitchingPolicy_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasManifestOptions() {
            return this.manifestOptionsBuilder_ != null || this.manifestOptions_ != null;
        }

        @Override
        public ManifestOptions getManifestOptions() {
            if (this.manifestOptionsBuilder_ == null) {
                return this.manifestOptions_ == null ? ManifestOptions.getDefaultInstance() : this.manifestOptions_;
            }
            return (ManifestOptions)this.manifestOptionsBuilder_.getMessage();
        }

        public Builder setManifestOptions(ManifestOptions value) {
            if (this.manifestOptionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.manifestOptions_ = value;
                this.onChanged();
            } else {
                this.manifestOptionsBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setManifestOptions(ManifestOptions.Builder builderForValue) {
            if (this.manifestOptionsBuilder_ == null) {
                this.manifestOptions_ = builderForValue.build();
                this.onChanged();
            } else {
                this.manifestOptionsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeManifestOptions(ManifestOptions value) {
            if (this.manifestOptionsBuilder_ == null) {
                this.manifestOptions_ = this.manifestOptions_ != null ? ManifestOptions.newBuilder(this.manifestOptions_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.manifestOptionsBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearManifestOptions() {
            if (this.manifestOptionsBuilder_ == null) {
                this.manifestOptions_ = null;
                this.onChanged();
            } else {
                this.manifestOptions_ = null;
                this.manifestOptionsBuilder_ = null;
            }
            return this;
        }

        public ManifestOptions.Builder getManifestOptionsBuilder() {
            this.onChanged();
            return (ManifestOptions.Builder)this.getManifestOptionsFieldBuilder().getBuilder();
        }

        @Override
        public ManifestOptionsOrBuilder getManifestOptionsOrBuilder() {
            if (this.manifestOptionsBuilder_ != null) {
                return (ManifestOptionsOrBuilder)this.manifestOptionsBuilder_.getMessageOrBuilder();
            }
            return this.manifestOptions_ == null ? ManifestOptions.getDefaultInstance() : this.manifestOptions_;
        }

        private SingleFieldBuilderV3<ManifestOptions, ManifestOptions.Builder, ManifestOptionsOrBuilder> getManifestOptionsFieldBuilder() {
            if (this.manifestOptionsBuilder_ == null) {
                this.manifestOptionsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getManifestOptions(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.manifestOptions_ = null;
            }
            return this.manifestOptionsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class AdTagMacrosDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)SessionsProto.internal_static_google_cloud_video_stitcher_v1_LiveSession_AdTagMacrosEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private AdTagMacrosDefaultEntryHolder() {
        }
    }

    private static final class AdTagMapDefaultEntryHolder {
        static final MapEntry<String, AdTag> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)SessionsProto.internal_static_google_cloud_video_stitcher_v1_LiveSession_AdTagMapEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.MESSAGE, (Object)AdTag.getDefaultInstance());

        private AdTagMapDefaultEntryHolder() {
        }
    }

    public static enum StitchingPolicy implements ProtocolMessageEnum
    {
        STITCHING_POLICY_UNSPECIFIED(0),
        COMPLETE_AD(1),
        COMPLETE_POD(2),
        CUT_CURRENT(3),
        UNRECOGNIZED(-1);

        public static final int STITCHING_POLICY_UNSPECIFIED_VALUE = 0;
        public static final int COMPLETE_AD_VALUE = 1;
        public static final int COMPLETE_POD_VALUE = 2;
        public static final int CUT_CURRENT_VALUE = 3;
        private static final Internal.EnumLiteMap<StitchingPolicy> internalValueMap;
        private static final StitchingPolicy[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static StitchingPolicy valueOf(int value) {
            return StitchingPolicy.forNumber(value);
        }

        public static StitchingPolicy forNumber(int value) {
            switch (value) {
                case 0: {
                    return STITCHING_POLICY_UNSPECIFIED;
                }
                case 1: {
                    return COMPLETE_AD;
                }
                case 2: {
                    return COMPLETE_POD;
                }
                case 3: {
                    return CUT_CURRENT;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<StitchingPolicy> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)StitchingPolicy.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return StitchingPolicy.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)LiveSession.getDescriptor().getEnumTypes().get(0);
        }

        public static StitchingPolicy valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != StitchingPolicy.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private StitchingPolicy(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<StitchingPolicy>(){

                public StitchingPolicy findValueByNumber(int number) {
                    return StitchingPolicy.forNumber(number);
                }
            };
            VALUES = StitchingPolicy.values();
        }
    }
}

