/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GlossaryName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/glossaries/{glossary}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String glossary;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGlossary() {
        return this.glossary;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private GlossaryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.glossary = (String)Preconditions.checkNotNull((Object)builder.getGlossary());
    }

    public static GlossaryName of(String project, String location, String glossary) {
        return GlossaryName.newBuilder().setProject(project).setLocation(location).setGlossary(glossary).build();
    }

    public static String format(String project, String location, String glossary) {
        return GlossaryName.newBuilder().setProject(project).setLocation(location).setGlossary(glossary).build().toString();
    }

    public static GlossaryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "GlossaryName.parse: formattedString not in valid format");
        return GlossaryName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("glossary"));
    }

    public static List<GlossaryName> parseList(List<String> formattedStrings) {
        ArrayList<GlossaryName> list = new ArrayList<GlossaryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GlossaryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GlossaryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GlossaryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GlossaryName glossaryName = this;
            synchronized (glossaryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"glossary", (Object)this.glossary);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "glossary", this.glossary});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GlossaryName) {
            GlossaryName that = (GlossaryName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.glossary.equals(that.glossary);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.glossary.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String glossary;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGlossary() {
            return this.glossary;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGlossary(String glossary) {
            this.glossary = glossary;
            return this;
        }

        private Builder() {
        }

        private Builder(GlossaryName glossaryName) {
            this.project = glossaryName.project;
            this.location = glossaryName.location;
            this.glossary = glossaryName.glossary;
        }

        public GlossaryName build() {
            return new GlossaryName(this);
        }
    }
}

