/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GlossaryEntryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_GLOSSARY_GLOSSARY_ENTRY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/glossaries/{glossary}/glossaryEntries/{glossary_entry}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String glossary;
    private final String glossaryEntry;

    @Deprecated
    protected GlossaryEntryName() {
        this.project = null;
        this.location = null;
        this.glossary = null;
        this.glossaryEntry = null;
    }

    private GlossaryEntryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.glossary = (String)Preconditions.checkNotNull((Object)builder.getGlossary());
        this.glossaryEntry = (String)Preconditions.checkNotNull((Object)builder.getGlossaryEntry());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGlossary() {
        return this.glossary;
    }

    public String getGlossaryEntry() {
        return this.glossaryEntry;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GlossaryEntryName of(String project, String location, String glossary, String glossaryEntry) {
        return GlossaryEntryName.newBuilder().setProject(project).setLocation(location).setGlossary(glossary).setGlossaryEntry(glossaryEntry).build();
    }

    public static String format(String project, String location, String glossary, String glossaryEntry) {
        return GlossaryEntryName.newBuilder().setProject(project).setLocation(location).setGlossary(glossary).setGlossaryEntry(glossaryEntry).build().toString();
    }

    public static GlossaryEntryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_GLOSSARY_GLOSSARY_ENTRY.validatedMatch(formattedString, "GlossaryEntryName.parse: formattedString not in valid format");
        return GlossaryEntryName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("glossary"), (String)matchMap.get("glossary_entry"));
    }

    public static List<GlossaryEntryName> parseList(List<String> formattedStrings) {
        ArrayList<GlossaryEntryName> list = new ArrayList<GlossaryEntryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GlossaryEntryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GlossaryEntryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GlossaryEntryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_GLOSSARY_GLOSSARY_ENTRY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GlossaryEntryName glossaryEntryName = this;
            synchronized (glossaryEntryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.glossary != null) {
                        fieldMapBuilder.put((Object)"glossary", (Object)this.glossary);
                    }
                    if (this.glossaryEntry != null) {
                        fieldMapBuilder.put((Object)"glossary_entry", (Object)this.glossaryEntry);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_GLOSSARY_GLOSSARY_ENTRY.instantiate(new String[]{"project", this.project, "location", this.location, "glossary", this.glossary, "glossary_entry", this.glossaryEntry});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GlossaryEntryName that = (GlossaryEntryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.glossary, that.glossary) && Objects.equals(this.glossaryEntry, that.glossaryEntry);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.glossary);
        h *= 1000003;
        return h ^= Objects.hashCode(this.glossaryEntry);
    }

    public static class Builder {
        private String project;
        private String location;
        private String glossary;
        private String glossaryEntry;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGlossary() {
            return this.glossary;
        }

        public String getGlossaryEntry() {
            return this.glossaryEntry;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGlossary(String glossary) {
            this.glossary = glossary;
            return this;
        }

        public Builder setGlossaryEntry(String glossaryEntry) {
            this.glossaryEntry = glossaryEntry;
            return this;
        }

        private Builder(GlossaryEntryName glossaryEntryName) {
            this.project = glossaryEntryName.project;
            this.location = glossaryEntryName.location;
            this.glossary = glossaryEntryName.glossary;
            this.glossaryEntry = glossaryEntryName.glossaryEntry;
        }

        public GlossaryEntryName build() {
            return new GlossaryEntryName(this);
        }
    }
}

